/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.plugins.extseed.impl;

import com.aelitis.azureus.plugins.extseed.ExternalSeedException;
import com.aelitis.azureus.plugins.extseed.impl.ExternalSeedReaderImpl;
import com.aelitis.azureus.plugins.extseed.util.ExternalSeedHTTPDownloaderListener;
import java.util.List;
import org.gudy.azureus2.plugins.peers.PeerReadRequest;

public class ExternalSeedReaderRequest
implements ExternalSeedHTTPDownloaderListener {
    private ExternalSeedReaderImpl reader;
    private List requests;
    private int start_piece_number;
    private int start_piece_offset;
    private int length;
    private int current_request_index = 0;
    private PeerReadRequest current_request;
    private byte[] current_buffer;

    protected ExternalSeedReaderRequest(ExternalSeedReaderImpl _reader, List _requests) {
        this.reader = _reader;
        this.requests = _requests;
        for (int i = 0; i < this.requests.size(); ++i) {
            PeerReadRequest req = (PeerReadRequest)this.requests.get(i);
            if (i == 0) {
                this.start_piece_number = req.getPieceNumber();
                this.start_piece_offset = req.getOffset();
            }
            this.length += req.getLength();
        }
    }

    public int getStartPieceNumber() {
        return this.start_piece_number;
    }

    public int getStartPieceOffset() {
        return this.start_piece_offset;
    }

    public int getLength() {
        return this.length;
    }

    public byte[] getBuffer() throws ExternalSeedException {
        if (this.current_request_index >= this.requests.size()) {
            throw new ExternalSeedException("Insufficient buffers to satisfy request");
        }
        this.current_request = (PeerReadRequest)this.requests.get(this.current_request_index++);
        this.current_buffer = new byte[this.current_request.getLength()];
        return this.current_buffer;
    }

    public void done() {
        this.reader.informComplete(this.current_request, this.current_buffer);
    }

    public void failed() {
        for (int i = this.current_request_index; i < this.requests.size(); ++i) {
            PeerReadRequest request2 = (PeerReadRequest)this.requests.get(i);
            this.reader.informFailed(request2);
        }
    }
}

