/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.core.peermanager.utils;

import com.aelitis.azureus.core.networkmanager.OutgoingMessageQueue;
import com.aelitis.azureus.core.peermanager.messaging.Message;
import com.aelitis.azureus.core.peermanager.messaging.bittorrent.BTPiece;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import org.gudy.azureus2.core3.disk.DiskManager;
import org.gudy.azureus2.core3.disk.DiskManagerReadRequest;
import org.gudy.azureus2.core3.disk.DiskManagerReadRequestListener;
import org.gudy.azureus2.core3.util.AEMonitor;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.DirectByteBuffer;

public class OutgoingBTPieceMessageHandler {
    private final OutgoingMessageQueue outgoing_message_queue;
    private final DiskManager disk_manager;
    private final LinkedList requests = new LinkedList();
    private final ArrayList loading_messages = new ArrayList();
    private final HashMap queued_messages = new HashMap();
    private final AEMonitor lock_mon = new AEMonitor("OutgoingBTPieceMessageHandler:lock");
    private boolean destroyed = false;
    private int request_read_ahead = 2;
    private final DiskManagerReadRequestListener read_req_listener = new DiskManagerReadRequestListener(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void readCompleted(DiskManagerReadRequest request2, DirectByteBuffer data) {
            try {
                OutgoingBTPieceMessageHandler.this.lock_mon.enter();
                if (!OutgoingBTPieceMessageHandler.this.loading_messages.contains(request2) || OutgoingBTPieceMessageHandler.this.destroyed) {
                    data.returnToPool();
                    return;
                }
                OutgoingBTPieceMessageHandler.this.loading_messages.remove(request2);
                BTPiece msg = new BTPiece(request2.getPieceNumber(), request2.getOffset(), data);
                OutgoingBTPieceMessageHandler.this.queued_messages.put(msg, request2);
                OutgoingBTPieceMessageHandler.this.outgoing_message_queue.addMessage(msg, true);
            }
            finally {
                OutgoingBTPieceMessageHandler.this.lock_mon.exit();
            }
            OutgoingBTPieceMessageHandler.this.outgoing_message_queue.doListenerNotifications();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void readFailed(DiskManagerReadRequest request2, Throwable cause) {
            try {
                OutgoingBTPieceMessageHandler.this.lock_mon.enter();
                if (!OutgoingBTPieceMessageHandler.this.loading_messages.contains(request2) || OutgoingBTPieceMessageHandler.this.destroyed) {
                    return;
                }
                OutgoingBTPieceMessageHandler.this.loading_messages.remove(request2);
            }
            finally {
                OutgoingBTPieceMessageHandler.this.lock_mon.exit();
            }
        }
    };
    private final OutgoingMessageQueue.MessageQueueListener sent_message_listener = new OutgoingMessageQueue.MessageQueueListener(){

        public boolean messageAdded(Message message) {
            return true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void messageSent(Message message) {
            if (message.getID().equals("BT_PIECE")) {
                try {
                    OutgoingBTPieceMessageHandler.this.lock_mon.enter();
                    OutgoingBTPieceMessageHandler.this.queued_messages.remove(message);
                }
                finally {
                    OutgoingBTPieceMessageHandler.this.lock_mon.exit();
                }
                OutgoingBTPieceMessageHandler.this.doReadAheadLoads();
            }
        }

        public void messageQueued(Message message) {
        }

        public void messageRemoved(Message message) {
        }

        public void protocolBytesSent(int byte_count) {
        }

        public void dataBytesSent(int byte_count) {
        }
    };

    public OutgoingBTPieceMessageHandler(DiskManager disk_manager, OutgoingMessageQueue outgoing_message_q) {
        this.disk_manager = disk_manager;
        this.outgoing_message_queue = outgoing_message_q;
        this.outgoing_message_queue.registerQueueListener(this.sent_message_listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addPieceRequest(int piece_number, int piece_offset, int length) {
        if (this.destroyed) {
            return;
        }
        DiskManagerReadRequest dmr = this.disk_manager.createReadRequest(piece_number, piece_offset, length);
        try {
            this.lock_mon.enter();
            this.requests.addLast(dmr);
        }
        finally {
            this.lock_mon.exit();
        }
        this.doReadAheadLoads();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removePieceRequest(int piece_number, int piece_offset, int length) {
        if (this.destroyed) {
            return;
        }
        DiskManagerReadRequest dmr = this.disk_manager.createReadRequest(piece_number, piece_offset, length);
        try {
            this.lock_mon.enter();
            if (this.requests.contains(dmr)) {
                this.requests.remove(dmr);
                return;
            }
            if (this.loading_messages.contains(dmr)) {
                this.loading_messages.remove(dmr);
                return;
            }
            Iterator i = this.queued_messages.entrySet().iterator();
            while (i.hasNext()) {
                Map.Entry entry = i.next();
                if (!entry.getValue().equals(dmr)) continue;
                BTPiece msg = (BTPiece)entry.getKey();
                if (this.outgoing_message_queue.removeMessage(msg, true)) {
                    i.remove();
                }
                break;
            }
        }
        finally {
            this.lock_mon.exit();
        }
        this.outgoing_message_queue.doListenerNotifications();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeAllPieceRequests() {
        if (this.destroyed) {
            return;
        }
        try {
            this.lock_mon.enter();
            String before_trace = this.outgoing_message_queue.getQueueTrace();
            int num_queued = this.queued_messages.size();
            int num_removed = 0;
            Iterator i = this.queued_messages.keySet().iterator();
            while (i.hasNext()) {
                BTPiece msg = (BTPiece)i.next();
                if (!this.outgoing_message_queue.removeMessage(msg, true)) continue;
                i.remove();
                ++num_removed;
            }
            if (num_removed < num_queued - 2) {
                Debug.out("num_removed[" + num_removed + "] < num_queued[" + num_queued + "]:\nBEFORE:\n" + before_trace + "\nAFTER:\n" + this.outgoing_message_queue.getQueueTrace());
            }
            this.requests.clear();
            this.loading_messages.clear();
        }
        finally {
            this.lock_mon.exit();
        }
        this.outgoing_message_queue.doListenerNotifications();
    }

    public void setRequestReadAhead(int num_to_read_ahead) {
        this.request_read_ahead = num_to_read_ahead;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destroy() {
        try {
            this.lock_mon.enter();
            this.removeAllPieceRequests();
            this.queued_messages.clear();
            this.destroyed = true;
        }
        finally {
            this.lock_mon.exit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doReadAheadLoads() {
        ArrayList<DiskManagerReadRequest> to_submit = null;
        try {
            this.lock_mon.enter();
            while (this.loading_messages.size() + this.queued_messages.size() < this.request_read_ahead && !this.requests.isEmpty() && !this.destroyed) {
                DiskManagerReadRequest dmr = (DiskManagerReadRequest)this.requests.removeFirst();
                this.loading_messages.add(dmr);
                if (to_submit == null) {
                    to_submit = new ArrayList<DiskManagerReadRequest>();
                }
                to_submit.add(dmr);
            }
        }
        finally {
            this.lock_mon.exit();
        }
        if (to_submit != null) {
            for (int i = 0; i < to_submit.size(); ++i) {
                this.disk_manager.enqueueReadRequest((DiskManagerReadRequest)to_submit.get(i), this.read_req_listener);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int[] getRequestedPieceNumbers() {
        int[] pieceNumbers;
        if (this.destroyed) {
            return new int[0];
        }
        int iLastNumber = -1;
        int pos = 0;
        try {
            this.lock_mon.enter();
            pieceNumbers = new int[this.queued_messages.size() + this.loading_messages.size() + this.requests.size()];
            for (BTPiece msg : this.queued_messages.keySet()) {
                if (iLastNumber == msg.getPieceNumber()) continue;
                iLastNumber = msg.getPieceNumber();
                pieceNumbers[pos++] = iLastNumber;
            }
            for (DiskManagerReadRequest dmr : this.loading_messages) {
                if (iLastNumber == dmr.getPieceNumber()) continue;
                iLastNumber = dmr.getPieceNumber();
                pieceNumbers[pos++] = iLastNumber;
            }
            for (DiskManagerReadRequest dmr : this.requests) {
                if (iLastNumber == dmr.getPieceNumber()) continue;
                iLastNumber = dmr.getPieceNumber();
                pieceNumbers[pos++] = iLastNumber;
            }
        }
        finally {
            this.lock_mon.exit();
        }
        int[] trimmed = new int[pos];
        System.arraycopy(pieceNumbers, 0, trimmed, 0, pos);
        return trimmed;
    }

    public int getRequestCount() {
        return this.queued_messages.size() + this.loading_messages.size() + this.requests.size();
    }
}

