/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.core.peermanager.unchoker;

import com.aelitis.azureus.core.peermanager.messaging.Message;
import com.aelitis.azureus.core.peermanager.piecepicker.util.BitFlags;
import com.aelitis.azureus.core.peermanager.unchoker.UnchokerUtil;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;
import org.gudy.azureus2.core3.peer.PEPeer;
import org.gudy.azureus2.core3.peer.PEPeerListener;
import org.gudy.azureus2.core3.peer.PEPeerManager;
import org.gudy.azureus2.core3.peer.PEPeerStats;
import org.gudy.azureus2.core3.peer.TyrantStats;
import org.gudy.azureus2.core3.peer.impl.PEPeerTransport;
import org.gudy.azureus2.core3.util.RandomUtils;
import org.gudy.azureus2.plugins.network.Connection;

public class UnchokerUtilTest {
    private static final int NUM_PEERS_TO_TEST = 100;
    private static final int BYTE_RANGE = 0x6400000;
    private static final int TEST_ROUNDS = 1000000;

    public static void main(String[] args) {
        TreeMap<PEPeerTransport, Integer> counts = new TreeMap<PEPeerTransport, Integer>(new Comparator(){

            public int compare(Object o1, Object o2) {
                PEPeer peer1 = (PEPeer)o1;
                PEPeer peer2 = (PEPeer)o2;
                long score1 = peer1.getStats().getTotalDataBytesSent() - peer1.getStats().getTotalDataBytesReceived();
                long score2 = peer2.getStats().getTotalDataBytesSent() - peer2.getStats().getTotalDataBytesReceived();
                return (int)(score1 - score2);
            }
        });
        ArrayList test_peers = UnchokerUtilTest.generateTestPeers();
        for (int i = 0; i < 1000000; ++i) {
            PEPeerTransport opt_peer;
            Integer count;
            if (i % 100000 == 0) {
                System.out.println("round=" + i);
            }
            if ((count = (Integer)counts.get(opt_peer = UnchokerUtil.getNextOptimisticPeer(test_peers, true, false))) == null) {
                count = new Integer(0);
            }
            counts.put(opt_peer, new Integer(count + 1));
        }
        int max_picked = 0;
        Iterator it = counts.values().iterator();
        while (it.hasNext()) {
            int count = (Integer)it.next();
            if (count <= max_picked) continue;
            max_picked = count;
        }
        int pos = 0;
        for (Map.Entry entry : counts.entrySet()) {
            PEPeer peer = (PEPeer)entry.getKey();
            int count = (Integer)entry.getValue();
            long score = peer.getStats().getTotalDataBytesSent() - peer.getStats().getTotalDataBytesReceived();
            float ratio = (float)peer.getStats().getTotalDataBytesSent() / (float)(peer.getStats().getTotalDataBytesReceived() + 1L);
            int percentile = count * 100 / max_picked;
            System.out.println("[" + pos + "] score=" + score + ", ratio=" + ratio + ", picked=" + count + "x, percentile=" + percentile + "%");
            ++pos;
        }
    }

    private static ArrayList generateTestPeers() {
        ArrayList<3> peers = new ArrayList<3>();
        for (int i = 0; i < 100; ++i) {
            final int bytes_received = RandomUtils.nextInt(0x6400000);
            final int bytes_sent = RandomUtils.nextInt(0x6400000);
            final PEPeerStats stats = new PEPeerStats(){

                public void dataBytesSent(int num_bytes) {
                }

                public void protocolBytesSent(int num_bytes) {
                }

                public void dataBytesReceived(int num_bytes) {
                }

                public void protocolBytesReceived(int num_bytes) {
                }

                public void bytesDiscarded(int num_bytes) {
                }

                public void hasNewPiece(int piece_size) {
                }

                public void statisticalSentPiece(int piece_size) {
                }

                public long getDataReceiveRate() {
                    return 0L;
                }

                public long getProtocolReceiveRate() {
                    return 0L;
                }

                public long getTotalDataBytesReceived() {
                    return bytes_received;
                }

                public long getTotalProtocolBytesReceived() {
                    return 0L;
                }

                public long getDataSendRate() {
                    return 0L;
                }

                public long getProtocolSendRate() {
                    return 0L;
                }

                public long getTotalDataBytesSent() {
                    return bytes_sent;
                }

                public long getTotalProtocolBytesSent() {
                    return 0L;
                }

                public long getSmoothDataReceiveRate() {
                    return 0L;
                }

                public long getTotalBytesDiscarded() {
                    return 0L;
                }

                public long getEstimatedDownloadRateOfPeer() {
                    return 0L;
                }

                public long getEstimatedUploadRateOfPeer() {
                    return 0L;
                }

                public long getTotalBytesDownloadedByPeer() {
                    return 0L;
                }
            };
            PEPeer peer = new PEPeer(){

                public void addListener(PEPeerListener listener) {
                }

                public void removeListener(PEPeerListener listener) {
                }

                public int getPeerState() {
                    return 30;
                }

                public PEPeerManager getManager() {
                    return null;
                }

                public String getPeerSource() {
                    return null;
                }

                public byte[] getId() {
                    return null;
                }

                public String getIp() {
                    return null;
                }

                public int getPort() {
                    return 0;
                }

                public String getIPHostName() {
                    return null;
                }

                public int getTCPListenPort() {
                    return 0;
                }

                public int getUDPListenPort() {
                    return 0;
                }

                public int getUDPNonDataListenPort() {
                    return 0;
                }

                public BitFlags getAvailable() {
                    return null;
                }

                public boolean isPieceAvailable(int pieceNumber) {
                    return false;
                }

                public boolean transferAvailable() {
                    return true;
                }

                public boolean isDownloadPossible() {
                    return true;
                }

                public void setSnubbed(boolean b) {
                }

                public boolean isChokingMe() {
                    return true;
                }

                public boolean isChokedByMe() {
                    return true;
                }

                public boolean isInteresting() {
                    return true;
                }

                public boolean isInterested() {
                    return true;
                }

                public boolean isSeed() {
                    return false;
                }

                public boolean isSnubbed() {
                    return false;
                }

                public long getSnubbedTime() {
                    return 0L;
                }

                public PEPeerStats getStats() {
                    return stats;
                }

                public boolean isIncoming() {
                    return false;
                }

                public int getPercentDoneInThousandNotation() {
                    return 0;
                }

                public String getClient() {
                    return null;
                }

                public boolean isOptimisticUnchoke() {
                    return false;
                }

                public void setOptimisticUnchoke(boolean is_optimistic) {
                }

                public void setUploadHint(int timeToSpread) {
                }

                public int getUploadHint() {
                    return 0;
                }

                public void setUniqueAnnounce(int uniquePieceNumber) {
                }

                public int getUniqueAnnounce() {
                    return 0;
                }

                public Object getData(String key) {
                    return null;
                }

                public void setData(String key, Object value) {
                }

                public Connection getPluginConnection() {
                    return null;
                }

                public boolean supportsMessaging() {
                    return false;
                }

                public Message[] getSupportedMessages() {
                    return null;
                }

                public String getEncryption() {
                    return "";
                }

                public int getReservedPieceNumber() {
                    return -1;
                }

                public void setReservedPieceNumber(int pieceNumber) {
                }

                public int[] getIncomingRequestedPieceNumbers() {
                    return null;
                }

                public int[] getOutgoingRequestedPieceNumbers() {
                    return null;
                }

                public int getPercentDoneOfCurrentIncomingRequest() {
                    return 0;
                }

                public int getPercentDoneOfCurrentOutgoingRequest() {
                    return 0;
                }

                public long getTimeSinceConnectionEstablished() {
                    return 0L;
                }

                public int getLastPiece() {
                    return -1;
                }

                public void setLastPiece(int pieceNumber) {
                }

                public int getConsecutiveNoRequestCount() {
                    return 0;
                }

                public void setConsecutiveNoRequestCount(int num) {
                }

                public int getIncomingRequestCount() {
                    return 0;
                }

                public int getOutgoingRequestCount() {
                    return 0;
                }

                public TyrantStats getTyrantStats() {
                    return null;
                }

                public boolean isSelfishTyrantPeer() {
                    return false;
                }
            };
            peers.add(peer);
        }
        return peers;
    }
}

