/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.core.networkmanager.impl;

import com.aelitis.azureus.core.networkmanager.EventWaiter;
import com.aelitis.azureus.core.networkmanager.Transport;
import com.aelitis.azureus.core.networkmanager.impl.TransportHelper;
import com.aelitis.azureus.core.networkmanager.impl.TransportHelperFilter;
import com.aelitis.azureus.core.networkmanager.impl.TransportStats;
import java.io.IOException;
import java.nio.ByteBuffer;
import org.gudy.azureus2.core3.util.Debug;

public abstract class TransportImpl
implements Transport {
    private TransportHelperFilter filter;
    private static final TransportStats stats = null;
    private ByteBuffer data_already_read = null;
    private volatile EventWaiter read_waiter;
    private volatile EventWaiter write_waiter;
    private volatile boolean is_ready_for_write = false;
    private volatile boolean is_ready_for_read = false;
    private Throwable write_select_failure = null;
    private Throwable read_select_failure = null;

    protected TransportImpl() {
    }

    protected void setFilter(TransportHelperFilter _filter) {
        this.filter = _filter;
    }

    protected TransportHelperFilter getFilter() {
        return this.filter;
    }

    public void setAlreadyRead(ByteBuffer bytes_already_read) {
        if (this.data_already_read != null) {
            Debug.out("push back already performed");
        }
        if (bytes_already_read != null && bytes_already_read.hasRemaining()) {
            this.data_already_read = bytes_already_read;
            this.is_ready_for_read = true;
        }
    }

    public String getEncryption() {
        return this.filter == null ? "" : this.filter.getName();
    }

    public boolean isReadyForWrite(EventWaiter waiter) {
        this.write_waiter = waiter;
        return this.is_ready_for_write;
    }

    protected boolean readyForWrite(boolean ready) {
        if (ready) {
            boolean progress = !this.is_ready_for_write;
            this.is_ready_for_write = true;
            EventWaiter ww = this.write_waiter;
            if (ww != null) {
                ww.eventOccurred();
            }
            return progress;
        }
        this.is_ready_for_write = false;
        return false;
    }

    protected void writeFailed(Throwable msg) {
        msg.fillInStackTrace();
        this.write_select_failure = msg;
        this.is_ready_for_write = true;
    }

    public boolean isReadyForRead(EventWaiter waiter) {
        this.read_waiter = waiter;
        return this.is_ready_for_read || this.data_already_read != null || this.filter != null && this.filter.hasBufferedRead();
    }

    protected boolean readyForRead(boolean ready) {
        if (ready) {
            boolean progress = !this.is_ready_for_read;
            this.is_ready_for_read = true;
            EventWaiter rw = this.read_waiter;
            if (rw != null) {
                rw.eventOccurred();
            }
            return progress;
        }
        this.is_ready_for_read = false;
        return false;
    }

    protected void readFailed(Throwable msg) {
        msg.fillInStackTrace();
        this.read_select_failure = msg;
        this.is_ready_for_read = true;
    }

    public long write(ByteBuffer[] buffers, int array_offset, int length) throws IOException {
        if (this.write_select_failure != null) {
            throw new IOException("write_select_failure: " + this.write_select_failure.getMessage());
        }
        if (this.filter == null) {
            return 0L;
        }
        long written = this.filter.write(buffers, array_offset, length);
        if (stats != null) {
            stats.bytesWritten((int)written);
        }
        if (written < 1L) {
            this.requestWriteSelect();
        }
        return written;
    }

    public long read(ByteBuffer[] buffers, int array_offset, int length) throws IOException {
        if (this.read_select_failure != null) {
            throw new IOException("read_select_failure: " + this.read_select_failure.getMessage());
        }
        if (this.data_already_read != null) {
            int inserted = 0;
            for (int i = array_offset; i < array_offset + length; ++i) {
                ByteBuffer bb = buffers[i];
                int orig_limit = this.data_already_read.limit();
                if (this.data_already_read.remaining() > bb.remaining()) {
                    this.data_already_read.limit(this.data_already_read.position() + bb.remaining());
                }
                inserted += this.data_already_read.remaining();
                bb.put(this.data_already_read);
                this.data_already_read.limit(orig_limit);
                if (this.data_already_read.hasRemaining()) continue;
                this.data_already_read = null;
                break;
            }
            if (!buffers[array_offset + length - 1].hasRemaining()) {
                return inserted;
            }
        }
        long bytes_read = this.filter.read(buffers, array_offset, length);
        if (stats != null) {
            stats.bytesRead((int)bytes_read);
        }
        if (bytes_read == 0L) {
            this.requestReadSelect();
        }
        return bytes_read;
    }

    private void requestWriteSelect() {
        this.is_ready_for_write = false;
        if (this.filter != null) {
            this.filter.getHelper().resumeWriteSelects();
        }
    }

    private void requestReadSelect() {
        this.is_ready_for_read = false;
        if (this.filter != null) {
            this.filter.getHelper().resumeReadSelects();
        }
    }

    public void connectedInbound() {
        this.registerSelectHandling();
    }

    protected void connectedOutbound() {
        this.registerSelectHandling();
    }

    private void registerSelectHandling() {
        TransportHelperFilter filter = this.getFilter();
        if (filter == null) {
            Debug.out("ERROR: registerSelectHandling():: filter == null");
            return;
        }
        TransportHelper helper = filter.getHelper();
        helper.registerForReadSelects(new TransportHelper.selectListener(){

            public boolean selectSuccess(TransportHelper helper, Object attachment) {
                return TransportImpl.this.readyForRead(true);
            }

            public void selectFailure(TransportHelper helper, Object attachment, Throwable msg) {
                TransportImpl.this.readFailed(msg);
            }
        }, null);
        helper.registerForWriteSelects(new TransportHelper.selectListener(){

            public boolean selectSuccess(TransportHelper helper, Object attachment) {
                return TransportImpl.this.readyForWrite(true);
            }

            public void selectFailure(TransportHelper helper, Object attachment, Throwable msg) {
                TransportImpl.this.writeFailed(msg);
            }
        }, null);
    }
}

