/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.core.dht.transport.udp.impl;

import com.aelitis.azureus.core.dht.impl.DHTLog;
import com.aelitis.azureus.core.dht.netcoords.DHTNetworkPosition;
import com.aelitis.azureus.core.dht.netcoords.DHTNetworkPositionManager;
import com.aelitis.azureus.core.dht.netcoords.vivaldi.ver1.VivaldiPositionProvider;
import com.aelitis.azureus.core.dht.transport.DHTTransport;
import com.aelitis.azureus.core.dht.transport.DHTTransportContact;
import com.aelitis.azureus.core.dht.transport.DHTTransportException;
import com.aelitis.azureus.core.dht.transport.DHTTransportFullStats;
import com.aelitis.azureus.core.dht.transport.DHTTransportReplyHandler;
import com.aelitis.azureus.core.dht.transport.DHTTransportReplyHandlerAdapter;
import com.aelitis.azureus.core.dht.transport.DHTTransportValue;
import com.aelitis.azureus.core.dht.transport.udp.DHTTransportUDPContact;
import com.aelitis.azureus.core.dht.transport.udp.impl.DHTTransportUDPImpl;
import com.aelitis.azureus.core.dht.transport.udp.impl.DHTUDPUtils;
import java.io.DataOutputStream;
import java.io.IOException;
import java.net.InetSocketAddress;
import org.gudy.azureus2.core3.util.AESemaphore;

public class DHTTransportUDPContactImpl
implements DHTTransportUDPContact {
    public static final int NODE_STATUS_UNKNOWN = -1;
    public static final int NODE_STATUS_ROUTABLE = 1;
    private DHTTransportUDPImpl transport;
    private InetSocketAddress external_address;
    private InetSocketAddress transport_address;
    private byte[] id;
    private byte protocol_version;
    private int instance_id;
    private long skew;
    private int random_id;
    private int node_status = -1;
    private DHTNetworkPosition[] network_positions;

    protected DHTTransportUDPContactImpl(boolean _is_local, DHTTransportUDPImpl _transport, InetSocketAddress _transport_address, InetSocketAddress _external_address, byte _protocol_version, int _instance_id, long _skew) throws DHTTransportException {
        this.transport = _transport;
        this.transport_address = _transport_address;
        this.external_address = _external_address;
        this.protocol_version = _protocol_version;
        if (this.transport_address.equals(this.external_address)) {
            this.external_address = this.transport_address;
        }
        this.instance_id = _instance_id;
        this.skew = _skew;
        if (this.transport_address == this.external_address || this.transport_address.getAddress().equals(this.external_address.getAddress())) {
            this.id = DHTUDPUtils.getNodeID(this.external_address, this.protocol_version);
        }
        this.network_positions = DHTNetworkPositionManager.createPositions(this.id == null ? DHTUDPUtils.getBogusNodeID() : this.id, _is_local);
    }

    public DHTTransport getTransport() {
        return this.transport;
    }

    public byte getProtocolVersion() {
        return this.protocol_version;
    }

    protected void setProtocolVersion(byte v) {
        this.protocol_version = v;
    }

    public long getClockSkew() {
        return this.skew;
    }

    public void setRandomID(int _random_id) {
        this.random_id = _random_id;
    }

    public int getRandomID() {
        return this.random_id;
    }

    protected int getNodeStatus() {
        return this.node_status;
    }

    protected void setNodeStatus(int ns) {
        this.node_status = ns;
    }

    public boolean isValid() {
        return this.addressMatchesID() && !this.transport.invalidExternalAddress(this.external_address.getAddress());
    }

    protected boolean addressMatchesID() {
        return this.id != null;
    }

    public InetSocketAddress getTransportAddress() {
        return this.transport_address;
    }

    public void setTransportAddress(InetSocketAddress address) {
        this.transport_address = address;
    }

    public InetSocketAddress getExternalAddress() {
        return this.external_address;
    }

    public String getName() {
        return DHTLog.getString2(this.id);
    }

    public InetSocketAddress getAddress() {
        return this.getExternalAddress();
    }

    public int getMaxFailForLiveCount() {
        return this.transport.getMaxFailForLiveCount();
    }

    public int getMaxFailForUnknownCount() {
        return this.transport.getMaxFailForUnknownCount();
    }

    public int getInstanceID() {
        return this.instance_id;
    }

    protected void setInstanceIDAndVersion(int _instance_id, byte _protocol_version) {
        this.instance_id = _instance_id;
        if (_protocol_version > this.protocol_version) {
            this.protocol_version = _protocol_version;
        }
    }

    public boolean isAlive(long timeout) {
        final AESemaphore sem = new AESemaphore("DHTTransportContact:alive");
        final boolean[] alive = new boolean[]{false};
        try {
            this.sendPing(new DHTTransportReplyHandlerAdapter(){

                public void pingReply(DHTTransportContact contact) {
                    alive[0] = true;
                    sem.release();
                }

                public void failed(DHTTransportContact contact, Throwable cause) {
                    sem.release();
                }
            });
            sem.reserve(timeout);
            return alive[0];
        }
        catch (Throwable e) {
            return false;
        }
    }

    public void sendPing(DHTTransportReplyHandler handler) {
        this.transport.sendPing(this, handler);
    }

    public void sendImmediatePing(DHTTransportReplyHandler handler, long timeout) {
        this.transport.sendImmediatePing(this, handler, timeout);
    }

    public void sendStats(DHTTransportReplyHandler handler) {
        this.transport.sendStats(this, handler);
    }

    public void sendStore(DHTTransportReplyHandler handler, byte[][] keys, DHTTransportValue[][] value_sets) {
        this.transport.sendStore(this, handler, keys, value_sets);
    }

    public void sendFindNode(DHTTransportReplyHandler handler, byte[] nid) {
        this.transport.sendFindNode(this, handler, nid);
    }

    public void sendFindValue(DHTTransportReplyHandler handler, byte[] key, int max_values, byte flags) {
        this.transport.sendFindValue(this, handler, key, max_values, flags);
    }

    public void sendKeyBlock(final DHTTransportReplyHandler handler, final byte[] request2, final byte[] signature) {
        this.sendFindNode(new DHTTransportReplyHandlerAdapter(){

            public void findNodeReply(DHTTransportContact contact, DHTTransportContact[] contacts) {
                DHTTransportUDPContactImpl.this.transport.sendKeyBlockRequest(DHTTransportUDPContactImpl.this, handler, request2, signature);
            }

            public void failed(DHTTransportContact _contact, Throwable _error) {
                handler.failed(_contact, _error);
            }
        }, new byte[0]);
    }

    public DHTTransportFullStats getStats() {
        return this.transport.getFullStats(this);
    }

    public byte[] getID() {
        if (this.id == null) {
            throw new RuntimeException("Invalid contact");
        }
        return this.id;
    }

    public void exportContact(DataOutputStream os) throws IOException, DHTTransportException {
        this.transport.exportContact(this, os);
    }

    public void remove() {
        this.transport.removeContact(this);
    }

    protected void setNetworkPositions(DHTNetworkPosition[] positions) {
        this.network_positions = positions;
    }

    public DHTNetworkPosition[] getNetworkPositions() {
        return this.network_positions;
    }

    public DHTNetworkPosition getNetworkPosition(byte position_type) {
        for (int i = 0; i < this.network_positions.length; ++i) {
            if (this.network_positions[i].getPositionType() != position_type) continue;
            return this.network_positions[i];
        }
        return null;
    }

    public String getString() {
        if (this.transport_address.equals(this.external_address)) {
            return DHTLog.getString2(this.id) + "[" + this.transport_address.toString() + ",V" + this.getProtocolVersion() + "]";
        }
        return DHTLog.getString2(this.id) + "[tran=" + this.transport_address.toString() + ",ext=" + this.external_address + ",V" + this.getProtocolVersion() + "]";
    }

    static {
        DHTNetworkPositionManager.registerProvider(new VivaldiPositionProvider());
    }
}

