/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.plugins.rating.updater;

import java.util.HashMap;
import java.util.Map;
import org.gudy.azureus2.plugins.utils.StaticUtilities;

public class RatingData {
    private static final String STRING_ENCODING = "UTF-8";
    private int score;
    private String nick;
    private String comment;

    public RatingData(int score, String nick, String comment) {
        this.score = score;
        this.nick = nick;
        this.comment = comment;
    }

    public RatingData(byte[] bencodedRating) {
        try {
            Map mRating = StaticUtilities.getFormatters().bDecode(bencodedRating);
            this.score = ((Long)mRating.get("s")).intValue();
            this.nick = new String((byte[])mRating.get("n"), STRING_ENCODING);
            this.comment = new String((byte[])mRating.get("c"), STRING_ENCODING);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public byte[] encodes() {
        try {
            HashMap<String, Object> mRating = new HashMap<String, Object>();
            mRating.put("s", new Long(this.score));
            if (this.comment.length() > 0) {
                mRating.put("n", this.nick.getBytes(STRING_ENCODING));
            } else {
                mRating.put("n", "");
            }
            mRating.put("c", this.comment.getBytes(STRING_ENCODING));
            return StaticUtilities.getFormatters().bEncode(mRating);
        }
        catch (Exception e) {
            e.printStackTrace();
            return new byte[0];
        }
    }

    public int getScore() {
        return this.score;
    }

    public String getNick() {
        return this.nick;
    }

    public String getComment() {
        return this.comment;
    }
}

