/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.plugins.rating.ui;

import com.aelitis.azureus.plugins.rating.RatingPlugin;
import com.aelitis.azureus.plugins.rating.updater.RatingData;
import com.aelitis.azureus.plugins.rating.updater.RatingResults;
import com.aelitis.azureus.plugins.rating.updater.RatingsUpdater;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.gudy.azureus2.plugins.download.Download;
import org.gudy.azureus2.ui.swt.ImageRepository;

public class RatingWindow {
    RatingPlugin plugin;
    RatingsUpdater updater;
    Download download;
    Text txtPersonalComment;
    RatingResults results;
    int score;
    String comment;

    public RatingWindow(RatingPlugin plugin, Download download) {
        this.plugin = plugin;
        this.updater = plugin.getUpdater();
        this.download = download;
        this.results = this.updater.getRatingsForDownload(download);
        RatingData personalData = this.updater.loadRatingsFromDownload(download);
        this.score = personalData.getScore();
        this.comment = personalData.getComment();
        final Shell shell = new Shell();
        shell.setText("Ratings & Comments for " + download.getTorrent().getName());
        shell.setImage(ImageRepository.getImage((String)"azureus"));
        GridLayout layout = new GridLayout();
        layout.numColumns = 3;
        shell.setLayout((Layout)layout);
        Label lblGlobalRating = new Label((Composite)shell, 0);
        lblGlobalRating.setText("Global Rating : ");
        Label lblGlobalRatingIcon = new Label((Composite)shell, 0);
        Label lblGlobalRatingInfo = new Label((Composite)shell, 0);
        lblGlobalRatingInfo.setText(this.results.getAverageScore());
        Label personalRating = new Label((Composite)shell, 0);
        personalRating.setText("Personal Rating : ");
        final Label personalRatingIcon = new Label((Composite)shell, 0);
        personalRatingIcon.addListener(4, new Listener(){

            public void handleEvent(Event event) {
                RatingWindow.this.score = event.x / 19 + 1;
                RatingWindow.this.setRatingImage(personalRatingIcon, RatingWindow.this.score);
            }
        });
        Button btnClear = new Button((Composite)shell, 8);
        btnClear.setText("clear");
        btnClear.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                RatingWindow.this.score = 0;
                RatingWindow.this.setRatingImage(personalRatingIcon, RatingWindow.this.score);
            }
        });
        personalRating.setToolTipText("Click the image to change your rating");
        personalRatingIcon.setToolTipText("Click the image to change your rating");
        Label lblComments = new Label((Composite)shell, 0);
        lblComments.setText("Comments : ");
        StyledText txtComments = new StyledText((Composite)shell, 2568);
        txtComments.setText(this.results.getComments());
        txtComments.setWordWrap(true);
        GridData data = new GridData(1808);
        data.horizontalSpan = 3;
        txtComments.setLayoutData((Object)data);
        Label personalComment = new Label((Composite)shell, 0);
        personalComment.setText("Your Comment (max 150 chars) : ");
        data = new GridData();
        data.horizontalSpan = 3;
        personalComment.setLayoutData((Object)data);
        this.txtPersonalComment = new Text((Composite)shell, 2048);
        this.txtPersonalComment.setText(this.comment);
        data = new GridData(768);
        data.horizontalSpan = 3;
        this.txtPersonalComment.setLayoutData((Object)data);
        this.txtPersonalComment.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                if (RatingWindow.this.txtPersonalComment.getText().length() > 150 && e.character != '\u007f' && e.keyCode != 8) {
                    e.doit = false;
                }
            }
        });
        Button btnOk = new Button((Composite)shell, 8);
        btnOk.setText("Ok");
        data = new GridData(896);
        data.horizontalSpan = 3;
        data.widthHint = 70;
        btnOk.setLayoutData((Object)data);
        btnOk.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                RatingData data = new RatingData(RatingWindow.this.score, RatingWindow.this.plugin.getNick(), RatingWindow.this.txtPersonalComment.getText());
                RatingWindow.this.updater.storeRatingsToDownload(RatingWindow.this.download, data);
                shell.close();
            }
        });
        this.setRatingImage(lblGlobalRatingIcon, this.results.getAverageScoreRound());
        this.setRatingImage(personalRatingIcon, this.score);
        shell.setSize(350, 400);
        shell.open();
    }

    private void setRatingImage(Label label, int rating) {
        if (rating == 0) {
            label.setImage(this.plugin.imgNoRating);
            if (this.txtPersonalComment.isEnabled()) {
                this.comment = this.txtPersonalComment.getText();
                this.txtPersonalComment.setText("You need to rate the torrent to comment it.");
                this.txtPersonalComment.setEnabled(false);
            }
        } else {
            label.setImage(this.plugin.imgRated[rating - 1]);
            if (!this.txtPersonalComment.isEnabled()) {
                this.txtPersonalComment.setText(this.comment);
                this.txtPersonalComment.setEnabled(true);
            }
        }
    }
}

