/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.ui.telnet;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.util.HashSet;
import java.util.StringTokenizer;
import org.apache.log4j.Logger;
import org.gudy.azureus2.core3.config.COConfigurationManager;
import org.gudy.azureus2.core3.torrentdownloader.TorrentDownloaderFactory;
import org.gudy.azureus2.core3.util.FileUtil;
import org.gudy.azureus2.ui.common.IUserInterface;
import org.gudy.azureus2.ui.common.UIConst;
import org.gudy.azureus2.ui.common.UITemplateHeadless;
import org.gudy.azureus2.ui.console.ConsoleInput;
import org.gudy.azureus2.ui.console.UserProfile;
import org.gudy.azureus2.ui.console.multiuser.MultiUserConsoleInput;
import org.gudy.azureus2.ui.console.multiuser.UserManager;
import org.gudy.azureus2.ui.console.multiuser.commands.UserCommand;
import org.gudy.azureus2.ui.telnet.SocketServer;

public class UI
extends UITemplateHeadless
implements IUserInterface {
    private UserManager userManager;

    public String[] processArgs(String[] args) {
        return args;
    }

    public void startUI() {
        if (!this.isStarted()) {
            try {
                int telnetPort = COConfigurationManager.getIntParameter("Telnet_iPort", 57006);
                String allowedHostsStr = COConfigurationManager.getStringParameter("Telnet_sAllowedHosts", "127.0.0.1,titan");
                StringTokenizer st = new StringTokenizer(allowedHostsStr, ",");
                HashSet<String> allowedHosts = new HashSet<String>();
                while (st.hasMoreTokens()) {
                    allowedHosts.add(st.nextToken().toLowerCase());
                }
                int maxLoginAttempts = COConfigurationManager.getIntParameter("Telnet_iMaxLoginAttempts", 3);
                this.userManager = this.initUserManager();
                Thread thread = new Thread((Runnable)new SocketServer(this, telnetPort, allowedHosts, this.userManager, maxLoginAttempts), "Telnet Socket Server Thread");
                thread.setDaemon(true);
                thread.start();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        super.startUI();
    }

    private UserManager initUserManager() {
        if (System.getProperty("azureus.console.multiuser") != null) {
            return UserManager.getInstance(UIConst.getAzureusCore().getPluginManager().getDefaultPluginInterface());
        }
        return null;
    }

    public void openTorrent(String fileName) {
        if (fileName.toUpperCase().startsWith("HTTP://")) {
            System.out.println("Downloading torrent from url: " + fileName);
            TorrentDownloaderFactory.downloadManaged(fileName);
            return;
        }
        try {
            if (!FileUtil.isTorrentFile(fileName)) {
                Logger.getLogger((String)"azureus2.ui.telnet").error((Object)(fileName + " doesn't seem to be a torrent file. Not added."));
                return;
            }
        }
        catch (Exception e) {
            Logger.getLogger((String)"azureus2.ui.telnet").error((Object)("Something is wrong with " + fileName + ". Not added. (Reason: " + e.getMessage() + ")"));
            return;
        }
        if (UIConst.getGlobalManager() != null) {
            try {
                UIConst.getGlobalManager().addDownloadManager(fileName, COConfigurationManager.getDirectoryParameter("Default save path"));
            }
            catch (Exception e) {
                Logger.getLogger((String)"azureus2.ui.telnet").error((Object)("The torrent " + fileName + " could not be added."), (Throwable)e);
            }
        }
    }

    public void createNewConsoleInput(String consoleName, InputStream inputStream, PrintStream outputStream, UserProfile profile) {
        ConsoleInput console;
        if (this.userManager != null) {
            MultiUserConsoleInput muc = new MultiUserConsoleInput(consoleName, UIConst.getAzureusCore(), new InputStreamReader(inputStream), outputStream, Boolean.FALSE, profile);
            muc.registerCommand(new UserCommand(this.userManager));
            console = muc;
        } else {
            console = new ConsoleInput(consoleName, UIConst.getAzureusCore(), new InputStreamReader(inputStream), outputStream, Boolean.FALSE, profile);
        }
        console.printconsolehelp();
    }
}

