/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.ui.swt.mainwindow;

import com.aelitis.azureus.core.AzureusCore;
import java.io.File;
import java.io.IOException;
import org.eclipse.swt.dnd.DropTargetEvent;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Shell;
import org.gudy.azureus2.core3.config.COConfigurationManager;
import org.gudy.azureus2.core3.global.GlobalManager;
import org.gudy.azureus2.core3.internat.MessageText;
import org.gudy.azureus2.core3.logging.LogAlert;
import org.gudy.azureus2.core3.logging.LogEvent;
import org.gudy.azureus2.core3.logging.LogIDs;
import org.gudy.azureus2.core3.logging.Logger;
import org.gudy.azureus2.core3.torrent.TOTorrent;
import org.gudy.azureus2.core3.util.AERunnable;
import org.gudy.azureus2.core3.util.AEThread;
import org.gudy.azureus2.core3.util.Constants;
import org.gudy.azureus2.core3.util.FileUtil;
import org.gudy.azureus2.core3.util.TorrentUtils;
import org.gudy.azureus2.ui.swt.OpenTorrentWindow;
import org.gudy.azureus2.ui.swt.URLTransfer;
import org.gudy.azureus2.ui.swt.Utils;
import org.gudy.azureus2.ui.swt.mainwindow.MainWindow;
import org.gudy.azureus2.ui.swt.sharing.ShareUtils;

public class TorrentOpener {
    public static void openTorrent(String torrentFile) {
        TorrentOpener.openTorrentWindow(null, new String[]{torrentFile}, false);
    }

    public static void openTorrentWindow() {
        TorrentOpener.openTorrentWindow(null, null, false);
    }

    protected static void openTorrentsForTracking(final String path, final String[] fileNames) {
        Utils.execSWTThread(new AERunnable(){

            public void runSupport() {
                MainWindow mainWindow = MainWindow.getWindow();
                if (mainWindow == null) {
                    return;
                }
                Display display = mainWindow.getDisplay();
                AzureusCore azureus_core = mainWindow.getAzureusCore();
                if (display == null || display.isDisposed() || azureus_core == null) {
                    return;
                }
                new AEThread(this, "TorrentOpener", azureus_core){
                    private final /* synthetic */ AzureusCore val$azureus_core;
                    private final /* synthetic */ 1 this$0;
                    {
                        this.this$0 = this$0;
                        this.val$azureus_core = val$azureus_core;
                        super(x0);
                    }

                    public void runSupport() {
                        for (int i = 0; i < 1.access$000(this.this$0).length; ++i) {
                            try {
                                TOTorrent t = TorrentUtils.readFromFile(new File(1.access$100(this.this$0), 1.access$000(this.this$0)[i]), true);
                                this.val$azureus_core.getTrackerHost().hostTorrent(t, true, true);
                                continue;
                            }
                            catch (Throwable e) {
                                Logger.log(new LogAlert(false, "Torrent open fails for '" + 1.access$100(this.this$0) + File.separator + 1.access$000(this.this$0)[i] + "'", e));
                            }
                        }
                    }
                }.start();
            }

            static /* synthetic */ String[] access$000(1 x0) {
                return x0.fileNames;
            }

            static /* synthetic */ String access$100(1 x0) {
                return x0.path;
            }
        });
    }

    public static void openTorrentTrackingOnly() {
        Utils.execSWTThread(new AERunnable(){

            public void runSupport() {
                MainWindow mainWindow = MainWindow.getWindow();
                if (mainWindow == null) {
                    return;
                }
                Shell shell = mainWindow.getShell();
                if (shell == null || shell.isDisposed()) {
                    return;
                }
                FileDialog fDialog = new FileDialog(shell, 4098);
                fDialog.setFilterPath(TorrentOpener.getFilterPathTorrent());
                fDialog.setFilterExtensions(new String[]{"*.torrent", "*.tor", Constants.FILE_WILDCARD});
                fDialog.setFilterNames(new String[]{"*.torrent", "*.tor", Constants.FILE_WILDCARD});
                fDialog.setText(MessageText.getString("MainWindow.dialog.choose.file"));
                String path = TorrentOpener.setFilterPathTorrent(fDialog.open());
                if (path == null) {
                    return;
                }
                TorrentOpener.openTorrentsForTracking(path, fDialog.getFileNames());
            }
        });
    }

    public static void openDroppedTorrents(AzureusCore azureus_core, DropTargetEvent event) {
        boolean bOverrideToStopped;
        if (event.data == null) {
            return;
        }
        boolean bl = bOverrideToStopped = event.detail == 1;
        if (event.data instanceof String[] || event.data instanceof String) {
            String[] stringArray;
            if (event.data instanceof String[]) {
                stringArray = (String[])event.data;
            } else {
                String[] stringArray2 = new String[1];
                stringArray = stringArray2;
                stringArray2[0] = (String)event.data;
            }
            String[] sourceNames = stringArray;
            if (sourceNames == null) {
                event.detail = 0;
            }
            if (event.detail == 0) {
                return;
            }
            for (int i = 0; i < sourceNames.length; ++i) {
                File source = new File(sourceNames[i]);
                if (source.isFile()) {
                    String filename = source.getAbsolutePath();
                    try {
                        if (!FileUtil.isTorrentFile(filename)) {
                            Logger.log(new LogEvent(LogIDs.GUI, "MainWindow::openTorrent: file it not a torrent file, sharing"));
                            ShareUtils.shareFile(azureus_core, filename);
                            continue;
                        }
                        TorrentOpener.openTorrentWindow(null, new String[]{filename}, bOverrideToStopped);
                    }
                    catch (Exception e) {
                        Logger.log(new LogAlert(true, "Torrent open fails for '" + filename + "'", e));
                    }
                    continue;
                }
                if (source.isDirectory()) {
                    String dir_name = source.getAbsolutePath();
                    String drop_action = COConfigurationManager.getStringParameter("config.style.dropdiraction", "0");
                    if (drop_action.equals("1")) {
                        ShareUtils.shareDir(azureus_core, dir_name);
                        continue;
                    }
                    if (drop_action.equals("2")) {
                        ShareUtils.shareDirContents(azureus_core, dir_name, false);
                        continue;
                    }
                    if (drop_action.equals("3")) {
                        ShareUtils.shareDirContents(azureus_core, dir_name, true);
                        continue;
                    }
                    TorrentOpener.openTorrentWindow(dir_name, null, bOverrideToStopped);
                    continue;
                }
                TorrentOpener.openTorrentWindow(null, new String[]{sourceNames[i]}, bOverrideToStopped);
            }
        } else if (event.data instanceof URLTransfer.URLType) {
            TorrentOpener.openTorrentWindow(null, new String[]{((URLTransfer.URLType)event.data).linkURL}, bOverrideToStopped);
        }
    }

    public static String getFilterPathData() {
        String before = COConfigurationManager.getStringParameter("previous.filter.dir.data");
        if (before != null && before.length() > 0) {
            return before;
        }
        try {
            String def = COConfigurationManager.getDirectoryParameter("Default save path");
            return def;
        }
        catch (IOException e) {
            return "";
        }
    }

    public static String getFilterPathTorrent() {
        String before = COConfigurationManager.getStringParameter("previous.filter.dir.torrent");
        if (before != null && before.length() > 0) {
            return before;
        }
        return COConfigurationManager.getStringParameter("General_sDefaultTorrent_Directory");
    }

    public static String setFilterPathData(String path) {
        if (path != null && path.length() > 0) {
            String before;
            File test = new File(path);
            if (!test.isDirectory()) {
                test = test.getParentFile();
            }
            String now = "";
            if (test != null) {
                now = test.getAbsolutePath();
            }
            if ((before = COConfigurationManager.getStringParameter("previous.filter.dir.data")) == null || before.length() == 0 || !before.equals(now)) {
                COConfigurationManager.setParameter("previous.filter.dir.data", now);
                COConfigurationManager.save();
            }
        }
        return path;
    }

    public static String setFilterPathTorrent(String path) {
        if (path != null && path.length() > 0) {
            String before;
            File test = new File(path);
            if (!test.isDirectory()) {
                test = test.getParentFile();
            }
            String now = "";
            if (test != null) {
                now = test.getAbsolutePath();
            }
            if ((before = COConfigurationManager.getStringParameter("previous.filter.dir.torrent")) == null || before.length() == 0 || !before.equals(now)) {
                COConfigurationManager.setParameter("previous.filter.dir.torrent", now);
                COConfigurationManager.save();
            }
            return now;
        }
        return path;
    }

    private static void openTorrentWindow(final String path, final String[] torrents, final boolean bOverrideStartModeToStopped) {
        Utils.execSWTThread(new AERunnable(){

            public void runSupport() {
                MainWindow mainWindow = MainWindow.getWindow();
                if (mainWindow == null) {
                    return;
                }
                Shell shell = mainWindow.getShell();
                GlobalManager gm = mainWindow.getGlobalManager();
                if (shell == null || shell.isDisposed() || gm == null) {
                    return;
                }
                OpenTorrentWindow.invoke(shell, gm, path, torrents, bOverrideStartModeToStopped, false, false);
            }
        });
    }
}

