/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.ui.swt.config.wizard;

import com.aelitis.azureus.core.AzureusCore;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.MessageBox;
import org.gudy.azureus2.core3.config.COConfigurationManager;
import org.gudy.azureus2.core3.internat.MessageText;
import org.gudy.azureus2.ui.swt.config.wizard.WelcomePanel;
import org.gudy.azureus2.ui.swt.wizard.Wizard;

public class ConfigureWizard
extends Wizard {
    int upSpeed = 4;
    int maxUpSpeed = 40;
    int maxActiveTorrents = 7;
    int maxDownloads = 5;
    int nbUploadsPerTorrent = 4;
    int serverTCPListenPort = COConfigurationManager.getIntParameter("TCP.Listen.Port");
    String torrentPath;
    boolean fastResume = true;
    boolean completed = false;

    public ConfigureWizard(AzureusCore azureus_core, Display display) {
        super(azureus_core, display, "configureWizard.title");
        WelcomePanel panel = new WelcomePanel(this, null);
        this.setFirstPanel(panel);
        try {
            this.torrentPath = COConfigurationManager.getDirectoryParameter("General_sDefaultTorrent_Directory");
        }
        catch (Exception e) {
            this.torrentPath = "";
        }
    }

    public void onClose() {
        if (!this.completed && !COConfigurationManager.getBooleanParameter("Wizard Completed", false)) {
            MessageBox mb = new MessageBox(this.getWizardWindow(), 196);
            mb.setText(MessageText.getString("wizard.close.confirmation"));
            mb.setMessage(MessageText.getString("wizard.close.message"));
            int result = mb.open();
            if (result == 128) {
                COConfigurationManager.setParameter("Wizard Completed", true);
                COConfigurationManager.save();
            }
        }
        super.onClose();
    }
}

