/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.ui.swt.components.shell;

import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.gudy.azureus2.core3.util.Constants;
import org.gudy.azureus2.ui.swt.components.shell.ShellManager;
import org.gudy.azureus2.ui.swt.mainwindow.MainMenu;
import org.gudy.azureus2.ui.swt.mainwindow.MainWindow;

public final class ShellFactory {
    public static Shell createShell(Display disp, int styles) {
        return ShellFactory.getRegisteredShell(new AEShell(disp, styles));
    }

    public static Shell createShell(Display disp) {
        return ShellFactory.getRegisteredShell(new AEShell(disp));
    }

    public static Shell createShell(Shell parent, int styles) {
        if (parent != null && parent.isDisposed()) {
            return null;
        }
        return ShellFactory.getRegisteredShell(new AEShell(parent, styles));
    }

    public static Shell createShell(Shell parent) {
        return ShellFactory.getRegisteredShell(new AEShell(parent));
    }

    public static Shell createShell(int styles) {
        return ShellFactory.getRegisteredShell(new AEShell(styles));
    }

    private static Shell getRegisteredShell(Shell toRegister) {
        if (Constants.isOSX) {
            if (MainWindow.getWindow() == null) {
                throw new IllegalStateException("Main window is not initialized yet");
            }
            new MainMenu(toRegister);
        }
        ShellManager.sharedManager().addWindow(toRegister);
        return toRegister;
    }

    private static class AEShell
    extends Shell {
        private AEShell(int styles) {
            super(styles);
        }

        private AEShell(Display display) {
            super(display);
        }

        private AEShell(Display display, int styles) {
            super(display, styles);
        }

        private AEShell(Shell parent) {
            super(parent);
        }

        private AEShell(Shell parent, int styles) {
            super(parent, styles);
        }

        protected void checkSubclass() {
        }

        public void setImage(Image image) {
            if (!Constants.isOSX) {
                super.setImage(image);
            }
        }

        public void setImages(Image[] images) {
            if (!Constants.isOSX) {
                super.setImages(images);
            }
        }
    }
}

