/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.ui.swt;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import org.eclipse.swt.SWT;
import org.eclipse.swt.SWTException;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.DropTarget;
import org.eclipse.swt.dnd.DropTargetAdapter;
import org.eclipse.swt.dnd.DropTargetEvent;
import org.eclipse.swt.dnd.DropTargetListener;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.graphics.Region;
import org.eclipse.swt.graphics.Resource;
import org.eclipse.swt.graphics.TextLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.program.Program;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.ScrollBar;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;
import org.gudy.azureus2.core3.config.COConfigurationManager;
import org.gudy.azureus2.core3.internat.MessageText;
import org.gudy.azureus2.core3.util.AERunnable;
import org.gudy.azureus2.core3.util.Constants;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.ui.swt.ImageRepository;
import org.gudy.azureus2.ui.swt.URLTransfer;
import org.gudy.azureus2.ui.swt.mainwindow.Colors;
import org.gudy.azureus2.ui.swt.mainwindow.SWTThread;
import org.gudy.azureus2.ui.swt.views.utils.VerticalAligner;

public class Utils {
    public static final boolean LAST_TABLECOLUMN_EXPANDS = Constants.isLinux;
    public static final boolean isGTK = SWT.getPlatform().equals("gtk");
    private static final boolean DIRECT_SETCHECKED = !Constants.isOSX || SWT.getVersion() >= 3212;

    public static void disposeComposite(Composite composite, boolean disposeSelf) {
        if (composite == null || composite.isDisposed()) {
            return;
        }
        Control[] controls = composite.getChildren();
        for (int i = 0; i < controls.length; ++i) {
            Control control = controls[i];
            if (control == null || control.isDisposed()) continue;
            if (control instanceof Composite) {
                Utils.disposeComposite((Composite)control, true);
            }
            try {
                control.dispose();
                continue;
            }
            catch (SWTException e) {
                Debug.printStackTrace(e);
            }
        }
        if (!composite.isDisposed() && disposeSelf) {
            try {
                composite.dispose();
            }
            catch (SWTException e) {
                Debug.printStackTrace(e);
            }
        }
    }

    public static void disposeComposite(Composite composite) {
        Utils.disposeComposite(composite, true);
    }

    public static void disposeSWTObjects(List disposeList) {
        boolean bResourceObjectExists = SWT.getVersion() >= 3129;
        for (int i = 0; i < disposeList.size(); ++i) {
            Object o = disposeList.get(i);
            if (o instanceof Widget && !((Widget)o).isDisposed()) {
                ((Widget)o).dispose();
                continue;
            }
            if (bResourceObjectExists && o instanceof Resource && !((Resource)o).isDisposed()) {
                ((Resource)o).dispose();
                continue;
            }
            try {
                if (o instanceof Cursor && !((Cursor)o).isDisposed()) {
                    ((Cursor)o).dispose();
                    continue;
                }
                if (o instanceof Font && !((Font)o).isDisposed()) {
                    ((Font)o).dispose();
                    continue;
                }
                if (o instanceof GC && !((GC)o).isDisposed()) {
                    ((GC)o).dispose();
                    continue;
                }
                if (o instanceof Image && !((Image)o).isDisposed()) {
                    ((Image)o).dispose();
                    continue;
                }
                if (o instanceof Region && !((Region)o).isDisposed()) {
                    ((Region)o).dispose();
                    continue;
                }
                if (!(o instanceof TextLayout) || ((TextLayout)o).isDisposed()) continue;
                ((TextLayout)o).dispose();
                continue;
            }
            catch (NoClassDefFoundError e) {
                // empty catch block
            }
        }
        disposeList.clear();
    }

    public static void setTextLinkFromClipboard(Shell shell, Text url, boolean accept_magnets) {
        String link = Utils.getLinkFromClipboard(shell.getDisplay(), accept_magnets);
        if (link != null) {
            url.setText(link);
        }
    }

    public static String getLinkFromClipboard(Display display, boolean accept_magnets) {
        String[] prefixes = new String[]{"http://", "https://", "magnet:?", "magnet://?"};
        Clipboard cb = new Clipboard(display);
        TextTransfer transfer = TextTransfer.getInstance();
        String data = (String)cb.getContents((Transfer)transfer);
        if (data != null) {
            int i;
            data = data.trim();
            for (i = 0; i < (accept_magnets ? prefixes.length : 2); ++i) {
                int begin = data.indexOf(prefixes[i]);
                if (begin < 0) continue;
                int end = data.indexOf("\n", begin + prefixes[i].length());
                String stringURL = end >= 0 ? data.substring(begin, end - 1) : data.substring(begin);
                try {
                    URL parsedURL = new URL(stringURL);
                    return parsedURL.toExternalForm();
                }
                catch (MalformedURLException e1) {
                    // empty catch block
                }
            }
            if (accept_magnets && data.length() == 40) {
                for (i = 0; i < data.length(); ++i) {
                    if ("0123456789abcdefABCDEF".indexOf(data.charAt(i)) != -1) continue;
                    return prefixes[0];
                }
                return data;
            }
        }
        return prefixes[0];
    }

    public static void centreWindow(Shell shell) {
        Rectangle displayRect;
        try {
            displayRect = shell.getMonitor().getClientArea();
        }
        catch (NoSuchMethodError e) {
            displayRect = shell.getDisplay().getClientArea();
        }
        Rectangle shellRect = shell.getBounds();
        if (shellRect.width > displayRect.width - 100) {
            shellRect.width = displayRect.width - 100;
        }
        if (shellRect.height > displayRect.height - 64) {
            shellRect.height = displayRect.height - 100;
        }
        shellRect.x = (displayRect.width - shellRect.width) / 2;
        shellRect.y = (displayRect.height - shellRect.height) / 2;
        shell.setBounds(shellRect);
    }

    public static void centerWindowRelativeTo(Shell window, Control control) {
        Rectangle bounds = control.getBounds();
        Point shellSize = window.getSize();
        window.setLocation(bounds.x + bounds.width / 2 - shellSize.x / 2, bounds.y + bounds.height / 2 - shellSize.y / 2);
    }

    public static void createURLDropTarget(Control control, final Text url) {
        DropTarget dropTarget = new DropTarget(control, 23);
        dropTarget.setTransfer(new Transfer[]{URLTransfer.getInstance()});
        dropTarget.addDropListener((DropTargetListener)new DropTargetAdapter(){

            public void dropAccept(DropTargetEvent event) {
                event.currentDataType = URLTransfer.pickBestType(event.dataTypes, event.currentDataType);
            }

            public void dragOver(DropTargetEvent event) {
                if ((event.operations & 4) > 0) {
                    event.detail = 4;
                } else if ((event.operations & 1) > 0) {
                    event.detail = 1;
                }
            }

            public void drop(DropTargetEvent event) {
                if (((URLTransfer.URLType)event.data).linkURL != null) {
                    url.setText(((URLTransfer.URLType)event.data).linkURL);
                }
            }
        });
    }

    public static void alternateRowBackground(TableItem item) {
        if (Constants.isLinux) {
            if (!item.getParent().getLinesVisible()) {
                item.getParent().setLinesVisible(true);
            }
            return;
        }
        if (item == null || item.isDisposed()) {
            return;
        }
        Color[] colors = new Color[]{item.getDisplay().getSystemColor(25), Colors.colorAltRow};
        Color newColor = colors[item.getParent().indexOf(item) % colors.length];
        if (!item.getBackground().equals((Object)newColor)) {
            item.setBackground(newColor);
        }
    }

    public static void alternateTableBackground(Table table) {
        if (table == null || table.isDisposed()) {
            return;
        }
        if (Constants.isLinux) {
            if (!table.getLinesVisible()) {
                table.setLinesVisible(true);
            }
            return;
        }
        int iTopIndex = table.getTopIndex();
        int iBottomIndex = Utils.getTableBottomIndex(table, iTopIndex);
        Color[] colors = new Color[]{table.getDisplay().getSystemColor(25), Colors.colorAltRow};
        int iFixedIndex = iTopIndex;
        for (int i = iTopIndex; i <= iBottomIndex; ++i) {
            TableItem row = table.getItem(i);
            if (row.isDisposed()) continue;
            Color newColor = colors[iFixedIndex % colors.length];
            ++iFixedIndex;
            if (row.getBackground().equals((Object)newColor)) continue;
            row.setBackground(newColor);
        }
    }

    public static void setMenuItemImage(MenuItem item, String repoKey) {
        if (!Constants.isOSX) {
            item.setImage(ImageRepository.getImage(repoKey));
        }
    }

    public static void setMenuItemImage(MenuItem item, Image image) {
        if (!Constants.isOSX) {
            item.setImage(image);
        }
    }

    public static void setShellIcon(Shell shell) {
        block5: {
            String[] sImageNames = new String[]{"azureus", "azureus32", "azureus64", "azureus128"};
            if (Constants.isOSX) {
                return;
            }
            try {
                ArrayList<Image> list = new ArrayList<Image>();
                Image[] images = new Image[]{ImageRepository.getImage("azureus"), ImageRepository.getImage("azureus32"), ImageRepository.getImage("azureus64"), ImageRepository.getImage("azureus128")};
                for (int i = 0; i < images.length; ++i) {
                    Image image = ImageRepository.getImage(sImageNames[i]);
                    if (image == null) continue;
                    list.add(image);
                }
                if (list.size() == 0) {
                    return;
                }
                shell.setImages(list.toArray(new Image[0]));
            }
            catch (NoSuchMethodError e) {
                Image image = ImageRepository.getImage(sImageNames[0]);
                if (image == null) break block5;
                shell.setImage(image);
            }
        }
    }

    public static boolean execSWTThread(Runnable code, boolean async) {
        SWTThread swt = SWTThread.getInstance();
        if (swt == null) {
            System.err.println("SWT Thread not started yet");
            return false;
        }
        Display display = swt.getDisplay();
        if (display == null || display.isDisposed()) {
            return false;
        }
        if (display.getThread() == Thread.currentThread()) {
            code.run();
        } else if (async) {
            display.asyncExec(code);
        } else {
            display.syncExec(code);
        }
        return true;
    }

    public static boolean execSWTThread(Runnable code) {
        return Utils.execSWTThread(code, true);
    }

    public static boolean isThisThreadSWT() {
        SWTThread swt = SWTThread.getInstance();
        if (swt == null) {
            System.err.println("SWT Thread not started yet");
            return false;
        }
        Display display = swt.getDisplay();
        if (display == null || display.isDisposed()) {
            return false;
        }
        return display.getThread() == Thread.currentThread();
    }

    public static int openMessageBox(Shell parent, int style, String keyPrefix, String[] textParams) {
        MessageBox mb = new MessageBox(parent, style);
        mb.setMessage(MessageText.getString(keyPrefix + ".text", textParams));
        mb.setText(MessageText.getString(keyPrefix + ".title"));
        return mb.open();
    }

    public static int openMessageBox(Shell parent, int style, String title, String text) {
        MessageBox mb = new MessageBox(parent, style);
        mb.setMessage(text);
        mb.setText(title);
        return mb.open();
    }

    public static int getTableBottomIndex(Table table, int iTopIndex) {
        if (!table.isVisible()) {
            return -1;
        }
        if (Constants.isOSX) {
            return Math.min(iTopIndex + (table.getClientArea().height - table.getHeaderHeight() - 1) / table.getItemHeight(), table.getItemCount() - 1);
        }
        int areaHeight = table.getClientArea().height;
        if (areaHeight <= table.getHeaderHeight()) {
            return -1;
        }
        TableItem bottomItem = table.getItem(new Point(2, table.getClientArea().height - 1));
        int iBottomIndex = bottomItem != null ? table.indexOf(bottomItem) : table.getItemCount() - 1;
        return iBottomIndex;
    }

    public static void openURL(String url) {
        Program.launch((String)url);
    }

    public static void setCheckedInSetData(final TableItem item, final boolean checked) {
        if (DIRECT_SETCHECKED) {
            item.setChecked(checked);
        } else {
            item.setChecked(!checked);
            item.getDisplay().asyncExec((Runnable)new AERunnable(){

                public void runSupport() {
                    item.setChecked(checked);
                }
            });
        }
        if (Constants.isWindowsXP || isGTK) {
            Rectangle r = item.getBounds(0);
            Table table = item.getParent();
            Rectangle rTable = table.getClientArea();
            r.y += VerticalAligner.getTableAdjustVerticalBy(table);
            table.redraw(0, r.y, rTable.width, r.height, true);
        }
    }

    public static boolean linkShellMetricsToConfig(final Shell shell, final String sConfigPrefix) {
        boolean isMaximized = COConfigurationManager.getBooleanParameter(sConfigPrefix + ".maximized", false);
        shell.setMaximized(isMaximized);
        String windowRectangle = COConfigurationManager.getStringParameter(sConfigPrefix + ".rectangle", null);
        boolean bDidResize = false;
        if (null != windowRectangle) {
            int i = 0;
            int[] values = new int[4];
            StringTokenizer st = new StringTokenizer(windowRectangle, ",");
            try {
                while (st.hasMoreTokens() && i < 4) {
                    values[i++] = Integer.valueOf(st.nextToken());
                    if (values[i - 1] >= 0) continue;
                    values[i - 1] = 0;
                }
                if (i == 4) {
                    shell.setBounds(values[0], values[1], values[2], values[3]);
                    bDidResize = true;
                }
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        shell.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                COConfigurationManager.setParameter(sConfigPrefix + ".maximized", shell.getMaximized());
                if (shell.getMaximized()) {
                    shell.setMaximized(false);
                }
                Rectangle windowRectangle = shell.getBounds();
                COConfigurationManager.setParameter(sConfigPrefix + ".rectangle", windowRectangle.x + "," + windowRectangle.y + "," + windowRectangle.width + "," + windowRectangle.height);
            }
        });
        return bDidResize;
    }

    public static class LabelWrapControlListener
    extends ControlAdapter {
        public void controlResized(ControlEvent e) {
            GridLayout parentLayout;
            if (SWT.getVersion() >= 3105) {
                return;
            }
            Composite parent = (Composite)e.widget;
            Control[] children = parent.getChildren();
            if (children.length > 0 && (parentLayout = (GridLayout)parent.getLayout()) != null) {
                Point size;
                int marginWidth = parentLayout.marginWidth;
                Composite grandParent = parent.getParent();
                if (grandParent instanceof ScrolledComposite) {
                    ScrollBar sb;
                    Composite greatGP = grandParent.getParent();
                    if (greatGP != null) {
                        size = greatGP.getSize();
                        if (greatGP.getLayout() instanceof GridLayout) {
                            marginWidth += ((GridLayout)greatGP.getLayout()).marginWidth;
                        }
                    } else {
                        size = grandParent.getSize();
                    }
                    if (grandParent.getLayout() instanceof GridLayout) {
                        marginWidth += ((GridLayout)grandParent.getLayout()).marginWidth;
                    }
                    if ((sb = grandParent.getVerticalBar()) != null) {
                        size.x -= sb.getSize().x + 1;
                    }
                } else {
                    size = parent.getSize();
                }
                boolean oneChanged = false;
                for (int i = 0; i < children.length; ++i) {
                    GridData gd;
                    if (!(children[i] instanceof Label) || (children[i].getStyle() & 0x40) != 64 || (gd = (GridData)children[i].getLayoutData()) == null || gd.horizontalAlignment != 4) continue;
                    if (gd.horizontalSpan == parentLayout.numColumns) {
                        gd.widthHint = size.x - 2 * marginWidth;
                        oneChanged = true;
                        continue;
                    }
                    Point pt = children[i].getLocation();
                    gd.widthHint = size.x - pt.x - 2 * marginWidth;
                    oneChanged = true;
                }
                if (oneChanged) {
                    parent.layout(true);
                    if (grandParent instanceof ScrolledComposite) {
                        ((ScrolledComposite)grandParent).setMinSize(parent.computeSize(-1, -1, true));
                    }
                }
            }
        }
    }
}

