/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.ui.common.util;

import java.applet.Applet;
import java.applet.AudioClip;
import java.io.File;
import java.net.URL;
import org.gudy.azureus2.core3.config.COConfigurationManager;
import org.gudy.azureus2.core3.disk.DiskManager;
import org.gudy.azureus2.core3.disk.DiskManagerFileInfo;
import org.gudy.azureus2.core3.disk.DiskManagerListener;
import org.gudy.azureus2.core3.disk.DiskManagerPiece;
import org.gudy.azureus2.core3.download.DownloadManager;
import org.gudy.azureus2.core3.download.DownloadManagerDiskListener;
import org.gudy.azureus2.core3.download.impl.DownloadManagerAdapter;
import org.gudy.azureus2.core3.global.GlobalManager;
import org.gudy.azureus2.core3.global.impl.GlobalManagerAdpater;
import org.gudy.azureus2.core3.logging.LogAlert;
import org.gudy.azureus2.core3.logging.Logger;
import org.gudy.azureus2.core3.util.AEMonitor;
import org.gudy.azureus2.core3.util.AEThread;
import org.gudy.azureus2.core3.util.Constants;
import org.gudy.azureus2.core3.util.Debug;

public class UserAlerts {
    private AudioClip audio_clip = null;
    private String audio_resource = "";
    private AEMonitor this_mon = new AEMonitor("UserAlerts");

    public UserAlerts(GlobalManager global_manager) {
        final DownloadManagerAdapter download_manager_listener = new DownloadManagerAdapter(){

            public void downloadComplete(DownloadManager manager) {
                UserAlerts.this.activityFinished(true);
            }
        };
        final DiskManagerListener disk_listener = new DiskManagerListener(){

            public void stateChanged(int oldState, int newState) {
            }

            public void filePriorityChanged(DiskManagerFileInfo file) {
            }

            public void pieceDoneChanged(DiskManagerPiece piece) {
            }

            public void fileAccessModeChanged(DiskManagerFileInfo file, int old_mode, int new_mode) {
                if (old_mode == 2 && new_mode == 1) {
                    UserAlerts.this.activityFinished(false);
                }
            }
        };
        final DownloadManagerDiskListener dm_disk_listener = new DownloadManagerDiskListener(){

            public void diskManagerAdded(DiskManager dm) {
                dm.addListener(disk_listener);
            }

            public void diskManagerRemoved(DiskManager dm) {
                dm.removeListener(disk_listener);
            }
        };
        global_manager.addListener(new GlobalManagerAdpater(){

            public void downloadManagerAdded(DownloadManager manager) {
                manager.addListener(download_manager_listener);
                manager.addDiskListener(dm_disk_listener);
            }

            public void downloadManagerRemoved(DownloadManager manager) {
                manager.removeListener(download_manager_listener);
                manager.removeDiskListener(dm_disk_listener);
            }

            public void destroyed() {
                UserAlerts.this.tidyUp();
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void activityFinished(boolean download) {
        String speech_text;
        String speech_enabler;
        String sound_file;
        String sound_enabler;
        String default_sound = "org/gudy/azureus2/ui/icons/downloadFinished.wav";
        if (download) {
            sound_enabler = "Play Download Finished";
            sound_file = "Play Download Finished File";
            speech_enabler = "Play Download Finished Announcement";
            speech_text = "Play Download Finished Announcement Text";
        } else {
            sound_enabler = "Play File Finished";
            sound_file = "Play File Finished File";
            speech_enabler = "Play File Finished Announcement";
            speech_text = "Play File Finished Announcement Text";
        }
        try {
            this.this_mon.enter();
            if (Constants.isOSX) {
                new AEThread("DownloadSound"){

                    public void runSupport() {
                        try {
                            if (COConfigurationManager.getBooleanParameter(speech_enabler)) {
                                Runtime.getRuntime().exec(new String[]{"say", COConfigurationManager.getStringParameter(speech_text)});
                            }
                            if (COConfigurationManager.getBooleanParameter(sound_enabler)) {
                                Runtime.getRuntime().exec(new String[]{"osascript", "-e", "beep"});
                            }
                            Thread.sleep(2500L);
                        }
                        catch (Throwable throwable) {
                            // empty catch block
                        }
                    }
                }.start();
                return;
            }
            if (!COConfigurationManager.getBooleanParameter(sound_enabler, false)) return;
            String file = COConfigurationManager.getStringParameter(sound_file);
            if ((file = file.trim()).startsWith("<")) {
                file = "";
            }
            if (this.audio_clip == null || !file.equals(this.audio_resource)) {
                block18: {
                    this.audio_clip = null;
                    if (file.length() != 0) {
                        File f = new File(file);
                        try {
                            block17: {
                                try {
                                    if (!f.exists()) break block17;
                                    URL file_url = f.toURL();
                                    this.audio_clip = Applet.newAudioClip(file_url);
                                }
                                catch (Throwable e) {
                                    Debug.printStackTrace(e);
                                    Object var11_13 = null;
                                    if (this.audio_clip == null) {
                                        Logger.log(new LogAlert(false, 3, "Failed to load audio file '" + file + "'"));
                                    }
                                    break block18;
                                }
                            }
                            Object var11_12 = null;
                            if (this.audio_clip != null) break block18;
                        }
                        catch (Throwable throwable) {
                            Object var11_14 = null;
                            if (this.audio_clip != null) throw throwable;
                            Logger.log(new LogAlert(false, 3, "Failed to load audio file '" + file + "'"));
                            throw throwable;
                        }
                        Logger.log(new LogAlert(false, 3, "Failed to load audio file '" + file + "'"));
                    }
                }
                if (this.audio_clip == null) {
                    this.audio_clip = Applet.newAudioClip(UserAlerts.class.getClassLoader().getResource("org/gudy/azureus2/ui/icons/downloadFinished.wav"));
                }
                this.audio_resource = file;
            }
            if (this.audio_clip == null) return;
            new AEThread("DownloadSound"){

                public void runSupport() {
                    try {
                        UserAlerts.this.audio_clip.play();
                        Thread.sleep(2500L);
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                }
            }.start();
            return;
        }
        catch (Throwable e) {
            Debug.printStackTrace(e);
            return;
        }
        finally {
            this.this_mon.exit();
        }
    }

    protected void tidyUp() {
        try {
            ThreadGroup threadGroup = Thread.currentThread().getThreadGroup();
            Thread[] threadList = new Thread[threadGroup.activeCount()];
            threadGroup.enumerate(threadList);
            for (int i = 0; i < threadList.length; ++i) {
                if (threadList[i] == null || !"Java Sound event dispatcher".equals(threadList[i].getName())) continue;
                threadList[i].interrupt();
            }
        }
        catch (Throwable e) {
            Debug.printStackTrace(e);
        }
    }
}

