/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.pluginsimpl.local.utils.security;

import java.net.Authenticator;
import java.net.PasswordAuthentication;
import java.net.URL;
import java.security.KeyStore;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.util.HashMap;
import java.util.Map;
import javax.net.ssl.SSLSocketFactory;
import org.gudy.azureus2.core3.security.SECertificateListener;
import org.gudy.azureus2.core3.security.SEPasswordListener;
import org.gudy.azureus2.core3.security.SESecurityManager;
import org.gudy.azureus2.core3.util.SHA1Hasher;
import org.gudy.azureus2.plugins.utils.security.CertificateListener;
import org.gudy.azureus2.plugins.utils.security.PasswordListener;

public class SESecurityManagerImpl
implements org.gudy.azureus2.plugins.utils.security.SESecurityManager {
    private Map password_listeners = new HashMap();
    private Map certificate_listeners = new HashMap();

    public byte[] calculateSHA1(byte[] data_in) {
        if (data_in == null) {
            data_in = new byte[]{};
        }
        SHA1Hasher hasher = new SHA1Hasher();
        return hasher.calculateHash(data_in);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void runWithAuthenticator(Authenticator authenticator, Runnable target) {
        try {
            Authenticator.setDefault(authenticator);
            target.run();
        }
        finally {
            SESecurityManager.installAuthenticator();
        }
    }

    public void addPasswordListener(final PasswordListener listener) {
        SEPasswordListener sepl = new SEPasswordListener(){

            public PasswordAuthentication getAuthentication(String realm, URL tracker) {
                return listener.getAuthentication(realm, tracker);
            }

            public void setAuthenticationOutcome(String realm, URL tracker, boolean success) {
                listener.setAuthenticationOutcome(realm, tracker, success);
            }
        };
        this.password_listeners.put(listener, sepl);
        SESecurityManager.addPasswordListener(sepl);
    }

    public void removePasswordListener(PasswordListener listener) {
        SEPasswordListener sepl = (SEPasswordListener)this.password_listeners.get(listener);
        if (sepl != null) {
            SESecurityManager.removePasswordListener(sepl);
        }
    }

    public void addCertificateListener(final CertificateListener listener) {
        SECertificateListener sepl = new SECertificateListener(){

            public boolean trustCertificate(String resource, X509Certificate cert) {
                return listener.trustCertificate(resource, cert);
            }
        };
        this.certificate_listeners.put(listener, sepl);
        SESecurityManager.addCertificateListener(sepl);
    }

    public void removeCertificateListener(CertificateListener listener) {
        SECertificateListener sepl = (SECertificateListener)this.certificate_listeners.get(listener);
        if (sepl != null) {
            SESecurityManager.removeCertificateListener(sepl);
        }
    }

    public SSLSocketFactory installServerCertificate(URL url) {
        return SESecurityManager.installServerCertificates(url);
    }

    public KeyStore getKeyStore() throws Exception {
        return SESecurityManager.getKeyStore();
    }

    public KeyStore getTrustStore() throws Exception {
        return SESecurityManager.getTrustStore();
    }

    public Certificate createSelfSignedCertificate(String alias, String cert_dn, int strength) throws Exception {
        return SESecurityManager.createSelfSignedCertificate(alias, cert_dn, strength);
    }
}

