/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.core3.util.test;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import org.gudy.azureus2.core3.util.SHA1;

public class SHA1SpeedTest {
    private static final int BUFF_MAX_SIZE = 0x400000;
    private static final int[] LOOPS = new int[]{30000, 15000, 4000, 3000, 2000, 1200, 800};
    private static final int[] TESTS = new int[]{16, 64, 256, 512, 1024, 2048, 4096};

    public static void main(String[] args) {
        SHA1 sha1Gudy = new SHA1();
        ByteBuffer dBuffer = ByteBuffer.allocateDirect(0x400000);
        ByteBuffer fBuffer = ByteBuffer.allocateDirect(20);
        fBuffer.order(ByteOrder.BIG_ENDIAN);
        for (int i = 0; i < 0x400000; ++i) {
            byte b = (byte)(Math.random() * 255.0);
            dBuffer.put(b);
        }
        try {
            Thread.sleep(10000L);
        }
        catch (Exception ignore) {
            // empty catch block
        }
        for (int t = 0; t < TESTS.length; ++t) {
            int buffsize = TESTS[t] * 1024;
            dBuffer.limit(buffsize);
            int loops = LOOPS[t];
            String info = " [" + buffsize / 1024 + "KB, " + loops + "x] = ";
            float totalMBytes = (float)buffsize / 1048576.0f * (float)loops;
            System.out.print("JMule SHA1");
            long jds = System.currentTimeMillis();
            for (int i = 0; i < loops; ++i) {
                dBuffer.position(0);
                dBuffer.limit(buffsize);
                fBuffer.position(0);
            }
            long jde = System.currentTimeMillis();
            long jdt = jde - jds;
            float jdspeed = totalMBytes / (float)(jdt / 1000L);
            System.out.println(info + jdt + " ms @ " + jdspeed + " MB/s");
            System.out.print("Gudy SHA1 ");
            long gds = System.currentTimeMillis();
            for (int i = 0; i < loops; ++i) {
                dBuffer.position(0);
                dBuffer.limit(buffsize);
                sha1Gudy.reset();
                sha1Gudy.update(dBuffer);
                sha1Gudy.digest();
            }
            long gde = System.currentTimeMillis();
            long gdt = gde - gds;
            float gdspeed = totalMBytes / (float)(gdt / 1000L);
            System.out.println(info + gdt + " ms @ " + gdspeed + " MB/s");
            System.out.println();
        }
        System.out.println("DONE");
    }
}

