/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.core3.util;

import java.util.Random;

public class RandomUtils {
    public static final Random RANDOM = new Random(System.currentTimeMillis());
    public static final int LISTEN_PORT_MIN = 10000;
    public static final int LISTEN_PORT_MAX = 65535;

    public static byte[] generateRandomBytes(int num_to_generate) {
        byte[] id = new byte[num_to_generate];
        RANDOM.nextBytes(id);
        return id;
    }

    public static String generateRandomAlphanumerics(int num_to_generate) {
        String alphabet = "abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789";
        StringBuffer buff = new StringBuffer(num_to_generate);
        for (int i = 0; i < num_to_generate; ++i) {
            int pos = (int)(RANDOM.nextDouble() * (double)alphabet.length());
            buff.append(alphabet.charAt(pos));
        }
        return buff.toString();
    }

    public static int generateRandomNetworkListenPort() {
        int min = 10000;
        int port = min + RANDOM.nextInt(65536 - min);
        return port;
    }

    public static int generateRandomPlusMinus1() {
        return RANDOM.nextBoolean() ? -1 : 1;
    }

    public static float nextFloat() {
        return RANDOM.nextFloat();
    }

    public static void nextBytes(byte[] bytes) {
        RANDOM.nextBytes(bytes);
    }

    public static int nextInt(int n) {
        return RANDOM.nextInt(n);
    }

    public static int generateRandomIntUpto(int max) {
        return RandomUtils.nextInt(max);
    }

    public static int generateRandomIntBetween(int min, int max) {
        return min + RandomUtils.generateRandomIntUpto(max + 1 - min);
    }
}

