/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.core3.util;

public class Constants {
    public static final String SF_WEB_SITE = "http://azureus.sourceforge.net/";
    public static final String AELITIS_WEB_SITE = "http://azureus.aelitis.com/";
    public static final String AELITIS_TORRENTS = "http://torrents.aelitis.com:88/torrents/";
    public static final String AZUREUS_WIKI = "http://azureus.aelitis.com/wiki/index.php/";
    public static final String DEFAULT_ENCODING = "UTF8";
    public static final String BYTE_ENCODING = "ISO-8859-1";
    public static final String INFINITY_STRING = "\u221e";
    public static final int INFINITY_AS_INT = 31536000;
    public static final String AZUREUS_NAME = "Azureus";
    public static final String AZUREUS_VERSION = "2.3.0.7_B51";
    public static final byte[] VERSION_ID = "-AZ2307-".getBytes();
    public static final String OSName = System.getProperty("os.name");
    public static final boolean isOSX = OSName.equalsIgnoreCase("Mac OS X");
    public static final boolean isLinux = OSName.equalsIgnoreCase("Linux");
    public static final boolean isSolaris = OSName.equalsIgnoreCase("SunOS");
    public static final boolean isWindowsXP = OSName.equalsIgnoreCase("Windows XP");
    public static final boolean isWindows95 = OSName.equalsIgnoreCase("Windows 95");
    public static final boolean isWindows98 = OSName.equalsIgnoreCase("Windows 98");
    public static final boolean isWindowsME = OSName.equalsIgnoreCase("Windows ME");
    public static final boolean isWindows9598ME = isWindows95 || isWindows98 || isWindowsME;
    public static final boolean isWindows = !isOSX && !isLinux && !isSolaris;
    public static final String JAVA_VERSION = System.getProperty("java.version");
    public static final String FILE_WILDCARD = isWindows ? "*.*" : "*";

    public static String getBaseVersion() {
        return Constants.getBaseVersion(AZUREUS_VERSION);
    }

    public static String getBaseVersion(String version) {
        int p1 = version.indexOf("_");
        if (p1 == -1) {
            return version;
        }
        return version.substring(0, p1);
    }

    public static boolean isCVSVersion() {
        return Constants.isCVSVersion(AZUREUS_VERSION);
    }

    public static boolean isCVSVersion(String version) {
        return version.indexOf("_") != -1;
    }

    public static int getIncrementalBuild() {
        return Constants.getIncrementalBuild(AZUREUS_VERSION);
    }

    public static int getIncrementalBuild(String version) {
        if (!Constants.isCVSVersion(version)) {
            return 0;
        }
        int p1 = version.indexOf("_B");
        if (p1 == -1) {
            return -1;
        }
        try {
            return Integer.parseInt(version.substring(p1 + 2));
        }
        catch (Throwable e) {
            System.out.println("can't parse version");
            return -1;
        }
    }

    public static int compareVersions(String version_1, String version_2) {
        for (int j = 0; j < Math.min(version_2.length(), version_1.length()); ++j) {
            int v2_next_dot;
            int v1_next_dot;
            char v2_c;
            char v1_c = version_1.charAt(j);
            if (v1_c == (v2_c = version_2.charAt(j))) continue;
            if (v2_c == '.') {
                return 1;
            }
            if (v1_c == '.') {
                return -1;
            }
            for (v1_next_dot = j + 1; v1_next_dot < version_1.length() && version_1.charAt(v1_next_dot) != '.'; ++v1_next_dot) {
            }
            for (v2_next_dot = j + 1; v2_next_dot < version_2.length() && version_2.charAt(v2_next_dot) != '.'; ++v2_next_dot) {
            }
            if (v1_next_dot == v2_next_dot) {
                return v1_c - v2_c;
            }
            return v1_next_dot - v2_next_dot;
        }
        return version_1.length() - version_2.length();
    }
}

