/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.core3.util;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileWriter;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.gudy.azureus2.core3.config.COConfigurationManager;
import org.gudy.azureus2.core3.logging.LogAlert;
import org.gudy.azureus2.core3.logging.Logger;
import org.gudy.azureus2.core3.util.AEDiagnosticsEvidenceGenerator;
import org.gudy.azureus2.core3.util.AEDiagnosticsLogger;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.FileUtil;
import org.gudy.azureus2.core3.util.IndentWriter;
import org.gudy.azureus2.core3.util.SystemTime;

public class AEDiagnostics {
    public static final boolean ALWAYS_PASS_HASH_CHECKS = false;
    public static final boolean USE_DUMMY_FILE_DATA = false;
    public static final boolean CHECK_DUMMY_FILE_DATA = false;
    public static final boolean DEBUG_MONITOR_SEM_USAGE = false;
    public static final boolean DEBUG_THREADS = true;
    public static final boolean TRACE_DIRECT_BYTE_BUFFERS = false;
    public static final boolean TRACE_DBB_POOL_USAGE = false;
    public static final boolean PRINT_DBB_POOL_USAGE = false;
    public static final boolean TRACE_TCP_TRANSPORT_STATS = false;
    public static final boolean TRACE_CONNECTION_DROPS = false;
    private static final int MAX_FILE_SIZE = 131072;
    private static final String CONFIG_KEY = "diagnostics.tidy_close";
    private static File debug_dir;
    private static File debug_save_dir;
    private static boolean started_up;
    private static Map loggers;
    private static List evidence_generators;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static synchronized void startup() {
        if (started_up) {
            return;
        }
        started_up = true;
        try {
            debug_dir = FileUtil.getUserFile("logs");
            debug_save_dir = new File(debug_dir, "save");
            boolean was_tidy = COConfigurationManager.getBooleanParameter(CONFIG_KEY);
            COConfigurationManager.setParameter(CONFIG_KEY, false);
            COConfigurationManager.save();
            if (debug_dir.exists()) {
                debug_save_dir.mkdir();
                File[] files = debug_dir.listFiles();
                if (files != null) {
                    boolean file_moved = false;
                    long now = SystemTime.getCurrentTime();
                    for (int i = 0; i < files.length; ++i) {
                        File file = files[i];
                        if (file.isDirectory() || was_tidy) continue;
                        file_moved = true;
                        FileUtil.renameFile(file, new File(debug_save_dir, now + "_" + file.getName()));
                    }
                    if (file_moved) {
                        Logger.logTextResource(new LogAlert(false, 1, "diagnostics.log_found"), new String[]{debug_save_dir.toString()});
                    }
                }
            } else {
                debug_dir.mkdir();
            }
        }
        catch (Throwable e) {
            if (!(e instanceof NoClassDefFoundError)) {
                Debug.printStackTrace(e);
            }
        }
        finally {
            try {
                Class.forName("com.aelitis.azureus.core.monitoring.thread.AEThreadMonitor");
            }
            catch (Throwable e) {}
        }
    }

    public static synchronized AEDiagnosticsLogger getLogger(String name) {
        AEDiagnosticsLogger logger = (AEDiagnosticsLogger)loggers.get(name);
        if (logger == null) {
            AEDiagnostics.startup();
            logger = new AEDiagnosticsLogger(name);
            try {
                File f1 = AEDiagnostics.getLogFile(logger);
                logger.setFirstFile(false);
                File f2 = AEDiagnostics.getLogFile(logger);
                logger.setFirstFile(true);
                if (f1.exists() && f2.exists() && f1.lastModified() < f2.lastModified()) {
                    logger.setFirstFile(false);
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            loggers.put(name, logger);
        }
        return logger;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static synchronized void log(AEDiagnosticsLogger logger, String str) {
        try {
            File log_file = AEDiagnostics.getLogFile(logger);
            if (log_file.exists() && log_file.length() >= 131072L) {
                logger.setFirstFile(!logger.isFirstFile());
                log_file = AEDiagnostics.getLogFile(logger);
                if (log_file.exists()) {
                    log_file.delete();
                }
            }
            Calendar now = GregorianCalendar.getInstance();
            String timeStamp = "[" + now.get(11) + ":" + AEDiagnostics.format(now.get(12)) + ":" + AEDiagnostics.format(now.get(13)) + "] ";
            str = timeStamp + str;
            PrintWriter pw = null;
            try {
                pw = new PrintWriter(new FileWriter(log_file, true));
                pw.println(str);
            }
            finally {
                if (pw != null) {
                    pw.close();
                }
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private static File getLogFile(AEDiagnosticsLogger logger) {
        return new File(debug_dir, logger.getName() + "_" + (logger.isFirstFile() ? "1" : "2") + ".log");
    }

    private static String format(int n) {
        if (n < 10) {
            return "0" + n;
        }
        return String.valueOf(n);
    }

    protected static void log(AEDiagnosticsLogger logger, Throwable e) {
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            PrintWriter pw = new PrintWriter(new OutputStreamWriter(baos));
            e.printStackTrace(pw);
            pw.close();
            AEDiagnostics.log(logger, baos.toString());
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public static void shutdown() {
        try {
            COConfigurationManager.setParameter(CONFIG_KEY, true);
            COConfigurationManager.save();
        }
        catch (Throwable e) {
            Debug.printStackTrace(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addEvidenceGenerator(AEDiagnosticsEvidenceGenerator gen) {
        List list = evidence_generators;
        synchronized (list) {
            evidence_generators.add(gen);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void generateEvidence(PrintWriter _writer) {
        IndentWriter writer = new IndentWriter(_writer);
        List list = evidence_generators;
        synchronized (list) {
            for (int i = 0; i < evidence_generators.size(); ++i) {
                try {
                    ((AEDiagnosticsEvidenceGenerator)evidence_generators.get(i)).generate(writer);
                    continue;
                }
                catch (Throwable e) {
                    e.printStackTrace(_writer);
                }
            }
        }
    }

    static {
        loggers = new HashMap();
        evidence_generators = new ArrayList();
    }
}

