/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.core3.config.impl;

import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.gudy.azureus2.core3.config.impl.ConfigurationParameterNotFoundException;
import org.gudy.azureus2.core3.util.AEMonitor;
import org.gudy.azureus2.core3.util.SystemProperties;

public class ConfigurationDefaults {
    private static final Long FALSE = new Long(0L);
    private static final Long TRUE = new Long(1L);
    private static ConfigurationDefaults configdefaults;
    private static AEMonitor class_mon;
    private HashMap def = new HashMap();
    public int def_int = 0;
    public float def_float = 0.0f;
    public int def_boolean = 0;
    public String def_String = "";
    public byte[] def_bytes = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ConfigurationDefaults getInstance() {
        try {
            class_mon.enter();
            if (configdefaults == null) {
                configdefaults = new ConfigurationDefaults();
            }
            ConfigurationDefaults configurationDefaults = configdefaults;
            return configurationDefaults;
        }
        finally {
            class_mon.exit();
        }
    }

    protected ConfigurationDefaults() {
        this.def.put("Override Ip", "");
        this.def.put("Enable incremental file creation", FALSE);
        this.def.put("TCP.Listen.Port", new Long(6881L));
        this.def.put("max active torrents", new Long(4L));
        this.def.put("max downloads", new Long(4L));
        this.def.put("Newly Seeding Torrents Get First Priority", TRUE);
        this.def.put("Max.Peer.Connections.Per.Torrent", new Long(70L));
        this.def.put("Max.Peer.Connections.Total", new Long(300L));
        this.def.put("File Max Open", new Long(50L));
        this.def.put("Use Config File Backups", TRUE);
        this.def.put("Max Uploads", new Long(4L));
        this.def.put("Max Uploads Seeding", new Long(4L));
        this.def.put("enable.seedingonly.maxuploads", FALSE);
        this.def.put("Max Download Speed KBs", new Long(0L));
        this.def.put("Max Upload Speed KBs", new Long(0L));
        this.def.put("Max Upload Speed Seeding KBs", new Long(0L));
        this.def.put("enable.seedingonly.upload.rate", FALSE);
        this.def.put("Max LAN Download Speed KBs", new Long(0L));
        this.def.put("Max LAN Upload Speed KBs", new Long(0L));
        this.def.put("Use Resume", TRUE);
        this.def.put("Save Resume Interval", new Long(5L));
        this.def.put("Check Pieces on Completion", TRUE);
        this.def.put("Stop Ratio", new Float(0.0f));
        this.def.put("Stop Peers Ratio", new Long(0L));
        this.def.put("Disconnect Seed", TRUE);
        this.def.put("priorityExtensions", "");
        this.def.put("priorityExtensionsIgnoreCase", FALSE);
        this.def.put("Ip Filter Enabled", TRUE);
        this.def.put("Ip Filter Allow", FALSE);
        this.def.put("Ip Filter Enable Banning", TRUE);
        this.def.put("Ip Filter Ban Block Limit", new Long(4L));
        this.def.put("Ip Filter Banning Persistent", TRUE);
        this.def.put("Allow Same IP Peers", FALSE);
        this.def.put("Use Super Seeding", FALSE);
        this.def.put("User Mode", new Long(0L));
        this.def.put("useCustomTab", TRUE);
        this.def.put("GUI Refresh", new Long(1000L));
        this.def.put("Graphics Update", new Long(4L));
        this.def.put("ReOrder Delay", new Long(0L));
        this.def.put("Send Version Info", TRUE);
        this.def.put("Show Download Basket", FALSE);
        this.def.put("config.style.refreshMT", new Long(0L));
        this.def.put("Open Details", FALSE);
        this.def.put("Use default data dir", FALSE);
        this.def.put("Default save path", "");
        this.def.put("GUI_SWT_bFancyTab", TRUE);
        this.def.put("GUI_SWT_bAlternateTablePainting", FALSE);
        this.def.put("update.start", TRUE);
        this.def.put("update.periodic", TRUE);
        this.def.put("update.opendialog", TRUE);
        this.def.put("Colors.progressBar.override", FALSE);
        this.def.put("Logger.Enabled", FALSE);
        this.def.put("Logging Enable", FALSE);
        this.def.put("Logging Dir", "");
        this.def.put("Logging Max Size", new Long(5L));
        int[] logComponents = new int[]{0, 1, 2, 4};
        for (int i = 0; i < logComponents.length; ++i) {
            for (int j = 0; j <= 3; ++j) {
                this.def.put("bLog" + logComponents[i] + "-" + j, TRUE);
            }
        }
        this.def.put("StartStopManager_iNumPeersAsFullCopy", new Long(0L));
        this.def.put("StartStopManager_iFakeFullCopySeedStart", new Long(1L));
        this.def.put("StartStopManager_iMinPeersToBoostNoSeeds", new Long(1L));
        this.def.put("StartStopManager_iMinSpeedForActiveDL", new Long(512L));
        this.def.put("StartStopManager_iMinSpeedForActiveSeeding", new Long(512L));
        this.def.put("StartStopManager_iRankType", new Long(1L));
        this.def.put("StartStopManager_iRankTypeSeedFallback", new Long(0L));
        this.def.put("StartStopManager_bAutoReposition", FALSE);
        this.def.put("StartStopManager_iMinSeedingTime", new Long(180L));
        this.def.put("StartStopManager_bIgnore0Peers", TRUE);
        this.def.put("StartStopManager_iIgnoreSeedCount", new Long(0L));
        this.def.put("StartStopManager_bPreferLargerSwarms", TRUE);
        this.def.put("StartStopManager_bDebugLog", FALSE);
        this.def.put("StartStopManager_iFirstPriority_Type", new Long(1L));
        this.def.put("StartStopManager_iFirstPriority_ShareRatio", new Long(500L));
        this.def.put("StartStopManager_iFirstPriority_SeedingMinutes", new Long(0L));
        this.def.put("StartStopManager_iFirstPriority_DLMinutes", new Long(0L));
        this.def.put("StartStopManager_bAutoStart0Peers", FALSE);
        this.def.put("StartStopManager_iFirstPriority_ignoreSPRatio", new Long(0L));
        this.def.put("StartStopManager_bFirstPriority_ignore0Peer", FALSE);
        this.def.put("StartStopManager_iIgnoreRatioPeersSeedStart", new Long(0L));
        this.def.put("StartStopManager_iIgnoreShareRatioSeedStart", new Long(0L));
        this.def.put("StartStopManager_bNewSeedsMoveTop", TRUE);
        this.def.put("StartStopManager_iAddForSeedingDLCopyCount", new Long(1L));
        this.def.put("StartStopManager_iMaxActiveTorrentsWhenSeeding", new Long(0L));
        this.def.put("StartStopManager_bMaxActiveTorrentsWhenSeedingEnabled", FALSE);
        this.def.put("Enable.Proxy", FALSE);
        this.def.put("Enable.SOCKS", FALSE);
        this.def.put("Proxy.Host", "");
        this.def.put("Proxy.Port", "");
        this.def.put("Proxy.Username", "");
        this.def.put("Proxy.Password", "");
        this.def.put("Proxy.Data.Enable", FALSE);
        this.def.put("Proxy.Data.SOCKS.version", "V4");
        this.def.put("Proxy.Data.SOCKS.inform", TRUE);
        this.def.put("Proxy.Data.Same", TRUE);
        this.def.put("Proxy.Data.Host", "");
        this.def.put("Proxy.Data.Port", "");
        this.def.put("Proxy.Data.Username", "");
        this.def.put("Proxy.Data.Password", "");
        this.def.put("Start Num Peers", new Long(-1L));
        this.def.put("Max Upload Speed", new Long(-1L));
        this.def.put("Max Clients", new Long(-1L));
        this.def.put("Server.shared.port", TRUE);
        this.def.put("Low Port", new Long(6881L));
        this.def.put("Already_Migrated", FALSE);
        this.def.put("ID", "");
        this.def.put("Play Download Finished", FALSE);
        this.def.put("Play Download Finished File", "");
        this.def.put("Close To Tray", TRUE);
        this.def.put("Minimize To Tray", FALSE);
        this.def.put("Watch Torrent Folder", FALSE);
        this.def.put("Watch Torrent Folder Interval", new Long(1L));
        this.def.put("Start Watched Torrents Stopped", FALSE);
        this.def.put("Watch Torrent Folder Path", "");
        this.def.put("Prioritize First Piece", FALSE);
        this.def.put("Use Lazy Bitfield", FALSE);
        this.def.put("Move Completed When Done", FALSE);
        this.def.put("Completed Files Directory", "");
        this.def.put("Zero New", FALSE);
        this.def.put("Move Only When In Default Save Dir", TRUE);
        this.def.put("Copy And Delete Data Rather Than Move", FALSE);
        this.def.put("Move Torrent When Done", TRUE);
        this.def.put("File.save.peers.enable", TRUE);
        this.def.put("File.strict.locking", TRUE);
        this.def.put("Move Deleted Data To Recycle Bin", TRUE);
        this.def.put("Save Torrent Files", TRUE);
        this.def.put("General_sDefaultTorrent_Directory", SystemProperties.getUserPath() + "torrents");
        this.def.put("Bind IP", "");
        this.def.put("Stats Export Peer Details", FALSE);
        this.def.put("Stats XSL File", "");
        this.def.put("Stats Enable", FALSE);
        this.def.put("Stats Period", new Long(30000L));
        this.def.put("Stats Dir", "");
        this.def.put("Stats File", "Azureus_Stats.xml");
        this.def.put("File.Torrent.IgnoreFiles", ".DS_Store;Thumbs.db;desktop.ini");
        this.def.put("File.save.peers.max", new Long(512L));
        this.def.put("Tracker Compact Enable", TRUE);
        this.def.put("Tracker Key Enable Client", TRUE);
        this.def.put("Tracker Key Enable Server", TRUE);
        this.def.put("Tracker Separate Peer IDs", FALSE);
        this.def.put("Tracker Client Connect Timeout", new Long(120L));
        this.def.put("Tracker Client Read Timeout", new Long(60L));
        this.def.put("Tracker Client Send OS and Java Version", TRUE);
        this.def.put("Tracker Client Show Warnings", TRUE);
        this.def.put("Tracker Public Enable", FALSE);
        this.def.put("Tracker Log Enable", FALSE);
        this.def.put("Tracker Port Enable", FALSE);
        this.def.put("Tracker Port", new Long(6969L));
        this.def.put("Tracker Port Backups", "");
        this.def.put("Tracker Port SSL Enable", FALSE);
        this.def.put("Tracker Port SSL", new Long(7000L));
        this.def.put("Tracker Port SSL Backups", "");
        this.def.put("Tracker Port Force External", FALSE);
        this.def.put("Tracker IP", "");
        this.def.put("Tracker Port UDP Enable", FALSE);
        this.def.put("Tracker Port UDP Version", new Long(2L));
        this.def.put("Tracker Send Peer IDs", TRUE);
        this.def.put("Tracker Max Peers Returned", new Long(100L));
        this.def.put("Tracker Scrape Cache", new Long(5000L));
        this.def.put("Tracker Announce Cache", new Long(500L));
        this.def.put("Tracker Announce Cache Min Peers", new Long(500L));
        this.def.put("Tracker Poll Interval Min", new Long(120L));
        this.def.put("Tracker Poll Interval Max", new Long(3600L));
        this.def.put("Tracker Scrape Retry Percentage", new Long(200L));
        this.def.put("Tracker Password Enable Web", FALSE);
        this.def.put("Tracker Password Web HTTPS Only", FALSE);
        this.def.put("Tracker Password Enable Torrent", FALSE);
        this.def.put("Tracker Username", "");
        this.def.put("Tracker Password", null);
        this.def.put("Tracker Poll Inc By", new Long(60L));
        this.def.put("Tracker Poll Inc Per", new Long(10L));
        this.def.put("Tracker NAT Check Enable", TRUE);
        this.def.put("Tracker NAT Check Timeout", new Long(15L));
        this.def.put("Tracker Max Seeds Retained", new Long(0L));
        this.def.put("Tracker Max Seeds", new Long(0L));
        this.def.put("Tracker Max GET Time", new Long(20L));
        this.def.put("Tracker Max POST Time Multiplier", new Long(1L));
        this.def.put("Tracker Max Threads", new Long(48L));
        this.def.put("Tracker TCP NonBlocking", FALSE);
        this.def.put("Tracker TCP NonBlocking Conc Max", new Long(2048L));
        this.def.put("Tracker Client Scrape Enable", TRUE);
        this.def.put("Tracker Client Scrape Stopped Enable", TRUE);
        this.def.put("Tracker Client Scrape Single Only", FALSE);
        this.def.put("Network Selection Prompt", TRUE);
        this.def.put("Network Selection Default.Public", TRUE);
        this.def.put("Network Selection Default.I2P", TRUE);
        this.def.put("Network Selection Default.Tor", TRUE);
        this.def.put("Tracker Network Selection Default.Public", TRUE);
        this.def.put("Tracker Network Selection Default.I2P", TRUE);
        this.def.put("Tracker Network Selection Default.Tor", TRUE);
        this.def.put("Peer Source Selection Default.Tracker", TRUE);
        this.def.put("Peer Source Selection Default.DHT", TRUE);
        this.def.put("Peer Source Selection Default.PeerExchange", TRUE);
        this.def.put("Peer Source Selection Default.Plugin", TRUE);
        this.def.put("Peer Source Selection Default.Incoming", TRUE);
        this.def.put("config.style.useSIUnits", FALSE);
        this.def.put("config.style.useUnitsRateBits", FALSE);
        this.def.put("Save Torrent Backup", FALSE);
        this.def.put("Sharing Protocol", "HTTP");
        this.def.put("Sharing Add Hashes", FALSE);
        this.def.put("Sharing Rescan Enable", FALSE);
        this.def.put("Sharing Rescan Period", new Long(60L));
        this.def.put("Sharing Torrent Comment", "");
        this.def.put("Sharing Permit DHT", TRUE);
        this.def.put("Sharing Torrent Private", FALSE);
        this.def.put("File.Decoder.Prompt", FALSE);
        this.def.put("File.Decoder.Default", "");
        this.def.put("File.Decoder.ShowLax", FALSE);
        this.def.put("File.Decoder.ShowAll", FALSE);
        this.def.put("Password enabled", FALSE);
        this.def.put("Password", null);
        this.def.put("Save detail views column widths", FALSE);
        this.def.put("config.interface.checkassoc", TRUE);
        this.def.put("Wizard Completed", FALSE);
        this.def.put("donations.donated", FALSE);
        this.def.put("donations.lastVersion", "");
        this.def.put("donations.nextAskTime", new Long(0L));
        this.def.put("Color Scheme.red", new Long(0L));
        this.def.put("Color Scheme.green", new Long(128L));
        this.def.put("Color Scheme.blue", new Long(255L));
        this.def.put("Show Splash", TRUE);
        this.def.put("window.maximized", TRUE);
        this.def.put("window.rectangle", "");
        this.def.put("Open Console", FALSE);
        this.def.put("Open Config", FALSE);
        this.def.put("Open Stats On Start", FALSE);
        this.def.put("Start Minimized", FALSE);
        this.def.put("Open Bar", FALSE);
        this.def.put("confirmationOnExit", FALSE);
        this.def.put("locale", Locale.getDefault().toString());
        this.def.put("locale.set.complete.count", new Long(0L));
        this.def.put("Add URL Silently", FALSE);
        this.def.put("config.style.dropdiraction", "0");
        this.def.put("MyTorrents.SplitAt", new Long(30L));
        this.def.put("Confirm Data Delete", TRUE);
        this.def.put("Password Confirm", null);
        this.def.put("Auto Update", TRUE);
        this.def.put("Alert on close", TRUE);
        this.def.put("diskmanager.friendly.hashchecking", FALSE);
        this.def.put("Default Start Torrents Stopped", FALSE);
        this.def.put("Server Enable UDP", TRUE);
        this.def.put("diskmanager.perf.cache.enable", TRUE);
        this.def.put("diskmanager.perf.cache.enable.read", TRUE);
        this.def.put("diskmanager.perf.cache.enable.write", TRUE);
        this.def.put("diskmanager.perf.cache.size", new Long(4L));
        this.def.put("diskmanager.perf.cache.notsmallerthan", new Long(1024L));
        this.def.put("diskmanager.perf.read.maxthreads", new Long(32L));
        this.def.put("diskmanager.perf.read.maxmb", new Long(5L));
        this.def.put("diskmanager.perf.write.maxthreads", new Long(32L));
        this.def.put("diskmanager.perf.write.maxmb", new Long(5L));
        this.def.put("diskmanager.perf.cache.trace", FALSE);
        this.def.put("diskmanager.perf.cache.flushpieces", TRUE);
        this.def.put("File.truncate.if.too.large", FALSE);
        this.def.put("Enable System Tray", TRUE);
        this.def.put("config.style.table.defaultSortOrder", new Long(0L));
        this.def.put("Ignore.peer.ports", "0");
        this.def.put("Security.JAR.tools.dir", "");
        this.def.put("network.max.simultaneous.connect.attempts", new Long(8L));
        this.def.put("network.tcp.mtu.size", new Long(1500L));
        this.def.put("network.tcp.socket.SO_SNDBUF", new Long(0L));
        this.def.put("network.tcp.socket.SO_RCVBUF", new Long(0L));
        this.def.put("network.tcp.socket.IPTOS", "");
        this.def.put("confirm_torrent_removal", FALSE);
        this.def.put("add_torrents_silently", FALSE);
        this.def.put("enable_small_osx_fonts", TRUE);
        this.def.put("Message Popup Autoclose in Seconds", new Long(10L));
        this.def.put("Play Download Finished Announcement", FALSE);
        this.def.put("Play Download Finished Announcement Text", "Download Complete");
        this.def.put("Play File Finished", FALSE);
        this.def.put("Play File Finished File", "");
        this.def.put("Play File Finished Announcement", FALSE);
        this.def.put("Play File Finished Announcement Text", "File Complete");
        this.def.put("BT Request Max Block Size", new Long(65536L));
        this.def.put("network.tcp.enable_safe_selector_mode", FALSE);
        this.def.put("network.transport.encrypted.require", FALSE);
        this.def.put("network.transport.encrypted.min_level", "RC4");
        this.def.put("network.transport.encrypted.fallback.outgoing", FALSE);
        this.def.put("network.transport.encrypted.fallback.incoming", FALSE);
        this.def.put("network.bind.local.port", new Long(0L));
    }

    public String getStringParameter(String p) throws ConfigurationParameterNotFoundException {
        if (this.def.containsKey(p)) {
            Object o = this.def.get(p);
            if (o instanceof Number) {
                return ((Number)o).toString();
            }
            return (String)o;
        }
        throw new ConfigurationParameterNotFoundException(p);
    }

    public int getIntParameter(String p) throws ConfigurationParameterNotFoundException {
        if (this.def.containsKey(p)) {
            return ((Long)this.def.get(p)).intValue();
        }
        throw new ConfigurationParameterNotFoundException(p);
    }

    public float getFloatParameter(String p) throws ConfigurationParameterNotFoundException {
        if (this.def.containsKey(p)) {
            return ((Float)this.def.get(p)).floatValue();
        }
        throw new ConfigurationParameterNotFoundException(p);
    }

    public Object getDefaultValueAsObject(String key) {
        return this.def.get(key);
    }

    public Set getAllowedParameters() {
        return this.def.keySet();
    }

    public void addParameter(String sKey, String sParameter) {
        this.def.put(sKey, sParameter);
    }

    public void addParameter(String sKey, int iParameter) {
        this.def.put(sKey, new Long(iParameter));
    }

    public void addParameter(String sKey, byte[] bParameter) {
        this.def.put(sKey, bParameter);
    }

    public void addParameter(String sKey, boolean bParameter) {
        Long lParameter = new Long(bParameter ? 1L : 0L);
        this.def.put(sKey, lParameter);
    }

    public void registerExternalDefaults(Map addmap) {
        this.def.putAll(addmap);
    }

    public boolean doesParameterDefaultExist(String p) {
        return this.def.containsKey(p);
    }

    public Object getParameter(String key) {
        return this.def.get(key);
    }

    static {
        class_mon = new AEMonitor("ConfigDef");
    }
}

