/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.core.util.average;

import com.aelitis.azureus.core.util.average.Average;

public class ExponentialMovingAverage
implements Average {
    private final float weight;
    private double prevEMA;

    public ExponentialMovingAverage(int periods) {
        if (periods < 1) {
            System.out.println("ExponentialMovingAverage:: ERROR: bad periods: " + periods);
        }
        this.weight = 2.0f / (float)(1 + periods);
        this.prevEMA = 0.0;
    }

    public ExponentialMovingAverage(float weight) {
        if ((double)weight < 0.0 || (double)weight > 1.0) {
            System.out.println("ExponentialMovingAverage:: ERROR: bad weight: " + weight);
        }
        this.weight = weight;
        this.prevEMA = 0.0;
    }

    public double update(double newValue) {
        this.prevEMA = (double)this.weight * (newValue - this.prevEMA) + this.prevEMA;
        return this.prevEMA;
    }

    public double getAverage() {
        return this.prevEMA;
    }
}

