/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.core.peermanager.messaging.advanced;

import com.aelitis.azureus.core.networkmanager.TCPTransport;
import com.aelitis.azureus.core.peermanager.messaging.Message;
import com.aelitis.azureus.core.peermanager.messaging.MessageException;
import com.aelitis.azureus.core.peermanager.messaging.MessageStreamDecoder;
import com.aelitis.azureus.core.peermanager.messaging.advanced.ADVHeaderReader;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.DirectByteBuffer;
import org.gudy.azureus2.core3.util.DirectByteBufferPool;

public class ADVMessageDecoder
implements MessageStreamDecoder {
    private static final byte SS = 11;
    private static final int MAX_MESSAGE_LENGTH = 262144;
    private DirectByteBuffer payload_buffer = null;
    private final ByteBuffer[] decode_array = new ByteBuffer[]{null, null};
    private final ADVHeaderReader header_reader = new ADVHeaderReader();
    private boolean reading_length_mode = true;
    private int message_length;
    private int pre_read_start_buffer;
    private int pre_read_start_position;
    private volatile boolean destroyed = false;
    private volatile boolean is_paused = false;
    private ArrayList messages_last_read = new ArrayList();
    private int protocol_bytes_last_read = 0;
    private int data_bytes_last_read = 0;
    private int data_bytes_owed = 0;
    private int percent_complete = -1;

    public int performStreamDecode(TCPTransport transport, int max_bytes) throws IOException {
        int bytes_remaining;
        int bytes_read;
        this.protocol_bytes_last_read = 0;
        this.data_bytes_last_read = 0;
        for (bytes_remaining = max_bytes; bytes_remaining > 0; bytes_remaining -= bytes_read) {
            if (this.destroyed) {
                Debug.out("ADV decoder already destroyed: " + transport.getDescription());
                break;
            }
            if (this.is_paused) {
                Debug.out("ADV decoder paused");
                break;
            }
            int bytes_possible = this.preReadProcess(bytes_remaining);
            if (bytes_possible < 1) {
                Debug.out("ERROR ADV: bytes_possible < 1");
                break;
            }
            if (this.reading_length_mode) {
                transport.read(this.decode_array, 1, 1);
            } else {
                transport.read(this.decode_array, 0, 2);
            }
            bytes_read = this.postReadProcess();
            if (bytes_read >= bytes_possible) continue;
            break;
        }
        return max_bytes - bytes_remaining;
    }

    public int getPercentDoneOfCurrentMessage() {
        return this.percent_complete;
    }

    public Message[] removeDecodedMessages() {
        if (this.messages_last_read.isEmpty()) {
            return null;
        }
        Message[] msgs = this.messages_last_read.toArray(new Message[this.messages_last_read.size()]);
        this.messages_last_read.clear();
        return msgs;
    }

    public int getProtocolBytesDecoded() {
        return this.protocol_bytes_last_read;
    }

    public int getDataBytesDecoded() {
        return this.data_bytes_last_read;
    }

    public ByteBuffer destroy() {
        this.is_paused = true;
        this.destroyed = true;
        this.header_reader.destroy();
        if (this.payload_buffer != null) {
            this.payload_buffer.returnToPool();
            this.payload_buffer = null;
        }
        for (int i = 0; i < this.messages_last_read.size(); ++i) {
            Message msg = (Message)this.messages_last_read.get(i);
            msg.destroy();
        }
        this.messages_last_read.clear();
        return null;
    }

    private int preReadProcess(int allowed) {
        if (allowed < 1) {
            Debug.out("allowed < 1");
        }
        this.decode_array[0] = this.payload_buffer == null ? null : this.payload_buffer.getBuffer((byte)11);
        this.decode_array[1] = this.header_reader.getReadBuffer();
        int bytes_available = 0;
        boolean shrink_remaining_buffers = false;
        int start_buff = this.reading_length_mode ? 1 : 0;
        boolean marked = false;
        for (int i = start_buff; i < 2; ++i) {
            ByteBuffer bb = this.decode_array[i];
            if (bb == null) {
                Debug.out("preReadProcess:: bb[" + i + "] == null, decoder destroyed=" + this.destroyed);
            }
            if (shrink_remaining_buffers) {
                bb.limit(0);
                continue;
            }
            int remaining = bb.remaining();
            if (remaining < 1) continue;
            if (!marked) {
                this.pre_read_start_buffer = i;
                this.pre_read_start_position = bb.position();
                marked = true;
            }
            if (remaining > allowed) {
                bb.limit(bb.position() + allowed);
                bytes_available += bb.remaining();
                shrink_remaining_buffers = true;
                continue;
            }
            bytes_available += remaining;
            allowed -= remaining;
        }
        return bytes_available;
    }

    private int postReadProcess() throws IOException {
        int bytes_read = 0;
        if (!this.reading_length_mode && !this.destroyed) {
            this.payload_buffer.limit((byte)11, this.message_length);
            bytes_read += this.payload_buffer.position((byte)11) - this.pre_read_start_position;
            if (!this.payload_buffer.hasRemaining((byte)11) && !this.is_paused) {
                this.payload_buffer.position((byte)11, 0);
                DirectByteBuffer ref_buff = this.payload_buffer;
                this.payload_buffer = null;
                try {
                    this.header_reader.getMessageID();
                    this.header_reader.getMessageSubID();
                    Message msg = null;
                    this.messages_last_read.add(msg);
                    if (msg.getType() == 1) {
                        this.data_bytes_owed += this.message_length;
                    }
                }
                catch (MessageException me) {
                    ref_buff.returnToPool();
                    throw new IOException("ADV message decode failed: " + me.getMessage());
                }
                this.reading_length_mode = true;
                this.percent_complete = -1;
            } else {
                this.percent_complete = this.payload_buffer.position((byte)11) * 100 / this.message_length;
            }
        }
        if (this.reading_length_mode && !this.destroyed) {
            bytes_read += this.pre_read_start_buffer == 1 ? this.decode_array[1].position() - this.pre_read_start_position : this.decode_array[1].position();
            if (this.header_reader.isHeaderReadComplete()) {
                this.reading_length_mode = false;
                this.message_length = this.header_reader.getMessageLength();
                if (this.message_length > 262144) {
                    throw new IOException("Invalid message length given for ADV message decode: " + this.message_length);
                }
                this.payload_buffer = DirectByteBufferPool.getBuffer((byte)24, this.message_length);
            }
        }
        if (bytes_read < this.data_bytes_owed) {
            this.data_bytes_last_read += bytes_read;
            this.data_bytes_owed -= bytes_read;
        } else {
            this.data_bytes_last_read += this.data_bytes_owed;
            this.data_bytes_owed = 0;
            this.protocol_bytes_last_read += bytes_read - this.data_bytes_owed;
        }
        return bytes_read;
    }

    public void pauseDecoding() {
        this.is_paused = true;
    }

    public void resumeDecoding() {
        this.is_paused = false;
    }
}

