/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.core.networkmanager.impl;

import com.aelitis.azureus.core.networkmanager.TCPTransport;
import com.aelitis.azureus.core.networkmanager.impl.TCPTransportHelperFilter;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import java.nio.channels.SocketChannel;

public class LightweightTCPTransport
implements TCPTransport {
    private final TCPTransportHelperFilter filter;

    public LightweightTCPTransport(TCPTransportHelperFilter filter) {
        this.filter = filter;
    }

    public long write(ByteBuffer[] buffers, int array_offset, int length) throws IOException {
        return this.filter.write(buffers, array_offset, length);
    }

    public long read(ByteBuffer[] buffers, int array_offset, int length) throws IOException {
        return this.filter.read(buffers, array_offset, length);
    }

    public SocketChannel getSocketChannel() {
        return this.filter.getSocketChannel();
    }

    public String getDescription() {
        return this.getSocketChannel().socket().getInetAddress().getHostAddress() + ": " + this.getSocketChannel().socket().getPort();
    }

    public void close() {
        try {
            this.getSocketChannel().close();
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }

    public void setAlreadyRead(ByteBuffer bytes_already_read) {
        throw new RuntimeException("not implemented");
    }

    public boolean isReadyForWrite() {
        throw new RuntimeException("not implemented");
    }

    public boolean isReadyForRead() {
        throw new RuntimeException("not implemented");
    }

    public void establishOutboundConnection(InetSocketAddress address, TCPTransport.ConnectListener listener) {
        throw new RuntimeException("not implemented");
    }

    public void setTransportMode(int mode) {
        throw new RuntimeException("not implemented");
    }

    public int getTransportMode() {
        throw new RuntimeException("not implemented");
    }

    public String getEncryption() {
        return this.filter.getName();
    }
}

