/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.core.diskmanager.cache.impl;

import com.aelitis.azureus.core.diskmanager.cache.CacheFile;
import com.aelitis.azureus.core.diskmanager.cache.CacheFileManagerException;
import com.aelitis.azureus.core.diskmanager.cache.impl.CacheEntry;
import com.aelitis.azureus.core.diskmanager.cache.impl.CacheFileManagerImpl;
import com.aelitis.azureus.core.diskmanager.file.FMFile;
import com.aelitis.azureus.core.diskmanager.file.FMFileManagerException;
import java.io.File;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.TreeSet;
import org.gudy.azureus2.core3.config.COConfigurationManager;
import org.gudy.azureus2.core3.logging.LogEvent;
import org.gudy.azureus2.core3.logging.LogIDs;
import org.gudy.azureus2.core3.logging.Logger;
import org.gudy.azureus2.core3.torrent.TOTorrent;
import org.gudy.azureus2.core3.torrent.TOTorrentFile;
import org.gudy.azureus2.core3.util.AEMonitor;
import org.gudy.azureus2.core3.util.Average;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.DirectByteBuffer;
import org.gudy.azureus2.core3.util.DirectByteBufferPool;

public class CacheFileWithCache
implements CacheFile {
    private static final byte SS_CACHE = 3;
    private static final LogIDs LOGID = LogIDs.CACHE;
    protected static Comparator comparator = new Comparator(){

        public int compare(Object _o1, Object _o2) {
            CacheEntry o1 = (CacheEntry)_o1;
            CacheEntry o2 = (CacheEntry)_o2;
            long offset1 = o1.getFilePosition();
            int length1 = o1.getLength();
            long offset2 = o2.getFilePosition();
            int length2 = o2.getLength();
            if (offset1 + (long)length1 > offset2 && offset2 + (long)length2 > offset1) {
                Debug.out("Overlapping cache entries - " + o1.getString() + "/" + o2.getString());
            }
            return offset1 - offset2 < 0L ? -1 : 1;
        }
    };
    protected static boolean TRACE = false;
    protected static final boolean TRACE_CACHE_CONTENTS = false;
    protected static final int READAHEAD_LOW_LIMIT = 65536;
    protected static final int READAHEAD_HIGH_LIMIT = 262144;
    protected static final int READAHEAD_HISTORY = 32;
    protected CacheFileManagerImpl manager;
    protected FMFile file;
    protected int access_mode = 1;
    protected TOTorrentFile torrent_file;
    protected TOTorrent torrent;
    protected long file_offset_in_torrent;
    protected long[] read_history = new long[32];
    protected int read_history_next = 0;
    protected TreeSet cache = new TreeSet(comparator);
    protected int current_read_ahead_size = 0;
    protected static final int READ_AHEAD_STATS_WAIT_TICKS = 10;
    protected int read_ahead_stats_wait = 10;
    protected Average read_ahead_made_average = Average.getInstance(1000, 5);
    protected Average read_ahead_used_average = Average.getInstance(1000, 5);
    protected long read_ahead_bytes_made;
    protected long last_read_ahead_bytes_made;
    protected long read_ahead_bytes_used;
    protected long last_read_ahead_bytes_used;
    protected int piece_size = 0;
    protected int piece_offset = 0;
    protected AEMonitor this_mon = new AEMonitor("CacheFile");
    protected volatile CacheFileManagerException pending_exception;

    protected CacheFileWithCache(CacheFileManagerImpl _manager, FMFile _file, TOTorrentFile _torrent_file) {
        this.manager = _manager;
        this.file = _file;
        Arrays.fill(this.read_history, -1L);
        if (_torrent_file != null) {
            TOTorrentFile f;
            this.torrent_file = _torrent_file;
            this.torrent = this.torrent_file.getTorrent();
            this.piece_size = (int)this.torrent.getPieceLength();
            for (int i = 0; i < this.torrent.getFiles().length && (f = this.torrent.getFiles()[i]) != this.torrent_file; ++i) {
                this.file_offset_in_torrent += f.getLength();
            }
            this.piece_offset = this.piece_size - (int)(this.file_offset_in_torrent % (long)this.piece_size);
            if (this.piece_offset == this.piece_size) {
                this.piece_offset = 0;
            }
            this.current_read_ahead_size = Math.min(65536, this.piece_size);
        }
    }

    public TOTorrentFile getTorrentFile() {
        return this.torrent_file;
    }

    protected void updateStats() {
        long made = this.read_ahead_bytes_made;
        long used = this.read_ahead_bytes_used;
        long made_diff = made - this.last_read_ahead_bytes_made;
        long used_diff = used - this.last_read_ahead_bytes_used;
        this.read_ahead_made_average.addValue(made_diff);
        this.read_ahead_used_average.addValue(used_diff);
        this.last_read_ahead_bytes_made = made;
        this.last_read_ahead_bytes_used = used;
        if (--this.read_ahead_stats_wait == 0) {
            this.read_ahead_stats_wait = 10;
            double made_average = this.read_ahead_made_average.getAverage();
            double used_average = this.read_ahead_used_average.getAverage();
            double ratio = used_average * 100.0 / made_average;
            if (ratio > 0.75) {
                this.current_read_ahead_size += 16384;
                this.current_read_ahead_size = Math.min(this.current_read_ahead_size, this.piece_size);
                this.current_read_ahead_size = Math.min(this.current_read_ahead_size, 262144);
                this.current_read_ahead_size = Math.min(this.current_read_ahead_size, (int)(this.manager.getCacheSize() / 16L));
            } else if (ratio < 0.5) {
                this.current_read_ahead_size -= 16384;
                this.current_read_ahead_size = Math.max(this.current_read_ahead_size, 65536);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void readCache(DirectByteBuffer file_buffer, long file_position, boolean recursive, boolean disable_read_cache) throws CacheFileManagerException {
        block46: {
            this.checkPendingException();
            int file_buffer_position = file_buffer.position((byte)3);
            int file_buffer_limit = file_buffer.limit((byte)3);
            int read_length = file_buffer_limit - file_buffer_position;
            if (this.manager.isCacheEnabled()) {
                if (TRACE) {
                    Logger.log(new LogEvent(this.torrent, LOGID, "readCache: " + this.getName() + ", " + file_position + " - " + (file_position + (long)read_length - 1L) + ":" + file_buffer_position + "/" + file_buffer_limit));
                }
                if (read_length == 0) {
                    return;
                }
                long writing_file_position = file_position;
                int writing_left = read_length;
                boolean ok = true;
                int used_entries = 0;
                long used_read_ahead = 0L;
                try {
                    this.this_mon.enter();
                    this.read_history[this.read_history_next++] = file_position + (long)read_length;
                    if (this.read_history_next == 32) {
                        this.read_history_next = 0;
                    }
                    Iterator it = this.cache.iterator();
                    while (ok && writing_left > 0 && it.hasNext()) {
                        CacheEntry entry2 = (CacheEntry)it.next();
                        long entry_file_position = entry2.getFilePosition();
                        int entry_length = entry2.getLength();
                        if (entry_file_position > writing_file_position) {
                            ok = false;
                            break;
                        }
                        if (entry_file_position + (long)entry_length <= writing_file_position) continue;
                        int skip = (int)(writing_file_position - entry_file_position);
                        int available = entry_length - skip;
                        if (available > writing_left) {
                            available = writing_left;
                        }
                        DirectByteBuffer entry_buffer = entry2.getBuffer();
                        int entry_buffer_position = entry_buffer.position((byte)3);
                        int entry_buffer_limit = entry_buffer.limit((byte)3);
                        try {
                            entry_buffer.limit((byte)3, entry_buffer_position + skip + available);
                            entry_buffer.position((byte)3, entry_buffer_position + skip);
                            if (TRACE) {
                                Logger.log(new LogEvent(this.torrent, LOGID, "cacheRead: using " + entry2.getString() + "[" + entry_buffer.position((byte)3) + "/" + entry_buffer.limit((byte)3) + "]" + "to write to [" + file_buffer.position((byte)3) + "/" + file_buffer.limit((byte)3) + "]"));
                            }
                            ++used_entries;
                            file_buffer.put((byte)3, entry_buffer);
                            this.manager.cacheEntryUsed(entry2);
                        }
                        finally {
                            entry_buffer.limit((byte)3, entry_buffer_limit);
                            entry_buffer.position((byte)3, entry_buffer_position);
                        }
                        writing_file_position += (long)available;
                        writing_left -= available;
                        if (entry2.getType() != 1) continue;
                        used_read_ahead += (long)available;
                    }
                    Object var28_31 = null;
                    if (ok) {
                        this.read_ahead_bytes_used += used_read_ahead;
                    }
                    this.this_mon.exit();
                }
                catch (Throwable throwable) {
                    Object var28_32 = null;
                    if (ok) {
                        this.read_ahead_bytes_used += used_read_ahead;
                    }
                    this.this_mon.exit();
                    throw throwable;
                }
                if (ok && writing_left == 0) {
                    if (!recursive) {
                        this.manager.cacheBytesRead(read_length);
                    }
                    if (TRACE) {
                        Logger.log(new LogEvent(this.torrent, LOGID, "cacheRead: cache use ok [entries = " + used_entries + "]"));
                    }
                    break block46;
                }
                if (TRACE) {
                    Logger.log(new LogEvent(this.torrent, LOGID, "cacheRead: cache use fails, reverting to plain read"));
                }
                file_buffer.position((byte)3, file_buffer_position);
                for (int i = 0; i < 2; ++i) {
                    try {
                        boolean do_read_ahead;
                        boolean bl = do_read_ahead = i == 0 && !recursive && !disable_read_cache && this.manager.isReadCacheEnabled() && read_length < this.current_read_ahead_size && file_position + (long)this.current_read_ahead_size <= this.file.getLength();
                        if (do_read_ahead) {
                            do_read_ahead = false;
                            for (int j = 0; j < 32; ++j) {
                                if (this.read_history[j] != file_position) continue;
                                do_read_ahead = true;
                                break;
                            }
                        }
                        int actual_read_ahead = this.current_read_ahead_size;
                        if (do_read_ahead) {
                            int data_left;
                            int request_piece_offset = (int)((file_position - (long)this.piece_offset) % (long)this.piece_size);
                            if (request_piece_offset < 0) {
                                request_piece_offset += this.piece_size;
                            }
                            if ((data_left = this.piece_size - request_piece_offset) < actual_read_ahead && (actual_read_ahead = data_left) <= read_length) {
                                do_read_ahead = false;
                            }
                        }
                        if (do_read_ahead) {
                            if (TRACE) {
                                Logger.log(new LogEvent(this.torrent, LOGID, "\tperforming read-ahead"));
                            }
                            DirectByteBuffer cache_buffer = DirectByteBufferPool.getBuffer((byte)5, actual_read_ahead);
                            boolean buffer_cached = false;
                            try {
                                CacheEntry entry3 = this.manager.allocateCacheSpace(1, this, cache_buffer, file_position, actual_read_ahead);
                                entry3.setClean();
                                try {
                                    this.this_mon.enter();
                                    this.flushCache(file_position, actual_read_ahead, true, -1L, 0L, -1L);
                                    this.getFMFile().read(cache_buffer, file_position);
                                    this.read_ahead_bytes_made += (long)actual_read_ahead;
                                    this.manager.fileBytesRead(actual_read_ahead);
                                    cache_buffer.position((byte)3, 0);
                                    this.cache.add(entry3);
                                    this.manager.addCacheSpace(entry3);
                                }
                                finally {
                                    this.this_mon.exit();
                                }
                                buffer_cached = true;
                            }
                            finally {
                                if (!buffer_cached) {
                                    cache_buffer.returnToPool();
                                }
                            }
                            this.readCache(file_buffer, file_position, true, disable_read_cache);
                            break block46;
                        }
                        if (TRACE) {
                            Logger.log(new LogEvent(this.torrent, LOGID, "\tnot performing read-ahead"));
                        }
                        try {
                            this.this_mon.enter();
                            this.flushCache(file_position, read_length, true, -1L, 0L, -1L);
                            this.getFMFile().read(file_buffer, file_position);
                        }
                        finally {
                            this.this_mon.exit();
                        }
                        this.manager.fileBytesRead(read_length);
                        break block46;
                    }
                    catch (CacheFileManagerException e) {
                        if (i != 1) continue;
                        throw e;
                    }
                    catch (FMFileManagerException e) {
                        if (i != 1) continue;
                        this.manager.rethrow(this, e);
                    }
                }
                break block46;
            }
            try {
                this.getFMFile().read(file_buffer, file_position);
                this.manager.fileBytesRead(read_length);
            }
            catch (FMFileManagerException e) {
                this.manager.rethrow(this, e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void writeCache(DirectByteBuffer file_buffer, long file_position, boolean buffer_handed_over) throws CacheFileManagerException {
        boolean failed;
        boolean buffer_cached;
        block20: {
            this.checkPendingException();
            buffer_cached = false;
            failed = false;
            try {
                try {
                    int file_buffer_position = file_buffer.position((byte)3);
                    int file_buffer_limit = file_buffer.limit((byte)3);
                    int write_length = file_buffer_limit - file_buffer_position;
                    if (write_length == 0) {
                        Object var14_11 = null;
                        if (!buffer_handed_over) return;
                        if (failed) return;
                        if (buffer_cached) return;
                        file_buffer.returnToPool();
                        return;
                    }
                    if (this.manager.isWriteCacheEnabled()) {
                        if (TRACE) {
                            Logger.log(new LogEvent(this.torrent, LOGID, "writeCache: " + this.getName() + ", " + file_position + " - " + (file_position + (long)write_length - 1L) + ":" + file_buffer_position + "/" + file_buffer_limit));
                        }
                        if (!buffer_handed_over && write_length < this.piece_size) {
                            if (TRACE) {
                                Logger.log(new LogEvent(this.torrent, LOGID, "    making copy of non-handedover buffer"));
                            }
                            DirectByteBuffer cache_buffer = DirectByteBufferPool.getBuffer((byte)10, write_length);
                            cache_buffer.put((byte)3, file_buffer);
                            cache_buffer.position((byte)3, 0);
                            file_buffer = cache_buffer;
                            file_buffer_position = 0;
                            file_buffer_limit = write_length;
                            buffer_handed_over = true;
                        }
                        if (buffer_handed_over) {
                            CacheEntry entry2 = this.manager.allocateCacheSpace(0, this, file_buffer, file_position, write_length);
                            try {
                                this.this_mon.enter();
                                if (this.access_mode != 2) {
                                    throw new CacheFileManagerException(this, "Write failed - cache file is read only");
                                }
                                this.flushCache(file_position, write_length, true, -1L, 0L, -1L);
                                this.cache.add(entry2);
                                this.manager.addCacheSpace(entry2);
                            }
                            finally {
                                this.this_mon.exit();
                            }
                            this.manager.cacheBytesWritten(write_length);
                            buffer_cached = true;
                            break block20;
                        }
                        try {
                            this.this_mon.enter();
                            this.flushCache(file_position, write_length, true, -1L, 0L, -1L);
                            this.getFMFile().write(file_buffer, file_position);
                        }
                        finally {
                            this.this_mon.exit();
                        }
                        this.manager.fileBytesWritten(write_length);
                        break block20;
                    }
                    this.getFMFile().write(file_buffer, file_position);
                    this.manager.fileBytesWritten(write_length);
                }
                catch (CacheFileManagerException e) {
                    failed = true;
                    throw e;
                }
                catch (FMFileManagerException e) {
                    failed = true;
                    this.manager.rethrow(this, e);
                    Object var14_13 = null;
                    if (!buffer_handed_over) return;
                    if (failed) return;
                    if (buffer_cached) return;
                    file_buffer.returnToPool();
                    return;
                }
            }
            catch (Throwable throwable) {
                Object var14_14 = null;
                if (!buffer_handed_over) throw throwable;
                if (failed) throw throwable;
                if (buffer_cached) throw throwable;
                file_buffer.returnToPool();
                throw throwable;
            }
        }
        Object var14_12 = null;
        if (!buffer_handed_over) return;
        if (failed) return;
        if (buffer_cached) return;
        file_buffer.returnToPool();
    }

    protected void flushCache(long file_position, long length, boolean release_entries, long minimum_to_release, long oldest_dirty_time, long min_chunk_size) throws CacheFileManagerException {
        try {
            this.flushCacheSupport(file_position, length, release_entries, minimum_to_release, oldest_dirty_time, min_chunk_size);
        }
        catch (CacheFileManagerException e) {
            if (!release_entries) {
                this.flushCacheSupport(0L, -1L, true, -1L, 0L, -1L);
            }
            throw e;
        }
    }

    /*
     * Exception decompiling
     */
    protected void flushCacheSupport(long file_position, long length, boolean release_entries, long minimum_to_release, long oldest_dirty_time, long min_chunk_size) throws CacheFileManagerException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Missing node tying up JSR block
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.tieUpRelations(Op02WithProcessedDataAndRefs.java:2900)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.copyBlock(Op02WithProcessedDataAndRefs.java:2889)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.inlineJSR(Op02WithProcessedDataAndRefs.java:2845)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.processJSRs(Op02WithProcessedDataAndRefs.java:2591)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.processJSR(Op02WithProcessedDataAndRefs.java:2481)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:444)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void multiBlockFlush(List multi_block_entries, long multi_block_start, long multi_block_next, boolean release_entries) throws CacheFileManagerException {
        int i3;
        boolean write_ok = false;
        try {
            try {
                CacheEntry entry2;
                if (TRACE) {
                    Logger.log(new LogEvent(this.torrent, LOGID, "multiBlockFlush: writing " + multi_block_entries.size() + " entries, [" + multi_block_start + "," + multi_block_next + "," + release_entries + "]"));
                }
                DirectByteBuffer[] buffers = new DirectByteBuffer[multi_block_entries.size()];
                long expected_per_entry_write = 0L;
                for (int i2 = 0; i2 < buffers.length; expected_per_entry_write += (long)entry2.getLength(), ++i2) {
                    entry2 = (CacheEntry)multi_block_entries.get(i2);
                    DirectByteBuffer buffer = entry2.getBuffer();
                    if (buffer.limit((byte)3) - buffer.position((byte)3) != entry2.getLength()) {
                        throw new CacheFileManagerException(this, "flush: inconsistent entry length, position wrong");
                    }
                    buffers[i2] = buffer;
                }
                long expected_overall_write = multi_block_next - multi_block_start;
                if (expected_per_entry_write != expected_overall_write) {
                    throw new CacheFileManagerException(this, "flush: inconsistent write length, entrys = " + expected_per_entry_write + " overall = " + expected_overall_write);
                }
                this.getFMFile().write(buffers, multi_block_start);
                this.manager.fileBytesWritten(expected_overall_write);
                write_ok = true;
            }
            catch (FMFileManagerException e) {
                throw new CacheFileManagerException(this, "flush fails", e);
            }
            Object var15_13 = null;
            i3 = 0;
        }
        catch (Throwable throwable) {
            Object var15_14 = null;
            int i3 = 0;
            while (true) {
                if (i3 >= multi_block_entries.size()) {
                    throw throwable;
                }
                CacheEntry entry3 = (CacheEntry)multi_block_entries.get(i3);
                if (release_entries) {
                    this.manager.releaseCacheSpace(entry3);
                } else {
                    entry3.resetBufferPosition();
                    if (write_ok) {
                        entry3.setClean();
                    }
                }
                ++i3;
            }
        }
        while (i3 < multi_block_entries.size()) {
            CacheEntry entry3 = (CacheEntry)multi_block_entries.get(i3);
            if (release_entries) {
                this.manager.releaseCacheSpace(entry3);
            } else {
                entry3.resetBufferPosition();
                if (write_ok) {
                    entry3.setClean();
                }
            }
            ++i3;
        }
        return;
    }

    protected void flushCache(long file_start_position, boolean release_entries, long minumum_to_release) throws CacheFileManagerException {
        if (this.manager.isCacheEnabled()) {
            if (TRACE) {
                Logger.log(new LogEvent(this.torrent, LOGID, "flushCache: " + this.getName() + ", rel = " + release_entries + ", min = " + minumum_to_release));
            }
            this.flushCache(file_start_position, -1L, release_entries, minumum_to_release, 0L, -1L);
        }
    }

    protected void flushCachePublic(boolean release_entries, long minumum_to_release) throws CacheFileManagerException {
        this.checkPendingException();
        this.flushCache(0L, release_entries, minumum_to_release);
    }

    protected void flushOldDirtyData(long oldest_dirty_time, long min_chunk_size) throws CacheFileManagerException {
        if (this.manager.isCacheEnabled()) {
            if (TRACE) {
                Logger.log(new LogEvent(this.torrent, LOGID, "flushOldDirtyData: " + this.getName()));
            }
            this.flushCache(0L, -1L, false, -1L, oldest_dirty_time, min_chunk_size);
        }
    }

    protected void flushOldDirtyData(long oldest_dirty_time) throws CacheFileManagerException {
        this.flushOldDirtyData(oldest_dirty_time, -1L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected long getBytesInCache(long offset, long length) {
        try {
            this.this_mon.enter();
            long result = 0L;
            Iterator it = this.cache.iterator();
            long start_pos = offset;
            long end_pos = offset + length;
            while (it.hasNext()) {
                int entry_length;
                CacheEntry entry2 = (CacheEntry)it.next();
                long this_start = entry2.getFilePosition();
                long this_end = this_start + (long)(entry_length = entry2.getLength());
                if (this_end <= start_pos) continue;
                if (end_pos <= this_start) break;
                long bit_start = start_pos < this_start ? this_start : start_pos;
                long bit_end = end_pos >= this_end ? this_end : end_pos;
                result += bit_end - bit_start;
            }
            long l = result;
            return l;
        }
        finally {
            this.this_mon.exit();
        }
    }

    protected void checkPendingException() throws CacheFileManagerException {
        if (this.pending_exception != null) {
            throw this.pending_exception;
        }
    }

    protected void setPendingException(CacheFileManagerException e) {
        this.pending_exception = e;
    }

    protected String getName() {
        return this.file.getName();
    }

    protected FMFile getFMFile() {
        return this.file;
    }

    public boolean exists() {
        return this.file.exists();
    }

    public void moveFile(File new_file) throws CacheFileManagerException {
        try {
            this.flushCachePublic(true, -1L);
            this.file.moveFile(new_file);
        }
        catch (FMFileManagerException e) {
            this.manager.rethrow(this, e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setAccessMode(int mode) throws CacheFileManagerException {
        try {
            this.this_mon.enter();
            if (this.access_mode != mode) {
                this.flushCachePublic(false, -1L);
            }
            this.file.setAccessMode(mode == 1 ? 1 : 2);
            this.access_mode = mode;
        }
        catch (FMFileManagerException e) {
            this.manager.rethrow(this, e);
        }
        finally {
            this.this_mon.exit();
        }
    }

    public int getAccessMode() {
        return this.access_mode;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setStorageType(int type) throws CacheFileManagerException {
        try {
            this.this_mon.enter();
            if (this.getStorageType() != type) {
                this.flushCachePublic(false, -1L);
            }
            this.file.setStorageType(type == 2 ? 2 : 1);
        }
        catch (FMFileManagerException e) {
            this.manager.rethrow(this, e);
        }
        finally {
            this.this_mon.exit();
        }
    }

    public int getStorageType() {
        return this.file.getStorageType() == 2 ? 2 : 1;
    }

    public void ensureOpen(String reason) throws CacheFileManagerException {
        try {
            this.file.ensureOpen(reason);
        }
        catch (FMFileManagerException e) {
            this.manager.rethrow(this, e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public long getLength() throws CacheFileManagerException {
        if (!this.manager.isCacheEnabled()) return this.file.getLength();
        try {
            this.this_mon.enter();
            long physical_size = this.file.getLength();
            Iterator it = this.cache.iterator();
            while (it.hasNext()) {
                int entry_length;
                long entry_file_position;
                long logical_size;
                CacheEntry entry2 = (CacheEntry)it.next();
                if (it.hasNext() || (logical_size = (entry_file_position = entry2.getFilePosition()) + (long)(entry_length = entry2.getLength())) <= physical_size) continue;
                physical_size = logical_size;
            }
            long l = physical_size;
            this.this_mon.exit();
            return l;
        }
        catch (Throwable throwable) {
            try {
                this.this_mon.exit();
                throw throwable;
            }
            catch (FMFileManagerException e) {
                this.manager.rethrow(this, e);
                return 0L;
            }
        }
    }

    public long compareLength(long compare_to) throws CacheFileManagerException {
        try {
            long physical_length = this.file.getLength();
            long res = physical_length - compare_to;
            if (res >= 0L) {
                return res;
            }
            return this.getLength() - compare_to;
        }
        catch (FMFileManagerException e) {
            this.manager.rethrow(this, e);
            return 0L;
        }
    }

    public void setLength(long length) throws CacheFileManagerException {
        try {
            this.flushCachePublic(true, -1L);
            this.file.setLength(length);
        }
        catch (FMFileManagerException e) {
            this.manager.rethrow(this, e);
        }
    }

    public void read(DirectByteBuffer buffer, long position, short policy) throws CacheFileManagerException {
        boolean flush;
        boolean read_cache = (policy & 1) != 0;
        boolean bl = flush = (policy & 2) != 0;
        if (flush) {
            int file_buffer_position = buffer.position((byte)3);
            int file_buffer_limit = buffer.limit((byte)3);
            int read_length = file_buffer_limit - file_buffer_position;
            this.flushCache(position, read_length, false, -1L, 0L, -1L);
        }
        this.readCache(buffer, position, false, !read_cache);
    }

    public void write(DirectByteBuffer buffer, long position) throws CacheFileManagerException {
        this.writeCache(buffer, position, false);
    }

    public void writeAndHandoverBuffer(DirectByteBuffer buffer, long position) throws CacheFileManagerException {
        this.writeCache(buffer, position, true);
    }

    public void flushCache() throws CacheFileManagerException {
        try {
            this.flushCachePublic(false, -1L);
            this.file.flush();
        }
        catch (FMFileManagerException e) {
            this.manager.rethrow(this, e);
        }
    }

    public void clearCache() throws CacheFileManagerException {
        this.flushCachePublic(true, -1L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public void close() throws CacheFileManagerException {
        block11: {
            boolean fm_file_closed;
            block10: {
                fm_file_closed = false;
                this.flushCachePublic(true, -1L);
                this.file.close();
                fm_file_closed = true;
                Object var4_2 = null;
                if (fm_file_closed) break block10;
                try {
                    this.file.close();
                }
                catch (Throwable e2) {
                    // empty catch block
                }
            }
            this.manager.closeFile(this);
            {
                break block11;
                catch (FMFileManagerException e) {
                    this.manager.rethrow(this, e);
                    Object var4_3 = null;
                    if (!fm_file_closed) {
                        try {
                            this.file.close();
                        }
                        catch (Throwable e2) {
                            // empty catch block
                        }
                    }
                    this.manager.closeFile(this);
                }
            }
            catch (Throwable throwable) {
                Object var4_4 = null;
                if (!fm_file_closed) {
                    try {
                        this.file.close();
                    }
                    catch (Throwable e2) {
                        // empty catch block
                    }
                }
                this.manager.closeFile(this);
                throw throwable;
            }
        }
    }

    public void delete() throws CacheFileManagerException {
        try {
            this.file.delete();
        }
        catch (FMFileManagerException e) {
            this.manager.rethrow(this, e);
        }
    }

    static {
        TRACE = COConfigurationManager.getBooleanParameter("diskmanager.perf.cache.trace");
        if (TRACE) {
            System.out.println("**** Disk Cache tracing enabled ****");
        }
    }
}

