/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.core.diskmanager.cache.impl;

import com.aelitis.azureus.core.diskmanager.cache.CacheFile;
import com.aelitis.azureus.core.diskmanager.cache.CacheFileManager;
import com.aelitis.azureus.core.diskmanager.cache.CacheFileManagerException;
import com.aelitis.azureus.core.diskmanager.cache.CacheFileManagerStats;
import com.aelitis.azureus.core.diskmanager.cache.CacheFileOwner;
import com.aelitis.azureus.core.diskmanager.cache.impl.CacheEntry;
import com.aelitis.azureus.core.diskmanager.cache.impl.CacheFileManagerStatsImpl;
import com.aelitis.azureus.core.diskmanager.cache.impl.CacheFileWithCache;
import com.aelitis.azureus.core.diskmanager.cache.impl.CacheFileWithoutCache;
import com.aelitis.azureus.core.diskmanager.file.FMFile;
import com.aelitis.azureus.core.diskmanager.file.FMFileManager;
import com.aelitis.azureus.core.diskmanager.file.FMFileManagerException;
import com.aelitis.azureus.core.diskmanager.file.FMFileManagerFactory;
import com.aelitis.azureus.core.diskmanager.file.FMFileOwner;
import java.io.File;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.WeakHashMap;
import org.gudy.azureus2.core3.config.COConfigurationManager;
import org.gudy.azureus2.core3.logging.LogEvent;
import org.gudy.azureus2.core3.logging.LogIDs;
import org.gudy.azureus2.core3.logging.Logger;
import org.gudy.azureus2.core3.torrent.TOTorrent;
import org.gudy.azureus2.core3.torrent.TOTorrentFile;
import org.gudy.azureus2.core3.util.AEDiagnostics;
import org.gudy.azureus2.core3.util.AEDiagnosticsEvidenceGenerator;
import org.gudy.azureus2.core3.util.AEMonitor;
import org.gudy.azureus2.core3.util.AEThread;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.DirectByteBuffer;
import org.gudy.azureus2.core3.util.IndentWriter;
import org.gudy.azureus2.core3.util.SystemTime;

public class CacheFileManagerImpl
implements CacheFileManager,
AEDiagnosticsEvidenceGenerator {
    private static final LogIDs LOGID = LogIDs.CACHE;
    public static final boolean DEBUG = false;
    public static final int CACHE_CLEANER_TICKS = 60;
    public static final int STATS_UPDATE_FREQUENCY = 1000;
    public static final long DIRTY_CACHE_WRITE_MAX_AGE = 120000L;
    protected boolean cache_enabled;
    protected boolean cache_read_enabled;
    protected boolean cache_write_enabled;
    protected long cache_size;
    protected long cache_files_not_smaller_than;
    protected long cache_minimum_free_size;
    protected long cache_space_free;
    private long cache_file_id_next = 0L;
    protected FMFileManager file_manager;
    protected WeakHashMap cache_files = new WeakHashMap();
    protected WeakHashMap updated_cache_files = null;
    protected LinkedHashMap cache_entries = new LinkedHashMap(1024, 0.75f, true);
    protected CacheFileManagerStatsImpl stats;
    protected Map torrent_to_cache_file_map = new HashMap();
    protected long cache_bytes_written;
    protected long cache_bytes_read;
    protected long file_bytes_written;
    protected long file_bytes_read;
    protected long cache_read_count;
    protected long cache_write_count;
    protected long file_read_count;
    protected long file_write_count;
    protected AEMonitor this_mon = new AEMonitor("CacheFileManager");

    public CacheFileManagerImpl() {
        AEDiagnostics.addEvidenceGenerator(this);
        this.file_manager = FMFileManagerFactory.getSingleton();
        boolean enabled = COConfigurationManager.getBooleanParameter("diskmanager.perf.cache.enable");
        boolean enable_read = COConfigurationManager.getBooleanParameter("diskmanager.perf.cache.enable.read");
        boolean enable_write = COConfigurationManager.getBooleanParameter("diskmanager.perf.cache.enable.write");
        int size = 0x100000 * COConfigurationManager.getIntParameter("diskmanager.perf.cache.size");
        int not_smaller_than = 1024 * COConfigurationManager.getIntParameter("notsmallerthan");
        if (size <= 0) {
            Debug.out("Invalid cache size parameter (" + size + "), caching disabled");
            enabled = false;
        }
        this.initialise(enabled, enable_read, enable_write, size, not_smaller_than);
    }

    protected void initialise(boolean enabled, boolean enable_read, boolean enable_write, long size, long not_smaller_than) {
        this.cache_enabled = enabled && (enable_read || enable_write);
        this.cache_read_enabled = enabled && enable_read;
        this.cache_write_enabled = enabled && enable_write;
        this.cache_size = size;
        this.cache_files_not_smaller_than = not_smaller_than;
        this.cache_minimum_free_size = this.cache_size / 4L;
        this.cache_space_free = this.cache_size;
        this.stats = new CacheFileManagerStatsImpl(this);
        AEThread t = new AEThread("CacheStatsAndCleaner"){

            public void runSupport() {
                CacheFileManagerImpl.this.cacheStatsAndCleaner();
            }
        };
        t.setDaemon(true);
        t.start();
        if (Logger.isEnabled()) {
            Logger.log(new LogEvent(LOGID, "DiskCache: enabled = " + this.cache_enabled + ", read = " + this.cache_read_enabled + ", write = " + this.cache_write_enabled + ", size = " + this.cache_size + " B"));
        }
    }

    protected boolean isWriteCacheEnabled() {
        return this.cache_write_enabled;
    }

    protected boolean isReadCacheEnabled() {
        return this.cache_read_enabled;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CacheFile createFile(final CacheFileOwner owner, File file, int type) throws CacheFileManagerException {
        long my_id;
        try {
            this.this_mon.enter();
            my_id = this.cache_file_id_next++;
        }
        finally {
            this.this_mon.exit();
        }
        try {
            CacheFile cf;
            FMFile fm_file = this.file_manager.createFile(new FMFileOwner(){

                public String getName() {
                    return owner.getCacheFileOwnerName() + "[" + my_id + "]";
                }

                public TOTorrentFile getTorrentFile() {
                    return owner.getCacheFileTorrentFile();
                }

                public File getControlFile(String name) {
                    return owner.getCacheFileControlFile(name);
                }
            }, file, type == 1 ? 1 : 2);
            TOTorrentFile tf = owner.getCacheFileTorrentFile();
            if (tf != null && tf.getLength() < this.cache_files_not_smaller_than) {
                cf = new CacheFileWithoutCache(this, fm_file, tf);
            } else {
                cf = new CacheFileWithCache(this, fm_file, tf);
                try {
                    this.this_mon.enter();
                    if (this.updated_cache_files == null) {
                        this.updated_cache_files = new WeakHashMap(this.cache_files);
                    }
                    this.updated_cache_files.put(cf, null);
                    if (tf != null) {
                        HashMap<TOTorrentFile, CacheFileWithCache> new_map = new HashMap<TOTorrentFile, CacheFileWithCache>(this.torrent_to_cache_file_map);
                        new_map.put(tf, (CacheFileWithCache)cf);
                        this.torrent_to_cache_file_map = new_map;
                    }
                }
                finally {
                    this.this_mon.exit();
                }
            }
            return cf;
        }
        catch (FMFileManagerException e) {
            this.rethrow(null, e);
            return null;
        }
    }

    public CacheFileManagerStats getStats() {
        return this.stats;
    }

    protected boolean isCacheEnabled() {
        return this.cache_enabled;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected CacheEntry allocateCacheSpace(int entry_type, CacheFileWithCache file, DirectByteBuffer buffer, long file_position, int length) throws CacheFileManagerException {
        boolean ok = false;
        boolean log = false;
        while (!ok) {
            CacheEntry oldest_entry = null;
            try {
                this.this_mon.enter();
                if ((long)length < this.cache_space_free || this.cache_space_free == this.cache_size) {
                    ok = true;
                } else {
                    oldest_entry = (CacheEntry)this.cache_entries.keySet().iterator().next();
                }
            }
            finally {
                this.this_mon.exit();
            }
            if (ok) continue;
            log = true;
            long old_free = this.cache_space_free;
            CacheFileWithCache oldest_file = oldest_entry.getFile();
            try {
                oldest_file.flushCache(oldest_entry.getFilePosition(), true, this.cache_minimum_free_size);
            }
            catch (CacheFileManagerException e) {
                if (oldest_file != file) {
                    oldest_file.setPendingException(e);
                }
                throw e;
            }
            long flushed = this.cache_space_free - old_free;
            if (Logger.isEnabled()) {
                TOTorrentFile tf = file.getTorrentFile();
                TOTorrent torrent = tf == null ? null : tf.getTorrent();
                Logger.log(new LogEvent(torrent, LOGID, "DiskCache: cache full, flushed " + flushed + " from " + oldest_file.getName()));
            }
            if (flushed != 0L) continue;
            try {
                this.this_mon.enter();
                if (this.cache_entries.size() <= 0 || (CacheEntry)this.cache_entries.keySet().iterator().next() != oldest_entry) continue;
                throw new CacheFileManagerException(null, "Cache inconsistent: 0 flushed");
            }
            finally {
                this.this_mon.exit();
            }
        }
        CacheEntry entry2 = new CacheEntry(entry_type, file, buffer, file_position, length);
        if (log && Logger.isEnabled()) {
            TOTorrentFile tf = file.getTorrentFile();
            TOTorrent torrent = tf == null ? null : tf.getTorrent();
            Logger.log(new LogEvent(torrent, LOGID, "DiskCache: cr=" + this.cache_bytes_read + ",cw=" + this.cache_bytes_written + ",fr=" + this.file_bytes_read + ",fw=" + this.file_bytes_written));
        }
        return entry2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    protected void cacheStatsAndCleaner() {
        cleaner_ticks = 60L;
        block8: while (true) {
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException e) {
                Debug.printStackTrace(e);
                break;
            }
            this.stats.update();
            cf_it = this.cache_files.keySet().iterator();
            while (cf_it.hasNext()) {
                ((CacheFileWithCache)cf_it.next()).updateStats();
            }
            if (--cleaner_ticks != 0L) continue;
            cleaner_ticks = 60L;
            dirty_files = new HashSet<CacheFileWithCache>();
            now = SystemTime.getCurrentTime();
            oldest = now - 120000L;
            try {
                this.this_mon.enter();
                if (this.updated_cache_files != null) {
                    this.cache_files = this.updated_cache_files;
                    this.updated_cache_files = null;
                }
                if (this.cache_entries.size() > 0) {
                    it = this.cache_entries.keySet().iterator();
                    while (it.hasNext()) {
                        entry = (CacheEntry)it.next();
                        if (!entry.isDirty()) continue;
                        dirty_files.add(entry.getFile());
                    }
                }
            }
            finally {
                this.this_mon.exit();
            }
            it = dirty_files.iterator();
            while (true) {
                if (it.hasNext()) ** break;
                continue block8;
                file = (CacheFileWithCache)it.next();
                try {
                    tf = file.getTorrentFile();
                    min_flush_size = -1L;
                    if (tf != null) {
                        min_flush_size = tf.getTorrent().getPieceLength();
                    }
                    file.flushOldDirtyData(oldest, min_flush_size);
                }
                catch (CacheFileManagerException e) {
                    file.setPendingException(e);
                    Debug.printStackTrace(e);
                }
                catch (Throwable e) {
                    Debug.printStackTrace(e);
                }
            }
            break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addCacheSpace(CacheEntry new_entry) throws CacheFileManagerException {
        try {
            this.this_mon.enter();
            this.cache_space_free -= (long)new_entry.getLength();
            this.cache_entries.put(new_entry, new_entry);
        }
        finally {
            this.this_mon.exit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void cacheEntryUsed(CacheEntry entry2) throws CacheFileManagerException {
        try {
            this.this_mon.enter();
            if (this.cache_entries.get(entry2) == null) {
                Debug.out("Cache inconsistency: entry missing on usage");
                throw new CacheFileManagerException(null, "Cache inconsistency: entry missing on usage");
            }
            entry2.used();
        }
        finally {
            this.this_mon.exit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void releaseCacheSpace(CacheEntry entry2) throws CacheFileManagerException {
        entry2.getBuffer().returnToPool();
        try {
            this.this_mon.enter();
            this.cache_space_free += (long)entry2.getLength();
            if (this.cache_entries.remove(entry2) == null) {
                Debug.out("Cache inconsistency: entry missing on removal");
                throw new CacheFileManagerException(null, "Cache inconsistency: entry missing on removal");
            }
        }
        finally {
            this.this_mon.exit();
        }
    }

    protected long getCacheSize() {
        return this.cache_size;
    }

    protected long getCacheUsed() {
        long free = this.cache_space_free;
        if (free < 0L) {
            free = 0L;
        }
        return this.cache_size - free;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void cacheBytesWritten(long num) {
        try {
            this.this_mon.enter();
            this.cache_bytes_written += num;
            ++this.cache_write_count;
        }
        finally {
            this.this_mon.exit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void cacheBytesRead(int num) {
        try {
            this.this_mon.enter();
            this.cache_bytes_read += (long)num;
            ++this.cache_read_count;
        }
        finally {
            this.this_mon.exit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void fileBytesWritten(long num) {
        try {
            this.this_mon.enter();
            this.file_bytes_written += num;
            ++this.file_write_count;
        }
        finally {
            this.this_mon.exit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void fileBytesRead(int num) {
        try {
            this.this_mon.enter();
            this.file_bytes_read += (long)num;
            ++this.file_read_count;
        }
        finally {
            this.this_mon.exit();
        }
    }

    protected long getBytesWrittenToCache() {
        return this.cache_bytes_written;
    }

    protected long getBytesWrittenToFile() {
        return this.file_bytes_written;
    }

    protected long getBytesReadFromCache() {
        return this.cache_bytes_read;
    }

    protected long getBytesReadFromFile() {
        return this.file_bytes_read;
    }

    public long getCacheReadCount() {
        return this.cache_read_count;
    }

    public long getCacheWriteCount() {
        return this.cache_write_count;
    }

    public long getFileReadCount() {
        return this.file_read_count;
    }

    public long getFileWriteCount() {
        return this.file_write_count;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void closeFile(CacheFileWithCache file) {
        TOTorrentFile tf = file.getTorrentFile();
        if (tf != null && this.torrent_to_cache_file_map.get(tf) != null) {
            try {
                this.this_mon.enter();
                HashMap new_map = new HashMap(this.torrent_to_cache_file_map);
                new_map.remove(tf);
                this.torrent_to_cache_file_map = new_map;
            }
            finally {
                this.this_mon.exit();
            }
        }
    }

    protected long getBytesInCache(TOTorrent torrent, int piece_number, int offset, long length) {
        Map map = this.torrent_to_cache_file_map;
        TOTorrentFile[] files = torrent.getFiles();
        long piece_size = torrent.getPieceLength();
        long target_start = (long)piece_number * piece_size + (long)offset;
        long target_end = target_start + length;
        long pos = 0L;
        long result = 0L;
        for (int i = 0; i < files.length; ++i) {
            TOTorrentFile tf = files[i];
            long len = tf.getLength();
            long this_start = pos;
            long this_end = pos += len;
            if (this_end <= target_start) continue;
            if (target_end <= this_start) break;
            long bit_start = target_start > this_start ? target_start : this_start;
            long bit_end = target_end < this_end ? target_end : this_end;
            CacheFileWithCache cache_file = (CacheFileWithCache)map.get(tf);
            if (cache_file == null) continue;
            result += cache_file.getBytesInCache(bit_start - this_start, bit_end - bit_start);
        }
        return result;
    }

    protected void rethrow(CacheFile file, FMFileManagerException e) throws CacheFileManagerException {
        Throwable cause = e.getCause();
        if (cause != null) {
            throw new CacheFileManagerException(file, e.getMessage(), cause);
        }
        throw new CacheFileManagerException(file, e.getMessage(), e);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void generate(IndentWriter writer) {
        writer.println("Cache Manager");
        try {
            writer.indent();
            try {
                this.this_mon.enter();
                writer.println("Entries = " + this.cache_entries.size());
                Iterator it = this.cache_entries.keySet().iterator();
                HashSet<CacheFileWithCache> files = new HashSet<CacheFileWithCache>();
                while (it.hasNext()) {
                    CacheEntry entry2 = (CacheEntry)it.next();
                    CacheFileWithCache file = entry2.getFile();
                    if (files.contains(file)) continue;
                    files.add(file);
                    writer.println("File:" + file.getName() + ", access = " + file.getAccessMode());
                }
            }
            finally {
                this.this_mon.exit();
            }
        }
        finally {
            writer.exdent();
        }
    }

    public void setFileLinks(TOTorrent torrent, Map links) {
        this.file_manager.setFileLinks(torrent, links);
    }
}

