/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.browser;

import org.eclipse.swt.browser.Browser;
import org.eclipse.swt.internal.Converter;
import org.eclipse.swt.internal.gtk.OS;
import org.eclipse.swt.internal.mozilla.XPCOM;
import org.eclipse.swt.internal.mozilla.XPCOMObject;
import org.eclipse.swt.internal.mozilla.nsEmbedString;
import org.eclipse.swt.internal.mozilla.nsID;
import org.eclipse.swt.internal.mozilla.nsIFilePicker;
import org.eclipse.swt.internal.mozilla.nsILocalFile;
import org.eclipse.swt.internal.mozilla.nsISupports;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Shell;

class FilePicker {
    XPCOMObject supports;
    XPCOMObject filePicker;
    int refCount = 0;
    int mode;
    long parentHandle;
    String[] files;
    String[] masks;
    String defaultFilename;
    String directory;
    String title;
    static final String SEPARATOR = System.getProperty("file.separator");

    public FilePicker() {
        this.createCOMInterfaces();
    }

    int AddRef() {
        ++this.refCount;
        return this.refCount;
    }

    void createCOMInterfaces() {
        int[] nArray = new int[3];
        nArray[0] = 2;
        this.supports = new XPCOMObject(nArray){

            public long method0(long[] args) {
                return FilePicker.this.queryInterface(args[0], args[1]);
            }

            public long method1(long[] args) {
                return FilePicker.this.AddRef();
            }

            public long method2(long[] args) {
                return FilePicker.this.Release();
            }
        };
        int[] nArray2 = new int[18];
        nArray2[0] = 2;
        nArray2[3] = 3;
        nArray2[4] = 1;
        nArray2[5] = 2;
        nArray2[6] = 1;
        nArray2[7] = 1;
        nArray2[8] = 1;
        nArray2[9] = 1;
        nArray2[10] = 1;
        nArray2[11] = 1;
        nArray2[12] = 1;
        nArray2[13] = 1;
        nArray2[14] = 1;
        nArray2[15] = 1;
        nArray2[16] = 1;
        nArray2[17] = 1;
        this.filePicker = new XPCOMObject(nArray2){

            public long method0(long[] args) {
                return FilePicker.this.queryInterface(args[0], args[1]);
            }

            public long method1(long[] args) {
                return FilePicker.this.AddRef();
            }

            public long method2(long[] args) {
                return FilePicker.this.Release();
            }

            public long method3(long[] args) {
                return FilePicker.this.Init(args[0], args[1], args[2]);
            }

            public long method4(long[] args) {
                return FilePicker.this.AppendFilters(args[0]);
            }

            public long method5(long[] args) {
                return FilePicker.this.AppendFilter(args[0], args[1]);
            }

            public long method6(long[] args) {
                return FilePicker.this.GetDefaultString(args[0]);
            }

            public long method7(long[] args) {
                return FilePicker.this.SetDefaultString(args[0]);
            }

            public long method8(long[] args) {
                return FilePicker.this.GetDefaultExtension(args[0]);
            }

            public long method9(long[] args) {
                return FilePicker.this.SetDefaultExtension(args[0]);
            }

            public long method10(long[] args) {
                return FilePicker.this.GetFilterIndex(args[0]);
            }

            public long method11(long[] args) {
                return FilePicker.this.SetFilterIndex(args[0]);
            }

            public long method12(long[] args) {
                return FilePicker.this.GetDisplayDirectory(args[0]);
            }

            public long method13(long[] args) {
                return FilePicker.this.SetDisplayDirectory(args[0]);
            }

            public long method14(long[] args) {
                return FilePicker.this.GetFile(args[0]);
            }

            public long method15(long[] args) {
                return FilePicker.this.GetFileURL(args[0]);
            }

            public long method16(long[] args) {
                return FilePicker.this.GetFiles(args[0]);
            }

            public long method17(long[] args) {
                return FilePicker.this.Show(args[0]);
            }
        };
    }

    void disposeCOMInterfaces() {
        if (this.supports != null) {
            this.supports.dispose();
            this.supports = null;
        }
        if (this.filePicker != null) {
            this.filePicker.dispose();
            this.filePicker = null;
        }
    }

    long getAddress() {
        return this.filePicker.getAddress();
    }

    long queryInterface(long riid, long ppvObject) {
        if (riid == 0L || ppvObject == 0L) {
            return -2147467262L;
        }
        nsID guid = new nsID();
        XPCOM.memmove(guid, riid, 16);
        if (guid.Equals(nsISupports.NS_ISUPPORTS_IID)) {
            XPCOM.memmove(ppvObject, new long[]{this.supports.getAddress()}, OS.PTR_SIZEOF);
            this.AddRef();
            return 0L;
        }
        if (guid.Equals(nsIFilePicker.NS_IFILEPICKER_IID)) {
            XPCOM.memmove(ppvObject, new long[]{this.filePicker.getAddress()}, OS.PTR_SIZEOF);
            this.AddRef();
            return 0L;
        }
        XPCOM.memmove(ppvObject, new long[1], OS.PTR_SIZEOF);
        return -2147467262L;
    }

    int Release() {
        --this.refCount;
        if (this.refCount == 0) {
            this.disposeCOMInterfaces();
        }
        return this.refCount;
    }

    long Init(long parent, long title, long mode) {
        this.parentHandle = parent;
        this.mode = (int)mode;
        if (title != 0L) {
            int length = XPCOM.strlen_PRUnichar(title);
            char[] chars = new char[length];
            XPCOM.memmove(chars, title, length * 2);
            this.title = new String(chars);
        }
        return 0L;
    }

    long Show(long _retval) {
        int style;
        if (this.mode == 2) {
            int result = this.showDirectoryPicker();
            XPCOM.memmove(_retval, new long[]{result}, OS.PTR_SIZEOF);
            return 0L;
        }
        int n = style = this.mode == 1 ? 8192 : 4096;
        if (this.mode == 3) {
            style |= 2;
        }
        Shell parent = this.parentHandle != 0L ? Shell.gtk_new(Display.getCurrent(), this.parentHandle) : new Shell(Display.getCurrent());
        FileDialog dialog = new FileDialog(parent, style);
        if (this.title != null) {
            dialog.setText(this.title);
        }
        if (this.directory != null) {
            dialog.setFilterPath(this.directory);
        }
        if (this.masks != null) {
            dialog.setFilterExtensions(this.masks);
        }
        if (this.defaultFilename != null) {
            dialog.setFileName(this.defaultFilename);
        }
        String filename = dialog.open();
        this.files = dialog.getFileNames();
        this.directory = dialog.getFilterPath();
        this.defaultFilename = null;
        this.title = null;
        this.masks = null;
        int result = filename == null ? 1 : 0;
        XPCOM.memmove(_retval, new long[]{result}, OS.PTR_SIZEOF);
        return 0L;
    }

    int showDirectoryPicker() {
        Shell parent = this.parentHandle != 0L ? Shell.gtk_new(Display.getCurrent(), this.parentHandle) : new Shell(Display.getCurrent());
        DirectoryDialog dialog = new DirectoryDialog(parent, 0);
        if (this.title != null) {
            dialog.setText(this.title);
        }
        if (this.directory != null) {
            dialog.setFilterPath(this.directory);
        }
        this.directory = dialog.open();
        this.defaultFilename = null;
        this.title = null;
        this.masks = null;
        this.files = null;
        return this.directory == null ? 1 : 0;
    }

    long GetFiles(long aFiles) {
        return -2147467263L;
    }

    long GetFileURL(long aFileURL) {
        return -2147467263L;
    }

    long GetFile(long aFile) {
        String filename = "";
        if (this.directory != null) {
            filename = String.valueOf(filename) + this.directory + SEPARATOR;
        }
        if (this.files != null && this.files.length > 0) {
            filename = String.valueOf(filename) + this.files[0];
        }
        nsEmbedString path = new nsEmbedString(filename);
        long[] file = new long[1];
        int rc = XPCOM.NS_NewLocalFile(path.getAddress(), true, file);
        path.dispose();
        if (rc != 0) {
            Browser.error(rc);
        }
        if (file[0] == 0L) {
            Browser.error(-2147467261);
        }
        XPCOM.memmove(aFile, file, OS.PTR_SIZEOF);
        return 0L;
    }

    long SetDisplayDirectory(long aDisplayDirectory) {
        if (aDisplayDirectory == 0L) {
            return 0L;
        }
        nsILocalFile file = new nsILocalFile(aDisplayDirectory);
        long pathname = XPCOM.nsEmbedCString_new();
        file.GetNativePath(pathname);
        int length = XPCOM.nsEmbedCString_Length(pathname);
        long buffer = XPCOM.nsEmbedCString_get(pathname);
        byte[] bytes = new byte[length];
        XPCOM.memmove(bytes, buffer, length);
        XPCOM.nsEmbedCString_delete(pathname);
        char[] chars = Converter.mbcsToWcs(null, bytes);
        this.directory = new String(chars);
        return 0L;
    }

    long GetDisplayDirectory(long aDisplayDirectory) {
        String directoryName = this.directory != null ? this.directory : "";
        nsEmbedString path = new nsEmbedString(directoryName);
        long[] file = new long[1];
        int rc = XPCOM.NS_NewLocalFile(path.getAddress(), true, file);
        path.dispose();
        if (rc != 0) {
            Browser.error(rc);
        }
        if (file[0] == 0L) {
            Browser.error(-2147467261);
        }
        XPCOM.memmove(aDisplayDirectory, file, OS.PTR_SIZEOF);
        return 0L;
    }

    long SetFilterIndex(long aFilterIndex) {
        return -2147467263L;
    }

    long GetFilterIndex(long aFilterIndex) {
        return -2147467263L;
    }

    long SetDefaultExtension(long aDefaultExtension) {
        return -2147467263L;
    }

    long GetDefaultExtension(long aDefaultExtension) {
        return -2147467263L;
    }

    long SetDefaultString(long aDefaultString) {
        if (aDefaultString == 0L) {
            return 0L;
        }
        int length = XPCOM.strlen_PRUnichar(aDefaultString);
        char[] chars = new char[length];
        XPCOM.memmove(chars, aDefaultString, length * 2);
        this.defaultFilename = new String(chars);
        return 0L;
    }

    long GetDefaultString(long aDefaultString) {
        return -2147467263L;
    }

    long AppendFilter(long title, long filter) {
        return -2147467263L;
    }

    long AppendFilters(long filterMask) {
        String[] addFilters = null;
        switch ((int)filterMask) {
            case 1: 
            case 64: {
                this.masks = null;
                break;
            }
            case 2: {
                addFilters = new String[]{"*.htm;*.html"};
                break;
            }
            case 8: {
                addFilters = new String[]{"*.gif;*.jpeg;*.jpg;*.png"};
                break;
            }
            case 4: {
                addFilters = new String[]{"*.txt"};
                break;
            }
            case 16: {
                addFilters = new String[]{"*.xml"};
                break;
            }
            case 32: {
                addFilters = new String[]{"*.xul"};
            }
        }
        if (this.masks == null) {
            this.masks = addFilters;
        } else if (addFilters != null) {
            String[] newFilters = new String[this.masks.length + addFilters.length];
            System.arraycopy(this.masks, 0, newFilters, 0, this.masks.length);
            System.arraycopy(addFilters, 0, newFilters, this.masks.length, addFilters.length);
            this.masks = newFilters;
        }
        return 0L;
    }
}

