/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.ui.swt.views;

import java.net.URL;
import java.util.List;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.program.Program;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Decorations;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Widget;
import org.gudy.azureus2.core3.config.COConfigurationManager;
import org.gudy.azureus2.core3.config.ParameterListener;
import org.gudy.azureus2.core3.disk.DiskManager;
import org.gudy.azureus2.core3.disk.DiskManagerPiece;
import org.gudy.azureus2.core3.download.DownloadManager;
import org.gudy.azureus2.core3.download.DownloadManagerStats;
import org.gudy.azureus2.core3.internat.MessageText;
import org.gudy.azureus2.core3.peer.PEPeerManager;
import org.gudy.azureus2.core3.torrent.TOTorrent;
import org.gudy.azureus2.core3.torrent.TOTorrentException;
import org.gudy.azureus2.core3.tracker.client.TRTrackerAnnouncer;
import org.gudy.azureus2.core3.tracker.client.TRTrackerScraperResponse;
import org.gudy.azureus2.core3.util.AERunnable;
import org.gudy.azureus2.core3.util.Constants;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.DisplayFormatters;
import org.gudy.azureus2.core3.util.SystemTime;
import org.gudy.azureus2.core3.util.TimeFormatter;
import org.gudy.azureus2.core3.util.TorrentUtils;
import org.gudy.azureus2.ui.swt.Messages;
import org.gudy.azureus2.ui.swt.Utils;
import org.gudy.azureus2.ui.swt.components.BufferedLabel;
import org.gudy.azureus2.ui.swt.components.BufferedTruncatedLabel;
import org.gudy.azureus2.ui.swt.debug.ObfusticateImage;
import org.gudy.azureus2.ui.swt.debug.UIDebugGenerator;
import org.gudy.azureus2.ui.swt.mainwindow.Colors;
import org.gudy.azureus2.ui.swt.mainwindow.Cursors;
import org.gudy.azureus2.ui.swt.maketorrent.MultiTrackerEditor;
import org.gudy.azureus2.ui.swt.maketorrent.TrackerEditorListener;
import org.gudy.azureus2.ui.swt.views.AbstractIView;

public class GeneralView
extends AbstractIView
implements ParameterListener,
ObfusticateImage {
    private Display display;
    private DownloadManager manager = null;
    boolean[] pieces;
    int loopFactor;
    Composite genComposite;
    Composite gFile;
    Canvas piecesImage;
    Image pImage;
    BufferedLabel piecesPercent;
    Canvas availabilityImage;
    Image aImage;
    BufferedLabel availabilityPercent;
    Group gTransfer;
    BufferedLabel timeElapsed;
    BufferedLabel timeRemaining;
    BufferedLabel download;
    BufferedLabel downloadSpeed;
    BufferedLabel upload;
    BufferedLabel uploadSpeed;
    BufferedLabel totalSpeed;
    BufferedLabel ave_completion;
    BufferedLabel seeds;
    BufferedLabel peers;
    Group gInfo;
    BufferedLabel fileName;
    BufferedLabel fileSize;
    BufferedLabel saveIn;
    BufferedLabel hash;
    BufferedTruncatedLabel tracker_status;
    BufferedLabel trackerUpdateIn;
    Menu menuTracker;
    MenuItem itemSelect;
    BufferedTruncatedLabel trackerUrlValue;
    BufferedLabel pieceNumber;
    BufferedLabel pieceSize;
    Control lblComment;
    BufferedLabel creation_date;
    BufferedLabel hashFails;
    BufferedLabel shareRatio;
    Button updateButton;
    private int graphicsUpdate = COConfigurationManager.getIntParameter("Graphics Update");

    public void dataSourceChanged(Object newDataSource) {
        this.manager = newDataSource == null ? null : (newDataSource instanceof Object[] ? (DownloadManager)((Object[])newDataSource)[0] : (DownloadManager)newDataSource);
    }

    public void initialize(Composite composite) {
        if (this.manager == null) {
            return;
        }
        this.pieces = new boolean[this.manager.getNbPieces()];
        this.display = composite.getDisplay();
        this.genComposite = new Canvas(composite, 0);
        GridLayout genLayout = new GridLayout();
        genLayout.marginHeight = 0;
        try {
            genLayout.marginTop = 5;
        }
        catch (NoSuchFieldError e) {
            // empty catch block
        }
        genLayout.marginWidth = 2;
        genLayout.numColumns = 1;
        this.genComposite.setLayout((Layout)genLayout);
        this.gFile = new Composite(this.genComposite, 8);
        GridData gridData = new GridData(768);
        this.gFile.setLayoutData((Object)gridData);
        GridLayout fileLayout = new GridLayout();
        fileLayout.marginHeight = 0;
        fileLayout.marginWidth = 10;
        fileLayout.numColumns = 3;
        this.gFile.setLayout((Layout)fileLayout);
        Label piecesInfo = new Label(this.gFile, 16384);
        Messages.setLanguageText((Widget)piecesInfo, "GeneralView.section.downloaded");
        gridData = new GridData(32);
        piecesInfo.setLayoutData((Object)gridData);
        this.piecesImage = new Canvas(this.gFile, 0);
        gridData = new GridData(768);
        gridData.widthHint = 150;
        gridData.heightHint = 25;
        this.piecesImage.setLayoutData((Object)gridData);
        this.piecesPercent = new BufferedLabel(this.gFile, 131072);
        gridData = new GridData(128);
        gridData.widthHint = 50;
        this.piecesPercent.setLayoutData(gridData);
        Label availabilityInfo = new Label(this.gFile, 16384);
        Messages.setLanguageText((Widget)availabilityInfo, "GeneralView.section.availability");
        gridData = new GridData(32);
        availabilityInfo.setLayoutData((Object)gridData);
        this.availabilityImage = new Canvas(this.gFile, 0);
        gridData = new GridData(768);
        gridData.widthHint = 150;
        gridData.heightHint = 25;
        this.availabilityImage.setLayoutData((Object)gridData);
        Messages.setLanguageText((Widget)this.availabilityImage, "GeneralView.label.status.pieces_available.tooltip");
        this.availabilityPercent = new BufferedLabel(this.gFile, 131072);
        gridData = new GridData(128);
        gridData.widthHint = 50;
        this.availabilityPercent.setLayoutData(gridData);
        Messages.setLanguageText(this.availabilityPercent.getWidget(), "GeneralView.label.status.pieces_available.tooltip");
        this.gTransfer = new Group(this.genComposite, 8);
        Messages.setLanguageText((Widget)this.gTransfer, "GeneralView.section.transfer");
        gridData = new GridData(768);
        this.gTransfer.setLayoutData((Object)gridData);
        GridLayout layoutTransfer = new GridLayout();
        layoutTransfer.numColumns = 6;
        this.gTransfer.setLayout((Layout)layoutTransfer);
        Label label = new Label((Composite)this.gTransfer, 16384);
        Messages.setLanguageText((Widget)label, "GeneralView.label.timeelapsed");
        this.timeElapsed = new BufferedLabel((Composite)this.gTransfer, 16384);
        gridData = new GridData(768);
        this.timeElapsed.setLayoutData(gridData);
        label = new Label((Composite)this.gTransfer, 16384);
        Messages.setLanguageText((Widget)label, "GeneralView.label.remaining");
        this.timeRemaining = new BufferedLabel((Composite)this.gTransfer, 16384);
        gridData = new GridData(768);
        this.timeRemaining.setLayoutData(gridData);
        label = new Label((Composite)this.gTransfer, 16384);
        Messages.setLanguageText((Widget)label, "GeneralView.label.shareRatio");
        this.shareRatio = new BufferedLabel((Composite)this.gTransfer, 16384);
        gridData = new GridData(768);
        this.shareRatio.setLayoutData(gridData);
        label = new Label((Composite)this.gTransfer, 16384);
        Messages.setLanguageText((Widget)label, "GeneralView.label.downloaded");
        this.download = new BufferedLabel((Composite)this.gTransfer, 16384);
        gridData = new GridData(768);
        this.download.setLayoutData(gridData);
        label = new Label((Composite)this.gTransfer, 16384);
        Messages.setLanguageText((Widget)label, "GeneralView.label.downloadspeed");
        this.downloadSpeed = new BufferedLabel((Composite)this.gTransfer, 16384);
        gridData = new GridData(768);
        this.downloadSpeed.setLayoutData(gridData);
        label = new Label((Composite)this.gTransfer, 16384);
        Messages.setLanguageText((Widget)label, "GeneralView.label.hashfails");
        this.hashFails = new BufferedLabel((Composite)this.gTransfer, 16384);
        gridData = new GridData(768);
        this.hashFails.setLayoutData(gridData);
        label = new Label((Composite)this.gTransfer, 16384);
        Messages.setLanguageText((Widget)label, "GeneralView.label.uploaded");
        this.upload = new BufferedLabel((Composite)this.gTransfer, 16384);
        gridData = new GridData(768);
        this.upload.setLayoutData(gridData);
        label = new Label((Composite)this.gTransfer, 16384);
        Messages.setLanguageText((Widget)label, "GeneralView.label.uploadspeed");
        this.uploadSpeed = new BufferedLabel((Composite)this.gTransfer, 16384);
        gridData = new GridData(768);
        gridData.horizontalSpan = 3;
        this.uploadSpeed.setLayoutData(gridData);
        label = new Label((Composite)this.gTransfer, 16384);
        Messages.setLanguageText((Widget)label, "GeneralView.label.seeds");
        this.seeds = new BufferedLabel((Composite)this.gTransfer, 16384);
        gridData = new GridData(768);
        this.seeds.setLayoutData(gridData);
        label = new Label((Composite)this.gTransfer, 16384);
        Messages.setLanguageText((Widget)label, "GeneralView.label.peers");
        this.peers = new BufferedLabel((Composite)this.gTransfer, 16384);
        gridData = new GridData(768);
        gridData.horizontalSpan = 3;
        this.peers.setLayoutData(gridData);
        label = new Label((Composite)this.gTransfer, 16384);
        Messages.setLanguageText((Widget)label, "GeneralView.label.totalspeed");
        this.totalSpeed = new BufferedLabel((Composite)this.gTransfer, 16384);
        gridData = new GridData(768);
        this.totalSpeed.setLayoutData(gridData);
        label = new Label((Composite)this.gTransfer, 16384);
        Messages.setLanguageText((Widget)label, "GeneralView.label.swarm_average_completion");
        this.ave_completion = new BufferedLabel((Composite)this.gTransfer, 16384);
        gridData = new GridData(768);
        gridData.horizontalSpan = 3;
        this.ave_completion.setLayoutData(gridData);
        this.gInfo = new Group(this.genComposite, 8);
        Messages.setLanguageText((Widget)this.gInfo, "GeneralView.section.info");
        gridData = new GridData(1808);
        this.gInfo.setLayoutData((Object)gridData);
        GridLayout layoutInfo = new GridLayout();
        layoutInfo.numColumns = 4;
        this.gInfo.setLayout((Layout)layoutInfo);
        label = new Label((Composite)this.gInfo, 16384);
        Messages.setLanguageText((Widget)label, "GeneralView.label.filename");
        this.fileName = new BufferedLabel((Composite)this.gInfo, 16384);
        gridData = new GridData(768);
        this.fileName.setLayoutData(gridData);
        label = new Label((Composite)this.gInfo, 16384);
        Messages.setLanguageText((Widget)label, "GeneralView.label.totalsize");
        this.fileSize = new BufferedLabel((Composite)this.gInfo, 16384);
        gridData = new GridData(768);
        this.fileSize.setLayoutData(gridData);
        label = new Label((Composite)this.gInfo, 16384);
        Messages.setLanguageText((Widget)label, "GeneralView.label.savein");
        this.saveIn = new BufferedLabel((Composite)this.gInfo, 16384);
        gridData = new GridData(768);
        this.saveIn.setLayoutData(gridData);
        label = new Label((Composite)this.gInfo, 16384);
        Messages.setLanguageText((Widget)label, "GeneralView.label.hash");
        this.hash = new BufferedLabel((Composite)this.gInfo, 16384);
        Messages.setLanguageText(this.hash.getWidget(), "GeneralView.label.hash.tooltip", true);
        gridData = new GridData(768);
        this.hash.setLayoutData(gridData);
        this.hash.setCursor(Cursors.handCursor);
        this.hash.setForeground(Colors.blue);
        label.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDoubleClick(MouseEvent arg0) {
                String hash_str = GeneralView.this.hash.getText();
                if (hash_str != null && hash_str.length() != 0) {
                    new Clipboard(GeneralView.this.display).setContents(new Object[]{hash_str.replaceAll(" ", "")}, new Transfer[]{TextTransfer.getInstance()});
                }
            }

            public void mouseDown(MouseEvent arg0) {
                String hash_str = GeneralView.this.hash.getText();
                if (hash_str != null && hash_str.length() != 0) {
                    new Clipboard(GeneralView.this.display).setContents(new Object[]{hash_str.replaceAll(" ", "")}, new Transfer[]{TextTransfer.getInstance()});
                }
            }
        });
        this.hash.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDoubleClick(MouseEvent arg0) {
                String hash_str = GeneralView.this.hash.getText();
                if (hash_str != null && hash_str.length() != 0) {
                    new Clipboard(GeneralView.this.display).setContents(new Object[]{hash_str.replaceAll(" ", "")}, new Transfer[]{TextTransfer.getInstance()});
                }
            }

            public void mouseDown(MouseEvent arg0) {
                String hash_str = GeneralView.this.hash.getText();
                if (hash_str != null && hash_str.length() != 0) {
                    new Clipboard(GeneralView.this.display).setContents(new Object[]{hash_str.replaceAll(" ", "")}, new Transfer[]{TextTransfer.getInstance()});
                }
            }
        });
        label = new Label((Composite)this.gInfo, 16384);
        Messages.setLanguageText((Widget)label, "GeneralView.label.numberofpieces");
        this.pieceNumber = new BufferedLabel((Composite)this.gInfo, 16384);
        gridData = new GridData(768);
        this.pieceNumber.setLayoutData(gridData);
        label = new Label((Composite)this.gInfo, 16384);
        Messages.setLanguageText((Widget)label, "GeneralView.label.size");
        this.pieceSize = new BufferedLabel((Composite)this.gInfo, 16384);
        gridData = new GridData(768);
        this.pieceSize.setLayoutData(gridData);
        label = new Label((Composite)this.gInfo, 16384);
        Messages.setLanguageText((Widget)label, "GeneralView.label.trackerurl");
        label.setCursor(Cursors.handCursor);
        label.setForeground(Colors.blue);
        label.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDoubleClick(MouseEvent arg0) {
                String announce = GeneralView.this.trackerUrlValue.getText();
                if (announce != null && announce.length() != 0) {
                    new Clipboard(GeneralView.this.display).setContents(new Object[]{announce}, new Transfer[]{TextTransfer.getInstance()});
                }
            }

            public void mouseDown(MouseEvent arg0) {
                String announce = GeneralView.this.trackerUrlValue.getText();
                if (announce != null && announce.length() != 0) {
                    new Clipboard(GeneralView.this.display).setContents(new Object[]{announce}, new Transfer[]{TextTransfer.getInstance()});
                }
            }
        });
        this.menuTracker = new Menu((Decorations)this.genComposite.getShell(), 8);
        this.itemSelect = new MenuItem(this.menuTracker, 64);
        Messages.setLanguageText((Widget)this.itemSelect, "GeneralView.menu.selectTracker");
        MenuItem itemEdit = new MenuItem(this.menuTracker, 0);
        Messages.setLanguageText((Widget)itemEdit, "MyTorrentsView.menu.editTracker");
        itemEdit.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                final TOTorrent torrent = GeneralView.this.manager.getTorrent();
                if (torrent == null) {
                    return;
                }
                List group = TorrentUtils.announceGroupsToList(torrent);
                new MultiTrackerEditor(null, group, new TrackerEditorListener(){

                    public void trackersChanged(String str, String str2, List _group) {
                        TorrentUtils.listToAnnounceGroups(_group, torrent);
                        try {
                            TorrentUtils.writeToFile(torrent);
                        }
                        catch (Throwable e2) {
                            Debug.printStackTrace(e2);
                        }
                        TRTrackerAnnouncer tc = GeneralView.this.manager.getTrackerClient();
                        if (tc != null) {
                            tc.resetTrackerUrl(true);
                        }
                    }
                }, true);
            }
        });
        final Listener menuListener = new Listener(){

            public void handleEvent(Event e) {
                if (e.widget instanceof MenuItem) {
                    String text = ((MenuItem)e.widget).getText();
                    TOTorrent torrent = GeneralView.this.manager.getTorrent();
                    TorrentUtils.announceGroupsSetFirst(torrent, text);
                    try {
                        TorrentUtils.writeToFile(torrent);
                    }
                    catch (TOTorrentException f) {
                        Debug.printStackTrace(f);
                    }
                    TRTrackerAnnouncer tc = GeneralView.this.manager.getTrackerClient();
                    if (tc != null) {
                        tc.resetTrackerUrl(false);
                    }
                }
            }
        };
        this.menuTracker.addListener(22, new Listener(){

            public void handleEvent(Event e) {
                Menu menuSelect = GeneralView.this.itemSelect.getMenu();
                if (menuSelect != null && !menuSelect.isDisposed()) {
                    menuSelect.dispose();
                }
                if (GeneralView.this.manager == null || GeneralView.this.genComposite == null || GeneralView.this.genComposite.isDisposed()) {
                    return;
                }
                List groups = TorrentUtils.announceGroupsToList(GeneralView.this.manager.getTorrent());
                menuSelect = new Menu((Decorations)GeneralView.this.genComposite.getShell(), 4);
                GeneralView.this.itemSelect.setMenu(menuSelect);
                for (List trackers : groups) {
                    MenuItem menuItem = new MenuItem(menuSelect, 64);
                    Messages.setLanguageText((Widget)menuItem, "wizard.multitracker.group");
                    Menu menu = new Menu((Decorations)GeneralView.this.genComposite.getShell(), 4);
                    menuItem.setMenu(menu);
                    for (String url : trackers) {
                        MenuItem menuItemTracker = new MenuItem(menu, 64);
                        menuItemTracker.setText(url);
                        menuItemTracker.addListener(13, menuListener);
                    }
                }
            }
        });
        this.trackerUrlValue = new BufferedTruncatedLabel((Composite)this.gInfo, 16384, 70);
        this.trackerUrlValue.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDown(MouseEvent event2) {
                String url;
                if (event2.button == 3 || event2.button == 1 && event2.stateMask == 262144) {
                    GeneralView.this.menuTracker.setVisible(true);
                } else if (event2.button == 1 && ((url = GeneralView.this.trackerUrlValue.getText()).startsWith("http://") || url.startsWith("https://"))) {
                    int pos = -1;
                    pos = url.indexOf("/announce");
                    if (pos != -1) {
                        url = url.substring(0, pos + 1);
                    }
                    Program.launch((String)url);
                }
            }
        });
        label = new Label((Composite)this.gInfo, 16384);
        Messages.setLanguageText((Widget)label, "GeneralView.label.creationdate");
        this.creation_date = new BufferedLabel((Composite)this.gInfo, 16384);
        gridData = new GridData(768);
        gridData.horizontalSpan = 1;
        this.creation_date.setLayoutData(gridData);
        gridData = new GridData(768);
        gridData.horizontalSpan = 1;
        this.trackerUrlValue.setLayoutData(gridData);
        label = new Label((Composite)this.gInfo, 16384);
        Messages.setLanguageText((Widget)label, "GeneralView.label.tracker");
        this.tracker_status = new BufferedTruncatedLabel((Composite)this.gInfo, 16384, 150);
        gridData = new GridData(768);
        gridData.horizontalSpan = 3;
        this.tracker_status.setLayoutData(gridData);
        label = new Label((Composite)this.gInfo, 16384);
        Messages.setLanguageText((Widget)label, "GeneralView.label.updatein");
        this.trackerUpdateIn = new BufferedLabel((Composite)this.gInfo, 16384);
        gridData = new GridData(768);
        this.trackerUpdateIn.setLayoutData(gridData);
        this.updateButton = new Button((Composite)this.gInfo, 8);
        Messages.setLanguageText((Widget)this.updateButton, "GeneralView.label.trackerurlupdate");
        gridData = new GridData(64);
        this.updateButton.setLayoutData((Object)gridData);
        this.updateButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event2) {
                GeneralView.this.manager.requestTrackerAnnounce(false);
            }
        });
        label = new Label((Composite)this.gInfo, 16384);
        label = new Label((Composite)this.gInfo, 16384);
        gridData = new GridData(2);
        label.setLayoutData((Object)gridData);
        Messages.setLanguageText((Widget)label, "GeneralView.label.comment");
        try {
            this.lblComment = new Link((Composite)this.gInfo, 16448);
            ((Link)this.lblComment).addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    Program.launch((String)e.text);
                }
            });
        }
        catch (Throwable e) {
            this.lblComment = new Label((Composite)this.gInfo, 16448);
        }
        gridData = new GridData(1808);
        gridData.horizontalSpan = 3;
        this.lblComment.setLayoutData((Object)gridData);
        this.piecesImage.addListener(9, new Listener(){

            public void handleEvent(Event e) {
                if (e.count == 0 && e.width > 0 && e.height > 0) {
                    GeneralView.this.updatePiecesInfo(true);
                }
            }
        });
        this.availabilityImage.addListener(9, new Listener(){

            public void handleEvent(Event e) {
                if (e.count == 0 && e.width > 0 && e.height > 0) {
                    GeneralView.this.updateAvailability();
                }
            }
        });
        if (Constants.isOSX) {
            Shell shell = this.genComposite.getShell();
            Point size = shell.getSize();
            shell.setSize(size.x - 1, size.y - 1);
            shell.setSize(size);
        }
        this.genComposite.layout();
        COConfigurationManager.addParameterListener("Graphics Update", this);
    }

    public Composite getComposite() {
        return this.genComposite;
    }

    public void refresh() {
        int comp;
        String remaining;
        if (this.getComposite() == null || this.getComposite().isDisposed() || this.manager == null) {
            return;
        }
        ++this.loopFactor;
        if (this.loopFactor % this.graphicsUpdate == 0) {
            this.updateAvailability();
            this.updatePiecesInfo(false);
        }
        DiskManager dm = this.manager.getDiskManager();
        String eta = DisplayFormatters.formatETA(this.manager.getStats().getETA());
        if (dm != null) {
            long rem = dm.getRemainingExcludingDND();
            String data_rem = DisplayFormatters.formatByteCountToKiBEtc(rem);
            remaining = rem > 0L ? eta + (eta.length() == 0 ? "" : " ") + data_rem : (eta.length() == 0 ? data_rem : eta);
        } else {
            remaining = eta;
        }
        this.setTime(this.manager.getStats().getElapsedTime(), remaining);
        TRTrackerScraperResponse hd = this.manager.getTrackerScrapeResponse();
        String seeds_str = this.manager.getNbSeeds() + " " + MessageText.getString("GeneralView.label.connected");
        String peers_str = this.manager.getNbPeers() + " " + MessageText.getString("GeneralView.label.connected");
        if (hd != null && hd.isValid()) {
            seeds_str = seeds_str + " ( " + hd.getSeeds() + " " + MessageText.getString("GeneralView.label.in_swarm") + " )";
            peers_str = peers_str + " ( " + hd.getPeers() + " " + MessageText.getString("GeneralView.label.in_swarm") + " )";
        }
        String _shareRatio = "";
        int sr = this.manager.getStats().getShareRatio();
        if (sr == -1) {
            _shareRatio = "\u221e";
        }
        if (sr > 0) {
            String partial = "" + sr % 1000;
            while (partial.length() < 3) {
                partial = "0" + partial;
            }
            _shareRatio = sr / 1000 + "." + partial;
        }
        DownloadManagerStats stats = this.manager.getStats();
        String swarm_speed = DisplayFormatters.formatByteCountToKiBEtcPerSec(stats.getTotalAverage()) + " ( " + DisplayFormatters.formatByteCountToKiBEtcPerSec(stats.getTotalAveragePerPeer()) + " " + MessageText.getString("GeneralView.label.averagespeed") + " )";
        String swarm_completion = "";
        PEPeerManager pm = this.manager.getPeerManager();
        if (pm != null && (comp = pm.getAverageCompletionInThousandNotation()) >= 0) {
            swarm_completion = DisplayFormatters.formatPercentFromThousands(comp);
        }
        this.setStats(DisplayFormatters.formatDownloaded(stats), DisplayFormatters.formatByteCountToKiBEtc(stats.getTotalDataBytesSent()), DisplayFormatters.formatByteCountToKiBEtcPerSec(stats.getDataReceiveRate()), DisplayFormatters.formatByteCountToKiBEtcPerSec(stats.getDataSendRate()), swarm_speed, "" + this.manager.getStats().getDownloadRateLimitBytesPerSecond() / 1024, "" + this.manager.getStats().getUploadRateLimitBytesPerSecond() / 1024, seeds_str, peers_str, DisplayFormatters.formatHashFails(this.manager), _shareRatio, swarm_completion);
        this.setTracker(this.manager);
        TOTorrent torrent = this.manager.getTorrent();
        this.setInfos(this.manager.getDisplayName(), DisplayFormatters.formatByteCountToKiBEtc(this.manager.getSize()), this.manager.getSaveLocation().toString(), TorrentUtils.nicePrintTorrentHash(torrent), this.manager.getNbPieces(), this.manager.getPieceLength(), this.manager.getTorrentComment(), DisplayFormatters.formatDate(this.manager.getTorrentCreationDate() * 1000L));
        if (this.loopFactor == 2) {
            this.getComposite().layout(true);
        }
    }

    public void delete() {
        if (this.aImage != null) {
            this.aImage.dispose();
        }
        this.aImage = null;
        if (this.pImage != null) {
            this.pImage.dispose();
        }
        this.pImage = null;
        Utils.disposeComposite(this.genComposite);
        COConfigurationManager.removeParameterListener("Graphics Update", this);
    }

    public String getData() {
        return "GeneralView.title.short";
    }

    public String getFullTitle() {
        return MessageText.getString("GeneralView.title.full");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateAvailability() {
        if (this.manager == null) {
            return;
        }
        try {
            int[] available;
            this.this_mon.enter();
            PEPeerManager pm = this.manager.getPeerManager();
            if (this.manager.getPeerManager() == null) {
                if (this.availabilityPercent.getText() != "") {
                    this.availabilityPercent.setText("");
                }
                available = new int[this.manager.getNbPieces()];
            } else {
                available = pm.getAvailability();
            }
            if (this.display == null || this.display.isDisposed()) {
                return;
            }
            if (this.availabilityImage == null || this.availabilityImage.isDisposed()) {
                return;
            }
            Rectangle bounds = this.availabilityImage.getClientArea();
            int xMax = bounds.width - 2;
            int yMax = bounds.height - 2;
            if (xMax < 10 || yMax < 5) {
                return;
            }
            if (this.aImage != null && !this.aImage.isDisposed()) {
                this.aImage.dispose();
            }
            this.aImage = new Image((Device)this.display, bounds.width, bounds.height);
            GC gc = new GC((Drawable)this.availabilityImage);
            GC gcImage = new GC((Drawable)this.aImage);
            try {
                gcImage.setForeground(Colors.grey);
                gcImage.drawRectangle(0, 0, bounds.width - 1, bounds.height - 1);
                int allMin = 0;
                int allMax = 0;
                int total = 0;
                String sTotal = "000";
                if (available != null) {
                    allMin = available.length == 0 ? 0 : available[0];
                    allMax = available.length == 0 ? 0 : available[0];
                    int nbPieces = available.length;
                    for (int i = 0; i < nbPieces; ++i) {
                        if (available[i] < allMin) {
                            allMin = available[i];
                        }
                        if (available[i] <= allMax) continue;
                        allMax = available[i];
                    }
                    int maxAboveMin = allMax - allMin;
                    if (maxAboveMin == 0) {
                        gcImage.setBackground(Colors.blues[allMin == 0 ? 0 : 9]);
                        gcImage.fillRectangle(1, 1, xMax, yMax);
                    } else {
                        int i;
                        for (i = 0; i < nbPieces; ++i) {
                            if (available[i] <= allMin) continue;
                            ++total;
                        }
                        total = total * 1000 / nbPieces;
                        sTotal = "" + total;
                        if (total < 10) {
                            sTotal = "0" + sTotal;
                        }
                        if (total < 100) {
                            sTotal = "0" + sTotal;
                        }
                        for (i = 0; i < xMax; ++i) {
                            int index;
                            int a1 = (i + 1) * nbPieces / xMax;
                            int a0 = i * nbPieces / xMax;
                            if (a1 == a0) {
                                ++a1;
                            }
                            if (a1 > nbPieces) {
                                a1 = nbPieces;
                            }
                            int max = 0;
                            int min = available[a0];
                            int Pi = 1000;
                            for (int j = a0; j < a1; ++j) {
                                if (available[j] > max) {
                                    max = available[j];
                                }
                                if (available[j] < min) {
                                    min = available[j];
                                }
                                Pi *= available[j];
                                Pi /= available[j] + 1;
                            }
                            int pond = Pi;
                            if (max == 0) {
                                pond = 0;
                            } else {
                                int PiM = 1000;
                                for (int j = a0; j < a1; ++j) {
                                    PiM *= max + 1;
                                    PiM /= max;
                                }
                                pond *= PiM;
                                pond /= 1000;
                                pond *= max - min;
                                pond /= 1000;
                                pond += min;
                            }
                            if (pond <= 0 || allMax == 0) {
                                index = 0;
                            } else {
                                index = (pond - allMin) * 8 / maxAboveMin + 1;
                                if (index > 9) {
                                    index = 9;
                                }
                            }
                            gcImage.setBackground(Colors.blues[index]);
                            gcImage.fillRectangle(i + 1, 1, 1, yMax);
                        }
                    }
                }
                if (this.availabilityPercent == null || this.availabilityPercent.isDisposed()) {
                    return;
                }
                this.availabilityPercent.setText(allMin + "." + sTotal);
                gc.drawImage(this.aImage, bounds.x, bounds.y);
            }
            finally {
                gcImage.dispose();
                gc.dispose();
            }
        }
        finally {
            this.this_mon.exit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updatePiecesInfo(boolean bForce) {
        block29: {
            if (this.manager == null) {
                return;
            }
            try {
                this.this_mon.enter();
                if (this.display == null || this.display.isDisposed()) {
                    return;
                }
                if (this.piecesImage == null || this.piecesImage.isDisposed()) {
                    return;
                }
                DiskManager dm = this.manager.getDiskManager();
                boolean valid = !bForce;
                boolean[] new_pieces = new boolean[this.manager.getNbPieces()];
                if (dm != null) {
                    DiskManagerPiece[] dm_pieces = dm.getPieces();
                    for (int i = 0; i < this.pieces.length; ++i) {
                        new_pieces[i] = dm_pieces[i].isDone();
                    }
                }
                if (this.pieces == null) {
                    valid = false;
                } else {
                    for (int i = 0; i < this.pieces.length; ++i) {
                        if (this.pieces[i] == new_pieces[i]) continue;
                        valid = false;
                        break;
                    }
                }
                this.pieces = new_pieces;
                if (valid) break block29;
                Rectangle bounds = this.piecesImage.getClientArea();
                int xMax = bounds.width - 2;
                int yMax = bounds.height - 2 - 6;
                if (xMax < 10 || yMax < 5) {
                    return;
                }
                int total = this.manager.getStats().getDownloadCompleted(true);
                if (this.pImage != null && !this.pImage.isDisposed()) {
                    this.pImage.dispose();
                }
                this.pImage = new Image((Device)this.display, bounds.width, bounds.height);
                GC gcImage = new GC((Drawable)this.pImage);
                try {
                    gcImage.setForeground(Colors.grey);
                    gcImage.drawRectangle(0, 0, bounds.width - 1, bounds.height - 1);
                    gcImage.drawLine(1, 6, xMax, 6);
                    if (this.pieces != null && this.pieces.length != 0) {
                        int nbPieces = this.pieces.length;
                        for (int i = 0; i < xMax; ++i) {
                            int a1 = (i + 1) * nbPieces / xMax;
                            int a0 = i * nbPieces / xMax;
                            if (a1 == a0) {
                                ++a1;
                            }
                            if (a1 > nbPieces) {
                                a1 = nbPieces;
                            }
                            int nbAvailable = 0;
                            for (int j = a0; j < a1; ++j) {
                                if (this.pieces[j]) {
                                    ++nbAvailable;
                                }
                                int index = nbAvailable * 9 / (a1 - a0);
                                gcImage.setBackground(Colors.blues[index]);
                                gcImage.fillRectangle(i + 1, 7, 1, yMax);
                            }
                        }
                    }
                    int limit = xMax * total / 1000;
                    gcImage.setBackground(Colors.colorProgressBar);
                    gcImage.fillRectangle(1, 1, limit, 5);
                    if (limit < xMax) {
                        gcImage.setBackground(Colors.blues[0]);
                        gcImage.fillRectangle(limit + 1, 1, xMax - limit, 5);
                    }
                }
                finally {
                    gcImage.dispose();
                }
                if (this.piecesPercent != null && !this.piecesPercent.isDisposed()) {
                    this.piecesPercent.setText(DisplayFormatters.formatPercentFromThousands(total));
                }
                if (this.pImage == null || this.pImage.isDisposed()) {
                    return;
                }
                GC gc = new GC((Drawable)this.piecesImage);
                gc.drawImage(this.pImage, bounds.x, bounds.y);
                gc.dispose();
            }
            finally {
                this.this_mon.exit();
            }
        }
    }

    private void setTime(String elapsed, String remaining) {
        this.timeElapsed.setText(elapsed);
        this.timeRemaining.setText(remaining);
    }

    private void setStats(String dl, String ul, String dls, String uls, String ts, String dl_speed, String ul_speed, String s, String p, String hash_fails, String share_ratio, String ave_comp) {
        if (this.display == null || this.display.isDisposed()) {
            return;
        }
        this.download.setText(dl);
        this.downloadSpeed.setText(dls);
        this.upload.setText(ul);
        this.uploadSpeed.setText(uls);
        this.totalSpeed.setText(ts);
        this.ave_completion.setText(ave_comp);
        this.seeds.setText(s);
        this.peers.setText(p);
        this.hashFails.setText(hash_fails);
        this.shareRatio.setText(share_ratio);
    }

    private void setTracker(DownloadManager _manager) {
        TOTorrent torrent;
        URL temp;
        if (this.display == null || this.display.isDisposed()) {
            return;
        }
        String status = _manager.getTrackerStatus();
        int time = _manager.getTrackerTime();
        TRTrackerAnnouncer trackerClient = _manager.getTrackerClient();
        this.tracker_status.setText(status);
        if (time < 0) {
            this.trackerUpdateIn.setText(MessageText.getString("GeneralView.label.updatein.querying"));
        } else {
            this.trackerUpdateIn.setText(TimeFormatter.formatColon(time));
        }
        String trackerURL = null;
        if (trackerClient != null && (temp = trackerClient.getTrackerUrl()) != null) {
            trackerURL = temp.toString();
        }
        if (trackerURL == null && (torrent = _manager.getTorrent()) != null) {
            trackerURL = torrent.getAnnounceURL().toString();
        }
        if (trackerURL != null) {
            this.trackerUrlValue.setText(trackerURL);
            if (trackerURL.startsWith("http://") || trackerURL.startsWith("https://")) {
                this.trackerUrlValue.setForeground(Colors.blue);
                this.trackerUrlValue.setCursor(Cursors.handCursor);
                Messages.setLanguageText(this.trackerUrlValue.getWidget(), "GeneralView.label.trackerurlopen.tooltip", true);
            } else {
                this.trackerUrlValue.setForeground(null);
                this.trackerUrlValue.setCursor(null);
                Messages.setLanguageText(this.trackerUrlValue.getWidget(), null);
                this.trackerUrlValue.setToolTipText(null);
            }
        }
        boolean update_state = trackerClient != null ? SystemTime.getCurrentTime() / 1000L - (long)trackerClient.getLastUpdateTime() >= 60L : false;
        if (this.updateButton.getEnabled() != update_state) {
            this.updateButton.setEnabled(update_state);
        }
    }

    private void setInfos(final String _fileName, final String _fileSize, final String _path, final String _hash, final int _pieceNumber, final String _pieceLength, final String _comment, final String _creation_date) {
        if (this.display == null || this.display.isDisposed()) {
            return;
        }
        Utils.execSWTThread(new AERunnable(){

            public void runSupport() {
                GeneralView.this.fileName.setText(_fileName);
                GeneralView.this.fileSize.setText(_fileSize);
                GeneralView.this.saveIn.setText(_path);
                GeneralView.this.hash.setText(_hash);
                GeneralView.this.pieceNumber.setText("" + _pieceNumber);
                GeneralView.this.pieceSize.setText(_pieceLength);
                String sOldComment = (String)GeneralView.this.lblComment.getData("comment");
                if (!_comment.equals(sOldComment)) {
                    if (GeneralView.this.lblComment instanceof Label) {
                        ((Label)GeneralView.this.lblComment).setText(_comment);
                    } else if (GeneralView.this.lblComment instanceof Link) {
                        String sNewComment = _comment.replaceAll("([^=\">][\\s]+|^)(http://[\\S]+)", "$1<A HREF=\"$2\">$2</A>");
                        sNewComment = sNewComment.replaceAll("(href=)(htt[^\\s>]+)", "$1\"$2\"");
                        ((Link)GeneralView.this.lblComment).setText(sNewComment);
                    }
                }
                GeneralView.this.creation_date.setText(_creation_date);
            }
        });
    }

    public void parameterChanged(String parameterName) {
        this.graphicsUpdate = COConfigurationManager.getIntParameter("Graphics Update");
    }

    public Image obfusticatedImage(Image image, Point shellOffset) {
        UIDebugGenerator.obfusticateArea(image, (Control)this.fileName.getWidget(), shellOffset, this.manager.toString());
        UIDebugGenerator.obfusticateArea(image, (Control)this.saveIn.getWidget(), shellOffset, Debug.secretFileName(this.saveIn.getText()));
        return image;
    }
}

