/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.ui.swt.osx;

import com.aelitis.azureus.core.AzureusCoreFactory;
import com.aelitis.azureus.ui.UIFunctions;
import com.aelitis.azureus.ui.UIFunctionsManager;
import java.io.IOException;
import org.eclipse.swt.internal.Callback;
import org.eclipse.swt.internal.carbon.AEDesc;
import org.eclipse.swt.internal.carbon.CFRange;
import org.eclipse.swt.internal.carbon.EventRecord;
import org.eclipse.swt.internal.carbon.HICommand;
import org.eclipse.swt.internal.carbon.OS;
import org.eclipse.swt.program.Program;
import org.eclipse.swt.widgets.Display;
import org.gudy.azureus2.core3.internat.MessageText;
import org.gudy.azureus2.core3.peer.TyrantStats;
import org.gudy.azureus2.core3.util.AERunnable;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.platform.macosx.access.jnilib.OSXAccess;
import org.gudy.azureus2.ui.swt.config.wizard.ConfigureWizard;
import org.gudy.azureus2.ui.swt.mainwindow.TorrentOpener;
import org.gudy.azureus2.ui.swt.nat.NatTestWindow;

public class CarbonUIEnhancer {
    private static final int kHICommandPreferences = 1886545254;
    private static final int kHICommandAbout = 1633841013;
    private static final int kHICommandServices = 1936028278;
    private static final int kHICommandWizard = 1635410798;
    private static final int kHICommandNatTest = 1635413620;
    private static final int kHICommandRestart = 1635414643;
    private static final int typeAEList = 1818850164;
    private static final int kCoreEventClass = 1634039412;
    private static final int kAEOpenDocuments = 1868853091;
    private static final String RESOURCE_BUNDLE = "org.eclipse.ui.carbon.Messages";
    private static String fgAboutActionName;
    private static String fgWizardActionName;
    private static String fgNatTestActionName;
    private static String fgRestartActionName;
    static final Object target;

    public CarbonUIEnhancer() {
        if (fgAboutActionName == null) {
            fgAboutActionName = MessageText.getString("MainWindow.menu.help.about");
        }
        if (fgWizardActionName == null) {
            fgWizardActionName = MessageText.getString("MainWindow.menu.file.configure").replaceAll("&", "");
        }
        if (fgNatTestActionName == null) {
            fgNatTestActionName = MessageText.getString("MainWindow.menu.tools.nattest").replaceAll("&", "");
        }
        if (fgRestartActionName == null) {
            fgRestartActionName = MessageText.getString("MainWindow.menu.file.restart").replaceAll("&", "");
        }
        this.earlyStartup();
        this.registerTorrentFile();
    }

    private void registerTorrentFile() {
        Callback openDocCallback = new Callback(target, "openDocProc", 3);
        int openDocProc = openDocCallback.getAddress();
        if (openDocProc == 0) {
            Debug.out("OSX: Could not find Callback 'openDocProc'");
            return;
        }
        int result = OS.AEInstallEventHandler((int)1634039412, (int)1868853091, (int)openDocProc, (int)0, (boolean)false);
        if (result != 0) {
            Debug.out("OSX: Could Install OpenDocs Event Handler. Error: " + result);
            return;
        }
        int appTarget = OS.GetApplicationEventTarget();
        Callback appleEventCallback = new Callback((Object)this, "appleEventProc", 3);
        int appleEventProc = appleEventCallback.getAddress();
        int[] mask3 = new int[]{1701867619, 1};
        result = OS.InstallEventHandler((int)appTarget, (int)appleEventProc, (int)(mask3.length / 2), (int[])mask3, (int)0, null);
        if (result != 0) {
            Debug.out("OSX: Could Install Event Handler. Error: " + result);
            return;
        }
    }

    public void earlyStartup() {
        final Display display = Display.getDefault();
        display.syncExec((Runnable)new AERunnable(){

            public void runSupport() {
                CarbonUIEnhancer.this.hookApplicationMenu(display);
            }
        });
    }

    public void hookApplicationMenu(final Display display) {
        Object target = new Object(){

            int commandProc(int nextHandler, int theEvent, int userData) {
                if (OS.GetEventKind((int)theEvent) == 1) {
                    HICommand command = new HICommand();
                    OS.GetEventParameter((int)theEvent, (int)0x2D2D2D2D, (int)1751346532, null, (int)14, null, (HICommand)command);
                    switch (command.commandID) {
                        case 1886545254: {
                            UIFunctions uiFunctions = UIFunctionsManager.getUIFunctions();
                            if (uiFunctions != null) {
                                uiFunctions.showConfig(null);
                            }
                            return 0;
                        }
                        case 1633841013: {
                            Program.launch((String)TyrantStats.TYRANT_HOMEPAGE_URL);
                            return 0;
                        }
                        case 1635414643: {
                            UIFunctions uiFunctions = UIFunctionsManager.getUIFunctions();
                            if (uiFunctions != null) {
                                uiFunctions.dispose(true, false);
                            }
                            return 0;
                        }
                        case 1635410798: {
                            new ConfigureWizard(AzureusCoreFactory.getSingleton(), display);
                            return 0;
                        }
                        case 1635413620: {
                            new NatTestWindow();
                            return 0;
                        }
                    }
                }
                return -9874;
            }
        };
        final Callback commandCallback = new Callback(target, "commandProc", 3);
        int commandProc = commandCallback.getAddress();
        if (commandProc == 0) {
            commandCallback.dispose();
            return;
        }
        int[] mask = new int[]{1668113523, 1};
        OS.InstallEventHandler((int)OS.GetApplicationEventTarget(), (int)commandProc, (int)(mask.length / 2), (int[])mask, (int)0, null);
        int[] outMenu = new int[1];
        short[] outIndex = new short[1];
        if (OS.GetIndMenuItemWithCommandID((int)0, (int)1886545254, (int)1, (int[])outMenu, (short[])outIndex) == 0 && outMenu[0] != 0) {
            int menu = outMenu[0];
            int l = fgAboutActionName.length();
            char[] buffer = new char[l];
            fgAboutActionName.getChars(0, l, buffer, 0);
            int str = OS.CFStringCreateWithCharacters((int)0, (char[])buffer, (int)l);
            OS.InsertMenuItemTextWithCFString((int)menu, (int)str, (short)0, (int)0, (int)1633841013);
            OS.CFRelease((int)str);
            OS.InsertMenuItemTextWithCFString((int)menu, (int)0, (short)1, (int)64, (int)0);
            OS.EnableMenuCommand((int)menu, (int)1886545254);
            OS.DisableMenuCommand((int)menu, (int)1936028278);
            l = fgWizardActionName.length();
            buffer = new char[l];
            fgWizardActionName.getChars(0, l, buffer, 0);
            str = OS.CFStringCreateWithCharacters((int)0, (char[])buffer, (int)l);
            OS.InsertMenuItemTextWithCFString((int)menu, (int)str, (short)3, (int)0, (int)1635410798);
            OS.CFRelease((int)str);
            l = fgNatTestActionName.length();
            buffer = new char[l];
            fgNatTestActionName.getChars(0, l, buffer, 0);
            str = OS.CFStringCreateWithCharacters((int)0, (char[])buffer, (int)l);
            OS.InsertMenuItemTextWithCFString((int)menu, (int)str, (short)4, (int)0, (int)1635413620);
            OS.CFRelease((int)str);
            OS.InsertMenuItemTextWithCFString((int)menu, (int)0, (short)5, (int)64, (int)0);
            l = fgRestartActionName.length();
            buffer = new char[l];
            fgRestartActionName.getChars(0, l, buffer, 0);
            str = OS.CFStringCreateWithCharacters((int)0, (char[])buffer, (int)l);
            OS.InsertMenuItemTextWithCFString((int)menu, (int)str, (short)6, (int)0, (int)1635414643);
            OS.CFRelease((int)str);
            OS.InsertMenuItemTextWithCFString((int)menu, (int)0, (short)7, (int)64, (int)0);
        }
        display.disposeExec((Runnable)new AERunnable(){

            public void runSupport() {
                commandCallback.dispose();
            }
        });
    }

    private static void stopSidekick() {
        try {
            Runtime.getRuntime().exec(new String[]{"osascript", "-e", "tell application \"Azureus\" to quit"});
        }
        catch (IOException e) {
            Debug.printStackTrace(e);
        }
    }

    int appleEventProc(int nextHandler, int theEvent, int userData) {
        int eventClass = OS.GetEventClass((int)theEvent);
        if (eventClass == 1701867619) {
            int[] aeEventID = new int[1];
            if (OS.GetEventParameter((int)theEvent, (int)1702261865, (int)1954115685, null, (int)4, null, (int[])aeEventID) != 0) {
                return -9874;
            }
            if (aeEventID[0] != 1868853091) {
                return -9874;
            }
            EventRecord eventRecord = new EventRecord();
            OS.ConvertEventRefToEventRecord((int)theEvent, (EventRecord)eventRecord);
            OS.AEProcessAppleEvent((EventRecord)eventRecord);
            return 0;
        }
        return -9874;
    }

    private static String OSXtoString(int i) {
        char[] c = new char[]{(char)(i >> 24 & 0xFF), (char)(i >> 16 & 0xFF), (char)(i >> 8 & 0xFF), (char)(i & 0xFF)};
        return new String(c);
    }

    static {
        target = new Object(){

            int openDocProc(int theAppleEvent, int reply, int handlerRefcon) {
                AEDesc aeDesc = new AEDesc();
                EventRecord eventRecord = new EventRecord();
                OS.ConvertEventRefToEventRecord((int)theAppleEvent, (EventRecord)eventRecord);
                try {
                    int result = OSXAccess.AEGetParamDesc(theAppleEvent, 0x2D2D2D2D, 1818850164, aeDesc);
                    if (result != 0) {
                        Debug.out("OSX: Could call AEGetParamDesc. Error: " + result);
                        return 0;
                    }
                }
                catch (UnsatisfiedLinkError e) {
                    Debug.out("OSX: AEGetParamDesc not available.  Can't open sent file");
                    return 0;
                }
                int[] count = new int[1];
                OS.AECountItems((AEDesc)aeDesc, (int[])count);
                if (count[0] > 0) {
                    String[] fileNames = new String[count[0]];
                    int maximumSize = 80;
                    int dataPtr = OS.NewPtr((int)maximumSize);
                    int[] aeKeyword = new int[1];
                    int[] typeCode = new int[1];
                    int[] actualSize = new int[1];
                    for (int i = 0; i < count[0]; ++i) {
                        if (OS.AEGetNthPtr((AEDesc)aeDesc, (int)(i + 1), (int)1718841958, (int[])aeKeyword, (int[])typeCode, (int)dataPtr, (int)maximumSize, (int[])actualSize) != 0) continue;
                        byte[] fsRef = new byte[actualSize[0]];
                        OS.memcpy((byte[])fsRef, (int)dataPtr, (int)actualSize[0]);
                        int dirUrl = OS.CFURLCreateFromFSRef((int)0, (byte[])fsRef);
                        int dirString = OS.CFURLCopyFileSystemPath((int)dirUrl, (int)0);
                        OS.CFRelease((int)dirUrl);
                        int length = OS.CFStringGetLength((int)dirString);
                        char[] buffer = new char[length];
                        CFRange range = new CFRange();
                        range.length = length;
                        OS.CFStringGetCharacters((int)dirString, (CFRange)range, (char[])buffer);
                        OS.CFRelease((int)dirString);
                        fileNames[i] = new String(buffer);
                    }
                    TorrentOpener.openTorrents(fileNames);
                }
                return 0;
            }
        };
    }
}

