/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.ui.swt.mainwindow;

import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import org.eclipse.swt.widgets.Display;
import org.gudy.azureus2.core3.config.COConfigurationManager;
import org.gudy.azureus2.core3.config.ParameterListener;
import org.gudy.azureus2.core3.logging.LogEvent;
import org.gudy.azureus2.core3.logging.LogIDs;
import org.gudy.azureus2.core3.logging.Logger;
import org.gudy.azureus2.core3.util.AERunnable;
import org.gudy.azureus2.core3.util.AEThread;
import org.gudy.azureus2.core3.util.Constants;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.ui.swt.MinimizedWindow;
import org.gudy.azureus2.ui.swt.Tab;
import org.gudy.azureus2.ui.swt.Utils;
import org.gudy.azureus2.ui.swt.mainwindow.MainStatusBar;
import org.gudy.azureus2.ui.swt.mainwindow.MainWindow;
import org.gudy.azureus2.ui.swt.views.IView;
import org.gudy.azureus2.ui.systray.SystemTraySWT;

public class GUIUpdater
extends AEThread
implements ParameterListener {
    private static final LogIDs LOGID = LogIDs.GUI;
    private static final boolean DEBUG_TIMER = Constants.isCVSVersion();
    private MainWindow mainWindow;
    private Display display;
    boolean finished = false;
    boolean refreshed = true;
    int waitTime = COConfigurationManager.getIntParameter("GUI Refresh");
    Map averageTimes = DEBUG_TIMER ? new HashMap() : null;

    public GUIUpdater(MainWindow mainWindow) {
        super("GUI updater");
        this.mainWindow = mainWindow;
        this.display = mainWindow.getDisplay();
        this.setPriority(8);
        COConfigurationManager.addParameterListener("GUI Refresh", this);
    }

    public void runSupport() {
        while (!this.finished) {
            if (this.refreshed) {
                this.update();
            }
            try {
                Thread.sleep(this.waitTime);
            }
            catch (Exception e) {
                Debug.printStackTrace(e);
            }
        }
    }

    public void parameterChanged(String parameterName) {
        this.waitTime = COConfigurationManager.getIntParameter("GUI Refresh");
    }

    private void update() {
        this.refreshed = false;
        Utils.execSWTThread(new AERunnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void runSupport() {
                try {
                    SystemTraySWT systemTraySWT;
                    LinkedHashMap<String, Long> timeMap;
                    long lTimeStart = System.currentTimeMillis();
                    LinkedHashMap<String, Long> linkedHashMap = timeMap = DEBUG_TIMER ? new LinkedHashMap<String, Long>() : null;
                    if (GUIUpdater.this.display == null || GUIUpdater.this.display.isDisposed()) {
                        return;
                    }
                    IView view = null;
                    if (!GUIUpdater.this.mainWindow.getShell().isDisposed() && GUIUpdater.this.mainWindow.isVisible() && !GUIUpdater.this.mainWindow.getShell().getMinimized()) {
                        MainStatusBar mainStatusBar;
                        view = GUIUpdater.this.mainWindow.getCurrentView();
                        if (DEBUG_TIMER) {
                            timeMap.put("Init", new Long(System.currentTimeMillis()));
                        }
                        if (view != null) {
                            view.refresh();
                            if (DEBUG_TIMER) {
                                String s = view.getFullTitle().replaceAll("[0-9.]++\\% : ", "");
                                timeMap.put("'" + s + "' Refresh", new Long(System.currentTimeMillis()));
                            }
                            Tab.refresh();
                            if (DEBUG_TIMER) {
                                timeMap.put("Tab Refresh", new Long(System.currentTimeMillis()));
                            }
                        }
                        if ((mainStatusBar = GUIUpdater.this.mainWindow.getMainStatusBar()) != null) {
                            mainStatusBar.refreshStatusBar();
                        }
                    }
                    if (DEBUG_TIMER) {
                        timeMap.put("Status Bar", new Long(System.currentTimeMillis()));
                    }
                    if ((systemTraySWT = GUIUpdater.this.mainWindow.getSystemTraySWT()) != null) {
                        systemTraySWT.update();
                    }
                    if (DEBUG_TIMER) {
                        timeMap.put("SysTray", new Long(System.currentTimeMillis()));
                    }
                    try {
                        MinimizedWindow.refreshAll();
                    }
                    catch (Exception e) {
                        Logger.log(new LogEvent(LOGID, "Error while trying to update DL Bars", e));
                    }
                    if (DEBUG_TIMER) {
                        timeMap.put("DLBars", new Long(System.currentTimeMillis()));
                        GUIUpdater.this.makeDebugToolTip(lTimeStart, timeMap);
                    }
                }
                catch (Exception e) {
                    Logger.log(new LogEvent(LOGID, "Error while trying to update GUI", e));
                }
                finally {
                    GUIUpdater.this.refreshed = true;
                }
            }
        });
    }

    public void stopIt() {
        this.finished = true;
        COConfigurationManager.removeParameterListener("GUI Refresh", this);
        COConfigurationManager.removeParameterListener("config.style.refreshMT", this);
    }

    private void makeDebugToolTip(long lTimeStart, Map timeMap) {
        boolean IDX_AVG = false;
        boolean IDX_SIZE = true;
        int IDX_MAX = 2;
        int IDX_LAST = 3;
        int IDX_TIME = 4;
        long lastTime = lTimeStart;
        for (String key : timeMap.keySet()) {
            if (!this.averageTimes.containsKey(key)) {
                this.averageTimes.put(key, new Object[]{new Long(0L), new Long(0L), new Long(0L), new Long(0L), new Long(System.currentTimeMillis())});
            }
            Object[] average = (Object[])this.averageTimes.get(key);
            long l = (Long)timeMap.get(key);
            long diff = l - lastTime;
            if (diff > 0L) {
                long count = (Long)average[1];
                if (count >= 20L) {
                    count = 19L;
                }
                long lNewAverage = ((Long)average[0] * count + diff) / (count + 1L);
                average[0] = new Long(lNewAverage);
                average[1] = new Long(count + 1L);
                if (diff > (Long)average[2]) {
                    average[2] = new Long(diff);
                }
                average[3] = new Long(diff);
                average[4] = new Long(System.currentTimeMillis());
            } else {
                average[3] = new Long(diff);
            }
            this.averageTimes.put(key, average);
            lastTime = l;
        }
        StringBuffer sb = new StringBuffer();
        Iterator iter = this.averageTimes.keySet().iterator();
        while (iter.hasNext()) {
            String key = (String)iter.next();
            Object[] average = (Object[])this.averageTimes.get(key);
            long lLastUpdated = (Long)average[4];
            if (System.currentTimeMillis() - lLastUpdated > 10000L) {
                iter.remove();
                continue;
            }
            long lTime = (Long)average[0];
            if (lTime <= 0L) continue;
            if (sb.length() > 0) {
                sb.append("\n");
            }
            sb.append(average[0] + "ms avg: ");
            sb.append("[" + key + "]");
            sb.append(average[1] + " samples");
            sb.append("; max:" + average[2]);
            sb.append("; last:" + average[3]);
        }
        MainStatusBar mainStatusBar = this.mainWindow.getMainStatusBar();
        if (mainStatusBar != null) {
            mainStatusBar.setDebugInfo(sb.toString());
        }
    }
}

