/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.ui.common;

import com.aelitis.azureus.core.AzureusCore;
import com.aelitis.azureus.core.AzureusCoreException;
import com.aelitis.azureus.core.AzureusCoreFactory;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.OutputStreamWriter;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.StringReader;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.net.Socket;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.StringTokenizer;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.OptionBuilder;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.commons.cli.PosixParser;
import org.apache.log4j.Appender;
import org.apache.log4j.ConsoleAppender;
import org.apache.log4j.Layout;
import org.apache.log4j.Logger;
import org.apache.log4j.PatternLayout;
import org.apache.log4j.spi.Filter;
import org.apache.log4j.varia.DenyAllFilter;
import org.gudy.azureus2.core3.config.COConfigurationManager;
import org.gudy.azureus2.ui.common.IUserInterface;
import org.gudy.azureus2.ui.common.StartServer;
import org.gudy.azureus2.ui.common.UIConst;
import org.gudy.azureus2.ui.common.UserInterfaceFactory;

public class Main {
    public static String DEFAULT_UI = "swt";
    public static StartServer start = null;
    protected static AzureusCore core;

    private static CommandLine parseCommands(String[] args, boolean constart) {
        CommandLine commands;
        Options options;
        block4: {
            if (args == null) {
                return null;
            }
            PosixParser parser = new PosixParser();
            options = new Options();
            options.addOption("h", "help", false, "Show this help.");
            OptionBuilder.withLongOpt((String)"exec");
            OptionBuilder.hasArg();
            OptionBuilder.withArgName((String)"file");
            OptionBuilder.withDescription((String)"Execute script file. The file should end with 'logout', otherwise the parser thread doesn't stop.");
            options.addOption(OptionBuilder.create((char)'e'));
            OptionBuilder.withLongOpt((String)"command");
            OptionBuilder.hasArg();
            OptionBuilder.withArgName((String)"command");
            OptionBuilder.withDescription((String)"Execute single script command. Try '-c help' for help on commands.");
            options.addOption(OptionBuilder.create((char)'c'));
            OptionBuilder.withLongOpt((String)"ui");
            OptionBuilder.withDescription((String)"Run <uis>. ',' separated list of user interfaces to run. The first one given will respond to requests without determinable source UI (e.g. further torrents added via command line).");
            OptionBuilder.withArgName((String)"uis");
            OptionBuilder.hasArg();
            options.addOption(OptionBuilder.create((char)'u'));
            commands = null;
            try {
                commands = parser.parse(options, args, true);
            }
            catch (ParseException exp) {
                Logger.getLogger((String)"azureus2").error((Object)("Parsing failed.  Reason: " + exp.getMessage()), (Throwable)exp);
                if (!constart) break block4;
                System.exit(2);
            }
        }
        if (commands.hasOption('h') && constart) {
            HelpFormatter hf = new HelpFormatter();
            hf.printHelp("java org.gudy.azureus2.ui.common.Main", "Optionally you can put torrent files to add to the end of the command line.\r\n", options, "Available User Interfaces: swt (default), web, console\r\nThe default interface is not started if you give either the '-e' or '-c' option (But you can start it by hand with '-u').", true);
            System.exit(0);
        }
        return commands;
    }

    public static void initRootLogger() {
        if (Logger.getRootLogger().getAppender("ConsoleAppender") == null) {
            ConsoleAppender app = new ConsoleAppender((Layout)new PatternLayout("%r [%t] %p %c %x - %m%n"));
            app.setName("ConsoleAppender");
            app.addFilter((Filter)new DenyAllFilter());
            Logger.getRootLogger().addAppender((Appender)app);
        }
    }

    public static void main(String[] args) {
        COConfigurationManager.preInitialise();
        String mi_str = System.getProperty("MULTI_INSTANCE");
        boolean mi = mi_str != null && mi_str.equalsIgnoreCase("true");
        Main.initRootLogger();
        try {
            CommandLine commands = Main.parseCommands(args, true);
            if (commands != null && Main.directLaunch(args, commands)) {
                return;
            }
            core = AzureusCoreFactory.create();
            if (mi) {
                System.out.println("MULTI_INSTANCE enabled");
                Main.processArgs(args, core, commands);
                return;
            }
            start = new StartServer();
            if (start == null || start.getServerState() == 0) {
                new StartSocket(commands == null ? new String[]{} : commands.getArgs());
            } else {
                start.start();
                Main.processArgs(args, core, commands);
            }
        }
        catch (AzureusCoreException e) {
            System.out.println("Start fails:");
            e.printStackTrace();
        }
    }

    public static void shutdown() {
        if (start != null) {
            start.stopIt();
        }
        if (core != null) {
            try {
                core.stop();
            }
            catch (AzureusCoreException e) {
                System.out.println("Stop fails:");
                e.printStackTrace();
            }
        }
        SimpleDateFormat temp = new SimpleDateFormat("dd-MMM-yyyy HH:mm:ss");
        Logger.getLogger((String)"azureus2").fatal((Object)("Azureus stopped at " + temp.format(new Date())));
    }

    public static boolean directLaunch(String[] args, CommandLine commands) {
        if (commands.hasOption('u')) {
            String uinames = commands.getOptionValue('u');
            if (uinames.indexOf(44) != -1) {
                return false;
            }
            if (!uinames.equalsIgnoreCase(DEFAULT_UI)) {
                return false;
            }
        }
        try {
            String uiclass = "org.gudy.azureus2.ui." + DEFAULT_UI + ".Main";
            Class<?> main_class = Class.forName(uiclass);
            Method main_method = main_class.getMethod("main", String[].class);
            main_method.invoke(null, new Object[]{commands.getArgs()});
            return true;
        }
        catch (Throwable e) {
            e.printStackTrace();
            return false;
        }
    }

    public static void processArgs(String[] args, AzureusCore new_core, CommandLine commands) {
        if (commands == null) {
            commands = Main.parseCommands(args, false);
        }
        if (commands != null && args.length > 0 || new_core != null) {
            Object[] params;
            if (UIConst.UIS == null) {
                UIConst.UIS = new HashMap();
            }
            if (commands.hasOption('u')) {
                String uinames = commands.getOptionValue('u');
                if (uinames.indexOf(44) == -1) {
                    if (!UIConst.UIS.containsKey(uinames)) {
                        UIConst.UIS.put(uinames, UserInterfaceFactory.getUI(uinames));
                    }
                } else {
                    StringTokenizer stok = new StringTokenizer(uinames, ",");
                    while (stok.hasMoreTokens()) {
                        String uin = stok.nextToken();
                        if (UIConst.UIS.containsKey(uin)) continue;
                        UIConst.UIS.put(uin, UserInterfaceFactory.getUI(uin));
                    }
                }
            } else if (UIConst.UIS.isEmpty() && !commands.hasOption('c') && !commands.hasOption('e')) {
                UIConst.UIS.put(DEFAULT_UI, UserInterfaceFactory.getUI(DEFAULT_UI));
            }
            Iterator uis = UIConst.UIS.values().iterator();
            boolean isFirst = true;
            String[] theRest = commands.getArgs();
            while (uis.hasNext()) {
                IUserInterface ui = (IUserInterface)uis.next();
                ui.init(isFirst, UIConst.UIS.size() > 1);
                theRest = ui.processArgs(theRest);
                isFirst = false;
            }
            if (new_core != null) {
                SimpleDateFormat temp = new SimpleDateFormat("dd-MMM-yyyy HH:mm:ss");
                UIConst.startTime = new Date();
                Logger.getLogger((String)"azureus2").fatal((Object)("Azureus started at " + temp.format(UIConst.startTime)));
                try {
                    new_core.start();
                    UIConst.setAzureusCore(new_core);
                }
                catch (AzureusCoreException e) {
                    Logger.getLogger((String)"azureus2").error((Object)"Start fails", (Throwable)e);
                }
            }
            uis = UIConst.UIS.values().iterator();
            while (uis.hasNext()) {
                ((IUserInterface)uis.next()).startUI();
            }
            Constructor<?> conConsoleInput = null;
            try {
                Class<?> clConsoleInput = Class.forName("org.gudy.azureus2.ui.console.ConsoleInput");
                params = new Class[]{String.class, AzureusCore.class, Reader.class, PrintStream.class, Boolean.class};
                conConsoleInput = clConsoleInput.getConstructor((Class<?>[])params);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            if (commands.hasOption('e')) {
                if (conConsoleInput != null) {
                    try {
                        params = new Object[]{commands.getOptionValue('e'), new_core, new FileReader(commands.getOptionValue('e')), System.out, Boolean.FALSE};
                        conConsoleInput.newInstance(params);
                    }
                    catch (FileNotFoundException e) {
                        Logger.getLogger((String)"azureus2").error((Object)("Script file not found: " + e.toString()));
                    }
                    catch (Exception e) {
                        Logger.getLogger((String)"azureus2").error((Object)("Error invocating the script processor: " + e.toString()));
                    }
                } else {
                    Logger.getLogger((String)"azureus2").error((Object)"ConsoleInput class not found. You need the console ui package to use '-e'");
                }
            }
            if (commands.hasOption('c')) {
                if (conConsoleInput != null) {
                    String comm = commands.getOptionValue('c');
                    comm = comm + "\nlogout\n";
                    Object[] params2 = new Object[]{commands.getOptionValue('c'), UIConst.getGlobalManager(), new StringReader(comm), System.out, Boolean.FALSE};
                    try {
                        conConsoleInput.newInstance(params2);
                    }
                    catch (Exception e) {
                        Logger.getLogger((String)"azureus2").error((Object)("Error invocating the script processor: " + e.toString()));
                    }
                } else {
                    Logger.getLogger((String)"azureus2").error((Object)"ConsoleInput class not found. You need the console ui package to use '-e'");
                }
            }
            Main.openTorrents(theRest);
        } else {
            Logger.getLogger((String)"azureus2").error((Object)"No commands to process");
        }
    }

    public static void openTorrents(String[] torrents) {
        if (UIConst.UIS != null && !UIConst.UIS.isEmpty() && torrents.length > 0) {
            for (int l = 0; l < torrents.length; ++l) {
                ((IUserInterface)UIConst.UIS.values().toArray()[0]).openTorrent(torrents[l]);
            }
        }
    }

    public static class StartSocket {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public StartSocket(String[] args) {
            Socket sck = null;
            PrintWriter pw = null;
            try {
                System.out.println("StartSocket: passing startup args to already-running process.");
                sck = new Socket("127.0.0.1", 6880);
                pw = new PrintWriter(new OutputStreamWriter(sck.getOutputStream()));
                StringBuffer buffer = new StringBuffer("Azureus Start Server Access;args;");
                for (int i = 0; i < args.length; ++i) {
                    String arg = args[i].replaceAll("&", "&&").replaceAll(";", "&;");
                    buffer.append(arg);
                    buffer.append(';');
                }
                pw.println(buffer.toString());
                pw.flush();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            finally {
                try {
                    if (pw != null) {
                        pw.close();
                    }
                }
                catch (Exception e) {}
                try {
                    if (sck != null) {
                        sck.close();
                    }
                }
                catch (Exception e) {}
            }
        }
    }
}

