/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.pluginsimpl.local.ui;

import java.net.URL;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.gudy.azureus2.core3.util.AEMonitor;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.plugins.PluginConfig;
import org.gudy.azureus2.plugins.PluginInterface;
import org.gudy.azureus2.plugins.PluginView;
import org.gudy.azureus2.plugins.ui.SWT.SWTManager;
import org.gudy.azureus2.plugins.ui.UIException;
import org.gudy.azureus2.plugins.ui.UIInstanceFactory;
import org.gudy.azureus2.plugins.ui.UIManager;
import org.gudy.azureus2.plugins.ui.UIManagerEvent;
import org.gudy.azureus2.plugins.ui.UIManagerEventListener;
import org.gudy.azureus2.plugins.ui.UIManagerListener;
import org.gudy.azureus2.plugins.ui.model.BasicPluginConfigModel;
import org.gudy.azureus2.plugins.ui.model.BasicPluginViewModel;
import org.gudy.azureus2.plugins.ui.model.PluginViewModel;
import org.gudy.azureus2.plugins.ui.tables.TableManager;
import org.gudy.azureus2.pluginsimpl.local.ui.SWT.SWTManagerImpl;
import org.gudy.azureus2.pluginsimpl.local.ui.UIManagerEventAdapter;
import org.gudy.azureus2.pluginsimpl.local.ui.model.BasicPluginConfigModelImpl;
import org.gudy.azureus2.pluginsimpl.local.ui.model.BasicPluginViewModelImpl;
import org.gudy.azureus2.pluginsimpl.local.ui.tables.TableManagerImpl;

public class UIManagerImpl
implements UIManager {
    protected static AEMonitor class_mon = new AEMonitor("UIManager:class");
    protected static boolean initialisation_complete;
    protected static List ui_listeners;
    protected static List ui_event_listeners;
    protected static List ui_factories;
    protected static List ui_event_history;
    protected PluginInterface pi;
    protected PluginConfig plugin_config;
    protected String key_prefix;
    protected TableManager table_manager;

    public UIManagerImpl(PluginInterface _pi) {
        this.pi = _pi;
        this.plugin_config = this.pi.getPluginconfig();
        this.key_prefix = this.plugin_config.getPluginConfigKeyPrefix();
        this.table_manager = new TableManagerImpl(this);
    }

    public PluginInterface getPluginInterface() {
        return this.pi;
    }

    public BasicPluginViewModel getBasicPluginViewModel(String name) {
        return this.createBasicPluginViewModel(name);
    }

    public PluginView createPluginView(PluginViewModel model) {
        try {
            return SWTManagerImpl.getSingleton().createPluginView(model);
        }
        catch (Throwable e) {
            return null;
        }
    }

    public BasicPluginViewModel createBasicPluginViewModel(String name) {
        BasicPluginViewModelImpl model = new BasicPluginViewModelImpl(this, name);
        UIManagerImpl.fireEvent(4, model);
        return model;
    }

    public void destroy(BasicPluginViewModel model) {
        UIManagerImpl.fireEvent(4, model);
    }

    public BasicPluginConfigModel createBasicPluginConfigModel(String section_name) {
        return this.createBasicPluginConfigModel("plugins", section_name);
    }

    public BasicPluginConfigModel createBasicPluginConfigModel(String parent_section, String section_name) {
        BasicPluginConfigModelImpl model = new BasicPluginConfigModelImpl(this, parent_section, section_name);
        UIManagerImpl.fireEvent(5, model);
        return model;
    }

    public void destroy(BasicPluginConfigModel model) {
        UIManagerImpl.fireEvent(8, model);
    }

    public void copyToClipBoard(String data) throws UIException {
        boolean ok = UIManagerImpl.fireEvent(6, data);
        if (!ok) {
            throw new UIException("Failed to deliver request to UI");
        }
    }

    public void openURL(URL url) throws UIException {
        boolean ok = UIManagerImpl.fireEvent(9, url);
        if (!ok) {
            throw new UIException("Failed to deliver request to UI");
        }
    }

    public TableManager getTableManager() {
        return this.table_manager;
    }

    public SWTManager getSWTManager() {
        return SWTManagerImpl.getSingleton();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void initialisationComplete() {
        try {
            class_mon.enter();
            initialisation_complete = true;
            for (int j = 0; j < ui_factories.size(); ++j) {
                UIInstanceFactory instance = (UIInstanceFactory)ui_factories.get(j);
                for (int i = 0; i < ui_listeners.size(); ++i) {
                    Object[] entry = (Object[])ui_listeners.get(i);
                    try {
                        ((UIManagerListener)entry[0]).UIAttached(instance.getInstance((PluginInterface)entry[1]));
                        continue;
                    }
                    catch (Throwable e) {
                        Debug.printStackTrace(e);
                    }
                }
            }
        }
        finally {
            class_mon.exit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void attachUI(UIInstanceFactory factory) {
        try {
            class_mon.enter();
            ui_factories.add(factory);
            if (initialisation_complete) {
                for (int i = 0; i < ui_listeners.size(); ++i) {
                    Object[] entry = (Object[])ui_listeners.get(i);
                    try {
                        ((UIManagerListener)entry[0]).UIAttached(factory.getInstance((PluginInterface)entry[1]));
                        continue;
                    }
                    catch (Throwable e) {
                        Debug.printStackTrace(e);
                    }
                }
            }
        }
        finally {
            class_mon.exit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void detachUI(UIInstanceFactory instance) throws UIException {
        try {
            class_mon.enter();
            instance.detach();
            ui_factories.remove(instance);
            if (initialisation_complete) {
                for (int i = 0; i < ui_listeners.size(); ++i) {
                    Object[] entry = (Object[])ui_listeners.get(i);
                    try {
                        ((UIManagerListener)entry[0]).UIDetached(instance.getInstance((PluginInterface)entry[1]));
                        continue;
                    }
                    catch (Throwable e) {
                        Debug.printStackTrace(e);
                    }
                }
            }
        }
        finally {
            class_mon.exit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addUIListener(UIManagerListener listener) {
        try {
            class_mon.enter();
            ui_listeners.add(new Object[]{listener, this.pi});
            if (initialisation_complete) {
                for (int i = 0; i < ui_factories.size(); ++i) {
                    UIInstanceFactory instance = (UIInstanceFactory)ui_factories.get(i);
                    try {
                        listener.UIAttached(instance.getInstance(this.pi));
                        continue;
                    }
                    catch (Throwable e) {
                        Debug.printStackTrace(e);
                    }
                }
            }
        }
        finally {
            class_mon.exit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeUIListener(UIManagerListener listener) {
        try {
            class_mon.enter();
            Iterator it = ui_listeners.iterator();
            while (it.hasNext()) {
                Object[] entry = (Object[])it.next();
                if (entry[0] != listener) continue;
                it.remove();
            }
        }
        finally {
            class_mon.exit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addUIEventListener(UIManagerEventListener listener) {
        try {
            class_mon.enter();
            ui_event_listeners.add(listener);
        }
        finally {
            class_mon.exit();
        }
        for (int i = 0; i < ui_event_history.size(); ++i) {
            try {
                listener.eventOccurred((UIManagerEvent)ui_event_history.get(i));
                continue;
            }
            catch (Throwable e) {
                Debug.printStackTrace(e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeUIEventListener(UIManagerEventListener listener) {
        try {
            class_mon.enter();
            ui_event_listeners.remove(listener);
        }
        finally {
            class_mon.exit();
        }
    }

    public static boolean fireEvent(int type, Object data) {
        return UIManagerImpl.fireEvent(new UIManagerEventAdapter(type, data));
    }

    public static boolean fireEvent(UIManagerEvent event2) {
        int type;
        boolean delivered = false;
        for (int i = 0; i < ui_event_listeners.size(); ++i) {
            try {
                if (!((UIManagerEventListener)ui_event_listeners.get(i)).eventOccurred(event2)) continue;
                delivered = true;
                break;
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
        }
        if ((type = event2.getType()) == 4 || type == 5 || type == 12) {
            delivered = true;
            ui_event_history.add(event2);
        } else if (type == 7 || type == 8) {
            delivered = true;
            Iterator it = ui_event_history.iterator();
            while (it.hasNext()) {
                UIManagerEvent e = (UIManagerEvent)it.next();
                int e_type = e.getType();
                if (e_type != 4 && e_type != 5 || e.getData() != event2.getData()) continue;
                it.remove();
                break;
            }
        }
        return delivered;
    }

    public void showTextMessage(String title_resource, String message_resource, String contents) {
        UIManagerImpl.fireEvent(1, new String[]{title_resource, message_resource, contents});
    }

    public boolean showConfigSection(String sectionID) {
        UIManagerEventAdapter event2 = new UIManagerEventAdapter(13, sectionID);
        if (!UIManagerImpl.fireEvent(event2)) {
            return false;
        }
        if (event2.getResult() instanceof Boolean) {
            return false;
        }
        return (Boolean)event2.getResult();
    }

    static {
        ui_listeners = new ArrayList();
        ui_event_listeners = new ArrayList();
        ui_factories = new ArrayList();
        ui_event_history = new ArrayList();
    }
}

