/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.pluginsimpl.local.sharing;

import java.io.File;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.util.Arrays;
import java.util.Map;
import java.util.StringTokenizer;
import org.gudy.azureus2.core3.config.COConfigurationManager;
import org.gudy.azureus2.core3.download.DownloadManagerState;
import org.gudy.azureus2.core3.download.DownloadManagerStateFactory;
import org.gudy.azureus2.core3.internat.LocaleTorrentUtil;
import org.gudy.azureus2.core3.torrent.TOTorrent;
import org.gudy.azureus2.core3.torrent.TOTorrentCreator;
import org.gudy.azureus2.core3.torrent.TOTorrentException;
import org.gudy.azureus2.core3.torrent.TOTorrentFactory;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.TorrentUtils;
import org.gudy.azureus2.plugins.sharing.ShareException;
import org.gudy.azureus2.plugins.sharing.ShareItem;
import org.gudy.azureus2.plugins.sharing.ShareResourceDeletionVetoException;
import org.gudy.azureus2.plugins.sharing.ShareResourceWillBeDeletedListener;
import org.gudy.azureus2.plugins.torrent.TorrentAttribute;
import org.gudy.azureus2.pluginsimpl.local.sharing.ShareItemImpl;
import org.gudy.azureus2.pluginsimpl.local.sharing.ShareManagerImpl;
import org.gudy.azureus2.pluginsimpl.local.sharing.ShareResourceDirContentsImpl;
import org.gudy.azureus2.pluginsimpl.local.sharing.ShareResourceDirImpl;
import org.gudy.azureus2.pluginsimpl.local.sharing.ShareResourceFileImpl;
import org.gudy.azureus2.pluginsimpl.local.sharing.ShareResourceImpl;
import org.gudy.azureus2.pluginsimpl.local.torrent.TorrentImpl;
import org.gudy.azureus2.pluginsimpl.local.torrent.TorrentManagerImpl;

public abstract class ShareResourceFileOrDirImpl
extends ShareResourceImpl {
    protected File file;
    protected ShareItemImpl item;

    protected static ShareResourceImpl getResourceSupport(ShareManagerImpl _manager, File _file) throws ShareException {
        try {
            return _manager.getResource(_file.getCanonicalFile());
        }
        catch (IOException e) {
            throw new ShareException("getCanonicalFile fails", e);
        }
    }

    protected ShareResourceFileOrDirImpl(ShareManagerImpl _manager, ShareResourceDirContentsImpl _parent, int _type, File _file) throws ShareException {
        super(_manager, _type);
        this.file = _file;
        if (this.getType() == 1) {
            if (!this.file.exists()) {
                throw new ShareException("File '".concat(this.file.getName()).concat("' not found"));
            }
            if (!this.file.isFile()) {
                throw new ShareException("Not a file");
            }
        } else {
            if (!this.file.exists()) {
                throw new ShareException("Dir '".concat(this.file.getName()).concat("' not found"));
            }
            if (this.file.isFile()) {
                throw new ShareException("Not a directory");
            }
        }
        try {
            this.file = this.file.getCanonicalFile();
        }
        catch (IOException e) {
            throw new ShareException("ShareResourceFile: failed to get canonical name", e);
        }
        if (_parent != null) {
            this.setParent(_parent);
            this.inheritAttributes(_parent);
        }
        this.createTorrent();
    }

    protected ShareResourceFileOrDirImpl(ShareManagerImpl _manager, int _type, File _file, Map _map) throws ShareException {
        super(_manager, _type, _map);
        this.file = _file;
        this.item = ShareItemImpl.deserialiseItem(this, _map);
    }

    public boolean canBeDeleted() throws ShareResourceDeletionVetoException {
        for (int i = 0; i < this.deletion_listeners.size(); ++i) {
            ((ShareResourceWillBeDeletedListener)this.deletion_listeners.get(i)).resourceWillBeDeleted(this);
        }
        return true;
    }

    protected abstract byte[] getFingerPrint() throws ShareException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void createTorrent() throws ShareException {
        try {
            TOTorrent to_torrent;
            this.manager.reportCurrentTask((this.item == null ? "Creating" : "Re-creating").concat(" torrent for '").concat(this.file.toString()).concat("'"));
            URL[] urls = this.manager.getAnnounceURLs();
            TOTorrentCreator creator = TOTorrentFactory.createFromFileOrDirWithComputedPieceLength(this.file, urls[0], this.manager.getAddHashes());
            creator.addListener(this.manager);
            try {
                this.manager.setTorrentCreator(creator);
                to_torrent = creator.create();
            }
            finally {
                this.manager.setTorrentCreator(null);
            }
            LocaleTorrentUtil.setDefaultTorrentEncoding(to_torrent);
            for (int i = 1; i < urls.length; ++i) {
                TorrentUtils.announceGroupsInsertLast(to_torrent, new URL[]{urls[i]});
            }
            String comment = COConfigurationManager.getStringParameter("Sharing Torrent Comment").trim();
            boolean private_torrent = COConfigurationManager.getBooleanParameter("Sharing Torrent Private");
            boolean dht_backup_enabled = COConfigurationManager.getBooleanParameter("Sharing Permit DHT", true);
            TorrentAttribute ta_props = TorrentManagerImpl.getSingleton().getAttribute("ShareProperties");
            String props = this.getAttribute(ta_props);
            if (props != null) {
                StringTokenizer tok = new StringTokenizer(props, ";");
                while (tok.hasMoreTokens()) {
                    String token = tok.nextToken();
                    int pos = token.indexOf(61);
                    if (pos == -1) {
                        Debug.out("ShareProperty invalid: " + props);
                        continue;
                    }
                    String lhs = token.substring(0, pos).trim().toLowerCase();
                    String rhs = token.substring(pos + 1).trim().toLowerCase();
                    boolean set = rhs.equals("true");
                    if (lhs.equals("private")) {
                        private_torrent = set;
                        continue;
                    }
                    if (lhs.equals("dht_backup")) {
                        dht_backup_enabled = set;
                        continue;
                    }
                    if (lhs.equals("comment")) {
                        comment = rhs;
                        continue;
                    }
                    Debug.out("ShareProperty invalid: " + props);
                    break;
                }
            }
            if (comment.length() > 0) {
                to_torrent.setComment(comment);
            }
            TorrentUtils.setDHTBackupEnabled(to_torrent, dht_backup_enabled);
            TorrentUtils.setPrivate(to_torrent, private_torrent);
            if (TorrentUtils.isDecentralised(to_torrent)) {
                TorrentUtils.setDecentralised(to_torrent);
            }
            DownloadManagerState download_manager_state = DownloadManagerStateFactory.getDownloadState(to_torrent);
            TorrentUtils.setResumeDataCompletelyValid(download_manager_state);
            download_manager_state.save();
            if (this.item == null) {
                byte[] fingerprint = this.getFingerPrint();
                this.item = new ShareItemImpl((ShareResourceImpl)this, fingerprint, new TorrentImpl(to_torrent));
            } else {
                this.item.setTorrent(new TorrentImpl(to_torrent));
                this.item.writeTorrent();
            }
        }
        catch (TOTorrentException e) {
            if (e.getReason() == 9) {
                throw new ShareException("ShareResource: Operation cancelled", e);
            }
            throw new ShareException("ShareResource: Torrent create failed", e);
        }
        catch (Throwable e) {
            throw new ShareException("ShareResource: Torrent create failed", e);
        }
    }

    protected void checkConsistency() throws ShareException {
        try {
            if (Arrays.equals(this.getFingerPrint(), this.item.getFingerPrint())) {
                if (!this.manager.torrentExists(this.item)) {
                    this.createTorrent();
                }
            } else {
                this.manager.addFileOrDir(null, this.file, this.getType(), true);
            }
        }
        catch (Throwable e) {
            this.manager.delete(this);
        }
    }

    protected static ShareResourceImpl deserialiseResource(ShareManagerImpl manager, Map map, int type) throws ShareException {
        try {
            File file = new File(new String((byte[])map.get("file"), "UTF8"));
            if (type == 1) {
                return new ShareResourceFileImpl(manager, file, map);
            }
            return new ShareResourceDirImpl(manager, file, map);
        }
        catch (UnsupportedEncodingException e) {
            throw new ShareException("internal error", e);
        }
    }

    protected void serialiseResource(Map map) {
        super.serialiseResource(map);
        map.put("type", new Long(this.getType()));
        try {
            map.put("file", this.file.toString().getBytes("UTF8"));
        }
        catch (UnsupportedEncodingException e) {
            Debug.printStackTrace(e);
        }
        this.item.serialiseItem(map);
    }

    protected void deleteInternal() {
        this.item.delete();
    }

    public String getName() {
        return this.file.toString();
    }

    public File getFile() {
        return this.file;
    }

    public ShareItem getItem() {
        return this.item;
    }
}

