/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.core3.tracker.client.impl.bt;

import com.aelitis.azureus.core.networkmanager.impl.udp.UDPNetworkManager;
import com.aelitis.net.udp.uc.PRUDPPacketHandlerException;
import com.aelitis.net.udp.uc.PRUDPPacketHandlerFactory;
import java.io.ByteArrayOutputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.ConnectException;
import java.net.HttpURLConnection;
import java.net.InetSocketAddress;
import java.net.URL;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.zip.GZIPInputStream;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLSession;
import org.gudy.azureus2.core3.config.COConfigurationManager;
import org.gudy.azureus2.core3.internat.MessageText;
import org.gudy.azureus2.core3.logging.LogEvent;
import org.gudy.azureus2.core3.logging.LogIDs;
import org.gudy.azureus2.core3.logging.Logger;
import org.gudy.azureus2.core3.security.SESecurityManager;
import org.gudy.azureus2.core3.tracker.client.TRTrackerScraperClientResolver;
import org.gudy.azureus2.core3.tracker.client.TRTrackerScraperResponse;
import org.gudy.azureus2.core3.tracker.client.impl.TRTrackerScraperImpl;
import org.gudy.azureus2.core3.tracker.client.impl.TRTrackerScraperResponseImpl;
import org.gudy.azureus2.core3.tracker.client.impl.bt.TRTrackerBTAnnouncerImpl;
import org.gudy.azureus2.core3.tracker.client.impl.bt.TRTrackerBTScraperResponseImpl;
import org.gudy.azureus2.core3.tracker.client.impl.bt.TrackerChecker;
import org.gudy.azureus2.core3.tracker.protocol.udp.PRUDPPacketReplyConnect;
import org.gudy.azureus2.core3.tracker.protocol.udp.PRUDPPacketReplyError;
import org.gudy.azureus2.core3.tracker.protocol.udp.PRUDPPacketReplyScrape;
import org.gudy.azureus2.core3.tracker.protocol.udp.PRUDPPacketReplyScrape2;
import org.gudy.azureus2.core3.tracker.protocol.udp.PRUDPPacketRequestConnect;
import org.gudy.azureus2.core3.tracker.protocol.udp.PRUDPPacketRequestScrape;
import org.gudy.azureus2.core3.tracker.protocol.udp.PRUDPPacketTracker;
import org.gudy.azureus2.core3.tracker.protocol.udp.PRUDPTrackerCodecs;
import org.gudy.azureus2.core3.tracker.util.TRTrackerUtils;
import org.gudy.azureus2.core3.util.AEMonitor;
import org.gudy.azureus2.core3.util.AERunnable;
import org.gudy.azureus2.core3.util.AddressUtils;
import org.gudy.azureus2.core3.util.BDecoder;
import org.gudy.azureus2.core3.util.BEncoder;
import org.gudy.azureus2.core3.util.ByteEncodedKeyHashMap;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.HashWrapper;
import org.gudy.azureus2.core3.util.SystemTime;
import org.gudy.azureus2.core3.util.ThreadPool;
import org.gudy.azureus2.core3.util.TorrentUtils;
import org.gudy.azureus2.plugins.clientid.ClientIDException;
import org.gudy.azureus2.pluginsimpl.local.clientid.ClientIDManagerImpl;

public class TrackerStatus {
    private static final LogIDs LOGID = LogIDs.TRACKER;
    private static final String SS = "Scrape.status.";
    private static final String SSErr = "Scrape.status.error.";
    private static final int FAULTY_SCRAPE_RETRY_INTERVAL = 600000;
    private static final int NOHASH_RETRY_INTERVAL = 10800000;
    private static final int GROUP_SCRAPES_MS = 900000;
    private static final int GROUP_SCRAPES_LIMIT = 20;
    private static List logged_invalid_urls;
    private static ThreadPool thread_pool;
    private final URL tracker_url;
    private boolean az_tracker;
    private String scrapeURL = null;
    private HashMap hashes;
    private TRTrackerScraperImpl scraper;
    private boolean bSingleHashScrapes = false;
    protected AEMonitor hashes_mon = new AEMonitor("TrackerStatus:hashes");
    private final TrackerChecker checker;

    public TrackerStatus(TrackerChecker _checker, TRTrackerScraperImpl _scraper, URL _tracker_url) {
        this.checker = _checker;
        this.scraper = _scraper;
        this.tracker_url = _tracker_url;
        this.az_tracker = TRTrackerUtils.isAZTracker(this.tracker_url);
        this.bSingleHashScrapes = COConfigurationManager.getBooleanParameter("Tracker Client Scrape Single Only");
        String trackerUrl = this.tracker_url.toString();
        this.hashes = new HashMap();
        try {
            trackerUrl = trackerUrl.replaceAll(" ", "");
            int position = trackerUrl.lastIndexOf(47);
            if (position >= 0 && trackerUrl.length() >= position + 9 && trackerUrl.substring(position + 1, position + 9).equals("announce")) {
                this.scrapeURL = trackerUrl.substring(0, position + 1) + "scrape" + trackerUrl.substring(position + 9);
            } else if (trackerUrl.toLowerCase().startsWith("udp:")) {
                this.scrapeURL = trackerUrl;
            } else if (position >= 0 && trackerUrl.lastIndexOf(46) < position) {
                this.scrapeURL = trackerUrl + (trackerUrl.endsWith("/") ? "" : "/") + "scrape";
            } else if (!logged_invalid_urls.contains(trackerUrl)) {
                logged_invalid_urls.add(trackerUrl);
            }
        }
        catch (Throwable e) {
            Debug.printStackTrace(e);
        }
    }

    protected boolean isTrackerScrapeUrlValid() {
        return this.scrapeURL != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected TRTrackerScraperResponseImpl getHashData(HashWrapper hash) {
        try {
            this.hashes_mon.enter();
            TRTrackerScraperResponseImpl tRTrackerScraperResponseImpl = (TRTrackerScraperResponseImpl)this.hashes.get(hash);
            return tRTrackerScraperResponseImpl;
        }
        finally {
            this.hashes_mon.exit();
        }
    }

    protected void updateSingleHash(HashWrapper hash, boolean force) {
        this.updateSingleHash(hash, force, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void updateSingleHash(HashWrapper hash, boolean force, boolean async) {
        if (this.scrapeURL == null) {
            return;
        }
        try {
            TRTrackerScraperResponseImpl response;
            ArrayList<TRTrackerScraperResponseImpl> responsesToUpdate = new ArrayList<TRTrackerScraperResponseImpl>();
            try {
                this.hashes_mon.enter();
                response = (TRTrackerScraperResponseImpl)this.hashes.get(hash);
                if (response == null) {
                    response = this.addHash(hash);
                }
            }
            finally {
                this.hashes_mon.exit();
            }
            long lMainNextScrapeStartTime = response.getNextScrapeStartTime();
            if (!force && lMainNextScrapeStartTime > SystemTime.getCurrentTime()) {
                return;
            }
            response.setStatus(3, null);
            responsesToUpdate.add(response);
            if (!this.bSingleHashScrapes) {
                try {
                    this.hashes_mon.enter();
                    Iterator iterHashes = this.hashes.values().iterator();
                    while (iterHashes.hasNext() && responsesToUpdate.size() < 20) {
                        long lTimeDiff;
                        TRTrackerScraperResponseImpl r = (TRTrackerScraperResponseImpl)iterHashes.next();
                        if (!r.getHash().equals(hash) || (lTimeDiff = Math.abs(lMainNextScrapeStartTime - r.getNextScrapeStartTime())) > 900000L || r.getStatus() == 3) continue;
                        r.setStatus(3, null);
                        responsesToUpdate.add(r);
                    }
                }
                finally {
                    this.hashes_mon.exit();
                }
            }
            this.runScrapes(responsesToUpdate, force, async);
        }
        catch (Throwable t) {
            Debug.out("updateSingleHash() exception", t);
        }
    }

    protected void runScrapes(final ArrayList responses, final boolean force, boolean async) {
        if (async) {
            thread_pool.run(new AERunnable(){

                public void runSupport() {
                    TrackerStatus.this.runScrapesSupport(responses, force);
                }
            });
        } else {
            this.runScrapesSupport(responses, force);
        }
    }

    protected void runScrapesSupport(ArrayList responses, boolean force) {
        try {
            if (Logger.isEnabled()) {
                Logger.log(new LogEvent(LOGID, "TrackerStatus: scraping '" + this.scrapeURL + "', number of hashes = " + responses.size() + ", single_hash_scrapes = " + this.bSingleHashScrapes));
            }
            boolean original_bSingleHashScrapes = this.bSingleHashScrapes;
            boolean disable_all_scrapes = !COConfigurationManager.getBooleanParameter("Tracker Client Scrape Enable");
            boolean disable_stopped_scrapes = !COConfigurationManager.getBooleanParameter("Tracker Client Scrape Stopped Enable");
            try {
                Map mapFlags;
                Map mapFiles;
                boolean this_is_az_tracker;
                HashWrapper one_of_the_hashes = null;
                TRTrackerScraperResponseImpl one_of_the_responses = null;
                char first_separator = this.scrapeURL.indexOf(63) == -1 ? (char)'?' : '&';
                String info_hash = "";
                String flags = "";
                for (int i = 0; i < responses.size(); ++i) {
                    TRTrackerScraperResponseImpl response = (TRTrackerScraperResponseImpl)responses.get(i);
                    HashWrapper hash = response.getHash();
                    if (Logger.isEnabled()) {
                        Logger.log(new LogEvent(TorrentUtils.getDownloadManager(hash), LOGID, "TrackerStatus: scraping, single_hash_scrapes = " + this.bSingleHashScrapes));
                    }
                    if (!this.scraper.isNetworkEnabled(hash, this.tracker_url)) {
                        response.setNextScrapeStartTime(SystemTime.getCurrentTime() + 600000L);
                        response.setStatus(1, MessageText.getString("Scrape.status.networkdisabled"));
                        this.scraper.scrapeReceived(response);
                        continue;
                    }
                    if (!force && (disable_all_scrapes || disable_stopped_scrapes && !this.scraper.isTorrentRunning(hash))) {
                        response.setNextScrapeStartTime(SystemTime.getCurrentTime() + 600000L);
                        response.setStatus(1, MessageText.getString("Scrape.status.disabled"));
                        this.scraper.scrapeReceived(response);
                        continue;
                    }
                    response.setStatus(3, MessageText.getString("Scrape.status.scraping"));
                    this.scraper.scrapeReceived(response);
                    info_hash = info_hash + (one_of_the_hashes != null ? (char)'&' : first_separator) + "info_hash=";
                    info_hash = info_hash + URLEncoder.encode(new String(hash.getBytes(), "ISO-8859-1"), "ISO-8859-1").replaceAll("\\+", "%20");
                    Object[] extensions = this.scraper.getExtensions(hash);
                    if (extensions != null) {
                        if (extensions[0] != null) {
                            info_hash = info_hash + (String)extensions[0];
                        }
                        flags = flags + (Character)extensions[1];
                    } else {
                        flags = flags + TRTrackerScraperClientResolver.FL_NONE;
                    }
                    one_of_the_responses = response;
                    one_of_the_hashes = hash;
                }
                if (one_of_the_hashes == null) {
                    return;
                }
                TorrentUtils.setTLSTorrentHash(one_of_the_hashes);
                String request2 = this.scrapeURL + info_hash;
                if (this.az_tracker) {
                    String port_details = TRTrackerUtils.getPortsForURL();
                    request2 = request2 + port_details;
                    request2 = request2 + "&azsf=" + flags;
                }
                URL reqUrl = new URL(request2);
                if (Logger.isEnabled()) {
                    Logger.log(new LogEvent(LOGID, "Accessing scrape interface using url : " + reqUrl));
                }
                ByteArrayOutputStream message = new ByteArrayOutputStream();
                long scrapeStartTime = SystemTime.getCurrentTime();
                URL redirect_url = null;
                if (reqUrl.getProtocol().equalsIgnoreCase("udp")) {
                    this.scrapeUDP(reqUrl, message, one_of_the_hashes, one_of_the_responses);
                    this.bSingleHashScrapes = true;
                } else {
                    redirect_url = this.scrapeHTTP(reqUrl, message);
                }
                Map map = BDecoder.decode(message.toByteArray());
                boolean bl = this_is_az_tracker = map.get("aztracker") != null;
                if (this.az_tracker != this_is_az_tracker) {
                    this.az_tracker = this_is_az_tracker;
                    TRTrackerUtils.setAZTracker(this.tracker_url, this.az_tracker);
                }
                Map map2 = mapFiles = map == null ? null : (Map)map.get("files");
                if (Logger.isEnabled()) {
                    Logger.log(new LogEvent(LOGID, "Response from scrape interface " + this.scrapeURL + ": " + (mapFiles == null ? "null" : "" + mapFiles.size()) + " returned"));
                }
                int iMinRequestInterval = 0;
                if (map != null && (mapFlags = (Map)map.get("flags")) != null) {
                    Long longScrapeValue = (Long)mapFlags.get("min_request_interval");
                    if (longScrapeValue != null) {
                        iMinRequestInterval = longScrapeValue.intValue();
                    }
                    Logger.log(new LogEvent(LOGID, "Received min_request_interval of " + iMinRequestInterval));
                }
                if (mapFiles == null || mapFiles.size() == 0) {
                    byte[] failure_reason_bytes;
                    byte[] byArray = failure_reason_bytes = map == null ? null : (byte[])map.get("failure reason");
                    if (failure_reason_bytes != null) {
                        long nextScrapeTime = SystemTime.getCurrentTime() + (long)(iMinRequestInterval == 0 ? 600000 : iMinRequestInterval * 1000);
                        for (int i = 0; i < responses.size(); ++i) {
                            TRTrackerScraperResponseImpl response = (TRTrackerScraperResponseImpl)responses.get(i);
                            response.setNextScrapeStartTime(nextScrapeTime);
                            response.setStatus(1, MessageText.getString("Scrape.status.error") + new String(failure_reason_bytes, "UTF8"));
                            this.scraper.scrapeReceived(response);
                        }
                    } else if (responses.size() > 1) {
                        this.bSingleHashScrapes = true;
                        if (Logger.isEnabled()) {
                            Logger.log(new LogEvent(LOGID, 1, this.scrapeURL + " doesn't properly support " + "multi-hash scrapes"));
                        }
                        for (int i = 0; i < responses.size(); ++i) {
                            TRTrackerScraperResponseImpl response = (TRTrackerScraperResponseImpl)responses.get(i);
                            response.setStatus(1, MessageText.getString("Scrape.status.error") + MessageText.getString("Scrape.status.error.invalid"));
                            this.scraper.scrapeReceived(response);
                        }
                    } else {
                        long nextScrapeTime = SystemTime.getCurrentTime() + (long)(iMinRequestInterval == 0 ? 10800000 : iMinRequestInterval * 1000);
                        TRTrackerScraperResponseImpl response = (TRTrackerScraperResponseImpl)responses.get(0);
                        response.setNextScrapeStartTime(nextScrapeTime);
                        response.setStatus(1, MessageText.getString("Scrape.status.error") + MessageText.getString("Scrape.status.error.nohash"));
                        this.scraper.scrapeReceived(response);
                    }
                    return;
                }
                if (!this.bSingleHashScrapes && responses.size() > 1 && mapFiles.size() == 1) {
                    this.bSingleHashScrapes = true;
                    if (Logger.isEnabled()) {
                        Logger.log(new LogEvent(LOGID, 1, this.scrapeURL + " only returned " + mapFiles.size() + " hash scrape(s), but we asked for " + responses.size()));
                    }
                }
                for (int i = 0; i < responses.size(); ++i) {
                    TRTrackerScraperResponseImpl response = (TRTrackerScraperResponseImpl)responses.get(i);
                    Map scrapeMap = (Map)mapFiles.get(new String(response.getHash().getBytes(), "ISO-8859-1"));
                    if (scrapeMap == null) {
                        if (responses.size() == 1 || mapFiles.size() != 1) {
                            response.setNextScrapeStartTime(SystemTime.getCurrentTime() + 10800000L);
                            response.setStatus(1, MessageText.getString("Scrape.status.error") + MessageText.getString("Scrape.status.error.nohash"));
                            this.scraper.scrapeReceived(response);
                            continue;
                        }
                        response.revertStatus();
                        if (response.getStatus() == 3) {
                            response.setNextScrapeStartTime(SystemTime.getCurrentTime() + 600000L);
                            response.setStatus(1, MessageText.getString("Scrape.status.error") + MessageText.getString("Scrape.status.error.invalid"));
                        } else {
                            this.bSingleHashScrapes = true;
                            if (original_bSingleHashScrapes) {
                                response.setNextScrapeStartTime(SystemTime.getCurrentTime() + 600000L);
                            }
                        }
                        this.scraper.scrapeReceived(response);
                        continue;
                    }
                    int seeds = ((Long)scrapeMap.get("complete")).intValue();
                    int peers = ((Long)scrapeMap.get("incomplete")).intValue();
                    if (seeds < 0 || peers < 0) {
                        if (Logger.isEnabled()) {
                            HashWrapper hash = response.getHash();
                            Logger.log(new LogEvent(TorrentUtils.getDownloadManager(hash), LOGID, "Invalid scrape response from '" + reqUrl + "': map = " + scrapeMap));
                        }
                        if (responses.size() > 1 && this.bSingleHashScrapes) {
                            response.setStatus(1, MessageText.getString("Scrape.status.error") + MessageText.getString("Scrape.status.error.invalid"));
                            this.scraper.scrapeReceived(response);
                            continue;
                        }
                        response.setNextScrapeStartTime(SystemTime.getCurrentTime() + 600000L);
                        response.setStatus(1, MessageText.getString("Scrape.status.error") + MessageText.getString("Scrape.status.error.invalid") + " " + (seeds < 0 ? MessageText.getString("MyTorrentsView.seeds") + " == " + seeds + ". " : "") + (peers < 0 ? MessageText.getString("MyTorrentsView.peers") + " == " + peers + ". " : ""));
                        this.scraper.scrapeReceived(response);
                        continue;
                    }
                    int scrapeInterval = TRTrackerScraperResponseImpl.calcScrapeIntervalSecs(iMinRequestInterval, seeds);
                    long nextScrapeTime = SystemTime.getCurrentTime() + (long)(scrapeInterval * 1000);
                    response.setNextScrapeStartTime(nextScrapeTime);
                    response.setScrapeStartTime(scrapeStartTime);
                    response.setSeeds(seeds);
                    response.setPeers(peers);
                    response.setStatus(2, MessageText.getString("Scrape.status.ok"));
                    this.scraper.scrapeReceived(response);
                    try {
                        String redirect_str;
                        int s_pos;
                        if (responses.size() != 1 || redirect_url == null || (s_pos = (redirect_str = redirect_url.toString()).indexOf("/scrape")) == -1) continue;
                        URL new_url = new URL(redirect_str.substring(0, s_pos) + "/announce" + redirect_str.substring(s_pos + 7));
                        if (!this.scraper.redirectTrackerUrl(response.getHash(), this.tracker_url, new_url)) continue;
                        this.removeHash(response.getHash());
                        continue;
                    }
                    catch (Throwable e) {
                        Debug.printStackTrace(e);
                    }
                }
            }
            catch (NoClassDefFoundError ignoreSSL) {
                for (int i = 0; i < responses.size(); ++i) {
                    TRTrackerScraperResponseImpl response = (TRTrackerScraperResponseImpl)responses.get(i);
                    response.setNextScrapeStartTime(SystemTime.getCurrentTime() + 600000L);
                    response.setStatus(1, MessageText.getString("Scrape.status.error") + ignoreSSL.getMessage());
                    this.scraper.scrapeReceived(response);
                }
            }
            catch (FileNotFoundException e) {
                for (int i = 0; i < responses.size(); ++i) {
                    TRTrackerScraperResponseImpl response = (TRTrackerScraperResponseImpl)responses.get(i);
                    response.setNextScrapeStartTime(SystemTime.getCurrentTime() + 600000L);
                    response.setStatus(1, MessageText.getString("Scrape.status.error") + MessageText.getString("DownloadManager.error.filenotfound"));
                    this.scraper.scrapeReceived(response);
                }
            }
            catch (ConnectException e) {
                for (int i = 0; i < responses.size(); ++i) {
                    TRTrackerScraperResponseImpl response = (TRTrackerScraperResponseImpl)responses.get(i);
                    response.setNextScrapeStartTime(SystemTime.getCurrentTime() + 600000L);
                    response.setStatus(1, MessageText.getString("Scrape.status.error") + e.getLocalizedMessage());
                    this.scraper.scrapeReceived(response);
                }
            }
            catch (Exception e) {
                String error_message = e.getMessage();
                if (error_message != null && error_message.indexOf("414") != -1 && !this.bSingleHashScrapes) {
                    this.bSingleHashScrapes = true;
                    return;
                }
                String msg = Debug.getNestedExceptionMessage(e);
                for (int i = 0; i < responses.size(); ++i) {
                    TRTrackerScraperResponseImpl response = (TRTrackerScraperResponseImpl)responses.get(i);
                    if (Logger.isEnabled()) {
                        HashWrapper hash = response.getHash();
                        Logger.log(new LogEvent((Object)TorrentUtils.getDownloadManager(hash), LOGID, 3, "Error from scrape interface " + this.scrapeURL + " : " + msg));
                    }
                    response.setNextScrapeStartTime(SystemTime.getCurrentTime() + 600000L);
                    response.setStatus(1, MessageText.getString("Scrape.status.error") + msg);
                    this.scraper.scrapeReceived(response);
                }
            }
        }
        catch (Throwable t) {
            Debug.out("runScrapesSupport failed", t);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected URL scrapeHTTP(URL reqUrl, ByteArrayOutputStream message) throws IOException {
        URL redirect_url = null;
        TRTrackerUtils.checkForBlacklistedURLs(reqUrl);
        reqUrl = TRTrackerUtils.adjustURLForHosting(reqUrl);
        reqUrl = AddressUtils.adjustURL(reqUrl);
        Properties http_properties = new Properties();
        http_properties.put("URL", reqUrl);
        try {
            ClientIDManagerImpl.getSingleton().generateHTTPProperties(http_properties);
        }
        catch (ClientIDException e) {
            throw new IOException(e.getMessage());
        }
        reqUrl = (URL)http_properties.get("URL");
        InputStream is = null;
        try {
            String encoding;
            boolean gzip;
            String marker;
            int pos;
            HttpURLConnection con = null;
            if (reqUrl.getProtocol().equalsIgnoreCase("https")) {
                HttpsURLConnection ssl_con = (HttpsURLConnection)reqUrl.openConnection();
                ssl_con.setHostnameVerifier(new HostnameVerifier(){

                    public boolean verify(String host, SSLSession session) {
                        return true;
                    }
                });
                con = ssl_con;
            } else {
                con = (HttpURLConnection)reqUrl.openConnection();
            }
            String user_agent = (String)http_properties.get("User-Agent");
            if (user_agent != null) {
                con.setRequestProperty("User-Agent", user_agent);
            }
            con.addRequestProperty("Accept-Encoding", "gzip");
            con.setRequestProperty("Connection", "close");
            con.connect();
            is = con.getInputStream();
            String resulting_url_str = con.getURL().toString();
            if (!reqUrl.toString().equals(resulting_url_str) && (pos = resulting_url_str.indexOf(marker = "permredirect=1")) != -1) {
                --pos;
                try {
                    redirect_url = new URL(resulting_url_str.substring(0, pos));
                }
                catch (Throwable e) {
                    Debug.printStackTrace(e);
                }
            }
            boolean bl = gzip = (encoding = con.getHeaderField("content-encoding")) != null && encoding.equalsIgnoreCase("gzip");
            if (gzip) {
                is = new GZIPInputStream(is);
            }
            byte[] data = new byte[1024];
            int num_read = 0;
            try {
                while (true) {
                    int len;
                    if ((len = is.read(data)) > 0) {
                        message.write(data, 0, len);
                        if ((num_read += len) <= 131072) continue;
                        message.reset();
                        throw new Exception("Tracker response invalid (too large)");
                    }
                    if (len == 0) {
                        Thread.sleep(20L);
                        continue;
                    }
                    break;
                }
            }
            catch (Exception e) {
                if (Logger.isEnabled()) {
                    Logger.log(new LogEvent(LOGID, 3, "Error from scrape interface " + this.scrapeURL + " : " + Debug.getNestedExceptionMessage(e)));
                }
                URL uRL = null;
                if (is != null) {
                    try {
                        is.close();
                    }
                    catch (IOException e1) {
                        // empty catch block
                    }
                }
                return uRL;
            }
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException e1) {}
            }
        }
        return redirect_url;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void scrapeUDP(URL reqUrl, ByteArrayOutputStream message, HashWrapper hash, TRTrackerScraperResponseImpl current_response) throws Exception {
        block17: {
            block16: {
                if (PRUDPPacketTracker.VERSION == 2 && this.scraper.isTorrentDownloading(hash)) {
                    if (Logger.isEnabled()) {
                        Logger.log(new LogEvent((Object)TorrentUtils.getDownloadManager(hash), TrackerStatus.LOGID, 1, "Scrape of " + reqUrl + " skipped as torrent running and " + "therefore scrape data available in " + "announce replies"));
                    }
                    map = new HashMap<String, ByteEncodedKeyHashMap>();
                    files = new ByteEncodedKeyHashMap();
                    map.put("files", files);
                    file = new HashMap<String, Long>();
                    resp_hash = hash.getBytes();
                    files.put(new String(resp_hash, "ISO-8859-1"), file);
                    file.put("complete", new Long(current_response.getSeeds()));
                    file.put("downloaded", new Long(-1L));
                    file.put("incomplete", new Long(current_response.getPeers()));
                    data = BEncoder.encode(map);
                    message.write(data);
                    return;
                }
                reqUrl = TRTrackerUtils.adjustURLForHosting(reqUrl);
                auth = null;
                auth_ok = false;
                try {
                    if (reqUrl.getQuery().toLowerCase().indexOf("auth") != -1) {
                        auth = SESecurityManager.getPasswordAuthentication("UDP Tracker", reqUrl);
                    }
                    port = UDPNetworkManager.getSingleton().getUDPNonDataListeningPortNumber();
                    handler = PRUDPPacketHandlerFactory.getHandler(port);
                    destination = new InetSocketAddress(reqUrl.getHost(), reqUrl.getPort() == -1 ? 80 : reqUrl.getPort());
                    failure_reason = null;
                    for (retry_loop = 0; retry_loop < 1; ++retry_loop) {
                        try {
                            connect_request = new PRUDPPacketRequestConnect();
                            reply = handler.sendAndReceive(auth, connect_request, destination);
                            if (reply.getAction() != 0) ** GOTO lbl109
                            connect_reply = (PRUDPPacketReplyConnect)reply;
                            my_connection = connect_reply.getConnectionId();
                            scrape_request = new PRUDPPacketRequestScrape(my_connection, hash.getBytes());
                            if ((reply = handler.sendAndReceive(auth, scrape_request, destination)).getAction() != 2) ** GOTO lbl-1000
                            auth_ok = true;
                            if (PRUDPPacketTracker.VERSION == 1) {
                                scrape_reply = (PRUDPPacketReplyScrape)reply;
                                map = new HashMap<String, ByteEncodedKeyHashMap>();
                                reply_hashes = scrape_reply.getHashes();
                                complete = scrape_reply.getComplete();
                                downloaded = scrape_reply.getDownloaded();
                                incomplete = scrape_reply.getIncomplete();
                                files = new ByteEncodedKeyHashMap();
                                map.put("files", files);
                                for (i = 0; i < reply_hashes.length; ++i) {
                                    file = new HashMap<String, Long>();
                                    resp_hash = reply_hashes[i];
                                    files.put(new String(resp_hash, "ISO-8859-1"), file);
                                    file.put("complete", new Long(complete[i]));
                                    file.put("downloaded", new Long(downloaded[i]));
                                    file.put("incomplete", new Long(incomplete[i]));
                                }
                                data = BEncoder.encode(map);
                                message.write(data);
                                if (auth == null) return;
                                break block16;
                            }
                            ** GOTO lbl-1000
                        }
                        catch (PRUDPPacketHandlerException e) {
                            if (e.getMessage() == null) throw e;
                            if (e.getMessage().indexOf("timed out") == -1) {
                                throw e;
                            }
                            failure_reason = "Timeout";
                            continue;
                        }
                    }
                    break block17;
                }
                catch (Throwable var28_44) {
                    if (auth == null) throw var28_44;
                    SESecurityManager.setPasswordAuthenticationOutcome(TRTrackerBTAnnouncerImpl.UDP_REALM, reqUrl, auth_ok);
                    throw var28_44;
                }
            }
            SESecurityManager.setPasswordAuthenticationOutcome(TRTrackerBTAnnouncerImpl.UDP_REALM, reqUrl, auth_ok);
            return;
lbl-1000:
            // 1 sources

            {
                scrape_reply = (PRUDPPacketReplyScrape2)reply;
                map = new HashMap<String, ByteEncodedKeyHashMap>();
                complete = scrape_reply.getComplete();
                downloaded = scrape_reply.getDownloaded();
                incomplete = scrape_reply.getIncomplete();
                files = new ByteEncodedKeyHashMap();
                map.put("files", files);
                file = new HashMap<String, Long>();
                resp_hash = hash.getBytes();
                files.put(new String(resp_hash, "ISO-8859-1"), file);
                file.put("complete", new Long(complete[0]));
                file.put("downloaded", new Long(downloaded[0]));
                file.put("incomplete", new Long(incomplete[0]));
                data = BEncoder.encode(map);
                message.write(data);
                if (auth == null) return;
            }
            SESecurityManager.setPasswordAuthenticationOutcome(TRTrackerBTAnnouncerImpl.UDP_REALM, reqUrl, auth_ok);
            return;
lbl-1000:
            // 1 sources

            {
                failure_reason = ((PRUDPPacketReplyError)reply).getMessage();
                if (Logger.isEnabled()) {
                    Logger.log(new LogEvent((Object)TorrentUtils.getDownloadManager(hash), TrackerStatus.LOGID, 3, "Response from scrape interface : " + failure_reason));
                }
                break block17;
lbl109:
                // 1 sources

                failure_reason = ((PRUDPPacketReplyError)reply).getMessage();
                if (!Logger.isEnabled()) break block17;
                Logger.log(new LogEvent((Object)TorrentUtils.getDownloadManager(hash), TrackerStatus.LOGID, 3, "Response from scrape interface : " + ((PRUDPPacketReplyError)reply).getMessage()));
            }
        }
        if (failure_reason != null) {
            map = new HashMap<String, byte[]>();
            map.put("failure reason", failure_reason.getBytes());
            data = BEncoder.encode(map);
            message.write(data);
        }
        if (auth == null) return;
        SESecurityManager.setPasswordAuthenticationOutcome(TRTrackerBTAnnouncerImpl.UDP_REALM, reqUrl, auth_ok);
    }

    protected String getURLParam(String url, String param) {
        int p1 = url.indexOf(param + "=");
        if (p1 == -1) {
            return null;
        }
        int p2 = url.indexOf("&", p1);
        if (p2 == -1) {
            return url.substring(p1 + param.length() + 1);
        }
        return url.substring(p1 + param.length() + 1, p2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected TRTrackerScraperResponseImpl addHash(HashWrapper hash) {
        TRTrackerBTScraperResponseImpl response = new TRTrackerBTScraperResponseImpl(this, hash);
        if (this.scrapeURL == null) {
            response.setStatus(1, MessageText.getString("Scrape.status.error") + MessageText.getString("Scrape.status.error.badURL"));
        } else {
            response.setStatus(0, MessageText.getString("Scrape.status.initializing"));
        }
        response.setNextScrapeStartTime(this.checker.getNextScrapeCheckOn());
        try {
            this.hashes_mon.enter();
            this.hashes.put(hash, response);
        }
        finally {
            this.hashes_mon.exit();
        }
        this.scraper.scrapeReceived(response);
        return response;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void removeHash(HashWrapper hash) {
        try {
            this.hashes_mon.enter();
            this.hashes.remove(hash);
        }
        finally {
            this.hashes_mon.exit();
        }
    }

    protected URL getTrackerURL() {
        return this.tracker_url;
    }

    protected Map getHashes() {
        return this.hashes;
    }

    protected AEMonitor getHashesMonitor() {
        return this.hashes_mon;
    }

    protected void scrapeReceived(TRTrackerScraperResponse response) {
        this.scraper.scrapeReceived(response);
    }

    public boolean getSupportsMultipeHashScrapes() {
        return !this.bSingleHashScrapes;
    }

    protected String getString() {
        return this.tracker_url + ", " + this.scrapeURL + ", multi-scrape=" + !this.bSingleHashScrapes;
    }

    static {
        PRUDPTrackerCodecs.registerCodecs();
        logged_invalid_urls = new ArrayList();
        thread_pool = new ThreadPool("TrackerStatus", 8, true);
    }
}

