/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.core3.disk.impl.piecemapper.impl;

import java.io.File;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.List;
import org.gudy.azureus2.core3.disk.impl.DiskManagerFileInfoImpl;
import org.gudy.azureus2.core3.disk.impl.piecemapper.DMPieceList;
import org.gudy.azureus2.core3.disk.impl.piecemapper.DMPieceMapper;
import org.gudy.azureus2.core3.disk.impl.piecemapper.DMPieceMapperFile;
import org.gudy.azureus2.core3.disk.impl.piecemapper.impl.PieceListImpl;
import org.gudy.azureus2.core3.disk.impl.piecemapper.impl.PieceMapEntryImpl;
import org.gudy.azureus2.core3.internat.LocaleUtilDecoder;
import org.gudy.azureus2.core3.torrent.TOTorrent;
import org.gudy.azureus2.core3.torrent.TOTorrentFile;
import org.gudy.azureus2.core3.util.FileUtil;

public class PieceMapperImpl
implements DMPieceMapper {
    private TOTorrent torrent;
    private long total_length;
    private int piece_count;
    private int piece_length;
    private int last_piece_length;
    protected ArrayList btFileList = new ArrayList();

    public PieceMapperImpl(TOTorrent _torrent) {
        this.torrent = _torrent;
        this.piece_length = (int)this.torrent.getPieceLength();
        this.piece_count = this.torrent.getNumberOfPieces();
        TOTorrentFile[] files = this.torrent.getFiles();
        for (int i = 0; i < files.length; ++i) {
            this.total_length += files[i].getLength();
        }
        this.last_piece_length = (int)(this.total_length - (long)(this.piece_count - 1) * (long)this.piece_length);
    }

    public void construct(LocaleUtilDecoder _locale_decoder, String _save_name) throws UnsupportedEncodingException {
        TOTorrentFile[] torrent_files = this.torrent.getFiles();
        if (this.torrent.isSimpleTorrent()) {
            this.buildFileLookupTables(torrent_files[0], _save_name);
        } else {
            this.buildFileLookupTables(torrent_files, _locale_decoder);
        }
    }

    protected void buildFileLookupTables(TOTorrentFile torrent_file, String fileName) {
        this.btFileList.add(new fileInfo(torrent_file, "", fileName, this.total_length));
    }

    protected void buildFileLookupTables(TOTorrentFile[] torrent_files, LocaleUtilDecoder locale_decoder) throws UnsupportedEncodingException {
        char separator = File.separatorChar;
        for (int i = 0; i < torrent_files.length; ++i) {
            this.buildFileLookupTable(torrent_files[i], locale_decoder, separator);
        }
    }

    private void buildFileLookupTable(TOTorrentFile torrent_file, LocaleUtilDecoder locale_decoder, char separator) throws UnsupportedEncodingException {
        long fileLength = torrent_file.getLength();
        byte[][] path_components = torrent_file.getPathComponents();
        StringBuffer pathBuffer = new StringBuffer(0);
        int lastIndex = path_components.length - 1;
        for (int j = 0; j < lastIndex; ++j) {
            String comp = locale_decoder.decodeString(path_components[j]);
            comp = FileUtil.convertOSSpecificChars(comp);
            pathBuffer.append(comp);
            pathBuffer.append(separator);
        }
        String last_comp = locale_decoder.decodeString(path_components[lastIndex]);
        last_comp = FileUtil.convertOSSpecificChars(last_comp);
        this.btFileList.add(new fileInfo(torrent_file, pathBuffer.toString(), last_comp, fileLength));
    }

    public DMPieceList[] getPieceMap() {
        DMPieceList[] pieceMap = new DMPieceList[this.piece_count];
        int modified_piece_length = this.piece_length;
        if (this.total_length < (long)modified_piece_length) {
            modified_piece_length = (int)this.total_length;
        }
        long fileOffset = 0L;
        int currentFile = 0;
        for (int i = 0; 1 == this.piece_count && i < this.piece_count || i < this.piece_count - 1; ++i) {
            ArrayList<PieceMapEntryImpl> pieceToFileList = new ArrayList<PieceMapEntryImpl>();
            int usedSpace = 0;
            while (modified_piece_length > usedSpace) {
                fileInfo tempFile = (fileInfo)this.btFileList.get(currentFile);
                long length = tempFile.getLength();
                long availableSpace = length - fileOffset;
                PieceMapEntryImpl tempPieceEntry = null;
                if (availableSpace <= (long)(modified_piece_length - usedSpace)) {
                    tempPieceEntry = new PieceMapEntryImpl(tempFile.getFileInfo(), fileOffset, (int)availableSpace);
                    usedSpace = (int)((long)usedSpace + availableSpace);
                    fileOffset = 0L;
                    ++currentFile;
                } else {
                    tempPieceEntry = new PieceMapEntryImpl(tempFile.getFileInfo(), fileOffset, modified_piece_length - usedSpace);
                    fileOffset += (long)(modified_piece_length - usedSpace);
                    usedSpace += modified_piece_length - usedSpace;
                }
                pieceToFileList.add(tempPieceEntry);
            }
            pieceMap[i] = PieceListImpl.convert(pieceToFileList);
        }
        if (this.piece_count > 1) {
            pieceMap[this.piece_count - 1] = PieceListImpl.convert(this.buildLastPieceToFileList(this.btFileList, currentFile, fileOffset));
        }
        return pieceMap;
    }

    private List buildLastPieceToFileList(List file_list, int currentFile, long fileOffset) {
        ArrayList<PieceMapEntryImpl> pieceToFileList = new ArrayList<PieceMapEntryImpl>();
        int usedSpace = 0;
        while (this.last_piece_length > usedSpace) {
            fileInfo tempFile = (fileInfo)file_list.get(currentFile);
            long length = tempFile.getLength();
            long availableSpace = length - fileOffset;
            PieceMapEntryImpl tempPieceEntry = null;
            if (availableSpace <= (long)(this.piece_length - usedSpace)) {
                tempPieceEntry = new PieceMapEntryImpl(tempFile.getFileInfo(), fileOffset, (int)availableSpace);
                usedSpace = (int)((long)usedSpace + availableSpace);
                fileOffset = 0L;
                ++currentFile;
            } else {
                tempPieceEntry = new PieceMapEntryImpl(tempFile.getFileInfo(), fileOffset, this.last_piece_length - usedSpace);
                fileOffset += (long)(this.piece_length - usedSpace);
                usedSpace += this.piece_length - usedSpace;
            }
            pieceToFileList.add(tempPieceEntry);
        }
        return pieceToFileList;
    }

    public long getTotalLength() {
        return this.total_length;
    }

    public int getLastPieceLength() {
        return this.last_piece_length;
    }

    public DMPieceMapperFile[] getFiles() {
        DMPieceMapperFile[] res = new DMPieceMapperFile[this.btFileList.size()];
        this.btFileList.toArray(res);
        return res;
    }

    protected static class fileInfo
    implements DMPieceMapperFile {
        private DiskManagerFileInfoImpl file;
        private TOTorrentFile torrent_file;
        private String path;
        private String name;
        private long length;

        public fileInfo(TOTorrentFile _torrent_file, String _path, String _name, long _length) {
            this.torrent_file = _torrent_file;
            this.path = _path;
            this.length = _length;
            this.name = _name;
        }

        public long getLength() {
            return this.length;
        }

        public File getDataFile() {
            return new File(this.path, this.name);
        }

        public TOTorrentFile getTorrentFile() {
            return this.torrent_file;
        }

        public DiskManagerFileInfoImpl getFileInfo() {
            return this.file;
        }

        public void setFileInfo(DiskManagerFileInfoImpl _file) {
            this.file = _file;
        }
    }
}

