/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.core3.disk.impl;

import org.gudy.azureus2.core3.disk.DiskManager;
import org.gudy.azureus2.core3.disk.DiskManagerPiece;
import org.gudy.azureus2.core3.disk.impl.DiskManagerFileInfoImpl;
import org.gudy.azureus2.core3.disk.impl.DiskManagerImpl;
import org.gudy.azureus2.core3.disk.impl.piecemapper.DMPieceList;
import org.gudy.azureus2.core3.logging.LogIDs;

public class DiskManagerPieceImpl
implements DiskManagerPiece {
    private static final LogIDs LOGID = LogIDs.PIECES;
    public static final int PIECE_STATUS_NEEDED = 1;
    public static final int PIECE_STATUS_WRITTEN = 32;
    public static final int PIECE_STATUS_CHECKING = 64;
    private static final int PIECE_STATUS_MASK_DOWNLOADABLE = 97;
    private static final int PIECE_STATUS_MASK_NEEDS_CHECK = 96;
    private final DiskManagerImpl diskManager;
    private final int pieceNumber;
    private final int length;
    private final int nbBlocks;
    protected volatile boolean[] written;
    private int statusFlags;
    private boolean done;

    protected DiskManagerPieceImpl(DiskManagerImpl _disk_manager, int pieceIndex) {
        this.diskManager = _disk_manager;
        this.pieceNumber = pieceIndex;
        int nbPieces = this.diskManager.getNbPieces();
        this.length = this.pieceNumber != nbPieces - 1 ? this.diskManager.getPieceLength() : this.diskManager.getLastPieceLength();
        this.nbBlocks = (this.length + 16384 - 1) / 16384;
        this.statusFlags = 1;
    }

    public DiskManager getManager() {
        return this.diskManager;
    }

    public int getPieceNumber() {
        return this.pieceNumber;
    }

    public int getLength() {
        return this.length;
    }

    public int getNbBlocks() {
        return this.nbBlocks;
    }

    public int getBlockSize(int blockNumber) {
        if (blockNumber == this.nbBlocks - 1 && this.length % 16384 != 0) {
            return this.length % 16384;
        }
        return 16384;
    }

    public boolean isSkipped() {
        DMPieceList pieceList = this.diskManager.getPieceList(this.pieceNumber);
        for (int i = 0; i < pieceList.size(); ++i) {
            if (pieceList.get(i).getFile().isSkipped()) continue;
            return false;
        }
        return true;
    }

    public boolean isNeeded() {
        return (this.statusFlags & 1) != 0;
    }

    public boolean calcNeeded() {
        boolean filesNeeded = false;
        DMPieceList pieceList = this.diskManager.getPieceList(this.pieceNumber);
        for (int i = 0; i < pieceList.size(); ++i) {
            DiskManagerFileInfoImpl file = pieceList.get(i).getFile();
            long fileLength = file.getLength();
            filesNeeded |= fileLength > 0L && file.getDownloaded() < fileLength && !file.isSkipped();
        }
        if (filesNeeded) {
            this.statusFlags |= 1;
            return true;
        }
        this.statusFlags &= 0xFFFFFFFE;
        return false;
    }

    public void clearNeeded() {
        this.statusFlags &= 0xFFFFFFFE;
    }

    public void setNeeded() {
        this.statusFlags |= 1;
    }

    public void setNeeded(boolean b) {
        this.statusFlags = b ? (this.statusFlags |= 1) : (this.statusFlags &= 0xFFFFFFFE);
    }

    public boolean isWritten() {
        return (this.statusFlags & 0x20) != 0;
    }

    public boolean[] getWritten() {
        return this.written;
    }

    public boolean isWritten(int blockNumber) {
        if (this.done) {
            return true;
        }
        boolean[] writtenRef = this.written;
        if (writtenRef == null) {
            return false;
        }
        return writtenRef[blockNumber];
    }

    public int getNbWritten() {
        if (this.done) {
            return this.nbBlocks;
        }
        boolean[] writtenRef = this.written;
        if (writtenRef == null) {
            return 0;
        }
        int res = 0;
        for (int i = 0; i < this.nbBlocks; ++i) {
            if (!writtenRef[i]) continue;
            ++res;
        }
        return res;
    }

    public void setWritten(int blockNumber) {
        if (this.written == null) {
            this.written = new boolean[this.nbBlocks];
        }
        boolean[] written_ref = this.written;
        written_ref[blockNumber] = true;
        for (int i = 0; i < this.nbBlocks; ++i) {
            if (written_ref[i]) continue;
            return;
        }
        this.statusFlags |= 0x20;
    }

    public boolean isChecking() {
        return (this.statusFlags & 0x40) != 0;
    }

    public boolean calcChecking() {
        return this.isChecking();
    }

    public void clearChecking() {
        this.statusFlags &= 0xFFFFFFBF;
    }

    public void setChecking() {
        this.statusFlags |= 0x40;
    }

    public void setChecking(boolean b) {
        this.statusFlags = b ? (this.statusFlags |= 0x40) : (this.statusFlags &= 0xFFFFFFBF);
    }

    public boolean isNeedsCheck() {
        return !this.done && (this.statusFlags & 0x60) == 32;
    }

    public boolean calcDone() {
        return this.done;
    }

    public boolean isDone() {
        return this.done;
    }

    public void setDone(boolean b) {
        if (b != this.done) {
            this.diskManager.setPieceDone(this, b);
        }
    }

    protected void setDoneSupport(boolean b) {
        this.done = b;
        if (this.done) {
            this.written = null;
        }
    }

    public void setDownloadable() {
        this.setDone(false);
        this.statusFlags &= 0xFFFFFF9E;
        this.calcNeeded();
    }

    public boolean isDownloadable() {
        return !this.done && (this.statusFlags & 0x61) == 1;
    }

    public boolean isInteresting() {
        return !this.done && (this.statusFlags & 1) != 0;
    }

    public void reset() {
        this.setDownloadable();
        this.written = null;
    }

    public void reDownloadBlock(int blockNumber) {
        boolean[] written_ref = this.written;
        if (written_ref != null) {
            written_ref[blockNumber] = false;
            this.setDownloadable();
        }
    }

    public String getString() {
        String text = "";
        text = text + (this.isNeeded() ? "needed," : "");
        text = text + (this.isDone() ? "done," : "");
        if (!this.isDone()) {
            text = text + (this.isDownloadable() ? "downable," : "");
            text = text + (this.isWritten() ? "written" : "written " + this.getNbWritten()) + ",";
            text = text + (this.isChecking() ? "checking" : "");
        }
        if (text.endsWith(",")) {
            text = text.substring(0, text.length() - 1);
        }
        return text;
    }
}

