/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.math.ec;

import java.math.BigInteger;
import org.bouncycastle.math.ec.ECFieldElement;
import org.bouncycastle.math.ec.ECPoint;

public abstract class ECCurve {
    BigInteger q;
    ECFieldElement a;
    ECFieldElement b;

    public ECCurve(BigInteger q, BigInteger a, BigInteger b) {
        this.q = q;
        this.a = this.fromBigInteger(a);
        this.b = this.fromBigInteger(b);
    }

    public abstract ECFieldElement fromBigInteger(BigInteger var1);

    public abstract ECPoint decodePoint(byte[] var1);

    public ECFieldElement getA() {
        return this.a;
    }

    public ECFieldElement getB() {
        return this.b;
    }

    public static class Fp
    extends ECCurve {
        public Fp(BigInteger q, BigInteger a, BigInteger b) {
            super(q, a, b);
        }

        public BigInteger getQ() {
            return this.q;
        }

        public ECFieldElement fromBigInteger(BigInteger x) {
            return new ECFieldElement.Fp(this.q, x);
        }

        public ECPoint decodePoint(byte[] encoded) {
            ECPoint.Fp p = null;
            switch (encoded[0]) {
                case 2: 
                case 3: {
                    int bit0;
                    int ytilde = encoded[0] & 1;
                    byte[] i = new byte[encoded.length - 1];
                    System.arraycopy(encoded, 1, i, 0, i.length);
                    ECFieldElement.Fp x = new ECFieldElement.Fp(this.q, new BigInteger(1, i));
                    ECFieldElement alpha = ((ECFieldElement)x).multiply(((ECFieldElement)x).square()).add(((ECFieldElement)x).multiply(this.a).add(this.b));
                    ECFieldElement beta = alpha.sqrt();
                    if (beta == null) {
                        throw new RuntimeException("Invalid point compression");
                    }
                    int n = bit0 = beta.toBigInteger().testBit(0) ? 0 : 1;
                    if (bit0 == ytilde) {
                        p = new ECPoint.Fp(this, x, beta);
                        break;
                    }
                    p = new ECPoint.Fp(this, x, new ECFieldElement.Fp(this.q, this.q.subtract(beta.toBigInteger())));
                    break;
                }
                case 4: {
                    byte[] xEnc = new byte[(encoded.length - 1) / 2];
                    byte[] yEnc = new byte[(encoded.length - 1) / 2];
                    System.arraycopy(encoded, 1, xEnc, 0, xEnc.length);
                    System.arraycopy(encoded, xEnc.length + 1, yEnc, 0, yEnc.length);
                    p = new ECPoint.Fp(this, new ECFieldElement.Fp(this.q, new BigInteger(1, xEnc)), new ECFieldElement.Fp(this.q, new BigInteger(1, yEnc)));
                    break;
                }
                default: {
                    throw new RuntimeException("Invalid point encoding 0x" + Integer.toString(encoded[0], 16));
                }
            }
            return p;
        }
    }
}

