/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.core.peermanager.unchoker;

import com.aelitis.azureus.core.peermanager.unchoker.GlobalTorrentAwareDownloadingUnchoker;
import com.aelitis.azureus.core.peermanager.unchoker.UnchokerUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import org.gudy.azureus2.core3.peer.PEPeer;
import org.gudy.azureus2.core3.peer.impl.PEPeerTransport;
import org.gudy.azureus2.core3.peer.impl.transport.PEPeerTransportProtocol;

public class MikesUnchoker
extends GlobalTorrentAwareDownloadingUnchoker {
    boolean excessMode = false;

    public GlobalTorrentAwareDownloadingUnchoker.ChokesAndUnchokes calculateChokesAndUnchokes(ArrayList all_peers, long uploadBandwidthToAllocate) {
        double offered_rate;
        int index;
        ArrayList<PEPeerTransportProtocol> chokes = new ArrayList<PEPeerTransportProtocol>();
        ArrayList<PEPeerTransportProtocol> unchokes = new ArrayList<PEPeerTransportProtocol>();
        if (all_peers.size() == 0) {
            return new GlobalTorrentAwareDownloadingUnchoker.ChokesAndUnchokes(chokes, unchokes);
        }
        int upload_cap = this.getUploadCap();
        System.out.println("upload cap is " + upload_cap + " kb/s");
        int total_failures = 0;
        int total_candidates = 0;
        double upload_sum = 0.0;
        for (PEPeerTransport p : all_peers) {
            if (p.isChokingMe() && !p.isChokedByMe()) {
                ++total_failures;
            }
            if (p.isChokedByMe()) continue;
            ++total_candidates;
            upload_sum += ((PEPeerTransportProtocol)p).getTyrantStats().getUploadCost();
        }
        this.market_rate = total_candidates > 2 ? upload_sum / (double)total_candidates : 3.0;
        System.out.println("failures: " + total_failures + " / candidates: " + total_candidates);
        double offeredTotal = 0.0;
        for (PEPeerTransport p : all_peers) {
            if (p.isChokedByMe()) continue;
            offeredTotal += p.getTyrantStats().getUploadCost();
        }
        if (this.excessMode) {
            System.out.println("We are in excess mode. offered total: " + offeredTotal + " / upload_cap: " + upload_cap);
        }
        if (this.market_rate < 1.0) {
            this.market_rate = 1.0;
        }
        System.out.println("market rate (post update): " + this.market_rate);
        PEPeer[] peerArr = new PEPeer[all_peers.size()];
        int pItr = 0;
        for (Object o : all_peers) {
            peerArr[pItr] = (PEPeer)all_peers.get(pItr);
            ++pItr;
        }
        Arrays.sort(peerArr, new Comparator<PEPeer>(){

            @Override
            public int compare(PEPeer o1, PEPeer o2) {
                double diff = o1.getTyrantStats().ratio(MikesUnchoker.this.market_rate) - o2.getTyrantStats().ratio(MikesUnchoker.this.market_rate);
                if (diff > 0.0) {
                    return -1;
                }
                if (diff < 0.0) {
                    return 1;
                }
                return 0;
            }
        });
        double uploadSum = 0.0;
        for (index = 0; index < peerArr.length; ++index) {
            offered_rate = peerArr[index].getTyrantStats().getUploadCost();
            if (offered_rate == 0.0) {
                offered_rate = this.market_rate;
            }
            if (peerArr[index].getTyrantStats().hasObservedInfo() && peerArr[index].getTyrantStats().ratio(this.market_rate) < 1.0 || !(uploadSum + offered_rate < (double)upload_cap) || !peerArr[index].isInteresting() || !UnchokerUtil.isUnchokable((PEPeerTransport)peerArr[index], false)) continue;
            unchokes.add((PEPeerTransportProtocol)peerArr[index]);
            uploadSum += offered_rate;
            peerArr[index].getTyrantStats().updateOfferedRate(offered_rate);
            peerArr[index].setOptimisticUnchoke(false);
        }
        System.out.println("first pass uploadSum: " + uploadSum);
        for (index = 0; index < peerArr.length; ++index) {
            if (unchokes.contains(peerArr[index])) continue;
            offered_rate = peerArr[index].getTyrantStats().getUploadCost();
            if (offered_rate == 0.0) {
                offered_rate = this.market_rate;
            }
            if (!(uploadSum + offered_rate < (double)upload_cap) || !peerArr[index].isInteresting() || !UnchokerUtil.isUnchokable((PEPeerTransport)peerArr[index], false)) continue;
            unchokes.add((PEPeerTransportProtocol)peerArr[index]);
            uploadSum += offered_rate;
            peerArr[index].getTyrantStats().updateOfferedRate(offered_rate);
            peerArr[index].setOptimisticUnchoke(true);
        }
        System.out.println("second pass uploadSum: " + uploadSum);
        Arrays.sort(peerArr, new Comparator<PEPeer>(){

            @Override
            public int compare(PEPeer o1, PEPeer o2) {
                return (int)(o1.getTyrantStats().getLastDownloadUpdate() - o2.getTyrantStats().getLastDownloadUpdate());
            }
        });
        for (index = 0; index < peerArr.length; ++index) {
            if (unchokes.contains(peerArr[index])) continue;
            offered_rate = peerArr[index].getTyrantStats().getUploadCost();
            if (offered_rate == 0.0) {
                offered_rate = this.market_rate;
            }
            if (!(uploadSum + offered_rate < (double)upload_cap) || !UnchokerUtil.isUnchokable((PEPeerTransport)peerArr[index], true)) continue;
            unchokes.add((PEPeerTransportProtocol)peerArr[index]);
            uploadSum += offered_rate;
            peerArr[index].setOptimisticUnchoke(true);
        }
        System.out.println("final pass uploadSum: " + uploadSum);
        System.out.println("final pass unchoked peer count: " + unchokes.size());
        this.excessMode = true;
        for (PEPeerTransportProtocol p : all_peers) {
            if (unchokes.contains(p)) continue;
            chokes.add(p);
            if (!UnchokerUtil.isUnchokable(p, true)) continue;
            this.excessMode = false;
        }
        return new GlobalTorrentAwareDownloadingUnchoker.ChokesAndUnchokes(chokes, unchokes);
    }
}

