/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.core.peermanager.unchoker;

import com.aelitis.azureus.core.peermanager.unchoker.GlobalTorrentAwareDownloadingUnchoker;
import com.aelitis.azureus.core.peermanager.unchoker.HistoricalDataPoint;
import com.aelitis.azureus.core.peermanager.unchoker.UnchokerUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import org.gudy.azureus2.core3.peer.PEPeer;
import org.gudy.azureus2.core3.peer.impl.PEPeerTransport;
import org.gudy.azureus2.core3.peer.impl.transport.PEPeerTransportProtocol;

public class JarUnchoker
extends GlobalTorrentAwareDownloadingUnchoker {
    long lastTotalAllocation = 0L;
    public static boolean EVENLY_ALLOCATE_EXCESS_BANDIWDTH = true;
    public static long ABSOLUTE_MINIMUM_ALLOCATION_PER_PEER = 30000L;
    private static GlobalTorrentAwareDownloadingUnchoker.ChokesAndUnchokes cache = null;
    private static long lastCalled = 0L;

    public GlobalTorrentAwareDownloadingUnchoker.ChokesAndUnchokes calculateChokesAndUnchokes(ArrayList all_peers, long uploadBandwidthToAllocate) {
        if (cache != null && lastCalled + 5000L > System.currentTimeMillis()) {
            System.out.println("hit cache");
            return cache;
        }
        ArrayList<PEPeerTransportProtocol> chokes = new ArrayList<PEPeerTransportProtocol>();
        ArrayList<PEPeerTransportProtocol> unchokes = new ArrayList<PEPeerTransportProtocol>();
        System.out.println("allocating " + uploadBandwidthToAllocate + " bytes for the next 10 sec");
        long unusedBandwidthLastRound = 0L;
        long allocatedBandwidthLastRound = 0L;
        long unusedBandwidthFromFlippedPeers = 0L;
        int numUnchoked = 0;
        int numPeersThatFlipped = 0;
        for (PEPeerTransportProtocol pet : all_peers) {
            if (pet.isChokedByMe()) continue;
            unusedBandwidthLastRound += (long)pet.getNetworkConnection().getBandwidthLimit();
            allocatedBandwidthLastRound += pet.getTyrantStats().getLastUploadAllocation();
            ++numUnchoked;
            if (pet.isInterested()) continue;
            ++numPeersThatFlipped;
            unusedBandwidthFromFlippedPeers += (long)pet.getNetworkConnection().getBandwidthLimit();
        }
        double percent = (double)unusedBandwidthLastRound / (double)allocatedBandwidthLastRound;
        System.out.println("Allocation percent unused last round: " + percent);
        System.out.println(numPeersThatFlipped + " peers out of " + numUnchoked + " peers went from interested to uninterested in the last round");
        System.out.println(unusedBandwidthFromFlippedPeers + " bytes were left allocated to the peers that flipped");
        int fallbackAllocation = 120000;
        Collections.sort(all_peers);
        for (int apit = 0; apit < all_peers.size() && uploadBandwidthToAllocate > 0L; ++apit) {
            PEPeerTransport pep = (PEPeerTransport)all_peers.get(apit);
            if (!UnchokerUtil.isUnchokable(pep, true) || pep.isChokedByMe()) continue;
            long toAllocate = pep.getTyrantStats().getLastUploadAllocation();
            if (toAllocate == 0L) {
                toAllocate = fallbackAllocation;
            }
            long penalty = Math.max(0, ((PEPeerTransportProtocol)pep).getNetworkConnection().getBandwidthLimit() / 3);
            toAllocate -= penalty;
            System.out.println(pep + " just lost " + penalty + " bytes because it didn't pull fast enough");
            toAllocate = Math.max(toAllocate, ABSOLUTE_MINIMUM_ALLOCATION_PER_PEER);
            pep.getTyrantStats().setLastUploadAllocation(toAllocate);
        }
        for (PEPeerTransport pep : all_peers) {
            if (((PEPeerTransportProtocol)pep).getStats() == null) continue;
            long sent = ((PEPeerTransportProtocol)pep).getStats().getTotalDataBytesSent();
            long received = ((PEPeerTransportProtocol)pep).getStats().getTotalDataBytesReceived();
            ((PEPeerTransportProtocol)pep).getTyrantStats().updateHistory(new HistoricalDataPoint(sent, received));
        }
        Boolean[] arr$ = new Boolean[]{false, true};
        int len$ = arr$.length;
        for (int i$ = 0; i$ < len$; ++i$) {
            long toAllocate;
            PEPeerTransport pep;
            boolean allow_snubbed = arr$[i$];
            Iterator pit = all_peers.iterator();
            while (pit.hasNext() && uploadBandwidthToAllocate > 0L) {
                pep = (PEPeerTransportProtocol)pit.next();
                if (!UnchokerUtil.isUnchokable(pep, allow_snubbed) || ((PEPeerTransportProtocol)pep).getTyrantStats().getDataBytesReceivedInTheLast(60L) <= ((PEPeerTransportProtocol)pep).getTyrantStats().getDataBytesSentInTheLast(60L) || ((PEPeerTransportProtocol)pep).isSelfishTyrantPeer()) continue;
                toAllocate = ((PEPeerTransportProtocol)pep).getTyrantStats().getLastUploadAllocation();
                if (toAllocate == 0L) {
                    toAllocate = fallbackAllocation;
                }
                toAllocate = (long)((double)toAllocate * 0.98);
                ((PEPeerTransportProtocol)pep).getTyrantStats().setLastUploadAllocation((int)toAllocate);
                uploadBandwidthToAllocate -= toAllocate;
                System.out.println("kept " + pep + " because they were sending us more than we sent them");
                ((PEPeerTransportProtocol)pep).getTyrantStats().setLastTyrantAction("Decreased upload allocation because of recent upload download ratio.");
                ((PEPeerTransportProtocol)pep).getNetworkConnection().setBandwidth((int)toAllocate);
                System.out.println(pep + " got " + toAllocate + " bytes for the next 10 sec");
                unchokes.add((PEPeerTransportProtocol)pep);
                pit.remove();
            }
            while (pit.hasNext()) {
                pit.next();
            }
            pit = all_peers.iterator();
            while (pit.hasNext() && uploadBandwidthToAllocate > 0L) {
                pep = (PEPeerTransportProtocol)pit.next();
                if (!UnchokerUtil.isUnchokable(pep, allow_snubbed) || ((PEPeerTransportProtocol)pep).getTyrantStats().getDataBytesReceivedInTheLast(60L) >= ((PEPeerTransportProtocol)pep).getTyrantStats().getDataBytesSentInTheLast(60L) || ((PEPeerTransportProtocol)pep).getTyrantStats().getDataBytesReceivedInTheLast(60L) <= 90000L || ((PEPeerTransportProtocol)pep).isSelfishTyrantPeer()) continue;
                toAllocate = ((PEPeerTransportProtocol)pep).getTyrantStats().getLastUploadAllocation();
                if (toAllocate == 0L) {
                    toAllocate = fallbackAllocation;
                }
                toAllocate = (long)((double)toAllocate * 0.98);
                ((PEPeerTransportProtocol)pep).getTyrantStats().setLastUploadAllocation((int)toAllocate);
                uploadBandwidthToAllocate -= toAllocate;
                System.out.println("kept " + pep + " because they were sending us data and their upload might be maxed");
                ((PEPeerTransportProtocol)pep).getTyrantStats().setLastTyrantAction("Decreased upload allocation because we might have found their max upload rate.");
                ((PEPeerTransportProtocol)pep).getNetworkConnection().setBandwidth((int)toAllocate);
                System.out.println(pep + " got " + toAllocate + " bytes for the next 10 sec");
                unchokes.add((PEPeerTransportProtocol)pep);
                pit.remove();
            }
            while (pit.hasNext()) {
                pit.next();
            }
            pit = all_peers.iterator();
            while (pit.hasNext() && uploadBandwidthToAllocate > 0L) {
                pep = (PEPeerTransport)pit.next();
                if (!UnchokerUtil.isUnchokable(pep, allow_snubbed) || pep.getStats() == null || pep.getStats().getTotalDataBytesSent() == 0L || !((double)pep.getStats().getTotalDataBytesReceived() / (double)pep.getStats().getTotalDataBytesSent() > 1.0) || pep.isSelfishTyrantPeer()) continue;
                toAllocate = pep.getTyrantStats().getLastUploadAllocation();
                if ((toAllocate = (long)((double)toAllocate * 1.1)) == 0L) {
                    toAllocate = fallbackAllocation;
                }
                ((PEPeerTransportProtocol)pep).getTyrantStats().setLastUploadAllocation((int)toAllocate);
                uploadBandwidthToAllocate -= toAllocate;
                System.out.println("kept " + pep + " because it had a good historic ratio");
                System.out.println(pep + " got " + toAllocate + " bytes for the next 10 sec");
                pep.getTyrantStats().setLastTyrantAction("Increased upload allocation because they weren't recipricating and they have a good historic ratio");
                unchokes.add((PEPeerTransportProtocol)pep);
                pit.remove();
            }
            while (pit.hasNext()) {
                pit.next();
            }
            pit = all_peers.iterator();
            while (pit.hasNext() && uploadBandwidthToAllocate > 0L) {
                long owed;
                pep = (PEPeerTransportProtocol)pit.next();
                if (!UnchokerUtil.isUnchokable(pep, allow_snubbed) || !((PEPeerTransportProtocol)pep).isSelfishTyrantPeer()) continue;
                long received = ((PEPeerTransportProtocol)pep).getStats().getTotalDataBytesReceived();
                long sent = ((PEPeerTransportProtocol)pep).getStats().getTotalDataBytesSent();
                if (sent < 100000L) {
                    owed = 32768L;
                } else {
                    long maxWillingToSend = received + received / 4L;
                    owed = maxWillingToSend - sent;
                }
                owed = Math.min(owed, uploadBandwidthToAllocate);
                if (owed > 0L) {
                    ((PEPeerTransportProtocol)pep).getTyrantStats().setLastUploadAllocation((int)owed);
                    uploadBandwidthToAllocate -= owed;
                    ((PEPeerTransportProtocol)pep).getTyrantStats().setLastTyrantAction("Allocated to a selfish peer");
                    unchokes.add((PEPeerTransportProtocol)pep);
                    System.out.println(pep + " got " + owed + " bytes for the next 10 sec");
                    ((PEPeerTransportProtocol)pep).getNetworkConnection().setBandwidth((int)owed);
                }
                pit.remove();
            }
            while (pit.hasNext()) {
                pit.next();
            }
            pit = all_peers.iterator();
            while (pit.hasNext() && uploadBandwidthToAllocate > 0L) {
                pep = (PEPeerTransportProtocol)pit.next();
                if (!UnchokerUtil.isUnchokable(pep, allow_snubbed)) continue;
                toAllocate = ((PEPeerTransportProtocol)pep).getTyrantStats().getLastUploadAllocation();
                if ((toAllocate = (long)((double)toAllocate * 1.1)) == 0L) {
                    toAllocate = fallbackAllocation;
                }
                uploadBandwidthToAllocate -= toAllocate;
                ((PEPeerTransportProtocol)pep).getTyrantStats().setLastUploadAllocation((int)toAllocate);
                System.out.println(pep + " was unchoked because we have excess bandwidth and we're picking peers with bad ratios");
                ((PEPeerTransportProtocol)pep).getTyrantStats().setLastTyrantAction("Bad ratio peer, but increased upload allocation because we already met upload requirements of better peers");
                unchokes.add((PEPeerTransportProtocol)pep);
                pit.remove();
                ((PEPeerTransportProtocol)pep).getNetworkConnection().setBandwidth((int)toAllocate);
                System.out.println(pep + " got " + toAllocate + " bytes for the next 10 sec");
            }
            while (pit.hasNext()) {
                pit.next();
            }
        }
        for (Object o : all_peers) {
            if (unchokes.contains(o)) continue;
            chokes.add((PEPeerTransportProtocol)o);
            ((PEPeer)o).getTyrantStats().setLastTyrantAction("choked");
        }
        for (PEPeerTransportProtocol pep : chokes) {
            if (pep.getNetworkConnection() == null) continue;
            pep.getNetworkConnection().setBandwidth((int)ABSOLUTE_MINIMUM_ALLOCATION_PER_PEER);
        }
        long totalUploadAllocated = 0L;
        for (PEPeerTransportProtocol pep : unchokes) {
            totalUploadAllocated += pep.getTyrantStats().getLastUploadAllocation();
        }
        for (PEPeerTransportProtocol pep : unchokes) {
            double connectionWeight = pep.getTyrantStats().getLastUploadAllocation();
            pep.getNetworkConnection().setWeight(connectionWeight);
            System.out.println("weight of " + connectionWeight + " assigned to " + pep.getNetworkConnection());
        }
        lastCalled = System.currentTimeMillis();
        cache = new GlobalTorrentAwareDownloadingUnchoker.ChokesAndUnchokes(chokes, unchokes);
        return cache;
    }
}

