/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.core.peermanager;

import com.aelitis.azureus.core.networkmanager.NetworkConnection;
import com.aelitis.azureus.core.networkmanager.NetworkManager;
import com.aelitis.azureus.core.networkmanager.impl.IncomingConnectionManager;
import com.aelitis.azureus.core.peermanager.PeerManagerRegistration;
import com.aelitis.azureus.core.peermanager.PeerManagerRegistrationAdapter;
import com.aelitis.azureus.core.peermanager.download.TorrentDownload;
import com.aelitis.azureus.core.peermanager.download.TorrentDownloadFactory;
import com.aelitis.azureus.core.peermanager.messaging.MessageManager;
import com.aelitis.azureus.core.peermanager.messaging.MessageStreamDecoder;
import com.aelitis.azureus.core.peermanager.messaging.MessageStreamEncoder;
import com.aelitis.azureus.core.peermanager.messaging.MessageStreamFactory;
import com.aelitis.azureus.core.peermanager.messaging.bittorrent.BTMessageDecoder;
import com.aelitis.azureus.core.peermanager.messaging.bittorrent.BTMessageEncoder;
import com.aelitis.azureus.core.peermanager.piecepicker.util.BitFlags;
import com.aelitis.azureus.core.util.bloom.BloomFilter;
import com.aelitis.azureus.core.util.bloom.BloomFilterFactory;
import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.gudy.azureus2.core3.config.COConfigurationManager;
import org.gudy.azureus2.core3.logging.LogEvent;
import org.gudy.azureus2.core3.logging.LogIDs;
import org.gudy.azureus2.core3.logging.Logger;
import org.gudy.azureus2.core3.peer.PEPeer;
import org.gudy.azureus2.core3.peer.PEPeerListener;
import org.gudy.azureus2.core3.peer.impl.PEPeerControl;
import org.gudy.azureus2.core3.peer.impl.PEPeerTransport;
import org.gudy.azureus2.core3.peer.impl.PEPeerTransportFactory;
import org.gudy.azureus2.core3.peer.util.PeerIdentityManager;
import org.gudy.azureus2.core3.util.AEMonitor;
import org.gudy.azureus2.core3.util.AEThread;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.HashWrapper;
import org.gudy.azureus2.core3.util.SystemTime;

public class PeerManager {
    private static final LogIDs LOGID = LogIDs.PEER;
    private static final PeerManager instance = new PeerManager();
    private static final int PENDING_TIMEOUT = 10000;
    private static final AEMonitor timer_mon = new AEMonitor("PeerManager:timeouts");
    private static Thread timer_thread;
    private static Set timer_targets;
    private final HashMap registered_legacy_managers = new HashMap();
    private final ByteBuffer legacy_handshake_header;
    private final AEMonitor managers_mon = new AEMonitor("PeerManager:managers");

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static void registerForTimeouts(PeerManagerRegistrationImpl reg) {
        try {
            timer_mon.enter();
            timer_targets.add(reg);
            if (timer_thread == null) {
                timer_thread = new AEThread("PeerManager:timeouts", true){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public void runSupport() {
                        int idle_time = 0;
                        block6: while (true) {
                            try {
                                Thread.sleep(5000L);
                            }
                            catch (Throwable e) {
                                // empty catch block
                            }
                            try {
                                timer_mon.enter();
                                if (timer_targets.size() == 0) {
                                    if ((idle_time += 5000) < 30000) continue;
                                    timer_thread = null;
                                    break;
                                }
                                idle_time = 0;
                                Iterator it = timer_targets.iterator();
                                while (true) {
                                    if (!it.hasNext()) continue block6;
                                    PeerManagerRegistrationImpl registration = (PeerManagerRegistrationImpl)it.next();
                                    if (registration.timeoutCheck()) continue;
                                    it.remove();
                                }
                            }
                            finally {
                                timer_mon.exit();
                                continue;
                            }
                            break;
                        }
                    }
                };
                timer_thread.start();
            }
        }
        finally {
            timer_mon.exit();
        }
    }

    public static PeerManager getSingleton() {
        return instance;
    }

    private PeerManager() {
        this.legacy_handshake_header = ByteBuffer.allocate(20);
        this.legacy_handshake_header.put((byte)"BitTorrent protocol".length());
        this.legacy_handshake_header.put("BitTorrent protocol".getBytes());
        this.legacy_handshake_header.flip();
        MessageManager.getSingleton().initialize();
        NetworkManager.ByteMatcher matcher = new NetworkManager.ByteMatcher(){

            public int size() {
                return 48;
            }

            public int minSize() {
                return 20;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public Object matches(InetSocketAddress address, ByteBuffer to_compare, int port) {
                int old_limit = to_compare.limit();
                int old_position = to_compare.position();
                to_compare.limit(old_position + 20);
                PeerManagerRegistrationImpl routing_data = null;
                if (to_compare.equals(PeerManager.this.legacy_handshake_header)) {
                    to_compare.limit(old_position + 48);
                    to_compare.position(old_position + 28);
                    byte[] hash = new byte[to_compare.remaining()];
                    to_compare.get(hash);
                    try {
                        PeerManager.this.managers_mon.enter();
                        List registrations = (List)PeerManager.this.registered_legacy_managers.get(new HashWrapper(hash));
                        if (registrations != null) {
                            routing_data = (PeerManagerRegistrationImpl)registrations.get(0);
                        }
                    }
                    finally {
                        PeerManager.this.managers_mon.exit();
                    }
                }
                to_compare.limit(old_limit);
                to_compare.position(old_position);
                if (routing_data != null && !routing_data.isActive()) {
                    if (routing_data.isKnownSeed(address)) {
                        if (Logger.isEnabled()) {
                            Logger.log(new LogEvent(LOGID, "Activation request from " + address + " denied as known seed"));
                        }
                        routing_data = null;
                    } else if (!routing_data.getAdapter().activateRequest(address)) {
                        if (Logger.isEnabled()) {
                            Logger.log(new LogEvent(LOGID, "Activation request from " + address + " denied by rules"));
                        }
                        routing_data = null;
                    }
                }
                return routing_data;
            }

            public Object minMatches(InetSocketAddress address, ByteBuffer to_compare, int port) {
                boolean matches = false;
                int old_limit = to_compare.limit();
                int old_position = to_compare.position();
                to_compare.limit(old_position + 20);
                if (to_compare.equals(PeerManager.this.legacy_handshake_header)) {
                    matches = true;
                }
                to_compare.limit(old_limit);
                to_compare.position(old_position);
                return matches ? "" : null;
            }

            public byte[] getSharedSecret() {
                return null;
            }
        };
        NetworkManager.getSingleton().requestIncomingConnectionRouting(matcher, new NetworkManager.RoutingListener(){

            public void connectionRouted(NetworkConnection connection, Object routing_data) {
                PeerManagerRegistrationImpl registration = (PeerManagerRegistrationImpl)routing_data;
                registration.route(connection);
            }

            public boolean autoCryptoFallback() {
                return false;
            }
        }, new MessageStreamFactory(){

            public MessageStreamEncoder createEncoder() {
                return new BTMessageEncoder();
            }

            public MessageStreamDecoder createDecoder() {
                return new BTMessageDecoder();
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PeerManagerRegistration registerLegacyManager(HashWrapper hash, PeerManagerRegistrationAdapter adapter) {
        try {
            this.managers_mon.enter();
            ArrayList<PeerManagerRegistrationImpl> registrations = (ArrayList<PeerManagerRegistrationImpl>)this.registered_legacy_managers.get(hash);
            if (registrations == null) {
                registrations = new ArrayList<PeerManagerRegistrationImpl>(1);
                this.registered_legacy_managers.put(hash, registrations);
                IncomingConnectionManager.getSingleton().addSharedSecret(hash.getBytes());
            }
            PeerManagerRegistrationImpl registration = new PeerManagerRegistrationImpl(hash, adapter);
            registrations.add(registration);
            PeerManagerRegistrationImpl peerManagerRegistrationImpl = registration;
            return peerManagerRegistrationImpl;
        }
        finally {
            this.managers_mon.exit();
        }
    }

    static {
        timer_targets = new HashSet();
    }

    private class PeerManagerRegistrationImpl
    implements PeerManagerRegistration {
        private HashWrapper hash;
        private PeerManagerRegistrationAdapter adapter;
        private TorrentDownload download;
        private volatile PEPeerControl active_control;
        private List pending_connections;
        private BloomFilter known_seeds;

        protected PeerManagerRegistrationImpl(HashWrapper _hash, PeerManagerRegistrationAdapter _adapter) {
            this.hash = _hash;
            this.adapter = _adapter;
        }

        protected HashWrapper getHash() {
            return this.hash;
        }

        protected PeerManagerRegistrationAdapter getAdapter() {
            return this.adapter;
        }

        public boolean isActive() {
            return this.active_control != null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void activate(PEPeerControl _active_control) {
            List connections = null;
            try {
                PeerManager.this.managers_mon.enter();
                this.active_control = _active_control;
                if (this.download != null) {
                    Debug.out("Already activated");
                }
                this.download = TorrentDownloadFactory.getSingleton().createDownload(this.active_control);
                connections = this.pending_connections;
                this.pending_connections = null;
            }
            finally {
                PeerManager.this.managers_mon.exit();
            }
            if (connections != null) {
                for (int i = 0; i < connections.size(); ++i) {
                    Object[] entry = (Object[])connections.get(i);
                    NetworkConnection nc = (NetworkConnection)entry[0];
                    this.route(_active_control, nc, true);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void deactivate() {
            try {
                PeerManager.this.managers_mon.enter();
                if (this.download == null) {
                    Debug.out("Already deactivated");
                } else {
                    this.download.destroy();
                    this.download = null;
                }
                this.active_control = null;
                if (this.pending_connections != null) {
                    for (int i = 0; i < this.pending_connections.size(); ++i) {
                        Object[] entry = (Object[])this.pending_connections.get(i);
                        NetworkConnection connection = (NetworkConnection)entry[0];
                        if (Logger.isEnabled()) {
                            Logger.log(new LogEvent(LOGID, 1, "Incoming connection from [" + connection + "] closed due to deactivation"));
                        }
                        connection.close();
                    }
                    this.pending_connections = null;
                }
            }
            finally {
                PeerManager.this.managers_mon.exit();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void unregister() {
            try {
                List registrations;
                PeerManager.this.managers_mon.enter();
                if (this.active_control != null) {
                    Debug.out("Not deactivated");
                    this.deactivate();
                }
                if ((registrations = (List)PeerManager.this.registered_legacy_managers.get(this.hash)) == null) {
                    Debug.out("manager already deregistered");
                } else if (registrations.remove(this)) {
                    if (registrations.size() == 0) {
                        IncomingConnectionManager.getSingleton().removeSharedSecret(this.hash.getBytes());
                        PeerManager.this.registered_legacy_managers.remove(this.hash);
                    }
                } else {
                    Debug.out("manager already deregistered");
                }
            }
            finally {
                PeerManager.this.managers_mon.exit();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected boolean isKnownSeed(InetSocketAddress address) {
            try {
                PeerManager.this.managers_mon.enter();
                if (this.known_seeds == null) {
                    boolean bl = false;
                    return bl;
                }
                boolean bl = this.known_seeds.contains(address.getAddress().getAddress());
                return bl;
            }
            finally {
                PeerManager.this.managers_mon.exit();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void setKnownSeed(InetSocketAddress address) {
            try {
                PeerManager.this.managers_mon.enter();
                if (this.known_seeds == null) {
                    this.known_seeds = BloomFilterFactory.createAddOnly(1024);
                }
                this.known_seeds.add(address.getAddress().getAddress());
            }
            finally {
                PeerManager.this.managers_mon.exit();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void route(NetworkConnection connection) {
            PEPeerControl control;
            boolean register_for_timeouts = false;
            try {
                PeerManager.this.managers_mon.enter();
                control = this.active_control;
                if (control == null) {
                    if (this.pending_connections != null && this.pending_connections.size() > 10) {
                        if (Logger.isEnabled()) {
                            Logger.log(new LogEvent(LOGID, 1, "Incoming connection from [" + connection + "] dropped too many pending activations"));
                        }
                        connection.close();
                    } else {
                        if (this.pending_connections == null) {
                            this.pending_connections = new ArrayList();
                        }
                        this.pending_connections.add(new Object[]{connection, new Long(SystemTime.getCurrentTime())});
                        if (this.pending_connections.size() == 1) {
                            register_for_timeouts = true;
                        }
                    }
                }
            }
            finally {
                PeerManager.this.managers_mon.exit();
            }
            if (register_for_timeouts) {
                PeerManager.registerForTimeouts(this);
            }
            if (control != null) {
                this.route(control, connection, false);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected boolean timeoutCheck() {
            try {
                PeerManager.this.managers_mon.enter();
                if (this.pending_connections == null) {
                    boolean bl = false;
                    return bl;
                }
                Iterator it = this.pending_connections.iterator();
                long now = SystemTime.getCurrentTime();
                while (it.hasNext()) {
                    Object[] entry = (Object[])it.next();
                    long start_time = (Long)entry[1];
                    if (now < start_time) {
                        entry[1] = new Long(now);
                        continue;
                    }
                    if (now - start_time <= 10000L) continue;
                    it.remove();
                    NetworkConnection connection = (NetworkConnection)entry[0];
                    if (Logger.isEnabled()) {
                        Logger.log(new LogEvent(LOGID, 1, "Incoming connection from [" + connection + "] closed due to activation timeout"));
                    }
                    connection.close();
                }
                if (this.pending_connections.size() == 0) {
                    this.pending_connections = null;
                }
                boolean bl = this.pending_connections != null;
                return bl;
            }
            finally {
                PeerManager.this.managers_mon.exit();
            }
        }

        protected void route(PEPeerControl control, final NetworkConnection connection, boolean is_activation) {
            boolean same_allowed;
            String host_address = connection.getEndpoint().getNotionalAddress().getAddress().getHostAddress();
            boolean bl = same_allowed = COConfigurationManager.getBooleanParameter("Allow Same IP Peers") || host_address.equals("127.0.0.1");
            if (!same_allowed && PeerIdentityManager.containsIPAddress(control.getPeerIdentityDataID(), host_address)) {
                if (Logger.isEnabled()) {
                    Logger.log(new LogEvent(LOGID, 1, "Incoming connection from [" + connection + "] dropped as IP address already " + "connected for [" + control.getDisplayName() + "]"));
                }
                connection.close();
                return;
            }
            if (Logger.isEnabled()) {
                Logger.log(new LogEvent(LOGID, "Incoming connection from [" + connection + "] routed to legacy download [" + control.getDisplayName() + "]"));
            }
            PEPeerTransport pt = PEPeerTransportFactory.createTransport(control, "Incoming", connection);
            if (is_activation) {
                pt.addListener(new PEPeerListener(){

                    public void stateChanged(PEPeer peer, int new_state) {
                        if (new_state == 40 && peer.isSeed()) {
                            InetSocketAddress address = connection.getEndpoint().getNotionalAddress();
                            PeerManagerRegistrationImpl.this.setKnownSeed(address);
                            PeerManagerRegistrationImpl.this.adapter.deactivateRequest(address);
                        }
                    }

                    public void sentBadChunk(PEPeer peer, int piece_num, int total_bad_chunks) {
                    }

                    public void addAvailability(PEPeer peer, BitFlags peerHavePieces) {
                    }

                    public void removeAvailability(PEPeer peer, BitFlags peerHavePieces) {
                    }
                });
            }
            control.addPeerTransport(pt);
        }
    }
}

