/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.core.networkmanager.impl;

import com.aelitis.azureus.core.networkmanager.NetworkManager;
import com.aelitis.azureus.core.networkmanager.Transport;
import com.aelitis.azureus.core.networkmanager.impl.ProtocolDecoder;
import com.aelitis.azureus.core.networkmanager.impl.TransportHelper;
import com.aelitis.azureus.core.networkmanager.impl.TransportHelperFilter;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.gudy.azureus2.core3.logging.LogEvent;
import org.gudy.azureus2.core3.logging.LogIDs;
import org.gudy.azureus2.core3.logging.Logger;
import org.gudy.azureus2.core3.util.AEMonitor;
import org.gudy.azureus2.core3.util.ByteFormatter;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.SimpleTimer;
import org.gudy.azureus2.core3.util.SystemTime;
import org.gudy.azureus2.core3.util.TimerEvent;
import org.gudy.azureus2.core3.util.TimerEventPerformer;

public class IncomingConnectionManager {
    private static final LogIDs LOGID = LogIDs.NWMAN;
    private static IncomingConnectionManager singleton = new IncomingConnectionManager();
    private volatile Map match_buffers_cow = new HashMap();
    private final AEMonitor match_buffers_mon = new AEMonitor("IncomingConnectionManager:match");
    private int max_match_buffer_size = 0;
    private int max_min_match_buffer_size = 0;
    private final ArrayList connections = new ArrayList();
    private final AEMonitor connections_mon = new AEMonitor("IncomingConnectionManager:conns");

    public static IncomingConnectionManager getSingleton() {
        return singleton;
    }

    protected IncomingConnectionManager() {
        SimpleTimer.addPeriodicEvent("IncomingConnectionManager:timeouts", 5000L, new TimerEventPerformer(){

            public void perform(TimerEvent ev) {
                IncomingConnectionManager.this.doTimeoutChecks();
            }
        });
    }

    public boolean isEmpty() {
        return this.match_buffers_cow.isEmpty();
    }

    public Object[] checkForMatch(TransportHelper transport, int incoming_port, ByteBuffer to_check, boolean min_match) {
        int orig_position = to_check.position();
        int orig_limit = to_check.limit();
        to_check.position(0);
        MatchListener listener = null;
        Object routing_data = null;
        for (Map.Entry entry : this.match_buffers_cow.entrySet()) {
            NetworkManager.ByteMatcher bm = (NetworkManager.ByteMatcher)entry.getKey();
            MatchListener this_listener = (MatchListener)entry.getValue();
            if (min_match) {
                if (orig_position < bm.minSize() || (routing_data = bm.minMatches(transport.getAddress(), to_check, incoming_port)) == null) continue;
                listener = this_listener;
                break;
            }
            if (orig_position < bm.size() || (routing_data = bm.matches(transport.getAddress(), to_check, incoming_port)) == null) continue;
            listener = this_listener;
            break;
        }
        to_check.position(orig_position);
        to_check.limit(orig_limit);
        if (listener == null) {
            return null;
        }
        return new Object[]{listener, routing_data};
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerMatchBytes(NetworkManager.ByteMatcher matcher, MatchListener listener) {
        try {
            this.match_buffers_mon.enter();
            if (matcher.size() > this.max_match_buffer_size) {
                this.max_match_buffer_size = matcher.size();
            }
            if (matcher.minSize() > this.max_min_match_buffer_size) {
                this.max_min_match_buffer_size = matcher.minSize();
            }
            HashMap<NetworkManager.ByteMatcher, MatchListener> new_match_buffers = new HashMap<NetworkManager.ByteMatcher, MatchListener>(this.match_buffers_cow);
            new_match_buffers.put(matcher, listener);
            this.match_buffers_cow = new_match_buffers;
            this.addSharedSecret(matcher.getSharedSecret());
        }
        finally {
            this.match_buffers_mon.exit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deregisterMatchBytes(NetworkManager.ByteMatcher to_remove) {
        try {
            this.match_buffers_mon.enter();
            HashMap new_match_buffers = new HashMap(this.match_buffers_cow);
            new_match_buffers.remove(to_remove);
            if (to_remove.size() == this.max_match_buffer_size) {
                this.max_match_buffer_size = 0;
                for (NetworkManager.ByteMatcher bm : new_match_buffers.keySet()) {
                    if (bm.size() <= this.max_match_buffer_size) continue;
                    this.max_match_buffer_size = bm.size();
                }
            }
            this.match_buffers_cow = new_match_buffers;
            this.removeSharedSecret(to_remove.getSharedSecret());
        }
        finally {
            this.match_buffers_mon.exit();
        }
    }

    public void addSharedSecret(byte[] secret) {
        if (secret != null) {
            ProtocolDecoder.addSecret(secret);
        }
    }

    public void removeSharedSecret(byte[] secret) {
        if (secret != null) {
            ProtocolDecoder.removeSecret(secret);
        }
    }

    public int getMaxMatchBufferSize() {
        return this.max_match_buffer_size;
    }

    public int getMaxMinMatchBufferSize() {
        return this.max_min_match_buffer_size;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addConnection(int local_port, TransportHelperFilter filter, Transport new_transport) {
        TransportHelper transport_helper = filter.getHelper();
        if (this.isEmpty()) {
            if (Logger.isEnabled()) {
                Logger.log(new LogEvent(LOGID, "Incoming connection from [" + transport_helper.getAddress() + "] dropped because zero routing handlers registered"));
            }
            transport_helper.close("No routing handler");
            return;
        }
        IncomingConnection ic = new IncomingConnection(filter, this.getMaxMatchBufferSize());
        SelectorListener sel_listener = new SelectorListener(local_port, new_transport);
        try {
            this.connections_mon.enter();
            this.connections.add(ic);
            transport_helper.registerForReadSelects(sel_listener, ic);
        }
        finally {
            this.connections_mon.exit();
        }
        sel_listener.selectSuccess(transport_helper, ic);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void removeConnection(IncomingConnection connection, boolean close_as_well) {
        try {
            this.connections_mon.enter();
            connection.filter.getHelper().cancelReadSelects();
            this.connections.remove(connection);
        }
        finally {
            this.connections_mon.exit();
        }
        if (close_as_well) {
            connection.filter.getHelper().close("Tidy close");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doTimeoutChecks() {
        try {
            IncomingConnection ic;
            int i;
            this.connections_mon.enter();
            ArrayList<IncomingConnection> to_close = null;
            long now = SystemTime.getCurrentTime();
            for (i = 0; i < this.connections.size(); ++i) {
                ic = (IncomingConnection)this.connections.get(i);
                TransportHelper transport_helper = ic.filter.getHelper();
                if (ic.last_read_time > 0L) {
                    if (now < ic.last_read_time) {
                        ic.last_read_time = now;
                        continue;
                    }
                    if (now - ic.last_read_time <= (long)transport_helper.getReadTimeout()) continue;
                    if (Logger.isEnabled()) {
                        Logger.log(new LogEvent(LOGID, "Incoming connection [" + transport_helper.getAddress() + "] forcibly timed out due to socket read inactivity [" + ic.buffer.position() + " bytes read: " + new String(ic.buffer.array()) + "]"));
                    }
                    if (to_close == null) {
                        to_close = new ArrayList<IncomingConnection>();
                    }
                    to_close.add(ic);
                    continue;
                }
                if (now < ic.initial_connect_time) {
                    ic.initial_connect_time = now;
                    continue;
                }
                if (now - ic.initial_connect_time <= (long)transport_helper.getConnectTimeout()) continue;
                if (Logger.isEnabled()) {
                    Logger.log(new LogEvent(LOGID, "Incoming connection [" + transport_helper.getAddress() + "] forcibly timed out after " + "60sec due to socket inactivity"));
                }
                if (to_close == null) {
                    to_close = new ArrayList();
                }
                to_close.add(ic);
            }
            if (to_close != null) {
                for (i = 0; i < to_close.size(); ++i) {
                    ic = (IncomingConnection)to_close.get(i);
                    this.removeConnection(ic, true);
                }
            }
        }
        finally {
            this.connections_mon.exit();
        }
    }

    public static interface MatchListener {
        public boolean autoCryptoFallback();

        public void connectionMatched(Transport var1, Object var2);
    }

    protected class SelectorListener
    implements TransportHelper.selectListener {
        private int local_port;
        private Transport transport;

        protected SelectorListener(int _local_port, Transport _transport) {
            this.local_port = _local_port;
            this.transport = _transport;
        }

        public boolean selectSuccess(TransportHelper transport_helper, Object attachment) {
            IncomingConnection ic = (IncomingConnection)attachment;
            try {
                long bytes_read = ic.filter.read(new ByteBuffer[]{ic.buffer}, 0, 1);
                if (bytes_read < 0L) {
                    throw new IOException("end of stream on socket read");
                }
                if (bytes_read == 0L) {
                    return false;
                }
                ic.last_read_time = SystemTime.getCurrentTime();
                Object[] match_data = IncomingConnectionManager.this.checkForMatch(transport_helper, this.local_port, ic.buffer, false);
                if (match_data == null) {
                    if (ic.buffer.position() >= IncomingConnectionManager.this.getMaxMatchBufferSize()) {
                        ic.buffer.flip();
                        if (Logger.isEnabled()) {
                            Logger.log(new LogEvent(LOGID, 1, "Incoming stream from [" + transport_helper.getAddress() + "] does not match " + "any known byte pattern: " + ByteFormatter.nicePrint(ic.buffer.array())));
                        }
                        IncomingConnectionManager.this.removeConnection(ic, true);
                    }
                } else {
                    ic.buffer.flip();
                    if (Logger.isEnabled()) {
                        Logger.log(new LogEvent(LOGID, "Incoming stream from [" + transport_helper.getAddress() + "] recognized as " + "known byte pattern: " + ByteFormatter.nicePrint(ic.buffer.array())));
                    }
                    IncomingConnectionManager.this.removeConnection(ic, false);
                    this.transport.setAlreadyRead(ic.buffer);
                    this.transport.connectedInbound();
                    MatchListener listener = (MatchListener)match_data[0];
                    listener.connectionMatched(this.transport, match_data[1]);
                }
                return true;
            }
            catch (Throwable t) {
                try {
                    if (Logger.isEnabled()) {
                        Logger.log(new LogEvent(LOGID, 3, "Incoming connection [" + transport_helper.getAddress() + "] socket read exception: " + t.getMessage()));
                    }
                }
                catch (Throwable x) {
                    Debug.out("Caught exception on incoming exception log:");
                    x.printStackTrace();
                    System.out.println("CAUSED BY:");
                    t.printStackTrace();
                }
                IncomingConnectionManager.this.removeConnection(ic, true);
                return false;
            }
        }

        public void selectFailure(TransportHelper transport_helper, Object attachment, Throwable msg) {
            IncomingConnection ic = (IncomingConnection)attachment;
            if (Logger.isEnabled()) {
                Logger.log(new LogEvent(LOGID, 3, "Incoming connection [" + transport_helper.getAddress() + "] socket select op failure: " + msg.getMessage()));
            }
            IncomingConnectionManager.this.removeConnection(ic, true);
        }
    }

    protected static class IncomingConnection {
        protected final TransportHelperFilter filter;
        protected final ByteBuffer buffer;
        protected long initial_connect_time;
        protected long last_read_time = -1L;

        protected IncomingConnection(TransportHelperFilter filter, int buff_size) {
            this.filter = filter;
            this.buffer = ByteBuffer.allocate(buff_size);
            this.initial_connect_time = SystemTime.getCurrentTime();
        }
    }
}

