/****************************************************************************
** $Id:  dialogs/properdiag.cpp
** AutoQ3D a qt 3d model editor program
**
** Copyright (C) 2005-2007 -Gonzalo Reynaga Garcia. <gonzaloreynaga@yahoo.com>
**
** This program is free software; you can redistribute it and/or
** modify it under the terms of the GNU General Public Licence
** as published by the Free Software Foundation; either version 2 
** of the License, or (at your option) any later option.
** 
** This program is distributed in the hope that it will be useful,
** but WITHOUT ANY WARRANTY; without even the implied warranty of
** MERCHANTABILITY or FITNESS FOR PARTICULAR PURPOSE. See the
** GNU General Public License for more details.
**
** You should have received a copy of the GNU General Public License
** along with this program; if not, write to the Free Software
** Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA
** 
*****************************************************************************/

#include "properdiag.h"


ProperDiag::ProperDiag( QWidget* parent, Qt::WFlags flags)
    : QDialog( parent,flags )
{	
	int i;
	QVBoxLayout* ProperDiagLayout;
	QHBoxLayout* layout1;
	table1 = new QTableWidget;
	table1->setSelectionMode(QAbstractItemView::NoSelection);
	table1->setRowCount(12);
	table1->setColumnCount(6);
	for(i=0;i<12;i++){
		table1->verticalHeader()->resizeSection(i,20);
	}
		table1->horizontalHeader()->hideSection(2);
		table1->horizontalHeader()->hideSection(3);
		table1->horizontalHeader()->hideSection(4);
		table1->horizontalHeader()->hideSection(5);
		table1->verticalHeader()->hideSection(8);
		table1->verticalHeader()->hideSection(9);
		table1->verticalHeader()->hideSection(10);
		table1->verticalHeader()->hideSection(11);
	table1->verticalHeader()->hide();
	table1->horizontalHeader()->hide();
	table1->horizontalHeader()->resizeSection(0,45);
	table1->horizontalHeader()->resizeSection(2,60);
	table1->horizontalHeader()->resizeSection(4,60);
	
	ProperDiagLayout = new QVBoxLayout( this);
	ProperDiagLayout->addWidget(table1);
	
	
	
	layout1 = new QHBoxLayout;
	cancelbot = new QPushButton("Cancel");
	okbot = new QPushButton( "OK");
	layout1->addWidget( okbot);
	layout1->addWidget( cancelbot);
	
	ProperDiagLayout->addLayout( layout1 );
	table1->setItem(1,1,new TableLabel("0",Qt::white,Qt::black));
	table1->setItem(2,1,new TableLabel("0",Qt::white,Qt::black));
	table1->setItem(3,1,new TableLabel("0",Qt::white,Qt::black));
	table1->setItem(5,1,new TableLabel("0",Qt::white,Qt::black));
	table1->setItem(6,1,new TableLabel("0",Qt::white,Qt::black));
	table1->setItem(7,1,new TableLabel("0",Qt::white,Qt::black));
	table1->setItem(9,1,new TableLabel("0",Qt::white,Qt::black));
	table1->setItem(10,1,new TableLabel("0",Qt::white,Qt::black));
	table1->setItem(11,1,new TableLabel("0",Qt::white,Qt::black));
	table1->setItem(1,5,new TableLabel("0",Qt::white,Qt::black));
	table1->setItem(2,5,new TableLabel("0",Qt::white,Qt::black));
	table1->setItem(3,5,new TableLabel("0",Qt::white,Qt::black));
	table1->setItem(5,5,new TableLabel("0",Qt::white,Qt::black));
	table1->setItem(6,5,new TableLabel("0",Qt::white,Qt::black));
	table1->setItem(7,5,new TableLabel("0",Qt::white,Qt::black));
	table1->setItem(9,5,new TableLabel("0",Qt::white,Qt::black));
	table1->setItem(10,5,new TableLabel("0",Qt::white,Qt::black));
	table1->setItem(11,5,new TableLabel("0",Qt::white,Qt::black));
	table1->setItem(0,3,new TableLabel("",Qt::white,Qt::black));
	table1->setItem(1,3,new TableLabel("0",Qt::white,Qt::black));
	table1->setItem(4,3,new TableLabel("0",Qt::white,Qt::black));
	table1->setItem(5,3,new TableLabel("0",Qt::white,Qt::black));
	table1->setItem(7,3,new TableLabel("0",Qt::white,Qt::black));
	table1->setItem(8,3,new TableLabel("0",Qt::white,Qt::black));
	table1->setItem(10,3,new TableLabel("0",Qt::white,Qt::black));
	table1->setItem(11,3,new TableLabel("0",Qt::white,Qt::black));
	
	resize( QSize(350, 320).expandedTo(minimumSizeHint()) );
	setWindowTitle(tr("Properties"));
	table1->setItem(0,0,new TableLabel(tr("Point 1"),Qt::blue,Qt::white));
	table1->setItem(1,0,new TableLabel("X",Qt::gray,Qt::black));
	table1->setItem(2,0,new TableLabel("Y",Qt::gray,Qt::black));
	table1->setItem(3,0,new TableLabel("Z",Qt::gray,Qt::black));

	table1->setItem(4,0,new TableLabel(tr("Point 2"),Qt::blue,Qt::white));
	table1->setItem(5,0,new TableLabel("X",Qt::gray,Qt::black));
	table1->setItem(6,0,new TableLabel("Y",Qt::gray,Qt::black));
	table1->setItem(7,0,new TableLabel("Z",Qt::gray,Qt::black));

	table1->setItem(8,0,new TableLabel(tr("Point 3"),Qt::blue,Qt::white));
	table1->setItem(9,0,new TableLabel("X",Qt::gray,Qt::black));
	table1->setItem(10,0,new TableLabel("Y",Qt::gray,Qt::black));
	table1->setItem(11,0,new TableLabel("Z",Qt::gray,Qt::black));
	
	TableLabel *cellcolor1=new TableLabel(tr("|Color 1"),Qt::white,Qt::black);cellcolor1->setTextAlignment(Qt::AlignVCenter|Qt::AlignLeft);
	table1->setItem(0,1,cellcolor1);
	TableLabel *cellcolor2=new TableLabel(tr("|Color 2"),Qt::white,Qt::black);cellcolor2->setTextAlignment(Qt::AlignVCenter|Qt::AlignLeft);
	table1->setItem(4,1,cellcolor2);
	TableLabel *cellcolor3=new TableLabel(tr("|Color 3"),Qt::white,Qt::black);cellcolor3->setTextAlignment(Qt::AlignVCenter|Qt::AlignLeft);
	table1->setItem(8,1,cellcolor3);

	table1->setItem(1,2,new TableLabel(tr("Texture ID"),Qt::white,Qt::black));
	table1->setItem(3,2,new TableLabel(tr("Texture 1"),Qt::blue,Qt::white));
	table1->setItem(4,2,new TableLabel("U",Qt::gray,Qt::black));
	table1->setItem(5,2,new TableLabel("V",Qt::gray,Qt::black));
	table1->setItem(6,2,new TableLabel(tr("Texture 2"),Qt::blue,Qt::white));
	table1->setItem(7,2,new TableLabel("U",Qt::gray,Qt::black));
	table1->setItem(8,2,new TableLabel("V",Qt::gray,Qt::black));
	table1->setItem(9,2,new TableLabel(tr("Texture 3"),Qt::blue,Qt::white));
	table1->setItem(10,2,new TableLabel("U",Qt::gray,Qt::black));
	table1->setItem(11,2,new TableLabel("V",Qt::gray,Qt::black));

	TableLabel *cellpick1=new TableLabel(tr("Pick 1"),Qt::blue,Qt::white);cellpick1->setTextAlignment(Qt::AlignVCenter|Qt::AlignLeft);
	table1->setItem(3,3,cellpick1);
	TableLabel *cellpick2=new TableLabel(tr("Pick 2"),Qt::blue,Qt::white);cellpick2->setTextAlignment(Qt::AlignVCenter|Qt::AlignLeft);
	table1->setItem(6,3,cellpick2);
	TableLabel *cellpick3=new TableLabel(tr("Pick 3"),Qt::blue,Qt::white);cellpick3->setTextAlignment(Qt::AlignVCenter|Qt::AlignLeft);
	table1->setItem(9,3,cellpick3);

	table1->setItem(0,4,new TableLabel(tr("Normal 1"),Qt::blue,Qt::white));
	table1->setItem(1,4,new TableLabel("X",Qt::gray,Qt::black));
	table1->setItem(2,4,new TableLabel("Y",Qt::gray,Qt::black));
	table1->setItem(3,4,new TableLabel("Z",Qt::gray,Qt::black));
	table1->setItem(4,4,new TableLabel(tr("Normal 2"),Qt::blue,Qt::white));
	table1->setItem(5,4,new TableLabel("X",Qt::gray,Qt::black));
	table1->setItem(6,4,new TableLabel("Y",Qt::gray,Qt::black));
	table1->setItem(7,4,new TableLabel("Z",Qt::gray,Qt::black));
	table1->setItem(8,4,new TableLabel(tr("Normal 3"),Qt::blue,Qt::white));
	table1->setItem(9,4,new TableLabel("X",Qt::gray,Qt::black));
	table1->setItem(10,4,new TableLabel("Y",Qt::gray,Qt::black));
	table1->setItem(11,4,new TableLabel("Z",Qt::gray,Qt::black));

	
	connect(okbot,SIGNAL(clicked()),this,SLOT(okpress()));
	connect(cancelbot,SIGNAL(clicked()),this,SLOT(cancelpress()));
	connect( table1, SIGNAL( clicked(const QModelIndex &) ), this, SLOT( ClickEvent(const QModelIndex &) ) );
	
}

ProperDiag::~ProperDiag()
{

}

void ProperDiag::okpress(){
	accept();
	close();
}



void ProperDiag::cancelpress(){
	reject();
	close();

}

void ProperDiag::showTriangleMode(bool mode){
	int i;
	if(mode){
		table1->horizontalHeader()->showSection(2);
		table1->horizontalHeader()->showSection(3);
		table1->horizontalHeader()->showSection(4);
		table1->horizontalHeader()->showSection(5);
		table1->verticalHeader()->showSection(8);
		table1->verticalHeader()->showSection(9);
		table1->verticalHeader()->showSection(10);
		table1->verticalHeader()->showSection(11);
		for(i=0;i<12;i++){
			table1->verticalHeader()->resizeSection(i,20);
		}
		table1->horizontalHeader()->resizeSection(2,60);
		table1->horizontalHeader()->resizeSection(4,60);

	}else{
		table1->horizontalHeader()->hideSection(2);
		table1->horizontalHeader()->hideSection(3);
		table1->horizontalHeader()->hideSection(4);
		table1->horizontalHeader()->hideSection(5);
		table1->verticalHeader()->hideSection(8);
		table1->verticalHeader()->hideSection(9);
		table1->verticalHeader()->hideSection(10);
		table1->verticalHeader()->hideSection(11);
	}

}

void ProperDiag::ClickEvent(const QModelIndex &index){
	QString tempo;
	int i,col,row;
	QTableWidgetItem *selcolor;
	if(index.isValid()){
		row=index.row();
		col=index.column();
		QPixmap pixmap( 20, 20 );
		if(col==1&&(row==0)){
			color1=QColorDialog::getColor(color1, this );
			if(color1.isValid()){
				pixmap.fill(color1);
				QTableWidgetItem *selcolor=table1->item(row,1);selcolor->setIcon(pixmap);
			}
		}
		if(col==1&&(row==4)){
			color2=QColorDialog::getColor(color2, this );
			if(color2.isValid()){
				pixmap.fill(color2);
				QTableWidgetItem *selcolor=table1->item(row,1);selcolor->setIcon(pixmap);
			}
		}
		if(col==1&&(row==8)){
			color3=QColorDialog::getColor(color3, this );
			if(color3.isValid()){
				pixmap.fill(color3);
				QTableWidgetItem *selcolor=table1->item(row,1);selcolor->setIcon(pixmap);
			}
		}
	
		if((col==3&&row==3)||(col==3&&row==6)||(col==3&&row==9)){
			if(pixname!=""){
			PickTex *pickdiag= new PickTex(this,0,pixname,uvcoords);/*WA_DeleteOnClose is in object*/
			if(pickdiag->exec()){
				selcolor=table1->item(row+1,3);selcolor->setText(QString("%1").arg(uvcoords[0]));
				selcolor=table1->item(row+2,3);selcolor->setText(QString("%1").arg(uvcoords[1]));
			}
			}
		}
		if(col==3&&(row==1)){
			selcolor=table1->item(1,3);i=selcolor->text().toInt();
			if(StrTex.count()<i){
				i=0;
			}
			TexFormSel *Texsel= new TexFormSel(this,0,StrTex,i);
			if(Texsel->exec()){
				tempo=Texsel->selitem;
				if(tempo.isNull()){
					selcolor->setText(QString("0"));
					selcolor=table1->item(0,3);selcolor->setText(tempo);
				}else{
					tempo.remove( 0,tempo.lastIndexOf( "/" )+1);
					selcolor->setText(QString("%1").arg(Texsel->selitemnum));
					selcolor=table1->item(0,3);selcolor->setText(tempo);
				}
			}
			Texsel->setAttribute(Qt::WA_DeleteOnClose);
			Texsel->close();
		}
	}
}





