/****************************************************************************
** $Id:  dialogs/prgsettings.cpp
** AutoQ3D a qt 3d model editor program
**
** Copyright (C) 2005-2007 -Gonzalo Reynaga Garcia. <gonzaloreynaga@yahoo.com>
**
** This program is free software; you can redistribute it and/or
** modify it under the terms of the GNU General Public Licence
** as published by the Free Software Foundation; either version 2
** of the License, or (at your option) any later option.
**
** This program is distributed in the hope that it will be useful,
** but WITHOUT ANY WARRANTY; without even the implied warranty of
** MERCHANTABILITY or FITNESS FOR PARTICULAR PURPOSE. See the
** GNU General Public License for more details.
**
** You should have received a copy of the GNU General Public License
** along with this program; if not, write to the Free Software
** Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA
**
*****************************************************************************/

#include "prgsettings.h"

#include <QVariant>
#include <QLabel>
#include <QPushButton>
#include <QLayout>
#include <QPixmap>

/*
 *  Constructs a About as a child of 'parent', with the
 *  name 'name' and widget flags set to 'f'.
 *
 *  The dialog will by default be modeless, unless you set 'modal' to
 *  TRUE to construct a modal dialog.
 */
PrgSettings::PrgSettings( QWidget* parent,Qt::WFlags fl )
    : QDialog( parent,fl )
{
 	QSettings settings("AutoQ3D-Community","AutoQ3D-Community");
	ProgramPath = settings.value("MainWindow/ProgramPath","/usr/share/AutoQ3D-Community").toString();


    Gene = new QVBoxLayout(this);
    BoxLanguage = new QHBoxLayout;
    FinalOpt = new QHBoxLayout;
    CChangeLanguage= new QComboBox;
    ChangePathBtn= new QPushButton;
    OkBtn= new QPushButton(tr("OK"));
    CancelBtn= new QPushButton(tr("Cancel"));

    LChangeLanguage = new QLabel(tr("Language"));
    LChangePathBtn = new QLabel(ProgramPath);

    ChangePathBtn->setText(tr("Change Program Path..."));

    Gene->addWidget(LChangePathBtn,Qt::AlignLeft);
    Gene->addWidget(ChangePathBtn,Qt::AlignLeft);


    CChangeLanguage->addItem(tr("English"));
    CChangeLanguage->addItem(tr("Spanish"));
    Gene->addStretch(1);
    BoxLanguage->addWidget(LChangeLanguage);
    BoxLanguage->addWidget(CChangeLanguage);

    Gene->addLayout(BoxLanguage);
    Gene->addStretch(1);
    FinalOpt->addWidget(OkBtn);
    FinalOpt->addWidget(CancelBtn);

	Gene->addLayout(FinalOpt);
    setWindowTitle(tr("Settings"));
	modif=0;


	CChangeLanguage->setCurrentIndex(settings.value("MainWindow/Language").toInt());
	connect( ChangePathBtn, SIGNAL( clicked() ), this, SLOT( SetPath() ) );
	connect( OkBtn, SIGNAL( clicked() ), this, SLOT( FunAccept() ) );
	connect( CancelBtn, SIGNAL( clicked() ), this, SLOT( accept() ) );
	connect( CChangeLanguage, SIGNAL( activated(int) ), this, SLOT( slotChanged(int)) );
}

/*
 *  Destroys the object and frees any allocated resources
 */
PrgSettings::~PrgSettings()
{
    // no need to delete child widgets, Qt does it all for us
}

void PrgSettings::slotChanged(int){
	modif=1;

}


void PrgSettings::SetPath(){
	QString tempo;
	tempo= QFileDialog::getExistingDirectory(this,tr("Set Program Path"),ProgramPath,QFileDialog::ShowDirsOnly);
	if(!tempo.isNull()){
		ProgramPath =tempo;
		LChangePathBtn->setText(ProgramPath);
		modif=1;
	}
}

void PrgSettings::FunAccept(){
	if(modif){
		QSettings settings("AutoQ3D-Community","AutoQ3D-Community");
		settings.setValue( "MainWindow/ProgramPath",ProgramPath );
		settings.setValue( "MainWindow/Language",CChangeLanguage->currentIndex());
		QMessageBox::information(this,tr("Information"),tr("Restart for load the changes"), tr("&OK"));
	}
	accept();
}
