/****************************************************************************
** $Id:  cmds/cmdrotateview.h
** AutoQ3D a qt 3d model editor program
**
** Copyright (C) 2005-2007 -Gonzalo Reynaga Garcia. <gonzaloreynaga@yahoo.com>
**
** This program is free software; you can redistribute it and/or
** modify it under the terms of the GNU General Public Licence
** as published by the Free Software Foundation; either version 2 
** of the License, or (at your option) any later option.
** 
** This program is distributed in the hope that it will be useful,
** but WITHOUT ANY WARRANTY; without even the implied warranty of
** MERCHANTABILITY or FITNESS FOR PARTICULAR PURPOSE. See the
** GNU General Public License for more details.
**
** You should have received a copy of the GNU General Public License
** along with this program; if not, write to the Free Software
** Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA
** 
*****************************************************************************/

#ifndef CMDROTATEVIEW_H
#define CMDROTATEVIEW_H
#include "cmds.h"


void cmds::cmdrotateview(){

	if(SecCmd==tr("**Cancel**")||SecCmd==""){
			rtlines[0].find=0;
			emit SetMouseMode(MOUSEMODE_SELECT);
			emit instru(tr("Command:"));
			SendText(SecCmd);
			CommandActive=0;
			step=0;SecCmd="BlankCommand";
			return;
	}

	switch(step){
		
		case 0:
				SendText(currentcmd);
				emit instru(tr("Rotate View:"));
				emit SetMouseMode(MOUSEMODE_ROTATE);
				step++;
				return;
		break;
		case 1:
			/*/////////*/
			if(!SecCmd.compare(tr("z","Zoom"))||!SecCmd.compare(tr("zoom"))||!SecCmd.compare(tr("'z"))||!SecCmd.compare(tr("'zoom"))){
				CommandActive=0;step=0;
				SecCmd="BlankCommand";
				processcmd(tr("z","Zoom"));
				return;
			}
			
			if(!SecCmd.compare(tr("p","Pan"))||!SecCmd.compare(tr("pan"))||!SecCmd.compare(tr("'p"))||!SecCmd.compare(tr("'pan"))){
				CommandActive=0;step=0;
				SecCmd="BlankCommand";
				processcmd(tr("p","Pan"));
				return;
			}
		
		break;
	}
	
	SendText(SecCmd);
	SendText(tr("**Secundary Command not found**"));
}


#endif
