/****************************************************************************
** $Id:  cmds/cmdpopzoom.h
** AutoQ3D a qt 3d model editor program
**
** Copyright (C) 2005-2007 -Gonzalo Reynaga Garcia. <gonzaloreynaga@yahoo.com>
**
** This program is free software; you can redistribute it and/or
** modify it under the terms of the GNU General Public Licence
** as published by the Free Software Foundation; either version 2 
** of the License, or (at your option) any later option.
** 
** This program is distributed in the hope that it will be useful,
** but WITHOUT ANY WARRANTY; without even the implied warranty of
** MERCHANTABILITY or FITNESS FOR PARTICULAR PURPOSE. See the
** GNU General Public License for more details.
**
** You should have received a copy of the GNU General Public License
** along with this program; if not, write to the Free Software
** Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA
** 
*****************************************************************************/

#ifndef CMDPOPZOOM_H
#define CMDPOPZOOM_H
#include "cmds.h"


void cmds::cmdpopzoom(){

	if(SecCmd==(tr("**Cancel**"))||SecCmd==""){
			PopViewMode=0;
			GripEditMode[0]=popStats[0];
			emit SetMouseMode(popStats[1]);
			emit instru(instruction);
			PopStep=0;
			return;
	}
	switch(PopStep){
		case 0:
				popStats[0]=GripEditMode[0];
				popStats[1]=*MouseMode;
				GripEditMode[0]=0;
				SendText(tr("zoom"));
				emit instru(instruction+tr("<<ZOOM:>>"));
				emit SetMouseMode(MOUSEMODE_ZOOM);
				PopStep++;
				return;
		break;
		
		case 1:
			if(!SecCmd.compare(tr("p","Pan"))||!SecCmd.compare(tr("pan"))||!SecCmd.compare(tr("'p"))||!SecCmd.compare(tr("'pan"))){
				PopViewMode=2;
				emit instru(instruction+tr("<<PAN:>>"));
				emit SetMouseMode(MOUSEMODE_PAN);
				return;
			}
			
			if(!SecCmd.compare(tr("rtv"))||!SecCmd.compare(tr("rotateview"))||!SecCmd.compare(tr("'rtv"))||!SecCmd.compare(tr("'rotateview"))){
				PopViewMode=3;
				emit instru(instruction+tr("<<ROTATE VIEW:>>"));
				emit SetMouseMode(MOUSEMODE_ROTATE);
				return;
			}
			
			
			if(!SecCmd.compare("setCmdData")){
				if(currentdata.format==2){
					emit ZoomVar(currentdata.v[0]);
					return;
				}
			
			}
			
			
		break;
		
	}
	
	
	SendText(SecCmd);
	SendText(tr("**Secundary Command not found**"));
}


#endif
