/****************************************************************************
** $Id:  cmds/cmdgrippointcolor.h
** AutoQ3D a qt 3d model editor program
**
** Copyright (C) 2005-2007 -Gonzalo Reynaga Garcia. <gonzaloreynaga@yahoo.com>
**
** This program is free software; you can redistribute it and/or
** modify it under the terms of the GNU General Public Licence
** as published by the Free Software Foundation; either version 2 
** of the License, or (at your option) any later option.
** 
** This program is distributed in the hope that it will be useful,
** but WITHOUT ANY WARRANTY; without even the implied warranty of
** MERCHANTABILITY or FITNESS FOR PARTICULAR PURPOSE. See the
** GNU General Public License for more details.
**
** You should have received a copy of the GNU General Public License
** along with this program; if not, write to the Free Software
** Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA
** 
*****************************************************************************/

#ifndef CMDGRIPPOINTCOLOR_H
#define CMDGRIPPOINTCOLOR_H
#include "cmds.h"


void cmds::cmdgrippointcolor(){
	int i;
	d3line *DLV;
	d3triangle *DTV;
	DLV=DataLV->data();
	DTV=DataTV->data();
	if((SecCmd==tr("**Cancel**")||SecCmd=="")&&!PopViewMode){
			SendText(SecCmd);
			CmdCancel();
			return;
	}

	switch(step){
		
		case 0:
				SendText(tr("--Point-Color--"));instruction=tr("Point Color:");emit instru(instruction);
				
				QColor col = QColorDialog::getColor(QColor((int)currentcolor[0]*255,(int)currentcolor[1]*255,(int)currentcolor[2]*255),this);
				if ( !col.isValid() ){
					CmdCancel();
					return;
				}
				tempdataF[0]=(float)col.red()/255.0;tempdataF[1]=(float)col.green()/255.0;tempdataF[2]=(float)col.blue()/255.0;
		
				GriPoint[0].find=0;

						for(i=0;i<DataSV.size();i++){
						if(DataSV[i].type==1){
							if((DLV[DataSV[i].index].v1[0]==GriPoint->v[0])&&(DLV[DataSV[i].index].v1[1]==GriPoint->v[1])&&(DLV[DataSV[i].index].v1[2]==GriPoint->v[2])){
								DLV[DataSV[i].index].c1[0]=tempdataF[0];DLV[DataSV[i].index].c1[1]=tempdataF[1];
								DLV[DataSV[i].index].c1[2]=tempdataF[2];
							}
							if((DLV[DataSV[i].index].v2[0]==GriPoint->v[0])&&(DLV[DataSV[i].index].v2[1]==GriPoint->v[1])&&(DLV[DataSV[i].index].v2[2]==GriPoint->v[2])){
								DLV[DataSV[i].index].c2[0]=tempdataF[0];DLV[DataSV[i].index].c2[1]=tempdataF[1];
								DLV[DataSV[i].index].c2[2]=tempdataF[2];
							}
						}
						if(DataSV[i].type==2){
							if((DTV[DataSV[i].index].v1[0]==GriPoint->v[0])&&(DTV[DataSV[i].index].v1[1]==GriPoint->v[1])&&(DTV[DataSV[i].index].v1[2]==GriPoint->v[2])){
								DTV[DataSV[i].index].c1[0]=tempdataF[0];DTV[DataSV[i].index].c1[1]=tempdataF[1];
								DTV[DataSV[i].index].c1[2]=tempdataF[2];
							}
							if((DTV[DataSV[i].index].v2[0]==GriPoint->v[0])&&(DTV[DataSV[i].index].v2[1]==GriPoint->v[1])&&(DTV[DataSV[i].index].v2[2]==GriPoint->v[2])){
								DTV[DataSV[i].index].c2[0]=tempdataF[0];DTV[DataSV[i].index].c2[1]=tempdataF[1];
								DTV[DataSV[i].index].c2[2]=tempdataF[2];
							}
							if((DTV[DataSV[i].index].v3[0]==GriPoint->v[0])&&(DTV[DataSV[i].index].v3[1]==GriPoint->v[1])&&(DTV[DataSV[i].index].v3[2]==GriPoint->v[2])){
								DTV[DataSV[i].index].c3[0]=tempdataF[0];DTV[DataSV[i].index].c3[1]=tempdataF[1];
								DTV[DataSV[i].index].c3[2]=tempdataF[2];
							}
						
						}
						}
			
			/*DataSV.resize(0);*/
			CmdCancel();
			return;
			
		break;
	}
	
	SendText(SecCmd);
	SendText(tr("**Secondary Command not found**"));
}


#endif
