/****************************************************************************
** $Id:  cmds/cmdgriponlyscale.h
** AutoQ3D a qt 3d model editor program
**
** Copyright (C) 2005-2007 -Gonzalo Reynaga Garcia. <gonzaloreynaga@yahoo.com>
**
** This program is free software; you can redistribute it and/or
** modify it under the terms of the GNU General Public Licence
** as published by the Free Software Foundation; either version 2 
** of the License, or (at your option) any later option.
** 
** This program is distributed in the hope that it will be useful,
** but WITHOUT ANY WARRANTY; without even the implied warranty of
** MERCHANTABILITY or FITNESS FOR PARTICULAR PURPOSE. See the
** GNU General Public License for more details.
**
** You should have received a copy of the GNU General Public License
** along with this program; if not, write to the Free Software
** Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA
** 
*****************************************************************************/

#ifndef CMDGRIPONLYSCALE_H
#define CMDGRIPONLYSCALE_H
#include "cmds.h"


void cmds::cmdgriponlyscale(){
	int i,j,k;
	d3line *DLV;
	d3triangle *DTV;
	DLV=DataLV->data();
	DTV=DataTV->data();
	if((SecCmd==tr("**Cancel**")||SecCmd=="")&&!PopViewMode){
			SendText(SecCmd);
			CmdCancel();
			return;
	}

	switch(step){
		
		case 0:
				SendText(tr("--Grip-Scale--"));instruction=tr("Scale [Copy/Reference/X/Y/Z/All](All):");emit instru(instruction);
				tempdataI[0]=0;tempdataF[0]=1;cscalarf[0]=1;cscalari[0]=7;
				for(i=0;i<DataSV.size();i++){
					if(DataSV[i].type==1){
						DataSLV.resize(DataSLV.size()+1);j=DataSLV.size()-1;
						DataSLV[j].v1[0]=DLV[DataSV[i].index].v1[0];
						DataSLV[j].v2[0]=DLV[DataSV[i].index].v2[0];
						DataSLV[j].v1[1]=DLV[DataSV[i].index].v1[1];
						DataSLV[j].v2[1]=DLV[DataSV[i].index].v2[1];
						DataSLV[j].v1[2]=DLV[DataSV[i].index].v1[2];
						DataSLV[j].v2[2]=DLV[DataSV[i].index].v2[2];
						DataSLV[j].c1[0]=DLV[DataSV[i].index].c1[0];
						DataSLV[j].c2[0]=DLV[DataSV[i].index].c2[0];
						DataSLV[j].c1[1]=DLV[DataSV[i].index].c1[1];
						DataSLV[j].c2[1]=DLV[DataSV[i].index].c2[1];
						DataSLV[j].c1[2]=DLV[DataSV[i].index].c1[2];
						DataSLV[j].c2[2]=DLV[DataSV[i].index].c2[2];
						
					}
					if(DataSV[i].type==2){
						DataSTV.resize(DataSTV.size()+1);j=DataSTV.size()-1;k=DataSV[i].index;
						DataSTV[j].v1[0]=DTV[k].v1[0];DataSTV[j].v2[0]=DTV[k].v2[0];DataSTV[j].v3[0]=DTV[k].v3[0];
						DataSTV[j].v1[1]=DTV[k].v1[1];DataSTV[j].v2[1]=DTV[k].v2[1];DataSTV[j].v3[1]=DTV[k].v3[1];
						DataSTV[j].v1[2]=DTV[k].v1[2];DataSTV[j].v2[2]=DTV[k].v2[2];DataSTV[j].v3[2]=DTV[k].v3[2];
						DataSTV[j].texture=DTV[k].texture;
						DataSTV[j].t1[0]=DTV[k].t1[0];DataSTV[j].t1[1]=DTV[k].t1[1];
						DataSTV[j].t2[0]=DTV[k].t2[0];DataSTV[j].t2[1]=DTV[k].t2[1];
						DataSTV[j].t3[0]=DTV[k].t3[0];DataSTV[j].t3[1]=DTV[k].t3[1];
						DataSTV[j].c1[0]=DTV[k].c1[0];DataSTV[j].c2[0]=DTV[k].c2[0];DataSTV[j].c3[0]=DTV[k].c3[0];
						DataSTV[j].c1[1]=DTV[k].c1[1];DataSTV[j].c2[1]=DTV[k].c2[1];DataSTV[j].c3[1]=DTV[k].c3[1];
						DataSTV[j].c1[2]=DTV[k].c1[2];DataSTV[j].c2[2]=DTV[k].c2[2];DataSTV[j].c3[2]=DTV[k].c3[2];
						DataSTV[j].n1[0]=DTV[k].n1[0];DataSTV[j].n2[0]=DTV[k].n2[0];DataSTV[j].n3[0]=DTV[k].n3[0];
						DataSTV[j].n1[1]=DTV[k].n1[1];DataSTV[j].n2[1]=DTV[k].n2[1];DataSTV[j].n3[1]=DTV[k].n3[1];
						DataSTV[j].n1[2]=DTV[k].n1[2];DataSTV[j].n2[2]=DTV[k].n2[2];DataSTV[j].n3[2]=DTV[k].n3[2];
					}
				}
				rtlines->v[0]=currentpoint->v[0];rtlines->v[1]=currentpoint->v[1];rtlines->v[2]=0;
				rtcolor[0]=currentcolor[0];rtcolor[1]=currentcolor[1];rtcolor[2]=currentcolor[2];
				rtlines[0].find=1;
				step++;
				emit SetMouseMode(MOUSEMODE_PICKPOINT);
				return;
		break;
		
		case 1:
			if(CmdSelectPopView()){return;}
			if(CmdCheckSnap()){return;}
			
			if(!SecCmd.compare(tr("c","Copy"))||!SecCmd.compare(tr("C","Copy"))){
				tempdataI[0]=1;
				SendText(tr("Copy"));
				return;
			}
			
			/*if(!SecCmd.compare("b")||!SecCmd.compare("B")){
				SendText("Base point");emit instru("Move (set base point):");
				DataSLV.resize(0);
				step=2;
				return;
			}*/
			if(!SecCmd.compare(tr("r","Reference"))||!SecCmd.compare(tr("R","Reference"))){
				SendText(tr("Reference"));emit instru(tr("Scale (Reference):"));
				DataSLV.resize(0);
				rtlines[0].find=0;
				step=3;
				return;
			}
			if(!SecCmd.compare("x")||!SecCmd.compare("X")){
				SendText(tr("Scale in X"));instruction=tr("Scale [Copy/Reference/X/Y/Z/All](X):");emit instru(instruction);
				cscalari[0]=1;
				return;
			}
			if(!SecCmd.compare("y")||!SecCmd.compare("Y")){
				SendText(tr("Scale in Y"));instruction=tr("Scale [Copy/Reference/X/Y/Z/All](Y):");emit instru(instruction);
				cscalari[0]=2;
				return;
			}
			if(!SecCmd.compare("z")||!SecCmd.compare("Z")){
				SendText(tr("Scale in Z"));instruction=tr("Scale [Copy/Reference/X/Y/Z/All](Z):");emit instru(instruction);
				cscalari[0]=4;
				return;
			}
			if(!SecCmd.compare("a")||!SecCmd.compare("A")){
				SendText(tr("Scale in all axes"));instruction=tr("Scale [Copy/Reference/X/Y/Z/All](All):");emit instru(instruction);
				cscalari[0]=7;
				return;
			}

			
			if(!SecCmd.compare("setCmdData")){
				if(currentdata.format>2){
						SendText(tr("Data reject"));
						return;
				}
				GriPoint[0].find=0;
				double var[4];
				var[2]=0;
				
				if(tempdataI[0]){/*//////Copy?(y/n)/////*/
					for(i=0;i<DataSLV.size();i++){
						j=DataLV->size();DataLV->resize(j+1);DLV=DataLV->data();
						DLV[j].c1[0]=DataSLV[i].c1[0];DLV[j].c1[1]=DataSLV[i].c1[1];DLV[j].c1[2]=DataSLV[i].c1[2];
						DLV[j].c2[0]=DataSLV[i].c2[0];DLV[j].c2[1]=DataSLV[i].c2[1];DLV[j].c2[2]=DataSLV[i].c2[2];
					}
					for(i=0;i<DataSTV.size();i++){
						j=DataTV->size();DataTV->resize(j+1);DTV=DataTV->data();
						DTV[j].texture=DataSTV[i].texture;
						DTV[j].t1[0]=DataSTV[i].t1[0];DTV[j].t1[1]=DataSTV[i].t1[1];
						DTV[j].t2[0]=DataSTV[i].t2[0];DTV[j].t2[1]=DataSTV[i].t2[1];
						DTV[j].t3[0]=DataSTV[i].t3[0];DTV[j].t3[1]=DataSTV[i].t3[1];
						DTV[j].c1[0]=DataSTV[i].c1[0];DTV[j].c1[1]=DataSTV[i].c1[1];DTV[j].c1[2]=DataSTV[i].c1[2];
						DTV[j].c2[0]=DataSTV[i].c2[0];DTV[j].c2[1]=DataSTV[i].c2[1];DTV[j].c2[2]=DataSTV[i].c2[2];
						DTV[j].c3[0]=DataSTV[i].c3[0];DTV[j].c3[1]=DataSTV[i].c3[1];DTV[j].c3[2]=DataSTV[i].c3[2];
						
					}
					if(currentdata.format==0){/*Global*/
						var[0]=currentdata.v[0]-rtlines->v[0];var[1]=currentdata.v[1]-rtlines->v[1];
						var[2]=sqrt(var[0]*var[0]+var[1]*var[1])/cscalarf[0];
					}
					
					if(currentdata.format==1){/*Relativa ("@")*/
						var[0]=currentdata.v[0];var[1]=currentdata.v[1];
						var[2]=sqrt(var[0]*var[0]+var[1]*var[1])/cscalarf[0];
					}
					if(currentdata.format==2){
						var[2]=currentdata.v[0]/cscalarf[0];
					}
					
					for(i=0,j=DataLV->size()-DataSLV.size();i<DataSLV.size();i++,j++){
							if(cscalari[0]&1){
								DLV[j].v1[0]=GriPoint->v[0]+(DataSLV[i].v1[0]-GriPoint->v[0])*var[2];
								DLV[j].v2[0]=GriPoint->v[0]+(DataSLV[i].v2[0]-GriPoint->v[0])*var[2];
							}else{
								DLV[j].v1[0]=GriPoint->v[0]+(DataSLV[i].v1[0]-GriPoint->v[0]);
								DLV[j].v2[0]=GriPoint->v[0]+(DataSLV[i].v2[0]-GriPoint->v[0]);
							}
							if(cscalari[0]&2){
								DLV[j].v1[1]=GriPoint->v[1]+(DataSLV[i].v1[1]-GriPoint->v[1])*var[2];
								DLV[j].v2[1]=GriPoint->v[1]+(DataSLV[i].v2[1]-GriPoint->v[1])*var[2];
							}else{
								DLV[j].v1[1]=GriPoint->v[1]+(DataSLV[i].v1[1]-GriPoint->v[1]);
								DLV[j].v2[1]=GriPoint->v[1]+(DataSLV[i].v2[1]-GriPoint->v[1]);
							}
							if(cscalari[0]&4){
								DLV[j].v1[2]=GriPoint->v[2]+(DataSLV[i].v1[2]-GriPoint->v[2])*var[2];
								DLV[j].v2[2]=GriPoint->v[2]+(DataSLV[i].v2[2]-GriPoint->v[2])*var[2];
							}else{
								DLV[j].v1[2]=GriPoint->v[2]+(DataSLV[i].v1[2]-GriPoint->v[2]);
								DLV[j].v2[2]=GriPoint->v[2]+(DataSLV[i].v2[2]-GriPoint->v[2]);
							}
					}
					for(i=0,j=DataTV->size()-DataSTV.size();i<DataSTV.size();i++,j++){
							if(cscalari[0]&1){
								DTV[j].v1[0]=GriPoint->v[0]+(DataSTV[i].v1[0]-GriPoint->v[0])*var[2];
								DTV[j].v2[0]=GriPoint->v[0]+(DataSTV[i].v2[0]-GriPoint->v[0])*var[2];
								DTV[j].v3[0]=GriPoint->v[0]+(DataSTV[i].v3[0]-GriPoint->v[0])*var[2];
							}else{
								DTV[j].v1[0]=GriPoint->v[0]+(DataSTV[i].v1[0]-GriPoint->v[0]);
								DTV[j].v2[0]=GriPoint->v[0]+(DataSTV[i].v2[0]-GriPoint->v[0]);
								DTV[j].v3[0]=GriPoint->v[0]+(DataSTV[i].v3[0]-GriPoint->v[0]);
							}
							if(cscalari[0]&2){
								DTV[j].v1[1]=GriPoint->v[1]+(DataSTV[i].v1[1]-GriPoint->v[1])*var[2];
								DTV[j].v2[1]=GriPoint->v[1]+(DataSTV[i].v2[1]-GriPoint->v[1])*var[2];
								DTV[j].v3[1]=GriPoint->v[1]+(DataSTV[i].v3[1]-GriPoint->v[1])*var[2];
							}else{
								DTV[j].v1[1]=GriPoint->v[1]+(DataSTV[i].v1[1]-GriPoint->v[1]);
								DTV[j].v2[1]=GriPoint->v[1]+(DataSTV[i].v2[1]-GriPoint->v[1]);
								DTV[j].v3[1]=GriPoint->v[1]+(DataSTV[i].v3[1]-GriPoint->v[1]);
							}
							if(cscalari[0]&4){
								DTV[j].v1[2]=GriPoint->v[2]+(DataSTV[i].v1[2]-GriPoint->v[2])*var[2];
								DTV[j].v2[2]=GriPoint->v[2]+(DataSTV[i].v2[2]-GriPoint->v[2])*var[2];
								DTV[j].v3[2]=GriPoint->v[2]+(DataSTV[i].v3[2]-GriPoint->v[2])*var[2];
							}else{
								DTV[j].v1[2]=GriPoint->v[2]+(DataSTV[i].v1[2]-GriPoint->v[2]);
								DTV[j].v2[2]=GriPoint->v[2]+(DataSTV[i].v2[2]-GriPoint->v[2]);
								DTV[j].v3[2]=GriPoint->v[2]+(DataSTV[i].v3[2]-GriPoint->v[2]);
							}
							
						tempdataF[0]=DTV[j].v2[0]-DTV[j].v1[0];
						tempdataF[1]=DTV[j].v2[1]-DTV[j].v1[1];
						tempdataF[2]=DTV[j].v2[2]-DTV[j].v1[2];
						tempdataF[3]=DTV[j].v3[0]-DTV[j].v1[0];
						tempdataF[4]=DTV[j].v3[1]-DTV[j].v1[1];
						tempdataF[5]=DTV[j].v3[2]-DTV[j].v1[2];
				
						DTV[j].n3[0]=DTV[j].n2[0]=DTV[j].n1[0]=(tempdataF[1]*tempdataF[5]-tempdataF[2]*tempdataF[4]);
						DTV[j].n3[1]=DTV[j].n2[1]=DTV[j].n1[1]=(tempdataF[2]*tempdataF[3]-tempdataF[0]*tempdataF[5]);
						DTV[j].n3[2]=DTV[j].n2[2]=DTV[j].n1[2]=(tempdataF[0]*tempdataF[4]-tempdataF[1]*tempdataF[3]);
						var[3]=sqrt(DTV[j].n1[0]*DTV[j].n1[0]+DTV[j].n1[1]*DTV[j].n1[1]+DTV[j].n1[2]*DTV[j].n1[2]);
						DTV[j].n3[0]/=var[3];DTV[j].n2[0]/=var[3];DTV[j].n1[0]/=var[3];
						DTV[j].n3[1]/=var[3];DTV[j].n2[1]/=var[3];DTV[j].n1[1]/=var[3];
						DTV[j].n3[2]/=var[3];DTV[j].n2[2]/=var[3];DTV[j].n1[2]/=var[3];

					}
	
				}else{
					if(currentdata.format==0){/*Global*/
						var[0]=(currentdata.v[0]-rtlines->v[0]);var[1]=(currentdata.v[1]-rtlines->v[1]);
						var[2]=sqrt(var[0]*var[0]+var[1]*var[1])/cscalarf[0];
					}
					
					if(currentdata.format==1){/*Relativa ("@")*/
						var[0]=currentdata.v[0];var[1]=currentdata.v[1];
						var[2]=sqrt(var[0]*var[0]+var[1]*var[1])/cscalarf[0];
					}
					
					if(currentdata.format==2){
						var[2]=currentdata.v[0]/cscalarf[0];
					}
					
					for(i=0,j=0,k=0;i<DataSV.size();i++){
						if(DataSV[i].type==1){
							if(cscalari[0]&1){
								DLV[DataSV[i].index].v1[0]=GriPoint->v[0]+(DataSLV[j].v1[0]-GriPoint->v[0])*var[2];
								DLV[DataSV[i].index].v2[0]=GriPoint->v[0]+(DataSLV[j].v2[0]-GriPoint->v[0])*var[2];
							}else{
								DLV[DataSV[i].index].v1[0]=GriPoint->v[0]+(DataSLV[j].v1[0]-GriPoint->v[0]);
								DLV[DataSV[i].index].v2[0]=GriPoint->v[0]+(DataSLV[j].v2[0]-GriPoint->v[0]);
							}
							if(cscalari[0]&2){
								DLV[DataSV[i].index].v1[1]=GriPoint->v[1]+(DataSLV[j].v1[1]-GriPoint->v[1])*var[2];
								DLV[DataSV[i].index].v2[1]=GriPoint->v[1]+(DataSLV[j].v2[1]-GriPoint->v[1])*var[2];
							}else{
								DLV[DataSV[i].index].v1[1]=GriPoint->v[1]+(DataSLV[j].v1[1]-GriPoint->v[1]);
								DLV[DataSV[i].index].v2[1]=GriPoint->v[1]+(DataSLV[j].v2[1]-GriPoint->v[1]);
							}
							if(cscalari[0]&4){
								DLV[DataSV[i].index].v1[2]=GriPoint->v[2]+(DataSLV[j].v1[2]-GriPoint->v[2])*var[2];
								DLV[DataSV[i].index].v2[2]=GriPoint->v[2]+(DataSLV[j].v2[2]-GriPoint->v[2])*var[2];
							}else{
								DLV[DataSV[i].index].v1[2]=GriPoint->v[2]+(DataSLV[j].v1[2]-GriPoint->v[2]);
								DLV[DataSV[i].index].v2[2]=GriPoint->v[2]+(DataSLV[j].v2[2]-GriPoint->v[2]);
							}
							j++;
						}
						if(DataSV[i].type==2){
							if(cscalari[0]&1){
								DTV[DataSV[i].index].v1[0]=GriPoint->v[0]+(DataSTV[k].v1[0]-GriPoint->v[0])*var[2];
								DTV[DataSV[i].index].v2[0]=GriPoint->v[0]+(DataSTV[k].v2[0]-GriPoint->v[0])*var[2];
								DTV[DataSV[i].index].v3[0]=GriPoint->v[0]+(DataSTV[k].v3[0]-GriPoint->v[0])*var[2];
							}else{
								DTV[DataSV[i].index].v1[0]=GriPoint->v[0]+(DataSTV[k].v1[0]-GriPoint->v[0]);
								DTV[DataSV[i].index].v2[0]=GriPoint->v[0]+(DataSTV[k].v2[0]-GriPoint->v[0]);
								DTV[DataSV[i].index].v3[0]=GriPoint->v[0]+(DataSTV[k].v3[0]-GriPoint->v[0]);
							}
							if(cscalari[0]&2){
								DTV[DataSV[i].index].v1[1]=GriPoint->v[1]+(DataSTV[k].v1[1]-GriPoint->v[1])*var[2];
								DTV[DataSV[i].index].v2[1]=GriPoint->v[1]+(DataSTV[k].v2[1]-GriPoint->v[1])*var[2];
								DTV[DataSV[i].index].v3[1]=GriPoint->v[1]+(DataSTV[k].v3[1]-GriPoint->v[1])*var[2];
							}else{
								DTV[DataSV[i].index].v1[1]=GriPoint->v[1]+(DataSTV[k].v1[1]-GriPoint->v[1]);
								DTV[DataSV[i].index].v2[1]=GriPoint->v[1]+(DataSTV[k].v2[1]-GriPoint->v[1]);
								DTV[DataSV[i].index].v3[1]=GriPoint->v[1]+(DataSTV[k].v3[1]-GriPoint->v[1]);
							}
							if(cscalari[0]&4){
								DTV[DataSV[i].index].v1[2]=GriPoint->v[2]+(DataSTV[k].v1[2]-GriPoint->v[2])*var[2];
								DTV[DataSV[i].index].v2[2]=GriPoint->v[2]+(DataSTV[k].v2[2]-GriPoint->v[2])*var[2];
								DTV[DataSV[i].index].v3[2]=GriPoint->v[2]+(DataSTV[k].v3[2]-GriPoint->v[2])*var[2];
							}else{
								DTV[DataSV[i].index].v1[2]=GriPoint->v[2]+(DataSTV[k].v1[2]-GriPoint->v[2]);
								DTV[DataSV[i].index].v2[2]=GriPoint->v[2]+(DataSTV[k].v2[2]-GriPoint->v[2]);
								DTV[DataSV[i].index].v3[2]=GriPoint->v[2]+(DataSTV[k].v3[2]-GriPoint->v[2]);
							}
						
						tempdataF[0]=DTV[DataSV[i].index].v2[0]-DTV[DataSV[i].index].v1[0];
						tempdataF[1]=DTV[DataSV[i].index].v2[1]-DTV[DataSV[i].index].v1[1];
						tempdataF[2]=DTV[DataSV[i].index].v2[2]-DTV[DataSV[i].index].v1[2];
						tempdataF[3]=DTV[DataSV[i].index].v3[0]-DTV[DataSV[i].index].v1[0];
						tempdataF[4]=DTV[DataSV[i].index].v3[1]-DTV[DataSV[i].index].v1[1];
						tempdataF[5]=DTV[DataSV[i].index].v3[2]-DTV[DataSV[i].index].v1[2];
				
		DTV[DataSV[i].index].n3[0]=DTV[DataSV[i].index].n2[0]=DTV[DataSV[i].index].n1[0]=(tempdataF[1]*tempdataF[5]-tempdataF[2]*tempdataF[4]);
		DTV[DataSV[i].index].n3[1]=DTV[DataSV[i].index].n2[1]=DTV[DataSV[i].index].n1[1]=(tempdataF[2]*tempdataF[3]-tempdataF[0]*tempdataF[5]);
		DTV[DataSV[i].index].n3[2]=DTV[DataSV[i].index].n2[2]=DTV[DataSV[i].index].n1[2]=(tempdataF[0]*tempdataF[4]-tempdataF[1]*tempdataF[3]);
var[3]=sqrt(DTV[DataSV[i].index].n1[0]*DTV[DataSV[i].index].n1[0]+DTV[DataSV[i].index].n1[1]*DTV[DataSV[i].index].n1[1]+DTV[DataSV[i].index].n1[2]*DTV[DataSV[i].index].n1[2]);
				DTV[DataSV[i].index].n3[0]/=var[3];DTV[DataSV[i].index].n2[0]/=var[3];DTV[DataSV[i].index].n1[0]/=var[3];
				DTV[DataSV[i].index].n3[1]/=var[3];DTV[DataSV[i].index].n2[1]/=var[3];DTV[DataSV[i].index].n1[1]/=var[3];
				DTV[DataSV[i].index].n3[2]/=var[3];DTV[DataSV[i].index].n2[2]/=var[3];DTV[DataSV[i].index].n1[2]/=var[3];
							k++;
						}
					}
					
				}
			
			
			/*DataSV.resize(0);*/
			CmdCancel();
			return;
			}
			
		break;
		
		case 3:/*REFERENCE (3-4)*/
			if(CmdSelectPopView()){return;}
			if(CmdCheckSnap()){return;}
			
			if(!SecCmd.compare("setCmdData")){
				if(currentdata.format>2){
						SendText(tr("Data reject"));
						return;
				}
				if(currentdata.format==0){
					tempdataF[1]=currentdata.v[0];tempdataF[2]=currentdata.v[1];tempdataF[3]=currentdata.v[2];
					rtlines->v[0]=tempdataF[1];rtlines->v[1]=tempdataF[2];rtlines->v[2]=tempdataF[3];rtlines[0].find=1;
					step++;
				}
				if(currentdata.format==1){
					tempdataF[1]=currentdata.v[0]+GriPoint->v[0];tempdataF[2]=currentdata.v[1]+GriPoint->v[1];tempdataF[3]=currentdata.v[2]+GriPoint->v[0];
					rtlines->v[0]=tempdataF[1];rtlines->v[1]=tempdataF[2];rtlines->v[2]=tempdataF[3];rtlines[0].find=1;
					step++;
				}
				if(currentdata.format==2){
					tempdataF[0]=currentdata.v[0];
					if(tempdataF[0]){cscalarf[0]=tempdataF[0];}else{cscalarf[0]=1;}
					for(i=0;i<DataSV.size();i++){
					if(DataSV[i].type==1){
						DataSLV.resize(DataSLV.size()+1);j=DataSLV.size()-1;
						DataSLV[j].v1[0]=DLV[DataSV[i].index].v1[0];DataSLV[j].v2[0]=DLV[DataSV[i].index].v2[0];
						DataSLV[j].v1[1]=DLV[DataSV[i].index].v1[1];DataSLV[j].v2[1]=DLV[DataSV[i].index].v2[1];
						DataSLV[j].v1[2]=DLV[DataSV[i].index].v1[2];DataSLV[j].v2[2]=DLV[DataSV[i].index].v2[2];
						DataSLV[j].c1[0]=DLV[DataSV[i].index].c1[0];DataSLV[j].c2[0]=DLV[DataSV[i].index].c2[0];
						DataSLV[j].c1[1]=DLV[DataSV[i].index].c1[1];DataSLV[j].c2[1]=DLV[DataSV[i].index].c2[1];
						DataSLV[j].c1[2]=DLV[DataSV[i].index].c1[2];DataSLV[j].c2[2]=DLV[DataSV[i].index].c2[2];
						
					}
					if(DataSV[i].type==2){
						DataSTV.resize(DataSTV.size()+1);j=DataSTV.size()-1;k=DataSV[i].index;
						DataSTV[j].v1[0]=DTV[k].v1[0];DataSTV[j].v2[0]=DTV[k].v2[0];DataSTV[j].v3[0]=DTV[k].v3[0];
						DataSTV[j].v1[1]=DTV[k].v1[1];DataSTV[j].v2[1]=DTV[k].v2[1];DataSTV[j].v3[1]=DTV[k].v3[1];
						DataSTV[j].v1[2]=DTV[k].v1[2];DataSTV[j].v2[2]=DTV[k].v2[2];DataSTV[j].v3[2]=DTV[k].v3[2];
						DataSTV[j].texture=DTV[k].texture;
						DataSTV[j].t1[0]=DTV[k].t1[0];DataSTV[j].t1[1]=DTV[k].t1[1];
						DataSTV[j].t2[0]=DTV[k].t2[0];DataSTV[j].t2[1]=DTV[k].t2[1];
						DataSTV[j].t3[0]=DTV[k].t3[0];DataSTV[j].t3[1]=DTV[k].t3[1];
						DataSTV[j].c1[0]=DTV[k].c1[0];DataSTV[j].c2[0]=DTV[k].c2[0];DataSTV[j].c3[0]=DTV[k].c3[0];
						DataSTV[j].c1[1]=DTV[k].c1[1];DataSTV[j].c2[1]=DTV[k].c2[1];DataSTV[j].c3[1]=DTV[k].c3[1];
						DataSTV[j].c1[2]=DTV[k].c1[2];DataSTV[j].c2[2]=DTV[k].c2[2];DataSTV[j].c3[2]=DTV[k].c3[2];
						DataSTV[j].n1[0]=DTV[k].n1[0];DataSTV[j].n2[0]=DTV[k].n2[0];DataSTV[j].n3[0]=DTV[k].n3[0];
						DataSTV[j].n1[1]=DTV[k].n1[1];DataSTV[j].n2[1]=DTV[k].n2[1];DataSTV[j].n3[1]=DTV[k].n3[1];
						DataSTV[j].n1[2]=DTV[k].n1[2];DataSTV[j].n2[2]=DTV[k].n2[2];DataSTV[j].n3[2]=DTV[k].n3[2];
					}
					}
					rtlines->v[0]=GriPoint->v[0];rtlines->v[1]=GriPoint->v[1];rtlines->v[2]=0;
					rtcolor[0]=currentcolor[0];rtcolor[1]=currentcolor[1];rtcolor[2]=currentcolor[2];rtlines[0].find=1;
				emit instru(instruction);
				step=1;
				return;
				}
			return;
			}
			
		break;
		case 4:/*REFERENCE (3-4)*/
			if(CmdSelectPopView()){return;}
			if(CmdCheckSnap()){return;}
			
			if(!SecCmd.compare("setCmdData")){
				if(currentdata.format>2){
						SendText(tr("Data reject"));
						return;
				}
				if(currentdata.format==0){
					tempdataF[0]=sqrt((tempdataF[1]-currentdata.v[0])*(tempdataF[1]-currentdata.v[0])+(tempdataF[2]-currentdata.v[1])*(tempdataF[2]-currentdata.v[1])+(tempdataF[3]-currentdata.v[2])*(tempdataF[3]-currentdata.v[2]));
					if(tempdataF[0]){cscalarf[0]=tempdataF[0];}else{cscalarf[0]=1;}
				}
				if(currentdata.format==1){
					tempdataF[0]=sqrt((tempdataF[1]-currentdata.v[0]-GriPoint->v[0])*(tempdataF[1]-currentdata.v[0]-GriPoint->v[0])+(tempdataF[2]-currentdata.v[1]-GriPoint->v[1])*(tempdataF[2]-currentdata.v[1]-GriPoint->v[1])+(tempdataF[3]-currentdata.v[2]-GriPoint->v[2])*(tempdataF[3]-currentdata.v[2]-GriPoint->v[2]));
					if(tempdataF[0]){cscalarf[0]=tempdataF[0];}else{cscalarf[0]=1;}
				}
				if(currentdata.format==2){
					tempdataF[0]=currentdata.v[0];
					if(tempdataF[0]){cscalarf[0]=tempdataF[0];}else{cscalarf[0]=1;}
				}
				for(i=0;i<DataSV.size();i++){
					if(DataSV[i].type==1){
						DataSLV.resize(DataSLV.size()+1);j=DataSLV.size()-1;
						DataSLV[j].v1[0]=DLV[DataSV[i].index].v1[0];DataSLV[j].v2[0]=DLV[DataSV[i].index].v2[0];
						DataSLV[j].v1[1]=DLV[DataSV[i].index].v1[1];DataSLV[j].v2[1]=DLV[DataSV[i].index].v2[1];
						DataSLV[j].v1[2]=DLV[DataSV[i].index].v1[2];DataSLV[j].v2[2]=DLV[DataSV[i].index].v2[2];
						DataSLV[j].c1[0]=DLV[DataSV[i].index].c1[0];DataSLV[j].c2[0]=DLV[DataSV[i].index].c2[0];
						DataSLV[j].c1[1]=DLV[DataSV[i].index].c1[1];DataSLV[j].c2[1]=DLV[DataSV[i].index].c2[1];
						DataSLV[j].c1[2]=DLV[DataSV[i].index].c1[2];DataSLV[j].c2[2]=DLV[DataSV[i].index].c2[2];
						
					}
					if(DataSV[i].type==2){
						DataSTV.resize(DataSTV.size()+1);j=DataSTV.size()-1;k=DataSV[i].index;
						DataSTV[j].v1[0]=DTV[k].v1[0];DataSTV[j].v2[0]=DTV[k].v2[0];DataSTV[j].v3[0]=DTV[k].v3[0];
						DataSTV[j].v1[1]=DTV[k].v1[1];DataSTV[j].v2[1]=DTV[k].v2[1];DataSTV[j].v3[1]=DTV[k].v3[1];
						DataSTV[j].v1[2]=DTV[k].v1[2];DataSTV[j].v2[2]=DTV[k].v2[2];DataSTV[j].v3[2]=DTV[k].v3[2];
						DataSTV[j].texture=DTV[k].texture;
						DataSTV[j].t1[0]=DTV[k].t1[0];DataSTV[j].t1[1]=DTV[k].t1[1];
						DataSTV[j].t2[0]=DTV[k].t2[0];DataSTV[j].t2[1]=DTV[k].t2[1];
						DataSTV[j].t3[0]=DTV[k].t3[0];DataSTV[j].t3[1]=DTV[k].t3[1];
						DataSTV[j].c1[0]=DTV[k].c1[0];DataSTV[j].c2[0]=DTV[k].c2[0];DataSTV[j].c3[0]=DTV[k].c3[0];
						DataSTV[j].c1[1]=DTV[k].c1[1];DataSTV[j].c2[1]=DTV[k].c2[1];DataSTV[j].c3[1]=DTV[k].c3[1];
						DataSTV[j].c1[2]=DTV[k].c1[2];DataSTV[j].c2[2]=DTV[k].c2[2];DataSTV[j].c3[2]=DTV[k].c3[2];
						DataSTV[j].n1[0]=DTV[k].n1[0];DataSTV[j].n2[0]=DTV[k].n2[0];DataSTV[j].n3[0]=DTV[k].n3[0];
						DataSTV[j].n1[1]=DTV[k].n1[1];DataSTV[j].n2[1]=DTV[k].n2[1];DataSTV[j].n3[1]=DTV[k].n3[1];
						DataSTV[j].n1[2]=DTV[k].n1[2];DataSTV[j].n2[2]=DTV[k].n2[2];DataSTV[j].n3[2]=DTV[k].n3[2];
					}
				}
				rtlines->v[0]=GriPoint->v[0];rtlines->v[1]=GriPoint->v[1];rtlines->v[2]=0;
				rtcolor[0]=currentcolor[0];rtcolor[1]=currentcolor[1];rtcolor[2]=currentcolor[2];rtlines[0].find=1;
				
			emit instru(instruction);
			step=1;
			return;
			}
		
		
		break;
	}
	
	SendText(SecCmd);
	SendText(tr("**Secondary Command not found**"));
}


#endif
