/****************************************************************************
** $Id:  cmds/cmddrawtriangle.h
** AutoQ3D a qt 3d model editor program
**
** Copyright (C) 2005-2007 -Gonzalo Reynaga Garcia. <gonzaloreynaga@yahoo.com>
**
** This program is free software; you can redistribute it and/or
** modify it under the terms of the GNU General Public Licence
** as published by the Free Software Foundation; either version 2 
** of the License, or (at your option) any later option.
** 
** This program is distributed in the hope that it will be useful,
** but WITHOUT ANY WARRANTY; without even the implied warranty of
** MERCHANTABILITY or FITNESS FOR PARTICULAR PURPOSE. See the
** GNU General Public License for more details.
**
** You should have received a copy of the GNU General Public License
** along with this program; if not, write to the Free Software
** Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA
** 
*****************************************************************************/

#ifndef CMDDRAWTRIANGLE_H
#define CMDDRAWTRIANGLE_H
#include "cmds.h"
#include <math.h>


void cmds::cmddrawtriangle(){
	int i;
	double var[2];
	d3triangle *DTV;
	DTV=DataTV->data();

	if((SecCmd==tr("**Cancel**")||SecCmd==""||SecCmd=="MouseRButton")&&!PopViewMode){
			SendText(tr("**Cancel**"));
			CmdCancel();
			return;
	}

	switch(step){
		
		case 0:
			/*/////////*/
		
				SendText(currentcmd);
				instruction=tr("pickpoint 1:");emit instru(instruction);
				emit SetMouseMode(MOUSEMODE_PICKPOINT);
				step++;
				return;
			
		break;

		case 1:
			if(CmdSelectPopView()){return;}
			if(CmdCheckSnap()){return;}
			
			if(!SecCmd.compare("setCmdData")){
				if(currentdata.format>1){
						SendText(tr("Data reject"));
						return;
				}
				GriPoint[0].v[0]=currentdata.v[0];GriPoint[0].v[1]=currentdata.v[1];GriPoint[0].v[2]=currentdata.v[2];
				rtlines[0].v[0]=currentdata.v[0];rtlines[0].v[1]=currentdata.v[1];rtlines[0].v[2]=currentdata.v[2];
				rtcolor[0]=currentcolor[0];rtcolor[1]=currentcolor[1];rtcolor[2]=currentcolor[2];
				rtlines[0].find=1;
				tempdataTRI[0].v1[0]=currentdata.v[0];tempdataTRI[0].v1[1]=currentdata.v[1];tempdataTRI[0].v1[2]=currentdata.v[2];
				tempdataTRI[0].c1[0]=currentcolor[0];tempdataTRI[0].c1[1]=currentcolor[1];tempdataTRI[0].c1[2]=currentcolor[2];
				/*/////////*/
				instruction=tr("pickpoint 2 or [Undo]:");emit instru(instruction);
				step++;
				return;
			}
		break;
		
		case 2:
			if(CmdSelectPopView()){return;}
			if(CmdCheckSnap()){return;}
			
			if(!SecCmd.compare("U","Undo")||!SecCmd.compare("u","Undo")){
					SendText(SecCmd);
					instruction=tr("pickpoint 1:");emit instru(instruction);
					rtlines[0].find=0;SecCmd="BlankCommand";step--;
			return;
			}
			
			if(!SecCmd.compare("setCmdData")){
				if(currentdata.format>1){
						SendText(tr("Data reject"));
						return;
				}
				
				rtcolor1[0]=rtcolor[0];rtcolor1[1]=rtcolor[1];rtcolor1[2]=rtcolor[2];
				rtcolor[0]=currentcolor[0];rtcolor[1]=currentcolor[1];rtcolor[2]=currentcolor[2];
				rtlines[1].v[0]=rtlines[0].v[0];rtlines[1].v[1]=rtlines[0].v[1];rtlines[1].v[2]=rtlines[0].v[2];
				
				if(currentdata.format==0){
					tempdataTRI[0].v2[0]=currentdata.v[0];tempdataTRI[0].v2[1]=currentdata.v[1];tempdataTRI[0].v2[2]=currentdata.v[2];
					rtlines[0].v[0]=currentdata.v[0];rtlines[0].v[1]=currentdata.v[1];rtlines[0].v[2]=currentdata.v[2];
				}
				
				if(currentdata.format==1){
					tempdataTRI[0].v2[0]=rtlines[0].v[0]+currentdata.v[0];
					tempdataTRI[0].v2[1]=rtlines[0].v[1]+currentdata.v[1];
					tempdataTRI[0].v2[2]=rtlines[0].v[2]+currentdata.v[2];
					
					rtlines[0].v[0]+=currentdata.v[0];
					rtlines[0].v[1]+=currentdata.v[1];
					rtlines[0].v[2]+=currentdata.v[2];
				}
				rtlines[1].find=1;
				tempdataTRI[0].c2[0]=currentcolor[0];tempdataTRI[0].c2[1]=currentcolor[1];tempdataTRI[0].c2[2]=currentcolor[2];
				GriPoint[0].v[0]=tempdataTRI[0].v2[0];GriPoint[0].v[1]=tempdataTRI[0].v2[1];GriPoint[0].v[2]=tempdataTRI[0].v2[2];
				
				instruction=tr("Next point:");emit instru(instruction);
				step++;
			return;
			}
		break;
		

	
	
	
	}
	
	if(step==3){
		if(!SecCmd.compare(tr("U","Undo"))||!SecCmd.compare(tr("u","Undo"))){
					SendText(SecCmd);
					rtlines[0].v[0]=rtlines[1].v[0];rtlines[0].v[1]=rtlines[1].v[1];rtlines[0].v[2]=rtlines[1].v[2];
					rtcolor[0]=rtcolor1[0];rtcolor[1]=rtcolor1[1];rtcolor[2]=rtcolor1[2];
					rtlines[1].find=0;
					step--;
					instruction=tr("pickpoint 2 or [Undo]:");emit instru(instruction);
					SecCmd="BlankCommand";
			return;
		}
	}
	
		if(step>2){
			if(CmdSelectPopView()){return;}
			if(CmdCheckSnap()){return;}
			
			
			if(!SecCmd.compare("setCmdData")){
				if(currentdata.format>1){
						SendText(tr("Data reject"));
						return;
				}
				i=DataTV->size();
				DataTV->resize(i+1);DTV=DataTV->data();
				DTV[i].v1[0]=tempdataTRI[0].v1[0];DTV[i].v1[1]=tempdataTRI[0].v1[1];DTV[i].v1[2]=tempdataTRI[0].v1[2];
				DTV[i].v2[0]=tempdataTRI[0].v2[0];DTV[i].v2[1]=tempdataTRI[0].v2[1];DTV[i].v2[2]=tempdataTRI[0].v2[2];
				DTV[i].texture=0;
				DTV[i].c1[0]=tempdataTRI[0].c1[0];DTV[i].c1[1]=tempdataTRI[0].c1[1];DTV[i].c1[2]=tempdataTRI[0].c1[2];
				DTV[i].c2[0]=tempdataTRI[0].c2[0];DTV[i].c2[1]=tempdataTRI[0].c2[1];DTV[i].c2[2]=tempdataTRI[0].c2[2];
				DTV[i].c3[0]=currentcolor[0];DTV[i].c3[1]=currentcolor[1];DTV[i].c3[2]=currentcolor[2];
				rtlines[1].v[0]=rtlines[0].v[0];rtlines[1].v[1]=rtlines[0].v[1];rtlines[1].v[2]=rtlines[0].v[2];
				rtcolor1[0]=rtcolor[0];rtcolor1[1]=rtcolor[1];rtcolor1[2]=rtcolor[2];
				rtcolor[0]=currentcolor[0];rtcolor[1]=currentcolor[1];rtcolor[2]=currentcolor[2];
				if(currentdata.format==0){
					DTV[i].v3[0]=currentdata.v[0];DTV[i].v3[1]=currentdata.v[1];DTV[i].v3[2]=currentdata.v[2];
					rtlines[0].v[0]=currentdata.v[0];rtlines[0].v[1]=currentdata.v[1];rtlines[0].v[2]=currentdata.v[2];
				}
				
				if(currentdata.format==1){
					DTV[i].v3[0]=rtlines[0].v[0]+currentdata.v[0];DTV[i].v3[1]=rtlines[0].v[1]+currentdata.v[1];DTV[i].v3[2]=rtlines[0].v[2]+currentdata.v[2];
					rtlines[0].v[0]+=currentdata.v[0];rtlines[0].v[1]+=currentdata.v[1];rtlines[0].v[2]+=currentdata.v[2];
				}
				GriPoint[0].v[0]=DTV[i].v3[0];GriPoint[0].v[1]=DTV[i].v3[1];GriPoint[0].v[2]=DTV[i].v3[2];
				tempdataF[0]=DTV[i].v2[0]-DTV[i].v1[0];
				tempdataF[1]=DTV[i].v2[1]-DTV[i].v1[1];
				tempdataF[2]=DTV[i].v2[2]-DTV[i].v1[2];
				tempdataF[3]=DTV[i].v3[0]-DTV[i].v1[0];
				tempdataF[4]=DTV[i].v3[1]-DTV[i].v1[1];
				tempdataF[5]=DTV[i].v3[2]-DTV[i].v1[2];
				
				DTV[i].n3[0]=DTV[i].n2[0]=DTV[i].n1[0]=(tempdataF[1]*tempdataF[5]-tempdataF[2]*tempdataF[4]);
				DTV[i].n3[1]=DTV[i].n2[1]=DTV[i].n1[1]=(tempdataF[2]*tempdataF[3]-tempdataF[0]*tempdataF[5]);
				DTV[i].n3[2]=DTV[i].n2[2]=DTV[i].n1[2]=(tempdataF[0]*tempdataF[4]-tempdataF[1]*tempdataF[3]);
				var[0]=sqrt(DTV[i].n1[0]*DTV[i].n1[0]+DTV[i].n1[1]*DTV[i].n1[1]+DTV[i].n1[2]*DTV[i].n1[2]);
				DTV[i].n3[0]/=var[0];DTV[i].n2[0]/=var[0];DTV[i].n1[0]/=var[0];
				DTV[i].n3[1]/=var[0];DTV[i].n2[1]/=var[0];DTV[i].n1[1]/=var[0];
				DTV[i].n3[2]/=var[0];DTV[i].n2[2]/=var[0];DTV[i].n1[2]/=var[0];
				
				
				if(step%2){
					tempdataTRI[0].v1[0]=DTV[i].v3[0];tempdataTRI[0].v1[1]=DTV[i].v3[1];tempdataTRI[0].v1[2]=DTV[i].v3[2];
					tempdataTRI[0].c1[0]=DTV[i].c3[0];tempdataTRI[0].c1[1]=DTV[i].c3[1];tempdataTRI[0].c1[2]=DTV[i].c3[2];
					DTV[i].t1[0]=0.0;DTV[i].t1[1]=0.0;DTV[i].t2[0]=1.0;DTV[i].t2[1]=0.0;DTV[i].t3[0]=0.0;DTV[i].t3[1]=1.0;					
				}else{
					tempdataTRI[0].v2[0]=DTV[i].v3[0];tempdataTRI[0].v2[1]=DTV[i].v3[1];tempdataTRI[0].v2[2]=DTV[i].v3[2];
					tempdataTRI[0].c2[0]=DTV[i].c3[0];tempdataTRI[0].c2[1]=DTV[i].c3[1];tempdataTRI[0].c2[2]=DTV[i].c3[2];
					DTV[i].t1[0]=0.0;DTV[i].t1[1]=1.0;DTV[i].t2[0]=1.0;DTV[i].t2[1]=0.0;DTV[i].t3[0]=1.0;DTV[i].t3[1]=1.0;
				}
				step++;
			return;
			}
		}
	
	
	
	
	SendText(SecCmd);
	SendText(tr("**Secondary Command not found**"));
}


#endif
