/****************************************************************************
** $Id:  fgui/selframe.cpp
** AutoQ3D a qt 3d model editor program
**
** Copyright (C) 2005-2007 -Gonzalo Reynaga Garcia. <gonzaloreynaga@yahoo.com>
**
** This program is free software; you can redistribute it and/or
** modify it under the terms of the GNU General Public Licence
** as published by the Free Software Foundation; either version 2 
** of the License, or (at your option) any later option.
** 
** This program is distributed in the hope that it will be useful,
** but WITHOUT ANY WARRANTY; without even the implied warranty of
** MERCHANTABILITY or FITNESS FOR PARTICULAR PURPOSE. See the
** GNU General Public License for more details.
**
** You should have received a copy of the GNU General Public License
** along with this program; if not, write to the Free Software
** Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA
** 
*****************************************************************************/

#include "selframe.h"




SelFrame::SelFrame( QWidget* parent, Qt::WFlags fl )
    : QDialog( parent, fl )
{
    setMaximumSize( QSize( 50, 50 ) );
    SelFrameLayout = new QGridLayout(this); 

    FindSize = new QLineEdit;
	textLabel1_2 = new QLabel;
	NumCen = new QPushButton;
	Checky = new QCheckBox(QString(tr("Invert normals")));

	SelFrameLayout->addWidget( Checky, 0, 0 );
	SelFrameLayout->addWidget( textLabel1_2, 1, 0 );
    SelFrameLayout->addWidget( FindSize, 2, 0 );
	SelFrameLayout->addWidget( NumCen, 2, 1 );
    
   
	NumCen->setText(tr("OK"));
    setWindowTitle(  tr("Selection Frame") );
    textLabel1_2->setText( tr("Num. of frame") );
    
    
    resize( QSize(50, 50).expandedTo(minimumSizeHint()) );
    FindSize->setValidator( new QIntValidator( FindSize) );
    FindSize->setText(QString("0"));
    
    connect( NumCen, SIGNAL( clicked() ) , this, SLOT( accept() ) );
}


SelFrame::~SelFrame()
{
   
}



