/****************************************************************************
** $Id:  dialogs/texform.cpp
** AutoQ3D a qt 3d model editor program
**
** Copyright (C) 2005-2007 -Gonzalo Reynaga Garcia. <gonzaloreynaga@yahoo.com>
**
** This program is free software; you can redistribute it and/or
** modify it under the terms of the GNU General Public Licence
** as published by the Free Software Foundation; either version 2 
** of the License, or (at your option) any later option.
** 
** This program is distributed in the hope that it will be useful,
** but WITHOUT ANY WARRANTY; without even the implied warranty of
** MERCHANTABILITY or FITNESS FOR PARTICULAR PURPOSE. See the
** GNU General Public License for more details.
**
** You should have received a copy of the GNU General Public License
** along with this program; if not, write to the Free Software
** Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA
** 
*****************************************************************************/

#include "texform.h"



TexForm::TexForm( QWidget* parent,Qt::WFlags flags,QStringList fd,QString fdir)
    : QDialog( parent,flags )
{	
	int i=1;
	srtlist=fd;
	QString tempo;
	filedir=fdir;
	QVBoxLayout* Form1Layout;
	
	Form1Layout = new QVBoxLayout(this);
	QHBoxLayout *Lay1 = new QHBoxLayout;
	QHBoxLayout *Lay2 = new QHBoxLayout;
	
	iconV=new QListWidget;
	
	
	cancelbot = new QPushButton(tr("Cancel"));
	okbot = new QPushButton(tr("OK"));
	removebot = new QPushButton(tr("Remove"));
	addbot = new QPushButton(tr("Add..."));
	changebot = new QPushButton(tr("Change..."));

	
	Lay1->addWidget( removebot );
	Lay1->addWidget( addbot);
	Lay1->addWidget( changebot );
	Lay2->addWidget( okbot );
	Lay2->addWidget( cancelbot );

	Form1Layout->addWidget(iconV);
	Form1Layout->addLayout(Lay1);
	Form1Layout->addLayout(Lay2);
	iconV->setViewMode(QListView::IconMode);
	iconV->setIconSize(QSize(70,70));
		
	resize( QSize(428, 287).expandedTo(minimumSizeHint()) );
	
	iconV->setSelectionMode(QAbstractItemView::SingleSelection);
	
	
		for(QStringList::Iterator it=srtlist.begin();it!=srtlist.end();++it){
			QPixmap bitmm(*it);
			tempo=*it;tempo.remove( 0,tempo.lastIndexOf( "/" )+1);
			QListWidgetItem *item = new QListWidgetItem(QString("#%1-").arg(i++)+tempo,iconV);
			item->setIcon(QIcon(bitmm.scaled(64,64)));
		}
		
		iconV->show();

	setWindowTitle(tr("Set Texture Files"));
	connect(okbot,SIGNAL(clicked()),this,SLOT(okpress()));
	connect(cancelbot,SIGNAL(clicked()),this,SLOT(cancelpress()));
	connect(addbot,SIGNAL(clicked()),this,SLOT(addTexture()));
	connect(removebot,SIGNAL(clicked()),this,SLOT(removeTexture()));
	connect(changebot,SIGNAL(clicked()),this,SLOT(changeTexture()));
}

TexForm::~TexForm()
{

}

void TexForm::okpress(){
	int i;
	QString tempo;
	QListWidgetItem *item;
	srtlist2.clear();
	for(i=0;i<iconV->count();i++){
		item=iconV->item(i);
		tempo=item->text();
		tempo.remove( 0,tempo.indexOf("-")+1);
		srtlist2<<filedir+"/"+tempo;
	}
	accept();
	close();
}


void TexForm::cancelpress(){
	reject();
	close();

}

void TexForm::addTexture(){
	QString tempo;
	QString fn = QFileDialog::getOpenFileName(this,QString(""),filedir, QString(""));
	if( !fn.isNull()){
	tempo=fn;
		fn.truncate(fn.lastIndexOf( "/" ));
		if(!filedir.compare(fn)){
			QPixmap bitmm(tempo);
			tempo.remove( 0,tempo.lastIndexOf( "/" )+1);
			QListWidgetItem *item = new QListWidgetItem(QString("#%1-").arg(iconV->count()+1)+tempo,iconV);
			item->setIcon(QIcon(bitmm.scaled(64,64)));
			/*item->setFlags( Qt::ItemIsSelectable );*/
		}else{
			QMessageBox::critical( this,tr("Error"),QString(tr("The image must be in the same\n directory than the 3d model")),tr("OK") );
		}
	}
}

void TexForm::removeTexture(){
	
	QListWidgetItem *item =iconV->currentItem();
	if(item!=NULL){
		QListWidgetItem *item2;
		QString tempo;
		int i=iconV->currentRow();
		delete item;
		for(;i<iconV->count();i++){
			item2=iconV->item(i);
			tempo=item2->text();
			tempo.remove(0,tempo.indexOf("-")+1);
			item2->setText(QString("#%1-").arg(i+1)+tempo);
		}
	}
	

}

void TexForm::changeTexture(){
	QString tempo;
	QListWidgetItem *item =iconV->currentItem();
	if(item!=NULL){
		int itemidx=iconV->currentRow();
		QString fn = QFileDialog::getOpenFileName(this,QString(""),filedir, QString(""));
		if(!fn.isNull()){
			tempo=fn;
			fn.truncate(fn.lastIndexOf( "/" ));
			if(!filedir.compare(fn)){
				QPixmap bitmm(tempo);
				tempo.remove( 0,tempo.lastIndexOf( "/" )+1);
				item->setText(QString("#%1-").arg(itemidx+1)+tempo);
				item->setIcon(QIcon(bitmm.scaled(64,64)));
			}else{
				QMessageBox::critical( this,tr("Error"),QString(tr("The image must be in the same\n directory than the 3d model")),tr("OK") );
			}
		}
	}
}






