/****************************************************************************
** $Id:  dialogs/properdiag.h
** AutoQ3D a qt 3d model editor program
**
** Copyright (C) 2005-2007 -Gonzalo Reynaga Garcia. <gonzaloreynaga@yahoo.com>
**
** This program is free software; you can redistribute it and/or
** modify it under the terms of the GNU General Public Licence
** as published by the Free Software Foundation; either version 2 
** of the License, or (at your option) any later option.
** 
** This program is distributed in the hope that it will be useful,
** but WITHOUT ANY WARRANTY; without even the implied warranty of
** MERCHANTABILITY or FITNESS FOR PARTICULAR PURPOSE. See the
** GNU General Public License for more details.
**
** You should have received a copy of the GNU General Public License
** along with this program; if not, write to the Free Software
** Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA
** 
*****************************************************************************/

#ifndef PROPERDIAG_H
#define PROPERDIAG_H
#include <QDialog>
#include <QStringList>
#include <QPushButton>
#include <QFileDialog>
#include <QMessageBox>
#include <QTableWidget>
#include <QColorDialog>
#include <QHeaderView>
#include <QModelIndex>

#include "../cmds/cmds.h"
#include "picktex.h"
#include "texformsel.h"

class QVBoxLayout;
class QHBoxLayout;
class QGridLayout;
class QPushButton;
class QTableWidget;
class QModelIndex;

class TableLabel : public QTableWidgetItem
{
public:
	TableLabel(const QString txt,QColor tempcolor,QColor txtc)
		:QTableWidgetItem(txt)
	{
		setBackgroundColor(tempcolor);
		setTextColor(txtc);
		setTextAlignment(Qt::AlignVCenter|Qt::AlignRight);
	}
    private:
};


class ProperDiag : public QDialog
{
    Q_OBJECT

public:
	ProperDiag( QWidget *parent = 0,Qt::WFlags fl=0);
	~ProperDiag();
	void showTriangleMode(bool);
	QString pixname;
	QTableWidget* table1;
	QColor color1,color2,color3;
	QStringList StrTex;
	float uvcoords[2];
protected:
	

protected slots:
	void okpress();
	void cancelpress();
	void ClickEvent(const QModelIndex &index);

public slots:



private:
	QPushButton* okbot;
	QPushButton* cancelbot;
	

};

#endif // PROPERTIES_H




