/****************************************************************************
** $Id:  cmds/cmdtex.h
** AutoQ3D a qt 3d model editor program
**
** Copyright (C) 2005-2007 -Gonzalo Reynaga Garcia. <gonzaloreynaga@yahoo.com>
**
** This program is free software; you can redistribute it and/or
** modify it under the terms of the GNU General Public Licence
** as published by the Free Software Foundation; either version 2 
** of the License, or (at your option) any later option.
** 
** This program is distributed in the hope that it will be useful,
** but WITHOUT ANY WARRANTY; without even the implied warranty of
** MERCHANTABILITY or FITNESS FOR PARTICULAR PURPOSE. See the
** GNU General Public License for more details.
**
** You should have received a copy of the GNU General Public License
** along with this program; if not, write to the Free Software
** Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA
** 
*****************************************************************************/

#ifndef CMDTEX_H
#define CMDTEX_H
#include "cmds.h"


void cmds::cmdtex(){
	int i;
	QString temp;
	d3triangle *DTV;
	DTV=DataTV->data();

	if((SecCmd==tr("**Cancel**")||SecCmd=="MouseRButton")&&!PopViewMode){
			SendText(tr("**Cancel**"));
			CmdCancel();
			return;
	}

	switch(step){
		
		case 0:
			/*/////////*/
		
				SendText(tr("--Proyect Texture--"));
				instruction=tr("Texture Proyect Plane [X/Y/Z]<Z>:");emit instru(instruction);
				tempdataI[0]=2;tempdataF[0]=1.0;tempdataF[1]=1.0;
				step++;				
				return;
			
		break;
		
		case 1:
			if(CmdSelectPopView()){return;}
			
			if(!SecCmd.compare("x")||!SecCmd.compare("X")){
				SendText("x");
				tempdataI[0]=0;
				if(tempdataI[0]==0){temp="X";}if(tempdataI[0]==1){temp="Y";}if(tempdataI[0]==2){temp="Z";}
				instruction=QString(tr("Texture Scale [Plane<%1>/U<%2>/V<%3>]:")).arg(temp).arg(tempdataF[0]).arg(tempdataF[1]);emit instru(instruction);
				step++;
				return;
			}
			if(!SecCmd.compare("y")||!SecCmd.compare("Y")){
				SendText("y");
				tempdataI[0]=1;
				if(tempdataI[0]==0){temp="X";}if(tempdataI[0]==1){temp="Y";}if(tempdataI[0]==2){temp="Z";}
				instruction=QString(tr("Texture Scale [Plane<%1>/U<%2>/V<%3>]:")).arg(temp).arg(tempdataF[0]).arg(tempdataF[1]);emit instru(instruction);
				step++;
				return;
			}
			if(!SecCmd.compare("z")||!SecCmd.compare("Z")){
				SendText("z");
				tempdataI[0]=2;
				if(tempdataI[0]==0){temp="X";}if(tempdataI[0]==1){temp="Y";}if(tempdataI[0]==2){temp="Z";}
				instruction=QString(tr("Texture Scale [Plane<%1>/U<%2>/V<%3>]:")).arg(temp).arg(tempdataF[0]).arg(tempdataF[1]);emit instru(instruction);
				step++;
				return;
			}
			if(!SecCmd.compare("")){
				if(tempdataI[0]==0){temp="X";}if(tempdataI[0]==1){temp="Y";}if(tempdataI[0]==2){temp="Z";}
				instruction=QString(tr("Texture Scale [Plane<%1>/U<%2>/V<%3>]:")).arg(temp).arg(tempdataF[0]).arg(tempdataF[1]);emit instru(instruction);
				step++;
				return;
			}
		break;
		case 2:
			if(CmdSelectPopView()){return;}
			if(!SecCmd.compare(tr("p"))||!SecCmd.compare(tr("P"))){
				if(tempdataI[0]==0){temp="X";}if(tempdataI[0]==1){temp="Y";}if(tempdataI[0]==2){temp="Z";}
				instruction=QString(tr("Texture Proyect Plane [X/Y/Z]<%1>:")).arg(temp);emit instru(instruction);
				step--;
				return;
			}
			if(!SecCmd.compare("u")||!SecCmd.compare("U")){
				instruction=QString(tr("Texture Scale U<%1>:")).arg(tempdataF[0]);emit instru(instruction);
				step++;
				return;
			}
			if(!SecCmd.compare("v")||!SecCmd.compare("V")){
				instruction=QString(tr("Texture Scale V<%1>:")).arg(tempdataF[1]);emit instru(instruction);
				step+=2;
				return;
			}
			if(!SecCmd.compare("")){
				if(tempdataI[0]==0){
					for(i=0;i<DataSV.size();i++){
						if(DataSV[i].type==2){
							DTV[DataSV[i].index].t1[0]=DTV[DataSV[i].index].v1[1]*tempdataF[0];
							DTV[DataSV[i].index].t1[1]=DTV[DataSV[i].index].v1[2]*tempdataF[1];
							DTV[DataSV[i].index].t2[0]=DTV[DataSV[i].index].v2[1]*tempdataF[0];
							DTV[DataSV[i].index].t2[1]=DTV[DataSV[i].index].v2[2]*tempdataF[1];
							DTV[DataSV[i].index].t3[0]=DTV[DataSV[i].index].v3[1]*tempdataF[0];
							DTV[DataSV[i].index].t3[1]=DTV[DataSV[i].index].v3[2]*tempdataF[1];
						}
					}
				}
				if(tempdataI[0]==1){
					for(i=0;i<DataSV.size();i++){
						if(DataSV[i].type==2){
							DTV[DataSV[i].index].t1[0]=DTV[DataSV[i].index].v1[0]*tempdataF[0];
							DTV[DataSV[i].index].t1[1]=DTV[DataSV[i].index].v1[2]*tempdataF[1];
							DTV[DataSV[i].index].t2[0]=DTV[DataSV[i].index].v2[0]*tempdataF[0];
							DTV[DataSV[i].index].t2[1]=DTV[DataSV[i].index].v2[2]*tempdataF[1];
							DTV[DataSV[i].index].t3[0]=DTV[DataSV[i].index].v3[0]*tempdataF[0];
							DTV[DataSV[i].index].t3[1]=DTV[DataSV[i].index].v3[2]*tempdataF[1];
						}
					}
				}
				if(tempdataI[0]==2){
					for(i=0;i<DataSV.size();i++){
						if(DataSV[i].type==2){
							DTV[DataSV[i].index].t1[0]=DTV[DataSV[i].index].v1[0]*tempdataF[0];
							DTV[DataSV[i].index].t1[1]=DTV[DataSV[i].index].v1[1]*tempdataF[1];
							DTV[DataSV[i].index].t2[0]=DTV[DataSV[i].index].v2[0]*tempdataF[0];
							DTV[DataSV[i].index].t2[1]=DTV[DataSV[i].index].v2[1]*tempdataF[1];
							DTV[DataSV[i].index].t3[0]=DTV[DataSV[i].index].v3[0]*tempdataF[0];
							DTV[DataSV[i].index].t3[1]=DTV[DataSV[i].index].v3[1]*tempdataF[1];
						}
					}
				}
				CmdCancel();
				return;
				
			}
			
		break;
		case 3:
			if(!SecCmd.compare("")){
				if(tempdataI[0]==0){temp="X";}if(tempdataI[0]==1){temp="Y";}if(tempdataI[0]==2){temp="Z";}
				instruction=QString(tr("Texture Scale [Plane<%1>/U<%2>/V<%3>]:")).arg(temp).arg(tempdataF[0]).arg(tempdataF[1]);emit instru(instruction);
				step=2;
				return;
			}
			if(!SecCmd.compare("setCmdData")){
				if(currentdata.format<2){
						SendText(tr("Data reject"));
						return;
				}
				tempdataF[0]=currentdata.v[0];
				if(tempdataI[0]==0){temp="X";}if(tempdataI[0]==1){temp="Y";}if(tempdataI[0]==2){temp="Z";}
				instruction=QString(tr("Texture Scale [Plane<%1>/U<%2>/V<%3>]:")).arg(temp).arg(tempdataF[0]).arg(tempdataF[1]);emit instru(instruction);
				step=2;
				return;
				
			}
		break;
		case 4:
			if(!SecCmd.compare("")){
				if(tempdataI[0]==0){temp="X";}if(tempdataI[0]==1){temp="Y";}if(tempdataI[0]==2){temp="Z";}
				instruction=QString(tr("Texture Scale [Plane<%1>/U<%2>/V<%3>]:")).arg(temp).arg(tempdataF[0]).arg(tempdataF[1]);emit instru(instruction);
				step=2;
				return;
			}
			if(!SecCmd.compare("setCmdData")){
				if(currentdata.format<2){
						SendText(tr("Data reject"));
						return;
				}
				tempdataF[1]=currentdata.v[0];
				if(tempdataI[0]==0){temp="X";}if(tempdataI[0]==1){temp="Y";}if(tempdataI[0]==2){temp="Z";}
				instruction=QString(tr("Texture Scale [Plane<%1>/U<%2>/V<%3>]:")).arg(temp).arg(tempdataF[0]).arg(tempdataF[1]);emit instru(instruction);
				step=2;
				return;
				
			}
			
		break;
		
		
		
		
	}
	
	
	
	
	
	SendText(SecCmd);
	SendText(tr("**Secondary Command not found**"));
}


#endif
